C  IDENTIFY PARAMETER NREC (STORAGE FOR VOLUME RECOMBINATION PROCESSES)
C
C  june 2015:  added: default single step vol.rec. process  e + He+ --> He(1S)+ rad.
c              rate taken from Janev et al., 1987, Process 2.3.13.
C
      SUBROUTINE EIRENE_XSECTP_PARAM

      USE EIRMOD_PARMMOD
      USE EIRMOD_COMUSR
      USE EIRMOD_CCONA
      USE EIRMOD_CGRID
      USE EIRMOD_CZT1
      USE EIRMOD_CTRCEI
      USE EIRMOD_CTEXT
      USE EIRMOD_COMXS
      USE EIRMOD_CSPEI

      IMPLICIT NONE

      INTEGER :: NRC, IATM, IPLS, KK
C
C
C   RECOMBINATION
C
      DO 1000 IPLS=1,NPLSI
C
        IF (NRCP(IPLS).EQ.0) THEN
C
          IF (NCHARP(IPLS).EQ.1.AND.NCHRGP(IPLS).EQ.1) THEN
!  H+ DEFAULT RECOMBINATION MODEL
C
C  DEFAULT HYDROGENIC RECOMBINATION MODEL
C  HYDR. RECOMBINATION RATE COEFFICIENT (1/S/CCM) E + H+ --> H + RAD.
C  GORDEEV ET. AL., PIS'MA ZH. EHKSP. TEOR. FIZ. 25 (1977) 223.
C
            DO 52 IATM=1,NATMI
              IF (NMASSP(IPLS).EQ.NMASSA(IATM)) THEN
C
                NREC=NREC+1
              ENDIF
   52       CONTINUE
C
          ELSEIF (NCHARP(IPLS).EQ.2.AND.NCHRGP(IPLS).EQ.1) THEN
! HE+ DEFAULT RECOMBINATION MODEL

C  DEFAULT HELIUM + RADIATIVE RECOMBINATION MODEL
C  HELIUM ION (HE+) RECOMBINATION RATE COEFFICIENT (1/S/CCM) E + HE+ --> HE + RAD.
C  JANEV ET. AL. FORMULA H.2. 2.3.13, BASED ON SOBELMAN 1979
C  (BORN-COULOMB APPROXIMATION), SIMILAR EXPRESSION AS FOR HYDROGEN DEFAULT RECOMBINATION MODEL

            DO 54 IATM=1,NATMI
              IF (NMASSP(IPLS).EQ.NMASSA(IATM)) THEN
C
                NREC=NREC+1
              ENDIF
   54       CONTINUE
          ENDIF
C
C  NON-DEFAULT MODEL: 240--
C
        ELSEIF (NRCP(IPLS).GT.0) THEN
          DO 82 NRC=1,NRCP(IPLS)
            KK=IREACP(IPLS,NRC)
            IF ((ISWR(KK).NE.6) .AND. (ISWR(KK).NE.7)) GOTO 82
C
C  RECOMBINATION MODEL FOR BULK IONS
            NREC=NREC+1
C
   82     CONTINUE
C
C  NO MODEL DEFINED
        ELSE
        ENDIF
C
C
 1000 CONTINUE
C
      RETURN
C
      END SUBROUTINE EIRENE_XSECTP_PARAM
