cdr  oct. 2015:
cdr  k=-1:  CX  H  + p
cdr  k=-11  EI  He + e (was formerly also k=-1)
!pb  june 2016: nullify unused pointers in default reaction k=-11
cdr  sept. 16:  extend options for asymptotics (extrapolation of fits)
cdr             currently this is by far overdone, all fits in here are single parametric
cdr             but leave as is, for later extensions....
cdr  nov.17  :  exclusively  iftflg(K,2)=0 for rate coefficients
c                       and  iftflg(K,1)=0 for cross-sections are set.
c               H.8 reaction for process K=-10: dis rec of H2+, could be set here.
c                       then iftflg(K,4)=0  as well.
cdr             asympt. corrections missing for He CX cross-sections.

      subroutine EIRENE_setup_default_reactions
C
C  for the trivial minimal set of hard-wired reaction processes,
C  selected by ...=0 flag in input block 4 for each species.
C
c  fill reacdat(k)%... with default reaction data, K < 0.
c  first set default rate coefficients K= -4,-5,...-11 (-1, -2 and -3 are not used)
c                                                  (extrapolation flags: 0)
c  and
c  then set default cross-sections     K= -1,-2,-3 (extrapolation flags: 5)
c


      use EIRMOD_precision
      use EIRMOD_parmmod
      use EIRMOD_comxs

      implicit none

      integer :: ir  ! corresponds to flags k, kk, istore,.....
                     ! in calling programs


!  SPECIFY DEFAULT MODEL FOR RATE COEFFICIENTS,
!  FILL REACDAT..%RTC...


!  HERE: K= -4,-5,...-10,-11
!        K= -1,-2,-3: currently not used, only for cross-sections, see below
C
C K=-1: FREE
C K=-2: FREE
C K=-3: FREE

C K=-4: E + H --> H+ + 2E
C  RATE COEFFICIENT, JANEV, 2.1.5
      IR = -4
      CALL EIRENE_ALLOC_FIT_FORM(REACDAT(IR)%RTC)

      ALLOCATE(REACDAT(IR)%RTC%POLY)
      ALLOCATE(REACDAT(IR)%RTC%POLY%DBLPOL(1:9,1))
      REACDAT(IR)%LRTC = .TRUE.
      REACDAT(IR)%RTC%IFIT = 1
c  currently: no asymptotics for this default reaction
c
!  ALREADY INITIALIZED IN EIRENE_INIT_CMDTA
!     REACDAT(IR)%RTMAX = 0._DP
!     REACDAT(IR)%ERTMAX = -HUGE(1._DP)
      REACDAT(IR)%ETH = 13.6_DP

      REACDAT(IR)%RTC%POLY%DBLPOL(1:9,1) =
     . (/-3.271396786375D+01,  1.353655609057D+01, -5.739328757388D+00,
     .    1.563154982022D+00, -2.877056004391D-01,  3.482559773737D-02,
     .   -2.631976175590D-03,  1.119543953861D-04, -2.039149852002D-06/)
      IFTFLG(IR,2) = 0

C K=-5: E + H2 --> H + H + E
C  RATE COEFFICIENT, JANEV, 2.2.5, PREPRINT (CORRECT), NOT "BOOK"
      IR = -5
      CALL EIRENE_ALLOC_FIT_FORM(REACDAT(IR)%RTC)
      ALLOCATE(REACDAT(IR)%RTC%POLY)
      ALLOCATE(REACDAT(IR)%RTC%POLY%DBLPOL(1:9,1))
      REACDAT(IR)%LRTC = .TRUE.
      REACDAT(IR)%RTC%IFIT = 1
c  currently: no asymptotics for this default reaction
c
!  ALREADY INITIALIZED IN EIRENE_INIT_CMDTA
!     REACDAT(IR)%RTMAX = 0._DP
!     REACDAT(IR)%ERTMAX = -HUGE(1._DP)
      REACDAT(IR)%ETH = 10.5_DP

      REACDAT(IR)%RTC%POLY%DBLPOL(1:9,1) =
     . (/-2.787217511174D+01,  1.052252660075D+01, -4.973212347860D+00,
     .    1.451198183114D+00, -3.062790554644D-01,  4.433379509258D-02,
     .   -4.096344172875D-03,  2.159670289222D-04, -4.928545325189D-06/)
      IFTFLG(IR,2) = 0

C K=-6: E + H2 --> H+ + H + 2E
C  RATE COEFFICIENT, JANEV, 2.2.10
      IR = -6
      CALL EIRENE_ALLOC_FIT_FORM(REACDAT(IR)%RTC)
      ALLOCATE(REACDAT(IR)%RTC%POLY)
      ALLOCATE(REACDAT(IR)%RTC%POLY%DBLPOL(1:9,1))
      REACDAT(IR)%LRTC = .TRUE.
      REACDAT(IR)%RTC%IFIT = 1
c  currently: no asymptotics for this default reaction
c
!  ALREADY INITIALIZED IN EIRENE_INIT_CMDTA
!     REACDAT(IR)%RTMAX = 0._DP
!     REACDAT(IR)%ERTMAX = -HUGE(1._DP)
      REACDAT(IR)%ETH = 25.0_DP

      REACDAT(IR)%RTC%POLY%DBLPOL(1:9,1) =
     . (/-3.834597006782D+01,  1.426322356722D+01, -5.826468569506D+00,
     .    1.727940947913D+00, -3.598120866343D-01,  4.822199350494D-02,
     .   -3.909402993006D-03,  1.738776657690D-04, -3.252844486351D-06/)
      IFTFLG(IR,2) = 0

C K=-7: E + H2 --> H2+(VIB) + 2E
C  RATE COEFFICIENT, JANEV, 2.2.9
      IR = -7
      CALL EIRENE_ALLOC_FIT_FORM(REACDAT(IR)%RTC)
      ALLOCATE(REACDAT(IR)%RTC%POLY)
      ALLOCATE(REACDAT(IR)%RTC%POLY%DBLPOL(1:9,1))
      REACDAT(IR)%LRTC = .TRUE.
      REACDAT(IR)%RTC%IFIT = 1
c  currently: no asymptotics for this default reaction
c
!  ALREADY INITIALIZED IN EIRENE_INIT_CMDTA
!     REACDAT(IR)%RTMAX = 0._DP
!     REACDAT(IR)%ERTMAX = -HUGE(1._DP)
      REACDAT(IR)%ETH = 15.45_DP

      REACDAT(IR)%RTC%POLY%DBLPOL(1:9,1) =
     . (/-3.568640293666D+01,  1.733468989961D+01, -7.767469363538D+00,
     .    2.211579405415D+00, -4.169840174384D-01,  5.088289820867D-02,
     .   -3.832737518325D-03,  1.612863120371D-04, -2.893391904431D-06/)
      IFTFLG(IR,2) = 0

C K=-8: E + H2+(VIB) --> H + H+ + E
C  RATE COEFFICIENT, JANEV, 2.2.12
      IR = -8
      CALL EIRENE_ALLOC_FIT_FORM(REACDAT(IR)%RTC)
      ALLOCATE(REACDAT(IR)%RTC%POLY)
      ALLOCATE(REACDAT(IR)%RTC%POLY%DBLPOL(1:9,1))
      REACDAT(IR)%LRTC = .TRUE.
      REACDAT(IR)%RTC%IFIT = 1
c  currently: no asymptotics for this default reaction
c
!  ALREADY INITIALIZED IN EIRENE_INIT_CMDTA
!     REACDAT(IR)%RTMAX = 0._DP
!     REACDAT(IR)%ERTMAX = -HUGE(1._DP)
      REACDAT(IR)%ETH = 10.5_DP

      REACDAT(IR)%RTC%POLY%DBLPOL(1:9,1) =
     . (/-1.781416067709D+01,  2.277799785711D+00, -1.266868411626D+00,
     .    4.296170447419D-01, -9.609908013189D-02,  1.387958040699D-02,
     .   -1.231349039470D-03,  6.042383126281D-05, -1.247521040900D-06/)
      IFTFLG(IR,2) = 0

C K=-9: E + H2+(VIB) --> H+ + H+ + 2E
C  RATE COEFFICIENT, JANEV, 2.2.11
      IR = -9
      CALL EIRENE_ALLOC_FIT_FORM(REACDAT(IR)%RTC)
      ALLOCATE(REACDAT(IR)%RTC%POLY)
      ALLOCATE(REACDAT(IR)%RTC%POLY%DBLPOL(1:9,1))
      REACDAT(IR)%LRTC = .TRUE.
      REACDAT(IR)%RTC%IFIT = 1
c  currently: no asymptotics for this default reaction
c
!  ALREADY INITIALIZED IN EIRENE_INIT_CMDTA
!     REACDAT(IR)%RTMAX = 0._DP
!     REACDAT(IR)%ERTMAX = -HUGE(1._DP)
      REACDAT(IR)%ETH = 15.5

      REACDAT(IR)%RTC%POLY%DBLPOL(1:9,1) =
     . (/-3.746192301092D+01,  1.559355031108D+01, -6.693238367093D+00,
     .    1.981700292134D+00, -4.044820889297D-01,  5.352391623039D-02,
     .   -4.317451841436D-03,  1.918499873454D-04, -3.591779705419D-06/)
      IFTFLG(IR,2) = 0

C K=-10: E + H2+(VIB) --> H + H(N)
C  RATE COEFFICIENT, JANEV, 2.2.14
      IR = -10
      CALL EIRENE_ALLOC_FIT_FORM(REACDAT(IR)%RTC)
      ALLOCATE(REACDAT(IR)%RTC%POLY)
      ALLOCATE(REACDAT(IR)%RTC%POLY%DBLPOL(1:9,1))
      REACDAT(IR)%LRTC = .TRUE.
      REACDAT(IR)%RTC%IFIT = 1
c  currently: no asymptotics for this default reaction
c
!  ALREADY INITIALIZED IN EIRENE_INIT_CMDTA
!     REACDAT(IR)%RTMAX = 0._DP
!     REACDAT(IR)%ERTMAX = -HUGE(1._DP)
!     REACDAT(IR)%ETH = 0._DP
cdr
cdr  original H.2, 2.2.14 fit in Janev 1987
cdr   REACDAT(IR)%RTC%POLY%DBLPOL(1:9,1) =
cdr  . (/-1.670435653561D+01, -6.035644995682D-01, -1.942745783445D-08,
cdr  .   -2.005952284492D-07,  2.962996104431D-08,  2.134293274971D-08,
cdr  .   -6.353973401838D-09,  6.152557460831D-10, -2.025361858319D-11/)
cdr  reduce original fit to linear expression in log-log scale
cdr  the resulting mean electron energy loss per event
cdr  is then exactly Te*(3/2+b1)=Te*(8.964355004318D-01)
cdr
      REACDAT(IR)%RTC%POLY%DBLPOL(1:9,1) =
     . (/-1.670435653561D+01, -6.035644995682D-01,  0.000000000000D+00,
     .    0.000000000000D+00,  0.000000000000D+00,  0.000000000000D+00,
     .    0.000000000000D+00,  0.000000000000D+00,  0.000000000000D+00/)
      IFTFLG(IR,2) = 0

cdr  here a corresponding H.8 reaction can be set, and: IFTFLG(IR,4)=0

C K=-11: E + HE --> 2E + HE+
C  RATE COEFFICIENT, JANEV, 2.3.9
      IR = -11
      CALL EIRENE_ALLOC_FIT_FORM(REACDAT(IR)%RTC)
      ALLOCATE(REACDAT(IR)%RTC%POLY)
      ALLOCATE(REACDAT(IR)%RTC%POLY%DBLPOL(1:9,1))
      REACDAT(IR)%LRTC = .TRUE.
      REACDAT(IR)%RTC%IFIT = 1
c  currently: no asymptotics for this default reaction
c
!  ALREADY INITIALIZED IN EIRENE_INIT_CMDTA
!     REACDAT(IR)%RTMAX = 0._DP
!     REACDAT(IR)%ERTMAX = -HUGE(1._DP)
      REACDAT(IR)%ETH = 24.56_DP

      REACDAT(IR)%RTC%POLY%DBLPOL(1:9,1) =
     .  (/-4.409864886561d+01, 2.391596563469d+01,-1.075323019821d+01,
     .     3.058038757198d+00,-5.685118909884d-01, 6.795391233790d-02,
     .    -5.009056101857d-03, 2.067236157507d-04,-3.649161410833d-06/)
      IFTFLG(IR,2) = 0

C

c.......................................................................

!  SPECIFY DEFAULT MODEL FOR CROSS-SECTIONS:  K=-1,-2,-3, DEFAULT CX CROSS-SECTIONS
!  FILL REACDAT..%CRS...

C  K=-1: H + H+ --> H+ + H CROSS-SECTION, JANEV, 3.1.8
C        LINEAR EXTRAPOLATION AT LOW ENERGY END FOR LN(SIGMA)
C        IDENTICAL TO hydhel.tex, H.1, 3.1.8
      IR = -1
      CALL EIRENE_ALLOC_FIT_FORM(REACDAT(IR)%CRS)
      ALLOCATE(REACDAT(IR)%CRS%POLY)
      ALLOCATE(REACDAT(IR)%CRS%POLY%DBLPOL(1:9,1))
      REACDAT(IR)%LCRS = .TRUE.
      REACDAT(IR)%CRS%IFIT = 1
      REACDAT(IR)%CRS%POLY%DBLPOL(1:9,1) =
     . (/-3.274123792568D+01, -8.916456579806D-02, -3.016990732025D-02,
     .    9.205482406462D-03,  2.400266568315D-03, -1.927122311323D-03,
     .    3.654750340106D-04, -2.788866460622D-05,  7.422296363524D-07/)
      IFTFLG(IR,1) = 0
c  asymptotic expression from data file HYDHEL, at low energy limit
      REACDAT(IR)%CRS%RC1MIN = -2.3025851D+00   ! ELABMIN=0.1
      REACDAT(IR)%CRS%RC1MAX = HUGE(1._DP)
      REACDAT(IR)%CRS%RC2MIN = -HUGE(1._DP)
      REACDAT(IR)%CRS%RC2MAX = HUGE(1._DP)
      REACDAT(IR)%CRS%FP1L = (/ -3.2945896D+01, -1.7131120D-01, 0._DP /)
      REACDAT(IR)%CRS%FP1R = 0._DP
      REACDAT(IR)%CRS%FP2B = 0._DP
      REACDAT(IR)%CRS%FP2T = 0._DP
C  USE ASYMPTOTIC EXPRESSION NO. IFMN=5 AT LOW ENERGY END
      REACDAT(IR)%CRS%JFEX1MN = 5
      REACDAT(IR)%CRS%JFEX1MX = 0
      REACDAT(IR)%CRS%JFEX2MN = 0
      REACDAT(IR)%CRS%JFEX2MX = 0
c
!  ALREADY INITIALIZED IN EIRENE_INIT_CMDTA
!     REACDAT(IR)%RTMAX = 0._DP
!     REACDAT(IR)%ERTMAX = -HUGE(1._DP)
!     REACDAT(IR)%ETH = 0._DP
      IFTFLG(IR,1) = 0

C
C  K=-2: He + He+ --> He+ + He CROSS-SECTION, JANEV, 5.3.1
C        LINEAR EXTRAPOLATION AT LOW ENERGY END FOR LN(SIGMA)
C        IDENTICAL TO hydhel.tex, H.1, 5.3.1
      IR = -2
      CALL EIRENE_ALLOC_FIT_FORM(REACDAT(IR)%CRS)
      ALLOCATE(REACDAT(IR)%CRS%POLY)
      ALLOCATE(REACDAT(IR)%CRS%POLY%DBLPOL(1:9,1))
      REACDAT(IR)%LCRS = .TRUE.
      REACDAT(IR)%CRS%IFIT = 1
      REACDAT(IR)%CRS%POLY%DBLPOL(1:9,1) =
     . (/ -3.369296194290d+01,-8.324653178943d-02, 6.660151719388d-03,
     .    -3.592504363592d-03,-1.745382918016d-04, 1.497204460315d-04,
     .    -2.152122621503d-05, 1.473684503283d-06,-4.401831552698d-08/)
      IFTFLG(IR,1) = 0
c  currently: no asymptotics for this default reaction
      REACDAT(IR)%CRS%RC1MIN = -HUGE(1._DP)
      REACDAT(IR)%CRS%RC1MAX = HUGE(1._DP)
      REACDAT(IR)%CRS%RC2MIN = -HUGE(1._DP)
      REACDAT(IR)%CRS%RC2MAX = HUGE(1._DP)
      REACDAT(IR)%CRS%FP1L = 0._DP
      REACDAT(IR)%CRS%FP1R = 0._DP
      REACDAT(IR)%CRS%FP2B = 0._DP
      REACDAT(IR)%CRS%FP2T = 0._DP
C  USE ASYMPTOTIC EXPRESSION NO. IFMN=5
      REACDAT(IR)%CRS%JFEX1MN = 5
      REACDAT(IR)%CRS%JFEX1MX = 5
      REACDAT(IR)%CRS%JFEX2MN = 0
      REACDAT(IR)%CRS%JFEX2MX = 0
c
!  ALREADY INITIALIZED IN EIRENE_INIT_CMDTA
!     REACDAT(IR)%RTMAX = 0._DP
!     REACDAT(IR)%ERTMAX = -HUGE(1._DP)
!     REACDAT(IR)%ETH = 0._DP
      IFTFLG(IR,1) = 0

C
C  K=-3: He + He++ --> He++ + He CROSS-SECTION, JANEV, 6.3.1
C        LINEAR EXTRAPOLATION AT LOW ENERGY END FOR LN(SIGMA)
C        IDENTICAL TO hydhel.tex, H.1, 6.3.1
      IR = -3
      CALL EIRENE_ALLOC_FIT_FORM(REACDAT(IR)%CRS)
      ALLOCATE(REACDAT(IR)%CRS%POLY)
      ALLOCATE(REACDAT(IR)%CRS%POLY%DBLPOL(1:9,1))
      REACDAT(IR)%LCRS = .TRUE.
      REACDAT(IR)%CRS%IFIT = 1
      REACDAT(IR)%CRS%POLY%DBLPOL(1:9,1) =
     . (/ -3.459818117569d+01,-8.748942423786d-02,-2.445604128495d-02,
     .     2.392295193337d-03, 9.876388162277d-04,-2.282012750308d-04,
     .     3.598361283629d-06, 1.940270105613d-06,-1.105794797036d-07/)
      IFTFLG(IR,1) = 0
c  currently: no asymptotics for this default reaction
      REACDAT(IR)%CRS%RC1MIN = -HUGE(1._DP)
      REACDAT(IR)%CRS%RC1MAX = HUGE(1._DP)
      REACDAT(IR)%CRS%RC2MIN = -HUGE(1._DP)
      REACDAT(IR)%CRS%RC2MAX = HUGE(1._DP)
      REACDAT(IR)%CRS%FP1L = 0._DP
      REACDAT(IR)%CRS%FP1R = 0._DP
      REACDAT(IR)%CRS%FP2B = 0._DP
      REACDAT(IR)%CRS%FP2T = 0._DP
C  USE ASYMPTOTIC EXPRESSION NO. IFMN=5
      REACDAT(IR)%CRS%JFEX1MN = 5
      REACDAT(IR)%CRS%JFEX1MX = 5
      REACDAT(IR)%CRS%JFEX2MN = 0
      REACDAT(IR)%CRS%JFEX2MX = 0
c
!  ALREADY INITIALIZED IN EIRENE_INIT_CMDTA
!     REACDAT(IR)%RTMAX = 0._DP
!     REACDAT(IR)%ERTMAX = -HUGE(1._DP)
!     REACDAT(IR)%ETH = 0._DP
      IFTFLG(IR,1) = 0


      end subroutine EIRENE_setup_default_reactions
