c  25.11.05: option modcol(3,4...)=3 added
c            (first implemented in fpatha)
c            CX rate option 4 added (adopted from fpatha)
C               added: jcou,ncou
!pb  30.08.06:  data structure for reaction data redefined
!pb  12.10.06:  modcol revised
!pb  22.11.06:  flag for shift of first parameter to rate_coeff introduced
!pb  28.11.06:  initialization of XSTOR reactivated because of trouble in
!pb             BGK iteration
!pb  22.03.07:  PI reactions revised
cdr  oct.14  :  ftabcx3 added. Full tests still to be done
cdr  oct.14  :  synchronized with fpathm, fpathi

cdr 31.10.14 :  speedup of final cut-off evaluations

cdr note:       sngl_poly evaluations are just the 8th-order polynomial,
cdr             plus rcmin,rcmax consideration.
cdr             unless rcmin,rcmax are set (as it is the case currently here),
cdr             there is no need to call  --> move to in-line
cdr 06.08.15 :  arguments added to vecusr
cdr 13.08.15 :  cflag(4,1) changed from 2 to 1 (as it was in fpatha).  Is that correct ??

cdr dec. 15:    missing: ftabel3
cdr jan. 16:    call to ftabcx3 added and tested for modcol=1 option


cdr summer 16:  connect function fehvei1 for kinetic energy release in
cdr             storage saving mode
cdr aug. 16:    bug fix re EXPO in PI branch
cdr sept.16:    PI process: use v0/vth >> 1. to switch to beam-rate coeff
cdr             EI process: started to check for H.3, H.1 options for EI processes
cdr                         according to v0/vth >> 1. criteria
cdr Nov. 16:    cflag(7,mstor0) rather than cflag(6,3), see comments

cdr nov. 17:    unified version of fpatha, fpathm and fpathi,
cdr             manually adapted from original branch "code-combine", aug. 16, (p.b.)
cdr dec  17:    bug fix: pvelq(iplsv), rather than pvelq(ipls)
cdr             probably no effect so far, because iplsv = ipls ?always?
cdr Nov. 19:    EARRH Arrhenius factor added
cdr             cflag(4,irpi) changed from 1 to 2.
cdr             Removed need for cross-sections, when
cdr             we have only (H.2) Maxwellian rates anyway.
cdr             Simpler (in velopi.f) and also more consistent.
cdr             tbd: full modcol(4,4,..) options for PI processes
cdr Feb. 22:    remove unused leading dimension in LGX... arrays.

C
      FUNCTION EIRENE_FPATH (K,CFLAG,JCOU,NCOU)
C
C   CALCULATE MEAN FREE PATH AND REACTION RATES FOR NEUTRAL OR CHARGED
C   "BEAM PARTICLES" , SPECIES IXSPZ, OF VELOCITY VEL IN DRIFTING MAXWELLIAN BACKGROUND MEDIUM
C   IN CELL K

C
C   INPUT:
C   IXSPZ     :  SPECIES INDEX (POINTER: IATM, IMOL, IION, IPHOT) (INPUT VIA COMMON)
C   K         :  CURRENT GRID CELL
C   JCOU, NCOU:  THERE WILL BE NCOU CALLS TO FPATH, FOR SAME TEST PARTICLE
C                COORDINATES WITH DIFFERENT CELL NUMBER K.
C                THIS CURRENT CALL IS CALL NO. JCOU.

C   OUTPUT: COMMON COMLCA
C           CFLAG: FLAG FOR SAMPLING OF POST-COLLISION STATES
C           CFLAG(1,...): EI
C           CFLAG(2,...): NOT IN USE, was DS process class in very old versions
C           CFLAG(3,...): CX
C           CFLAG(4,...): PI
C           CFLAG(5,...): EL
C           CFLAG(6,...): RC
c           CFLAG(7,...): PH PHOTONIC PROCESSES
C
C   FLAG FOR POST-COLLISION DISTRIBUTION IN VELOCITY SPACE
C  CFLAG(...,IRCL),  IRCL: IREI,..., IRCX,IRPI,IREL,IRRC,IRPH
C      =0: VI: DELTA COLLISION IN VELOCITY SPACE (BUT DIFFERENT
C                                                   SPECIES ALLOWED)
C      =1: VI: MONOENERGETIC AND ISOTROPIC IN FRAME MOVING WITH BULK SPECIES
C      =2: VI: DRIFTING MAXWELLIAN
C      =3: VI: SIGMA-V-WEIGHTED MAXWELLIAN IN FRAME MOVING WITH BULK SPECIES
C      =X  VI: DELTA COLLISION IN VELOCITY SPACE: VI=V0 (BUT DIFFERENT SPECIES ALLOWED)
C              TO BE WRITTEN
C
      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD
      USE EIRMOD_COMUSR
      USE EIRMOD_CCONA
      USE EIRMOD_CLOGAU
      USE EIRMOD_CINIT
      USE EIRMOD_CZT1
      USE EIRMOD_COMPRT
      USE EIRMOD_COMXS
      USE EIRMOD_CESTIM , ONLY: LEX
      USE EIRMOD_CTRCEI , ONLY: TRCAMD

      IMPLICIT NONE

      REAL(DP), INTENT(OUT) :: CFLAG(7,MSTOR0)
      INTEGER, INTENT(IN) :: K,JCOU,NCOU

      REAL(DP) :: DENIO(NPLS), ZTI(NPLS)
      REAL(DP) :: PVELQ(NPLSV)
      REAL(DP) :: TBCX3(9), TBEL3(9), TBPI3(9), FP(6), FP2(6)
      REAL(DP) :: EPCX3(9), EPEL3(9)  !EPPI3: TO BE DONE
      REAL(DP) :: EIRENE_FPATH, EIRENE_FPATHPH,
     .          EIRENE_CROSS,
     .          EIRENE_RATE_COEFF, EIRENE_SNGL_POLY,
     .          EIRENE_ENERGY_RATE_COEFF,
     .          CEL, CXS, CII, VEFFQ, VEFF,
     .          TBEL,
     .          SIGMAX, EHEAVY,
     .          DENEL, VX, VY, VZ, PVELQ0, ELAB,
     .          VRELQ, VREL, XC, YC, ZC,
     .          ELB, TII,
cdr  .          V0_REL,  ! for diagnostic purposes only
     .          EXPO,
cdr  functions for 'on the fly' evaluation of A&M data
     .          EIRENE_FEELEI1, EIRENE_FEELPI3,
     .          EIRENE_FEHVEI1, EIRENE_FEHVPI3,
     .          EIRENE_FEPLCX3, EIRENE_FEPLEL3,
     .          EIRENE_FTABCX3, EIRENE_FTABPI3,
     .          EIRENE_FTABEI1,
     .          RCMIN, RCMAX, EARRH,
     .          RC2MIN, RC2MAX
      INTEGER :: IBGK, IXEL, IREL, IXEI, IREI, IXPI, IRPI,
     .                 IXCX, IRCX,
     .           J, KK, IPLSTI,
     .           JPLS, IPLSV, IREAC,
     .           jfex2mn, jfex2mx
      REAL(DP), PARAMETER :: TMINL=-2.3_DP
      REAL(DP), PARAMETER :: EMINL=-2.3_DP  ! hard-coded cut-off
                                  ! for EBEAM parameter in H.3 fits
      EXTERNAL :: EIRENE_VECUSR, EIRENE_EXIT_OWN, EIRENE_CROSS,
     .            EIRENE_FEELEI1, EIRENE_FEELPI3, EIRENE_FEHVEI1,
     .            EIRENE_FEHVPI3, EIRENE_FEPLCX3, EIRENE_FEPLEL3,
     .            EIRENE_FPATHPH,
     .            EIRENE_FTABCX3, EIRENE_FTABEI1, EIRENE_FTABPI3,
     .            EIRENE_ENERGY_RATE_COEFF, EIRENE_RATE_COEFF,
     .            EIRENE_SNGL_POLY

!  FOR PHOTONS CALL EIRENE_FPATHPH
      IF (ITYP == 0) THEN
        EIRENE_FPATH = EIRENE_FPATHPH(K,CFLAG,JCOU,NCOU)
        RETURN
      END IF
C
C  SET DEFAULTS: NO REACTIONS
C
      XSTORV=0.D0
!pb   IF (NCOU.GT.1) THEN
        XSTOR=0.D0
!pb   ENDIF
      EIRENE_FPATH=1.D10
      SIGMAX=0.D0
C
      IF (LGVAC(K,0)) RETURN
C
C   LOCAL PLASMA PARAMETERS
C
      DENEL=DEIN(K)

      DO JPLS=1,NPLSI
        ZTI(JPLS)=ZT1(JPLS,K)
        DENIO(JPLS)=DIIN(JPLS,K)
      END DO
C
C  TRANSFORM TEST PARTICLE VELOCITY TO FRAME MOVING WITH BULK SPECIES IPLS
C            PVELQ(IPLSV) IS THE VELOCITY IN THESE REFERENCE FRAMES, SQUARED
C
      PVELQ0=VEL*VEL
      DO JPLS=1,NPLS
        IPLSV=MPLSV(JPLS)
        IF (NLDRFT) THEN
          IF (INDPRO(4) == 8) THEN
            XC=0.
            YC=0.
            ZC=0.
            CALL EIRENE_VECUSR (2,K,XC,YC,ZC,VX,VY,VZ,JPLS,.FALSE.)
          ELSE
            VX=VXIN(IPLSV,K)
            VY=VYIN(IPLSV,K)
            VZ=VZIN(IPLSV,K)
          END IF
          PVELQ(IPLSV)=(VELX*VEL-VX)**2+
     .                 (VELY*VEL-VY)**2+
     .                 (VELZ*VEL-VZ)**2
        ELSE
          PVELQ(IPLSV)=PVELQ0
        ENDIF
      END DO
C
C
C  ELECTRON IMPACT COLLISION - RATE - COEFFICIENT
C  NO MASS SCALING NEEDED FOR BULK ELECTRONS
C
      IF (LGXEI(0).EQ.0.OR.LGVAC(K,NPLS+1)) GOTO 30
      DO 10 IXEI=1,NXEII
        IREI=LGXEI(IXEI)
        IF (MODCOL(1,2,IREI).EQ.1) THEN
          IF (NSTORDR >= NRAD) THEN
            SIGVEI(IREI)=TABEI1(IREI,K)
          ELSE
            SIGVEI(IREI)=EIRENE_FTABEI1(IREI,K)
          END IF
        ELSE
          GOTO 990
        ENDIF
C
        IF (NSTORDR >= NRAD) THEN
          ESIGEI(IREI,5)=EELEI1(IREI,K)
          EHEAVY        =EHVEI1(IREI,K)
        ELSE
          ESIGEI(IREI,5)=EIRENE_FEELEI1(IREI,K)
          EHEAVY        =EIRENE_FEHVEI1(IREI,K)
        ENDIF
C
        ESIGEI(IREI,1)=EATEI(IREI,0,1)*E0+EATEI(IREI,0,2)*EHEAVY
        ESIGEI(IREI,2)=EMLEI(IREI,0,1)*E0+EMLEI(IREI,0,2)*EHEAVY
        ESIGEI(IREI,3)=EIOEI(IREI,0,1)*E0+EIOEI(IREI,0,2)*EHEAVY

        ESIGEI(IREI,4)=EPLEI(IREI,0,1)*E0+EPLEI(IREI,0,2)*EHEAVY
C
        SIGMAX=MAX(SIGMAX,SIGVEI(IREI))
        SIGEIT=SIGEIT+SIGVEI(IREI)
   10 CONTINUE
C
C  GENERAL ION IMPACT ON TEST PARTICLE IXSPZ, BULK ION SPEZIES IPLS=1,NPLSI
C  30--->40
C
   30 IF (LGXPI(0,0).EQ.0) GOTO 40
      DO 36 IXPI=1,NXPII
        IRPI=LGXPI(IXPI,0)
        IPLS=LGXPI(IXPI,1)
        IPLSV=MPLSV(IPLS)
        IPLSTI=MPLSTI(IPLS)
        IF (LGVAC(K,IPLS)) GOTO 36
C
C  1.) RATE COEFFICIENT
C
        IF (MODCOL(4,2,IRPI).EQ.1) THEN
C  MAXWELL, AT PRE-SPECIFIED BEAM ENERGY, MOSTLY AT EB=0.0
C           OR AT A PRE-SPEFICIED TEST PARTICLE TEMP. TB, MOSTLY TB=TI
cdr  strictly we should use E0/Ti as smallness parameter, just the opposite case as in model 2.
          IF (NSTORDR >= NRAD) THEN
            SIGVPI(IRPI)=TABPI3(IRPI,K,1)
          ELSE
CDR  SIGVPI(IRPI)=FTABPI3 : NOT READY
!pb         KK=NREAPI(IRPI)
!pb         TII=TIINL(IPLSTI,K)+ADDPI(IRPI,IPLS)
!pb         TBPI = EIRENE_RATE_COEFF(KK,K,TII,0._DP,.TRUE.,0)*DIIN(IPLS,K)
!pb         SIGVPI(IRPI)=TBPI
c
            SIGVPI(IRPI)=EIRENE_FTABPI3(IRPI,K)
          END IF

        ELSEIF (MODCOL(4,2,IRPI).EQ.2) THEN

C  MODEL 2:
C  BEAM - MAXWELLIAN RATE IN PLASMA FRAME

! Scale log collision energy to projectile energy for proper isotope, for rate coefficient,
! i.e. use neutral particle mass.
C
          IF (TIIN(IPLSTI,K).LT.TVAC) THEN  ! cannot happen,
                                            ! here already lgvac(ipls)=T
C  HERE: T_I IS SO LOW, THAT ALL ION ENERGY IS IN DRIFT MOTION.
cdr  strictly we should use Ti/E0 as smallness parameter, not Ti alone.
C           HENCE: USE BEAM-BEAM RATE INSTEAD.
            VRELQ=PVELQ(IPLSV)
            VREL=SQRT(VRELQ)
            ELAB=LOG(VRELQ)+DEFPI(IRPI)
            IREAC=MODCOL(4,1,IRPI)
            CII=EIRENE_CROSS(ELAB,IREAC,IRPI,FACRPI(IRPI,1),
     .                       'FPATH PI1')
            SIGVPI(IRPI)=CII*VREL*DENIO(IPLS)
          ELSE
C  Set hard-wired MINIMUM PROJECTILE ENERGY cut off: 0.1 EV
! scale log projectile energy for proper isotope, for rate coefficient, i.e. use test particle mass
            ELB=MAX(EMINL,LOG(PVELQ(IPLSV))+EEFPI(IRPI))
cdr         V0_REL=SQRT(PVELQ(IPLSV)) ! is already isotopically correct
! scale log temperature to target temperature for proper isotope, for rate coefficient, i.e. use field particle mass
            TII=TIINL(IPLSTI,K)+ADDPI(IRPI,IPLS)
            IF (NSTORDR >= NRAD) THEN
              TBPI3(1:NSTORDT) = TABPI3(IRPI,K,1:NSTORDT)
cdr  energy dependence (for 2nd fit parameter).
cdr  No Arrhenius factor
cdr  No asymptotics (tbd)
              FP = 0._DP
              RCMIN = -HUGE(1._DP)
              RCMAX = HUGE(1._DP)
c  energy dependence (for 2nd fit parameter). No Arrhenius factor
              EARRH = 0.0
              EXPO = EIRENE_SNGL_POLY(TBPI3,ELB,RCMIN,RCMAX,FP,0,0,
     .                                EARRH,TRCAMD,.TRUE.)
              SIGVPI(IRPI)=EXPO
            ELSE
! CALCULATE RATE COEFFICIENT "ON THE FLY"
CDR  THIS SHOULD BE DONE IN FTABPI3.  NOT READY
              KK=NREAPI(IRPI)
              EXPO = EIRENE_RATE_COEFF(KK,K,TII,ELB,.FALSE.,0)
     .             + DIINL(IPLS,K) + FACRPI(IRPI,2)
              SIGVPI(IRPI)=EXP(EXPO)
            ENDIF
          END IF

C  MODEL 3:
        ELSEIF (MODCOL(4,2,IRPI).EQ.3) THEN
C  BEAM - BEAM, BUT WITH EFFECTIVE INTERACTION ENERGY
          VRELQ=ZTI(IPLS)+PVELQ(IPLSV)
          VREL=SQRT(VRELQ)
! scale log collision energy to mass as used for cross-section energy scale
          ELAB=LOG(VRELQ)+DEFPI(IRPI)
          IREAC=MODCOL(4,1,IRPI)
          CII=EIRENE_CROSS(ELAB,IREAC,IRPI,FACRPI(IRPI,1),'FPATH II')
          SIGVPI(IRPI)=CII*VREL*DENIO(IPLS)
        ELSE
          GOTO 991
        ENDIF
C
C  2.A ELECTRON ENERGY LOSS PER COLLISION (EV)
C
        IF (NSTORDR >= NRAD) THEN
          ESIGPI(IRPI,5)=EELPI3(IRPI,K,1)
          EHEAVY        =EHVPI3(IRPI,K,1)
        ELSE
          ESIGPI(IRPI,5)=EIRENE_FEELPI3(IRPI,K)
          EHEAVY        =EIRENE_FEHVPI3(IRPI,K)
        ENDIF
C
C  2.B SECONDARY PARTICLE ENERGY LOSS/GAIN PER COLLISION (EV)
C
        ESIGPI(IRPI,1)=EATPI(IRPI,0,1)*E0+EATPI(IRPI,0,2)*EHEAVY
        ESIGPI(IRPI,2)=EMLPI(IRPI,0,1)*E0+EMLPI(IRPI,0,2)*EHEAVY
        ESIGPI(IRPI,3)=EIOPI(IRPI,0,1)*E0+EIOPI(IRPI,0,2)*EHEAVY
cdr summed over post collision field particle species
cdr tbd:  two post collision field particles with different mass, hence different EHEAVY
cdr tbd:  use eplpi(iri,ipp,1) and eplpi(iri,ipp,2)
        ESIGPI(IRPI,4)=EPLPI(IRPI,0,1)*E0+EPLPI(IRPI,0,2)*EHEAVY
C
        SIGMAX=MAX(SIGMAX,SIGVPI(IRPI))
        SIGPIT=SIGPIT+SIGVPI(IRPI)
C
C  2.C BULK ION ENERGY LOSS PER COLLISION (EV)

cdr  here should come LEX condition, as well as iest(..,3)=0 (tracklength) condition
C
cdr     IF (NSTORDR >= NRAD) THEN
cdr       ESIGPI(IRPI,4)=EPLPI3(IRPI,K,1)
cdr     ELSE
cdr       ESIGPI(IRPI,4)=EIRENE_FEPLPI3(IRPI,K)
cdr     END IF
cdr     CFLAG(4,1)=2
c  cflag (4,...) should become cflag4(irpi,...).
c  tentatively:
cdr  set NFLAG for VELOPI: post collision velocity sampling
cdr     if (modcol(4,4,...)  ...) ...
        CFLAG(4,IRPI)=2  !dr, changed from 1 to 2.
cdr                           We may not have cross-sections,
cdr                           only velocity independent rates.
c
   36 CONTINUE
C
C  CHARGE EXCHANGE RATE COEFFICIENT OF TEST PARTICLE IXSPZ
C  WITH BULK IONS OF SPEZIES IPLS=1,NPLSI
C  40--->50
C
   40 CONTINUE
      IF (LGXCX(0,0).EQ.0.OR.LGVAC(K,0)) GOTO 50
      DO 41 IXCX=1,NXCXI
        IRCX=LGXCX(IXCX,0)
        IPLS=LGXCX(IXCX,1)
        IPLSTI=MPLSTI(IPLS)
        IPLSV=MPLSV(IPLS)
        IF (LGVAC(K,IPLS)) GOTO 41
C
C  1.) RATE COEFFICIENT
C
        IF (MODCOL(3,2,IRCX).EQ.1) THEN
C  MODEL 1:
C  MAXWELLIAN RATE, IGNORE TEST PARTICLE VELOCITY (or assume a pre-described temperature)
cdr  strictly we should use E0/Ti as smallness parameter, just the opposite case as in model 2.
          IF (NSTORDR >= NRAD) THEN
            SIGVCX(IRCX)=TABCX3(IRCX,K,1)
          ELSE
            SIGVCX(IRCX)=EIRENE_FTABCX3(IRCX,K)
          END IF

        ELSEIF (MODCOL(3,2,IRCX).EQ.2) THEN
C  MODEL 2:
C  BEAM - MAXWELLIAN RATE IN PLASMA FRAME
          IF (TIIN(IPLSTI,K).LT.TVAC) THEN  !  cannot happen,
                                            !  here already lgvac(ipls)
C  HERE: T_I IS SO LOW, THAT ALL ION ENERGY IS IN DRIFT MOTION.
cdr  strictly we should use Ti/E0 as smallness parameter, not Ti alone.
C           HENCE: USE BEAM-BEAM RATE INSTEAD.
            VRELQ=PVELQ(IPLSV)
            VREL=SQRT(VRELQ)
C   PMASS FOR CROSS-SECTION RELATIVE VELOCITY
            ELAB=LOG(VRELQ)+DEFCX(IRCX)
            IREAC=MODCOL(3,1,IRCX)
            CXS=EIRENE_CROSS(ELAB,IREAC,IRCX,FACRCX(IRCX,1),
     .                       'FPATH CX1')
            SIGVCX(IRCX)=CXS*VREL*DENIO(IPLS)
          ELSE
C  MINIMUM PROJECTILE ENERGY: 0.1 EV
cdr         if (LOG(PVELQ(IPLSV))+EEFCX(IRCX).le.EMINL) then
cdr           elb=LOG(PVELQ(IPLSV))+EEFCX(IRCX)
cdr           write (iunout,*) 'elb in fpath-1 ',elb, exp(elb)
cdr         endif
C   TMASS FOR RATE COEFF. BEAM VELOCITY
            ELB=MAX(EMINL,LOG(PVELQ(IPLSV))+EEFCX(IRCX))
            IF (NSTORDR >= NRAD) THEN
! DOUBLE POLYNOMIAL FIT REDUCED TO SINGLE POLYNOMIAL FIT BY
! PRE-CALCULATING TEMPERATURE DEPENDENCIES
              TBCX3(1:NSTORDT) = TABCX3(IRCX,K,1:NSTORDT)
! CNR: SET VALIDITY RANGE AND PARAMETERS FOR EXTRAPOLATION FOR SECOND PARAMETER (FIRST WAS REDUCED)
              KK=NREACX(IRCX)
              rc2min  = reacdat(KK)%rtc%rc2min
              rc2max  = reacdat(KK)%rtc%rc2max
              fp2(1:3)= reacdat(KK)%rtc%fp2b
              fp2(4:6)= reacdat(KK)%rtc%fp2t
              jfex2mn = reacdat(KK)%rtc%jfex2mn
              jfex2mx = reacdat(KK)%rtc%jfex2mx
              EARRH = 0.0
              EXPO = EIRENE_SNGL_POLY(TBCX3,ELB,RC2MIN,RC2MAX,
     .                                FP2,JFEX2MN,JFEX2MX,
     .                                EARRH,TRCAMD,.TRUE.)
              if (LOG(EXPO).GT.709._dp) then
                write(*,*) "OVERFLOW IN FPATH SIGVCX: ",EXPO,KK,
     .               K,TIIN(IPLSTI,K),ELB,DIIN(IPLS,K)*1.e6_dp
              end if
              SIGVCX(IRCX)=EXPO
            ELSE
! CALCULATE RATE COEFFICIENT ON THE FLY
CDR  THIS SHOULD BE DONE IN FTABCX3.  NOT READY
              KK=NREACX(IRCX)
              TII=TIINL(IPLSTI,K)+ADDCX(IRCX,IPLS)
              EXPO = EIRENE_RATE_COEFF(KK,K,TII,ELB,.FALSE.,0)
     .               + DIINL(IPLS,K) + FACRCX(IRCX,2)
              if (EXPO.GT.709._dp) then
                write(*,*) "OVERFLOW IN FPATH SIGVCX: ",EXPO,KK,
     .               K,TIIN(IPLSTI,K),ELB,DIIN(IPLS,K)*1.e6_dp
              end if
              SIGVCX(IRCX)=EXP(EXPO)
            END IF
          ENDIF

        ELSEIF (MODCOL(3,2,IRCX).EQ.3) THEN
C  MODEL 3: (ALSO: MINIMAL CX MODEL, ONLY CROSS-SECTION IS USED, NO RATE COEFFICIENTS)
C  BEAM - BEAM RATE, BUT WITH EFFECTIVE INTERACTION ENERGY TO APPROX.
c                    ACCOUNT FOR FIELD PARTICLE THERMAL ENERGY
          VEFFQ=ZTI(IPLS)+PVELQ(IPLSV)
          VEFF=SQRT(VEFFQ)
          ELAB=LOG(VEFFQ)+DEFCX(IRCX)
          IREAC=MODCOL(3,1,IRCX)
          CXS=EIRENE_CROSS(ELAB,IREAC,IRCX,FACRCX(IRCX,1),'FPATH CX2')
          SIGVCX(IRCX)=CXS*VEFF*DENIO(IPLS)
        ELSEIF (MODCOL(3,2,IRCX).EQ.4) THEN
C  MODEL 4
C  BEAM - BEAM RATE, IGNORE FIELD PARTICLE THERMAL ENERGY ALTOGETHER
          VRELQ=PVELQ(IPLSV)
          VREL=SQRT(VRELQ)
          ELAB=LOG(VRELQ)+DEFCX(IRCX)
          IREAC=MODCOL(3,1,IRCX)
          CXS=EIRENE_CROSS(ELAB,IREAC,IRCX,FACRCX(IRCX,1),'FPATH CX3')
          SIGVCX(IRCX)=CXS*VREL*DENIO(IPLS)
        ELSE
          GOTO 992
        ENDIF
C
        SIGMAX=MAX(SIGMAX,SIGVCX(IRCX))
        SIGCXT=SIGCXT+SIGVCX(IRCX)
C
C  2.) BULK ION ENERGY LOSS RATE:
C
        IF (MODCOL(3,4,IRCX).EQ.1) THEN
C  MODEL 1:
C  MEAN ENERGY FROM DRIFTING MAXWELLIAN
C  (ONLY NEEDED FOR PRE COLLISION ENERGY TRACKLENGTH ESTIMATOR)
C  ION SAMPLING FROM MAXWELLIAN
          IF (LEX.AND.(IESTCX(IRCX,3).EQ.0)) THEN  ! for tracklength
                                                   ! estimator only
            IF (NSTORDR >= NRAD) THEN
              ESIGCX(IRCX,1)=EPLCX3(IRCX,K,1)
            ELSE
              ESIGCX(IRCX,1)=EIRENE_FEPLCX3(IRCX,K)
            END IF
          END IF  ! this was for tracklength estimator only

cdr  set NFLAG for VELOCX: post-collision velocity sampling
          CFLAG(3,IRCX)=2
        ELSEIF (MODCOL(3,4,IRCX).EQ.2) THEN
C  MODEL 2:
C  MEAN ENERGY FROM CROSS-SECTION-WEIGHTED DRIFTING MAXWELLIAN
C  (ONLY NEEDED FOR TRACKLENGTH ESTIMATOR)
C  ION SAMPLING FROM WEIGHTED DRIFTING MAXWELLIAN (E.G., BY REJECTION)
          IF (LEX.AND.(IESTCX(IRCX,3).EQ.0)) THEN  ! for tracklength
                                                   ! estimator only
C  MINIMUM PROJECTILE ENERGY: 0.1 EV
cdr         if (LOG(PVELQ(IPLSV))+EEFCX(IRCX).le.EMINL) then
cdr           elb=LOG(PVELQ(IPLSV))+EEFCX(IRCX)
cdr           write (iunout,*) 'elb in fpath-2 ',elb, exp(elb)
cdr         endif
            ELB=MAX(EMINL,LOG(PVELQ(IPLSV))+EEFCX(IRCX))
            IF (NSTORDR >= NRAD) THEN
! DOUBLE POLYNOMIAL FIT REDUCED TO SINGLE POLYNOMIAL FIT BY
! PRE-CALCULATING TEMPERATURE DEPENDENCIES
              EPCX3(1:NSTORDT) = EPLCX3(IRCX,K,1:NSTORDT)
              FP = 0._DP
              RCMIN = -HUGE(1._DP)
              RCMAX = HUGE(1._DP)
              EARRH = 0.0
              EXPO = EIRENE_SNGL_POLY(EPCX3,ELB,RCMIN,RCMAX,FP,0,0,
     .                                EARRH,TRCAMD,.TRUE.)
              if (LOG(EXPO).GT.709._dp) then
                write(*,*) "ESIGCX: ",EXPO,KK,K,TII,ELB,
     .               DIINL(IPLS,K),FACRCX(IRCX,2)
              end if
              ESIGCX(IRCX,1)=EXPO/SIGVCX(IRCX)
            ELSE
! CALCULATE ENERGY-WEIGHTED RATE COEFFICIENT ON THE FLY
CDR  THIS SHOULD BE DONE IN ...  NOT READY
              KK=NELRCX(IRCX)
              TII=TIINL(IPLSTI,K)+ADDCX(IRCX,IPLS)
              EXPO = EIRENE_ENERGY_RATE_COEFF(KK,K,TII,ELB,.FALSE.,0)
     .               + DIINL(IPLS,K) + FACRCX(IRCX,2)
              if (EXPO.GT.709._dp) then
                write(*,*) "ESIGCX: ",EXPO,KK,K,TII,ELB,
     .               DIINL(IPLS,K),FACRCX(IRCX,2)
              end if
              ESIGCX(IRCX,1)=EXP(EXPO)/SIGVCX(IRCX)
            END IF

            IF (LEDRIFT) ESIGCX(IRCX,1)=ESIGCX(IRCX,1)+EDRIFT(IPLS,K)
          ENDIF  ! this was for tracklength estimator only

cdr  set NFLAG for VELOCX: post-collision velocity sampling
          CFLAG(3,IRCX)=3
        ELSEIF (MODCOL(3,4,IRCX).EQ.3) THEN
C  MODEL 3:
C  MEAN ENERGY FROM DRIFTING ISOTROPIC ONE SPEED DISTRIBUTION
C  (ONLY NEEDED FOR TRACKLENGTH ESTIMATOR)
C  ION SAMPLING FROM WEIGHTED DRIFTING ISOTROPIC ONE SPEED DISTRIBUTION
          IF (LEX.AND.(IESTCX(IRCX,3).EQ.0)) THEN  ! for tracklength
                                                   ! estimator only
            IF (NSTORDR >= NRAD) THEN
              ESIGCX(IRCX,1)=EPLCX3(IRCX,K,1)
            ELSE
              ESIGCX(IRCX,1)=EIRENE_FEPLCX3(IRCX,K)
            END IF
          ENDIF  ! this was for tracklength estimator only

cdr  set NFLAG for VELOCX: post-collision velocity sampling
          CFLAG(3,IRCX)=1
        ELSE
          GOTO 992
        ENDIF
   41 CONTINUE
C
C  ELASTIC COLLISIONS OF TEST PARTICLE IXSPZ  WITH BULK IONS OF SPEZIES IPLS=1,NPLSI
C  50--->60
C
   50 CONTINUE
      IF (LGXEL(0,0).EQ.0.OR.LGVAC(K,0)) GOTO 60
      DO 51 IXEL=1,NXELI
        IREL=LGXEL(IXEL,0)
        IPLS=LGXEL(IXEL,1)
        IPLSTI=MPLSTI(IPLS)
        IPLSV=MPLSV(IPLS)
        IBGK=NPBGKP(IPLS,1)
        IF (LGVAC(K,IPLS)) GOTO 51
C
C  1.) RATE COEFFICIENT
C
        IF (MODCOL(5,2,IREL).EQ.1) THEN
C  MODEL 1:
C  MAXWELLIAN RATE, IGNORE TEST PARTICLE VELOCITY (or assume a pre-described temperature)
cdr  strictly we should use E0/Ti as smallness parameter, just the opposite case as in model 2.
          IF (NSTORDR >= NRAD) THEN
            SIGVEL(IREL)=TABEL3(IREL,K,1)
          ELSE
cdr  here should be call to ftabel3,  to be done
            KK=NREAEL(IREL)
            TII=TIINL(IPLSTI,K)+ADDEL(IREL,IPLS)
!pb
! this is another cut-off, at TIIN <=0.1 eV rather than at TVAC = 0.02 eV
            tii = max(tminl,tii)
            TBEL = EIRENE_RATE_COEFF(KK,K,TII,0._DP,.TRUE.,0)*
     .             MIN(DENSLIM(IPLS),DIIN(IPLS,K))*FACREL(IREL,1)
            SIGVEL(IREL)=TBEL
          END IF

        ELSEIF (MODCOL(5,2,IREL).EQ.2) THEN
C  MODEL 2:
C  BEAM - MAXWELL
          IF (TIIN(IPLSTI,K).LT.TVAC) THEN
C  TEMPERATURE TOO LOW, USE: BEAM_ATOM - BEAM_DRIFT RATE COEFF.
cdr  strictly we should use Ti/E0 as smallness parameter, not Ti alone.
            VRELQ=PVELQ(IPLSV)
            VREL=SQRT(VRELQ)
            ELAB=LOG(VRELQ)+DEFEL(IREL)
            IREAC=MODCOL(5,1,IREL)
            CEL=EIRENE_CROSS(ELAB,IREAC,IREL,FACREL(IREL,1),
     .                       'FPATH EL1')
            SIGVEL(IREL)=CEL*VREL*DENIO(IPLS)
          ELSE
C  MINIMUM PROJECTILE ENERGY: 0.1 EV
            ELB=MAX(EMINL,LOG(PVELQ(IPLSV))+EEFEL(IREL))
            IF (NSTORDR >= NRAD) THEN
! DOUBLE POLYNOMIAL FIT IS REDUCED TO SINGLE POLYNOMIAL FIT BY
! PRE-CALCULATING TEMPERATURE DEPENDENCIES ALREADY IN INITIALIZATION PHASE
              TBEL3(1:NSTORDT) = TABEL3(IREL,K,1:NSTORDT)
! CNR: SET VALIDITY RANGE AND PARAMETERS FOR EXTRAPOLATION FOR SECOND PARAMETER (FIRST WAS REDUCED)
              KK=NREAEL(IREL)
              rc2min  = reacdat(KK)%rtc%rc2min
              rc2max  = reacdat(KK)%rtc%rc2max
              fp2(1:3)= reacdat(KK)%rtc%fp2b
              fp2(4:6)= reacdat(KK)%rtc%fp2t
              jfex2mn = reacdat(KK)%rtc%jfex2mn
              jfex2mx = reacdat(KK)%rtc%jfex2mx
              EARRH = 0.0
              EXPO = EIRENE_SNGL_POLY(TBEL3,ELB,RC2MIN,RC2MAX,
     .                                FP2,jfex2mn,jfex2mx,
     .                                EARRH,TRCAMD,.TRUE.)
              if (LOG(EXPO).GT.709._dp) then
                write(*,*) "OVERFLOW IN FPATH SIGVEL: ",EXPO,KK,
     .               K,TIIN(IPLSTI,K),ELB,DIIN(IPLS,K)*1.e6_dp
              end if
              SIGVEL(IREL)=EXPO
            ELSE
! CALCULATE RATE COEFFICIENT ON THE FLY
CDR  THIS SHOULD BE DONE IN FTABEL3.  NOT READY
              KK=NREAEL(IREL)
              TII=TIINL(IPLSTI,K)+ADDEL(IREL,IPLS)
              EXPO = EIRENE_RATE_COEFF(KK,K,TII,ELB,.FALSE.,0)
     .               + DIINL(IPLS,K) + FACREL(IREL,2)
              if (EXPO.GT.709._dp) then
                write(*,*) "OVERFLOW IN FPATH SIGVEL: ",EXPO,KK,
     .               K,TIIN(IPLSTI,K),ELB,DIIN(IPLS,K)*1.e6_dp
              end if
              SIGVEL(IREL)=EXP(EXPO)
            END IF
          ENDIF

        ELSEIF (MODCOL(5,2,IREL).EQ.3) THEN
C  MODEL 3:
C  BEAM - BEAM RATE, BUT WITH EFFECTIVE INTERACTION ENERGY
          VEFFQ=ZTI(IPLS)+PVELQ(IPLSV)
          VEFF=SQRT(VEFFQ)
          ELAB=LOG(VEFFQ)+DEFEL(IREL)
          IREAC=MODCOL(5,1,IREL)
C  FIND SIGMA FROM AMJUEL DATA TABLES (e.g. BACHMANN ET AL.)
          CEL=EIRENE_CROSS(ELAB,IREAC,IREL,FACREL(IREL,1),
     .                       'FPATH EL2')
          SIGVEL(IREL)=CEL*VEFF*DENIO(IPLS)
        ELSEIF (MODCOL(5,2,IREL).EQ.4) THEN
C  MODEL 4:
C  BEAM - BEAM RATE, IGNORE THERMAL ION ENERGY
          VRELQ=PVELQ(IPLSV)
          VREL=SQRT(VRELQ)
          ELAB=LOG(VRELQ)+DEFEL(IREL)
          IREAC=MODCOL(5,1,IREL)
          CEL=EIRENE_CROSS(ELAB,IREAC,IREL,FACREL(IREL,1),'FPATH EL3')
          SIGVEL(IREL)=CEL*VREL*DENIO(IPLS)
        ELSE
          GOTO 995
        ENDIF

        SIGMAX=MAX(SIGMAX,SIGVEL(IREL))
        SIGELT=SIGELT+SIGVEL(IREL)

        IF (IBGK.NE.0) SIGBGK=SIGBGK+SIGVEL(IREL)
C
C  2.) BULK ION ENERGY LOSS RATE:
C
        IF (MODCOL(5,4,IREL).EQ.1) THEN
C  MODEL 1:
C  MEAN ENERGY FROM DRIFTING MAXWELLIAN
C  (ONLY NEEDED FOR PRE COLLISION ENERGY TRACKLENGTH ESTIMATOR)
C  ION SAMPLING FROM MAXWELLIAN
cdr if (lex .and. .....), analog to CX
          IF (NSTORDR >= NRAD) THEN
            ESIGEL(IREL,1)=EPLEL3(IREL,K,1)
          ELSE
! CALCULATE ENERGY LOSS RATE COEFFICIENT ON THE FLY
            ESIGEL(IREL,1)=EIRENE_FEPLEL3(IREL,K)
          END IF

cdr  set NFLAG for VELOEL: post-collision velocity sampling
          CFLAG(5,IREL)=2
        ELSEIF (MODCOL(5,4,IREL).EQ.2) THEN
C  MODEL 2:
C  MEAN ENERGY FROM CROSS-SECTION-WEIGHTED DRIFTING MAXWELLIAN
C  (ONLY NEEDED FOR TRACKLENGTH ESTIMATOR)
C  ION SAMPLING FROM WEIGHTED DRIFTING MAXWELLIAN (E.G., BY REJECTION)
          IF (IESTEL(IREL,3).EQ.0) THEN  ! for tracklength
                                         ! estimator only
C  MINIMUM PROJECTILE ENERGY: 0.1 EV
            ELB=MAX(EMINL,LOG(PVELQ(IPLSV))+EEFEL(IREL))
            IF (NSTORDR >= NRAD) THEN
! DOUBLE POLYNOMIAL FIT REDUCED TO SINGLE POLYNOMIAL FIT BY
! PRE-CALCULATING TEMPERATURE DEPENDENCIES
              EPEL3(1:NSTORDT) = EPLEL3(IREL,K,1:NSTORDT)
              FP = 0._DP
              RCMIN = -HUGE(1._DP)
              RCMAX = HUGE(1._DP)
              EARRH = 0.0
              EXPO = EIRENE_SNGL_POLY(EPEL3,ELB,RCMIN,RCMAX,FP,0,0,
     .                                EARRH,TRCAMD,.TRUE.)
              if (LOG(EXPO).GT.709._dp) then
                write(*,*) "ESIGEL: ",EXPO,KK,K,TII,ELB,
     .               DIINL(IPLS,K),FACREL(IREL,2)
              end if
              ESIGEL(IREL,1)=EXPO/SIGVEL(IREL)
            ELSE
! CALCULATE ENERGY-WEIGHTED RATE COEFFICIENT ON THE FLY
              KK=NELREL(IREL)
              TII=TIINL(IPLSTI,K)+ADDEL(IREL,IPLS)
              EXPO = EIRENE_ENERGY_RATE_COEFF(KK,K,TII,ELB,.FALSE.,0)
     .               + DIINL(IPLS,K) + FACREL(IREL,2)
              if (EXPO.GT.709._dp) then
                write(*,*) "ESIGEL: ",EXPO,KK,K,TII,ELB,
     .               DIINL(IPLS,K),FACREL(IREL,2)
              end if
              ESIGEL(IREL,1)=EXP(EXPO)/SIGVEL(IREL)
            END IF
            IF (LEDRIFT) ESIGEL(IREL,1)=ESIGEL(IREL,1)+EDRIFT(IPLS,K)
          ENDIF  ! this was for tracklength estimator only

cdr  set NFLAG for VELOEL: post-collision velocity sampling
          CFLAG(5,IREL)=3
        ELSEIF (MODCOL(5,4,IREL).EQ.3) THEN
C  MODEL 3:
C  MEAN ENERGY FROM DRIFTING ISOTROPIC ONE SPEED DISTRIBUTION
C  (ONLY NEEDED FOR TRACKLENGTH ESTIMATOR)
C  ION SAMPLING FROM WEIGHTED DRIFTING ISOTROPIC ONE SPEED DISTRIBUTION
          IF (NSTORDR >= NRAD) THEN
            ESIGEL(IREL,1)=EPLEL3(IREL,K,1)
          ELSE
            ESIGEL(IREL,1)=EIRENE_FEPLEL3(IREL,K)
          END IF

cdr  set NFLAG for VELOEL: post-collision velocity sampling
          CFLAG(5,IREL)=1
        ELSE
          GOTO 995
        ENDIF
   51 CONTINUE
C
   60 CONTINUE
C
C     TOTAL
C
C  CUT OFF RESIDUAL RATES, WHICH SHOULD STRICTLY BE ZERO
C  TO AVOID SPURIOUS ENTRIES TO COLLISION RATE TALLIES
C  CURRENTLY: CUT-OFF AT 1E-10 TIMES SIGMAX
C
      IF (SIGEIT.GT.0._DP) THEN
        DO IXEI=1,NXEII
          IREI=LGXEI(IXEI)
          IF (SIGVEI(IREI) .LE. SIGMAX*1.D-10) THEN
            SIGEIT=SIGEIT-SIGVEI(IREI)
            SIGVEI(IREI) = 0.D0
          END IF
        END DO
      END IF

      IF (SIGPIT.GT.0._DP) THEN
        DO IXPI=1,NXPII
          IRPI=LGXPI(IXPI,0)
          IF (SIGVPI(IRPI) .LE. SIGMAX*1.D-10) THEN
            SIGPIT=SIGPIT-SIGVPI(IRPI)
            SIGVPI(IRPI) = 0.D0
          END IF
        END DO
      END IF

      IF (SIGCXT.GT.0._DP) THEN
        DO IXCX=1,NXCXI
          IRCX=LGXCX(IXCX,0)
          IF (SIGVCX(IRCX) .LE. SIGMAX*1.D-10) THEN
            SIGCXT=SIGCXT-SIGVCX(IRCX)
            SIGVCX(IRCX) = 0.D0
          END IF
        END DO
      END IF
C
      IF (SIGELT.GT.0._DP) THEN
        DO IXEL=1,NXELI
          IREL=LGXEL(IXEL,0)
          IF (SIGVEL(IREL) .LE. SIGMAX*1.D-10) THEN
            SIGELT=SIGELT-SIGVEL(IREL)
            SIGVEL(IREL) = 0.D0
          END IF
        END DO
      END IF
C
      SIGTOT=SIGEIT+SIGPIT+SIGCXT+SIGELT
      IF (SIGTOT.GT.1.D-20) THEN
        EIRENE_FPATH=VEL/SIGTOT
        ZMFPI=1./EIRENE_FPATH
      ENDIF
C
      RETURN
  990 CONTINUE
      WRITE (iunout,*)
     .  'ERROR IN FPATH: INCONSISTENT ELEC. IMP. DATA'
      WRITE (iunout,*) 'ITYP,IXSPZ,IREI,MODCOL(1,J,IREI),J=1,4 '
      WRITE (iunout,*) ITYP,IXSPZ,IREI,(MODCOL(1,J,IREI),J=1,4)
      CALL EIRENE_EXIT_OWN(1)
  991 CONTINUE
      WRITE (iunout,*)
     .  'ERROR IN FPATH: INCONSISTENT ION IMP. DATA'
      WRITE (iunout,*) 'ITYP,IXSPZ,IRPI,MODCOL(4,J,IRPI),J=1,4 '
      WRITE (iunout,*) ITYP,IXSPZ,IRPI,(MODCOL(4,J,IRPI),J=1,4)
      CALL EIRENE_EXIT_OWN(1)
  992 CONTINUE
      WRITE (iunout,*)
     .  'ERROR IN FPATH: INCONSISTENT CHARGE EXCHANGE DATA'
      WRITE (iunout,*) 'ITYP,IXSPZ,IRCX,MODCOL(3,J,IRCX),J=1,4 '
      WRITE (iunout,*) ITYP,IXSPZ,IRCX,(MODCOL(3,J,IRCX),J=1,4)
      CALL EIRENE_EXIT_OWN(1)
  995 CONTINUE
      WRITE (iunout,*)
     .  'ERROR IN FPATH: INCONSISTENT ELASTIC COLL. DATA'
      WRITE (iunout,*) 'ITYP,IXSPZ,IREL,MODCOL(5,J,IREL),J=1,4 '
      WRITE (iunout,*) ITYP,IXSPZ,IREL,(MODCOL(5,J,IREL),J=1,4)
      CALL EIRENE_EXIT_OWN(1)
      END FUNCTION EIRENE_FPATH
