!pb  22.11.06: flag for shift of first parameter to rate_coeff introduced
cdr  4.5.2020:  notation: syncr. pls --> tii


      FUNCTION EIRENE_FEPLCX3 (IRCX,K)
c  RETURN mean energy (EV) of impacting (heavy) bulk particle IPLS,
c  CX reaction no. IRCX,
c  cell no. K
c  IPLS: via common

CDR  SEPT 15: OPTION KK > 0  CORRECT ???
CDR  KK IS A FLAG, SET IN XSTCX (FOR NON-DEFAULT) OR IN XSECTA (FOR DEFAULT) CX MODELS

      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD
      USE EIRMOD_COMUSR
      USE EIRMOD_CCONA
      USE EIRMOD_COMPRT
      USE EIRMOD_COMXS

      IMPLICIT NONE

      INTEGER, INTENT(IN) :: IRCX, K
      REAL(DP) :: TII, ADD, EPCX, EIRENE_FEPLCX3,
     .            EIRENE_RATE_COEFF
      INTEGER :: KK, IPLSTI
      EXTERNAL :: EIRENE_RATE_COEFF

      EIRENE_FEPLCX3=0.D0
      KK=NELRCX(IRCX)
      IPLSTI=MPLSTI(IPLS)
      IF (KK < 0) THEN
        SELECT CASE (KK)
        CASE (-1)
C  DEFAULT CX MODEL
            EIRENE_FEPLCX3=1.5*TIIN(IPLSTI,K)
            IF (LEDRIFT) EIRENE_FEPLCX3=EIRENE_FEPLCX3+EDRIFT(IPLS,K)
        CASE (-2)
C  MEAN ENERGY FROM DRIFTING MONOENERGETIC
            EIRENE_FEPLCX3=EPLCX3(IRCX,1,1)
            IF (LEDRIFT) EIRENE_FEPLCX3=EIRENE_FEPLCX3+EDRIFT(IPLS,K)
        CASE (-3)
C  MEAN ENERGY FROM DRIFTING MAXWELLIAN
            EIRENE_FEPLCX3=1.5*TIIN(IPLSTI,K)
            IF (LEDRIFT) EIRENE_FEPLCX3=EIRENE_FEPLCX3+EDRIFT(IPLS,K)
        END SELECT
      ELSE
C  MEAN ENERGY FROM SINGLE PARAMETER FIT KK
CDR   ???????

        TII=TIINL(IPLSTI,K)+ADDCX(IRCX,IPLS)
        EPCX = EIRENE_RATE_COEFF(KK,K,TII,0._DP,.FALSE.,0)
        ADD=EPLCX3(IRCX,1,1)
        EIRENE_FEPLCX3=EPCX*DIIN(IPLS,K)*ADD
      END IF

      RETURN
      END FUNCTION EIRENE_FEPLCX3
