cdr  aug.16 extended options for extrapolation beyond valid range of fit.
cdr         parmlim,fparlim added to argument list
cdr         added: iflag=4  constant extrapolation  (e.g. for low density limit, corona)
cdr         to be done: automatically ensure continuity across parmlim,
cdr                     in case of iflag=2,...,5.
cdr         Only when fp1,fp2,fp3 are internally
cdr         derived in sngl_poly.f, then this is guaranteed
C
      FUNCTION EIRENE_EXTRAP(PARM,PARMLIM,FPARLIM,
     .                       IFLAG,FP1,FP2,FP3)
C
C  FUNCTION FOR EXTRAPOLATING SINGLE PARAMETER FITS "FF(PP)" BEYOND THEIR
C  RANGE OF VALIDITY, WHEN LN(PP)=PARM IS OUT OF RANGE. RETURN EXTRAP=FF(PARM)
C
C  INPUT:  PARM   : LOG OF INDEPENDENT PARAMETER (RELATIVE ENERGY, TEMPERATURE, DENSITY)
C                   WHICH IS OUT OF VALID FIT RANGE: PARM=LN(PP)
C          PARMLIM: LOG OF THE NEAREST BOUNDARY FOR VALID PARAMETER PARM.
C          FPARLIM: FF(PARMLIM)  (NOT: LOG THEREOF)

C  OUTPUT: EXTRAP IS NOT LOG(FF), BUT THE TRUE VALUE OF THE EXTRAPOLATED FIT EXPRESSION
C          EXTRAP = FF(PARM)

C  TYPE  IFLAG=1--3: JANEV ET AL. , SPRINGER, 1987, P13
C  TYPE  IFLAG=5  BACHMANN ET AL., IPP-REPORT, .....ELASTIC

C  IFLAG=1 : RETURN EXTRAP=0.0 OUTSIDE RANGE OF FIT VALIDITY
C  IFLAG=4 : RETURN EXTRAP=FPARLIM (EXTRAPOLATION BY A CONSTANT, DETERMINED
C                                   BY THE FIT VALUE AT THE VALIDITY BOUNDARY)
C  IFLAG=5 : RETURN EXTRAP=EXP(FP1+FP2*PARM+FP3*PARM**2), 2ND ORDER ON LOG SCALE
C
      USE EIRMOD_PRECISION
      USE EIRMOD_COMPRT, ONLY: IUNOUT
      USE EIRMOD_CCONA

      IMPLICIT NONE

      REAL(DP), INTENT(IN) :: PARM, PARMLIM, FPARLIM, FP1, FP2, FP3
      INTEGER, INTENT(IN)  :: IFLAG
      REAL(DP)             :: X, EL, EIRENE_EXTRAP
      EXTERNAL             :: EIRENE_EXIT_OWN

      IF (IFLAG.EQ.1) THEN
C  JANEV TYPE 1, LOW ENERGY
C  E.G. FOR CROSS-SECTIONS WITH NONZERO THRESHOLD, JUST RETURN ZERO BELOW THRESHOLD
        EIRENE_EXTRAP=EPS30   !        EIRENE_EXTRAP=0.

      ELSEIF (IFLAG.EQ.2) THEN
C  JANEV TYPE 1, HIGH ENERGY EXTRAPOLATION OF CROSS-SECTIONS
C  EXTRAPOLATION AT HIGH ENERGY END FOR REACTIONS WITH A NONZERO THRESHOLD
C  FP1 SHOULD BE = E_THRESHOLD (EV)
C  FP2 SCALING FACTOR, SHOULD BE COMPUTED FROM PARMLIM,FPARLIM
C  FP3=-N
        EL=EXP(PARM)
        X=EL/FP1
        EIRENE_EXTRAP=FP2*X**FP3*LOG(X)

      ELSEIF (IFLAG.EQ.3) THEN
C  LINEAR EXTRAPOLATION OF LN(FF) IN PARM= LN(P)
CNR FLOOR AT EPS30 TO AVOID LOG(0) IN POLY ROUTINES
        EIRENE_EXTRAP=EXP(MAX(-100._DP,FP1+FP2*PARM))

      ELSEIF (IFLAG.EQ.4) THEN
C   EXTRAPOLATION WITH A CONSTANT
C
        EIRENE_EXTRAP=FPARLIM

      ELSEIF (IFLAG.EQ.5) THEN
C  QUADRATIC EXTRAPOLATION OF LN(FF) IN PARM=LN(PP)
CNR FLOOR AT EPS30 TO AVOID LOG(0) IN POLY ROUTINES
        EIRENE_EXTRAP=EXP(MAX(-100._DP,FP1+FP2*PARM+FP3*PARM**2))
      ELSE
        GOTO 999
      ENDIF
      RETURN
  999 CONTINUE
      WRITE (iunout,*) 'ERROR IN EXTRAP. IFLAG OUT OF RANGE.'
      WRITE (iunout,*) 'EXIT CALLED'
      CALL EIRENE_EXIT_OWN(1)
      END FUNCTION EIRENE_EXTRAP
