c--------------------------------------------------------------------------
c  SPTUSR submodule for dynamic follow-up of surface composition
c
c         Author  : Sergey Makarov
c
c--------------------------------------------------------------------------
c
      SUBROUTINE EIRENE_SPTUSR
      IMPLICIT NONE
      RETURN
      END SUBROUTINE EIRENE_SPTUSR

      SUBROUTINE EIRENE_SP1USR(WMIN,FMASS,FCHAR,FLXSP,
     .             IGASP,
     .             YIELD1,
     .             ISPZP,ESPTP,VSPTP,VXSPTP,VYSPTP,VZSPTP,
     .             IGASC,
     .             YIELD2,
     .             ISPZC,ESPTC,VSPTC,VXSPTC,VYSPTC,VZSPTC,
     .             YSPTWL,QQS)
      USE EIRMOD_PRECISION, ONLY: DP
      USE EIRMOD_COMUSR, ONLY: NSPH
      USE EIRMOD_CLGIN,  ONLY: ISPUT, EWALL, RECYCS
      USE EIRMOD_COMPRT, ONLY: ISPZ, MSURF, E0,
     .                         VELX, VELY, VELZ, CRTX, CRTY, CRTZ
      USE EIRMOD_SPUTER
      USE EIRMOD_REFUSR
      IMPLICIT NONE
      INTEGER :: IGASC, IGASP
      INTEGER :: ISPZC, ISPZP
      REAL(DP) :: WMIN, FMASS, FCHAR, FLXSP
      REAL(DP) :: YIELD1, YIELD2, ESPTC, VSPTC, ESPTP,
     .            VSPTP, VXSPTP, VYSPTP, VZSPTP,
     .            VXSPTC, VYSPTC, VZSPTC, QQS
      REAL(DP) :: YSPTWL !VK NUMBER OF WALL ATOMS IN SPUTTERED PARTICLE

      INTEGER :: ITA, IPS, IPR, MODCHM, MODPYS
      REAL(DP) :: ENWALL, TWALL, SE, COSIN, PRFCS, ETHE0, E0ETF, SQE,
     .            F, F1, F2, F3, QQP, CAOPT, ARG, ANGFAC

C  TENTATIVELY ASSUME: NO SPUTTERED PARTICLES
      YIELD1=0.D0
      YIELD2=0.D0
      ISPZP=0
      ISPZC=0

C  CURRENTLY: PHOTONS DO NOT SPUTTER
      IF (ISPZ.LE.NSPH) RETURN
C
C
C  SURFACE NUMBER :  MSURF  (MSURF=0: DEFAULT MODEL)
C  SPECIES INDEX  :  ISPZ   (INCIDENT SPECIES)
C  IDENTIFY PROJECTILE (IPR) AND TARGET (ITA) FROM SPUTER DATA TABLE
C
C    ITA=ITARG(MSURF)
C       Be surface even if W surface                                som 23.10.18
      ITA=2
      IPS=IPROJS(ISPZ)
      IF (IPS.GT.0.AND.IPS.EQ.ITA) THEN
        IPR=7
      ELSE
        IPR=IPROJ(ISPZ)
      ENDIF
C
      MODPYS=ISPUT(1,MSURF)
      MODCHM=ISPUT(2,MSURF)

C  SET WALL TEMPERATURE FOR SPUTTERING MODEL AND FOR SAMPLING OF SPUTTERED PARTICLE VELOCITY
      ENWALL=EWALL(MSURF)
      IF (ENWALL.GT.0.D0) THEN
C  ENWALL=1.5 TWALL, MEAN ENERGY OF THERMALLY REEMITTED PARTICLES
        TWALL=ENWALL*0.66667
      ELSEIF (ENWALL.LT.0.D0) THEN
        TWALL=-ENWALL
      ELSE
        GOTO 998
      ENDIF

      SE=0.D0
C
      COSIN=CRTX*VELX+CRTY*VELY+CRTZ*VELZ
      IF (COSIN.LE.0.D0) GOTO 999
C
C  NO PHYSICAL SPUTTERING?
C
      IF (MODPYS.LE.0) GOTO 5000
C
C  FIRST: PHYSICAL SPUTTERING AND SUBLIMATION
C
C     IF (MODPYS.EQ.1) THEN                                            som 22.10.18
C
C  CONSTANT SPUTTER YIELD: RECYCS
C       YIELD1=RECYCS(ISPZ,MSURF)
C  NO SUBLIMATION YIELD IN THIS MODEL:
C       QQS=0.
C
C     ELSEIF (MODPYS.EQ.2) THEN

      IF (ITA.EQ.0) GOTO 5000  ! TARGET NOT IDENTIFIED,
                               ! SO NO SPUTTERING WITH MODPYS=2
C
C   ECKSTEIN/ROTH/BOHDANSKY/MODEL: IPP 9/82, FEB. 1993
C

      IF (IPR.EQ.0.AND.ITA.NE.0) THEN
C   FOR THIS PROJECTILE THERE ARE NO DATA IN SPUTTER TABLE, BUT TARGET ITA IS IDENTIFIED
C   EVALUATE ETF FROM EQ. 7 IN REPORT IPP 9/82
C   EVALUATE ETH  AND Q FROM EQS. 28 AND 27, RESP. IN REPORT IPP 9/82
C   I.E. USE SAME SIGMUND-THEORY APPROXIMATION, AND "V(R)=A*1/R^^6",
C   AS IT IS ALSO THE CASE FOR REST OF THE SPUTTER DATA IN THIS MODEL
        RM1=FMASS
        RM2=RTAMU(ITA)
        Z1=FCHAR
        Z2=ZTAR(ITA)
        Z123=Z1**TWOTHIRD
        Z223=Z2**TWOTHIRD
        ES23=ES(ITA)**TWOTHIRD
        FM2M1=RM2/RM1
        GM2M1=(RM1**FIVESIXTH*RM2**ONESIXTH)/(RM1+RM2)
        GZ1Z213=(Z123+Z223)**ONETHIRD
        GZ1Z212=(Z123+Z223)**(0.5)
C   EQ. 7
        XETF=30.74*(RM1+RM2)/RM2*Z1*Z2*GZ1Z212
        ETF(ITA,0)=XETF
C   EQ. 28
        ETH(ITA,0)=(BT1*FM2M1**BT2+BT3*FM2M1**BT4)*ES(ITA)
C   EQ. 27
        Q(ITA,0)=0.278*Z123*Z223*GZ1Z213*GM2M1/ES23
      ENDIF

      IF (IPR.GE.0.AND.ITA.GT.0) THEN
        PRFCS=RECYCS(ISPZ,MSURF)
C  NO SPUTTERING BELOW THRESHOLD
        IF (E0.LE.ETH(ITA,IPR).OR.PRFCS.LE.0.D0) GOTO 5000

        ETHE0=ETH(ITA,IPR)/E0
        E0ETF=E0/ETF(ITA,IPR)
        SQE=SQRT(E0ETF)
C  YIELD FACTOR FOR PHYS. SPUTTERING
        QQP=Q(ITA,IPR)
C  YIELD FACTOR FOR SUBLIMATION
        QQS=0.
c       IF (IFLAG.EQ.2) THEN
c         QQS=54.*FMASS**1.2*EXP(-0.78/TWALL)
c       ENDIF
        F1=(QQP+QQS)*(1.-ETHE0**0.666667)*(1.-ETHE0)*(1.-ETHE0)
c  replace Thomas-Fermi potential by Kr-C potential
c  Thomas-Fermi potential
c       F2=3.441*SQE*LOG(E0ETF+2.718)
c       F3=1.+6.355*SQE+E0ETF*(6.882*SQE-1.708)
c  Kr-C potential
        F2=0.5*LOG(1.+1.2288*E0ETF)
        F3=E0ETF+0.1728*SQE+0.008*E0ETF**0.1504
C
        SE=F2/F3
        YIELD1=F1*SE
        YIELD1=MAX(0._DP,YIELD1)*PRFCS
C INCIDENT ANGULAR DEPENDENCE OF YIELD: YAMAMURA FIT: LOC.CIT.,P 10
C MAXIMUM (ABOUT: 3.36) AT COSIN=0.26.
C ANGFAC -->0. FOR COSIN -->0.
C ANGFAC -->1. FOR COSIN -->1.
C       AOPT=75.
C       CAOPT=COS(AOPT*PIA/180.D0)
        CAOPT=0.26
        F=2.
!        ANGFAC=COSIN**(-F)*EXP(F*(1.-1./COSIN)*CAOPT)
        ARG=MAX(-500._DP,LOG(COSIN)*(-F)+F*(1.-1./COSIN)*CAOPT)
        ANGFAC=EXP(ARG)
        YIELD1=YIELD1*ANGFAC
        
C Application of the Be concentration factor som 22.10.18
        IF (MSURF .GT. 0) THEN
          YIELD1=YIELD1*CONBE(MSURF)
        ENDIF
      ENDIF
C
  998 CONTINUE
  999 CONTINUE
 5000 CONTINUE
      RETURN
      END SUBROUTINE EIRENE_SP1USR
