

      SUBROUTINE EIRENE_TET_STEP (IS,ITET,ISIDE,NRS)
cdr add geometrical tetrahedron side area on cumulated RRSTEP variable.
cdr No projection to plasma flux tube is done.

      USE EIRMOD_PRECISION
      USE EIRMOD_COMUSR
      USE EIRMOD_CTETRA
      USE EIRMOD_CSTEP

      IMPLICIT NONE

      INTEGER, INTENT(IN) :: IS, ITET, ISIDE
      INTEGER, INTENT(INOUT) :: NRS
      REAL(DP), EXTERNAL :: EIRENE_ARTRI3
      INTEGER :: I1, I2, I3
      INTEGER ITSIDE(3,4)
      DATA ITSIDE /1,2,3,
     .             1,4,2,
     .             2,4,3,
     .             3,4,1/

! SIDE ISIDE OF TETRAHEDRON ITET BELONGS TO STEP FUNCTION ISTEP

      NRS=NRS+1
      I1=NTECK(ITSIDE(1,ISIDE),ITET)
      I2=NTECK(ITSIDE(2,ISIDE),ITET)
      I3=NTECK(ITSIDE(3,ISIDE),ITET)
cdr cumulated independent variable for sampling (dimension: area)
      RRSTEP(IS,NRS+1)=RRSTEP(IS,NRS) +
     .                 EIRENE_ARTRI3(XTETRA(I1),YTETRA(I1),ZTETRA(I1),
     .                               XTETRA(I2),YTETRA(I2),ZTETRA(I2),
     .                               XTETRA(I3),YTETRA(I3),ZTETRA(I3))
      IRSTEP(IS,NRS)=ITET
      IPSTEP(IS,NRS)=ISIDE
      ITSTEP(IS,NRS)=1
      IASTEP(IS,NRS)=0
      IBSTEP(IS,NRS)=1

      RETURN
      END SUBROUTINE EIRENE_TET_STEP
