

      SUBROUTINE EIRENE_MAKE_TETRA_48 (INDCO)

      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD
      USE EIRMOD_CTETRA
      USE EIRMOD_COMPRT, ONLY: IUNOUT
      USE EIRMOD_CLGIN

      IMPLICIT NONE

      INTEGER,INTENT(IN) :: INDCO(27)
      INTEGER :: ITET, JTET, IS, JS
      REAL(DP), SAVE :: FEM_KOOR(3,27) = reshape(
     . (/-1._dp, -1._dp, -1._dp,
     .    0._dp, -1._dp, -1._dp,
     .    1._dp, -1._dp, -1._dp,
     .   -1._dp,  0._dp, -1._dp,
     .    0._dp,  0._dp, -1._dp,
     .    1._dp,  0._dp, -1._dp,
     .   -1._dp,  1._dp, -1._dp,
     .    0._dp,  1._dp, -1._dp,
     .    1._dp,  1._dp, -1._dp,
     .   -1._dp, -1._dp,  0._dp,
     .    0._dp, -1._dp,  0._dp,
     .    1._dp, -1._dp,  0._dp,
     .   -1._dp,  0._dp,  0._dp,
     .    0._dp,  0._dp,  0._dp,
     .    1._dp,  0._dp,  0._dp,
     .   -1._dp,  1._dp,  0._dp,
     .    0._dp,  1._dp,  0._dp,
     .    1._dp,  1._dp,  0._dp,
     .   -1._dp, -1._dp,  1._dp,
     .    0._dp, -1._dp,  1._dp,
     .    1._dp, -1._dp,  1._dp,
     .   -1._dp,  0._dp,  1._dp,
     .    0._dp,  0._dp,  1._dp,
     .    1._dp,  0._dp,  1._dp,
     .   -1._dp,  1._dp,  1._dp,
     .    0._dp,  1._dp,  1._dp,
     .    1._dp,  1._dp,  1._dp /), (/ 3, 27 /))
      EXTERNAL :: EIRENE_EXIT_OWN

      IF (NTET+48 > NTETRA) THEN
        WRITE (iunout,*) ' ALLOWED NUMBER OF TETRAHEDRA EXCEEDED '
        WRITE (iunout,*) ' INCREASE NTETRA '
        CALL EIRENE_EXIT_OWN(1)
      END IF

      NTECK(1,NTET+1) = INDCO(1)
      NTECK(2,NTET+1) = INDCO(2)
      NTECK(3,NTET+1) = INDCO(11)
      NTECK(4,NTET+1) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(1),NTET+1)
      CALL EIRENE_EINFUEGEN (INDCO(2),NTET+1)
      CALL EIRENE_EINFUEGEN (INDCO(11),NTET+1)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+1)
      RTCEN(NTET+1) = 0.25_DP* (FEM_KOOR(1,1)+FEM_KOOR(1,2)+
     .                          FEM_KOOR(1,11)+FEM_KOOR(1,14))
      STCEN(NTET+1) = 0.25_DP* (FEM_KOOR(2,1)+FEM_KOOR(2,2)+
     .                          FEM_KOOR(2,11)+FEM_KOOR(2,14))
      TTCEN(NTET+1) = 0.25_DP* (FEM_KOOR(3,1)+FEM_KOOR(3,2)+
     .                          FEM_KOOR(3,11)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(1),INDCO(2),INDCO(11),INDCO(14))) THEN
        NTBAR(2,NTET+1) = NTET+34
        NTSEITE(2,NTET+1) = 2
        NTBAR(3,NTET+1) = NTET+2
        NTSEITE(3,NTET+1) = 4
        NTBAR(4,NTET+1) = NTET+8
        NTSEITE(4,NTET+1) = 3
      ELSE
        NTBAR(1:4,NTET+1) = -1
        NTSEITE(1:4,NTET+1) = -1
      END IF


      NTECK(1,NTET+2) = INDCO(2)
      NTECK(2,NTET+2) = INDCO(3)
      NTECK(3,NTET+2) = INDCO(11)
      NTECK(4,NTET+2) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(2),NTET+2)
      CALL EIRENE_EINFUEGEN (INDCO(3),NTET+2)
      CALL EIRENE_EINFUEGEN (INDCO(11),NTET+2)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+2)
      RTCEN(NTET+2) = 0.25_DP* (FEM_KOOR(1,2)+FEM_KOOR(1,3)+
     .                          FEM_KOOR(1,11)+FEM_KOOR(1,14))
      STCEN(NTET+2) = 0.25_DP* (FEM_KOOR(2,2)+FEM_KOOR(2,3)+
     .                          FEM_KOOR(2,11)+FEM_KOOR(2,14))
      TTCEN(NTET+2) = 0.25_DP* (FEM_KOOR(3,2)+FEM_KOOR(3,3)+
     .                          FEM_KOOR(3,11)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(2),INDCO(3),INDCO(11),INDCO(14))) THEN
        NTBAR(2,NTET+2) = NTET+33
        NTSEITE(2,NTET+2) = 2
        NTBAR(3,NTET+2) = NTET+3
        NTSEITE(3,NTET+2) = 4
        NTBAR(4,NTET+2) = NTET+1
        NTSEITE(4,NTET+2) = 3
      ELSE
        NTBAR(1:4,NTET+2) = -1
        NTSEITE(1:4,NTET+2) = -1
      END IF


      NTECK(1,NTET+3) = INDCO(3)
      NTECK(2,NTET+3) = INDCO(12)
      NTECK(3,NTET+3) = INDCO(11)
      NTECK(4,NTET+3) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(3),NTET+3)
      CALL EIRENE_EINFUEGEN (INDCO(12),NTET+3)
      CALL EIRENE_EINFUEGEN (INDCO(11),NTET+3)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+3)
      RTCEN(NTET+3) = 0.25_DP* (FEM_KOOR(1,3)+FEM_KOOR(1,12)+
     .                          FEM_KOOR(1,11)+FEM_KOOR(1,14))
      STCEN(NTET+3) = 0.25_DP* (FEM_KOOR(2,3)+FEM_KOOR(2,12)+
     .                          FEM_KOOR(2,11)+FEM_KOOR(2,14))
      TTCEN(NTET+3) = 0.25_DP* (FEM_KOOR(3,3)+FEM_KOOR(3,12)+
     .                          FEM_KOOR(3,11)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(3),INDCO(12),INDCO(11),INDCO(14))) THEN
        NTBAR(2,NTET+3) = NTET+16
        NTSEITE(2,NTET+3) = 2
        NTBAR(3,NTET+3) = NTET+4
        NTSEITE(3,NTET+3) = 4
        NTBAR(4,NTET+3) = NTET+2
        NTSEITE(4,NTET+3) = 3
      ELSE
        NTBAR(1:4,NTET+3) = -1
        NTSEITE(1:4,NTET+3) = -1
      END IF


      NTECK(1,NTET+4) = INDCO(12)
      NTECK(2,NTET+4) = INDCO(21)
      NTECK(3,NTET+4) = INDCO(11)
      NTECK(4,NTET+4) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(12),NTET+4)
      CALL EIRENE_EINFUEGEN (INDCO(21),NTET+4)
      CALL EIRENE_EINFUEGEN (INDCO(11),NTET+4)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+4)
      RTCEN(NTET+4) = 0.25_DP* (FEM_KOOR(1,12)+FEM_KOOR(1,21)+
     .                          FEM_KOOR(1,11)+FEM_KOOR(1,14))
      STCEN(NTET+4) = 0.25_DP* (FEM_KOOR(2,12)+FEM_KOOR(2,21)+
     .                          FEM_KOOR(2,11)+FEM_KOOR(2,14))
      TTCEN(NTET+4) = 0.25_DP* (FEM_KOOR(3,12)+FEM_KOOR(3,21)+
     .                          FEM_KOOR(3,11)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(12),INDCO(21),INDCO(11),INDCO(14))) THEN
        NTBAR(2,NTET+4) = NTET+15
        NTSEITE(2,NTET+4) = 2
        NTBAR(3,NTET+4) = NTET+5
        NTSEITE(3,NTET+4) = 4
        NTBAR(4,NTET+4) = NTET+3
        NTSEITE(4,NTET+4) = 3
      ELSE
        NTBAR(1:4,NTET+4) = -1
        NTSEITE(1:4,NTET+4) = -1
      END IF


      NTECK(1,NTET+5) = INDCO(21)
      NTECK(2,NTET+5) = INDCO(20)
      NTECK(3,NTET+5) = INDCO(11)
      NTECK(4,NTET+5) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(21),NTET+5)
      CALL EIRENE_EINFUEGEN (INDCO(20),NTET+5)
      CALL EIRENE_EINFUEGEN (INDCO(11),NTET+5)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+5)
      RTCEN(NTET+5) = 0.25_DP* (FEM_KOOR(1,21)+FEM_KOOR(1,20)+
     .                          FEM_KOOR(1,11)+FEM_KOOR(1,14))
      STCEN(NTET+5) = 0.25_DP* (FEM_KOOR(2,21)+FEM_KOOR(2,20)+
     .                          FEM_KOOR(2,11)+FEM_KOOR(2,14))
      TTCEN(NTET+5) = 0.25_DP* (FEM_KOOR(3,21)+FEM_KOOR(3,20)+
     .                          FEM_KOOR(3,11)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(21),INDCO(20),INDCO(11),INDCO(14))) THEN
        NTBAR(2,NTET+5) = NTET+42
        NTSEITE(2,NTET+5) = 2
        NTBAR(3,NTET+5) = NTET+6
        NTSEITE(3,NTET+5) = 4
        NTBAR(4,NTET+5) = NTET+4
        NTSEITE(4,NTET+5) = 3
      ELSE
        NTBAR(1:4,NTET+5) = -1
        NTSEITE(1:4,NTET+5) = -1
      END IF


      NTECK(1,NTET+6) = INDCO(20)
      NTECK(2,NTET+6) = INDCO(19)
      NTECK(3,NTET+6) = INDCO(11)
      NTECK(4,NTET+6) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(20),NTET+6)
      CALL EIRENE_EINFUEGEN (INDCO(19),NTET+6)
      CALL EIRENE_EINFUEGEN (INDCO(11),NTET+6)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+6)
      RTCEN(NTET+6) = 0.25_DP* (FEM_KOOR(1,20)+FEM_KOOR(1,19)+
     .                          FEM_KOOR(1,11)+FEM_KOOR(1,14))
      STCEN(NTET+6) = 0.25_DP* (FEM_KOOR(2,20)+FEM_KOOR(2,19)+
     .                          FEM_KOOR(2,11)+FEM_KOOR(2,14))
      TTCEN(NTET+6) = 0.25_DP* (FEM_KOOR(3,20)+FEM_KOOR(3,19)+
     .                          FEM_KOOR(3,11)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(20),INDCO(19),INDCO(11),INDCO(14))) THEN
        NTBAR(2,NTET+6) = NTET+41
        NTSEITE(2,NTET+6) = 2
        NTBAR(3,NTET+6) = NTET+7
        NTSEITE(3,NTET+6) = 4
        NTBAR(4,NTET+6) = NTET+5
        NTSEITE(4,NTET+6) = 3
      ELSE
        NTBAR(1:4,NTET+6) = -1
        NTSEITE(1:4,NTET+6) = -1
      END IF


      NTECK(1,NTET+7) = INDCO(19)
      NTECK(2,NTET+7) = INDCO(10)
      NTECK(3,NTET+7) = INDCO(11)
      NTECK(4,NTET+7) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(19),NTET+7)
      CALL EIRENE_EINFUEGEN (INDCO(10),NTET+7)
      CALL EIRENE_EINFUEGEN (INDCO(11),NTET+7)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+7)
      RTCEN(NTET+7) = 0.25_DP* (FEM_KOOR(1,19)+FEM_KOOR(1,10)+
     .                          FEM_KOOR(1,11)+FEM_KOOR(1,14))
      STCEN(NTET+7) = 0.25_DP* (FEM_KOOR(2,19)+FEM_KOOR(2,10)+
     .                          FEM_KOOR(2,11)+FEM_KOOR(2,14))
      TTCEN(NTET+7) = 0.25_DP* (FEM_KOOR(3,19)+FEM_KOOR(3,10)+
     .                          FEM_KOOR(3,11)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(19),INDCO(10),INDCO(11),INDCO(14))) THEN
        NTBAR(2,NTET+7) = NTET+28
        NTSEITE(2,NTET+7) = 2
        NTBAR(3,NTET+7) = NTET+8
        NTSEITE(3,NTET+7) = 4
        NTBAR(4,NTET+7) = NTET+6
        NTSEITE(4,NTET+7) = 3
      ELSE
        NTBAR(1:4,NTET+7) = -1
        NTSEITE(1:4,NTET+7) = -1
      END IF


      NTECK(1,NTET+8) = INDCO(10)
      NTECK(2,NTET+8) = INDCO(1)
      NTECK(3,NTET+8) = INDCO(11)
      NTECK(4,NTET+8) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(10),NTET+8)
      CALL EIRENE_EINFUEGEN (INDCO(1),NTET+8)
      CALL EIRENE_EINFUEGEN (INDCO(11),NTET+8)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+8)
      RTCEN(NTET+8) = 0.25_DP* (FEM_KOOR(1,10)+FEM_KOOR(1,1)+
     .                          FEM_KOOR(1,11)+FEM_KOOR(1,14))
      STCEN(NTET+8) = 0.25_DP* (FEM_KOOR(2,10)+FEM_KOOR(2,1)+
     .                          FEM_KOOR(2,11)+FEM_KOOR(2,14))
      TTCEN(NTET+8) = 0.25_DP* (FEM_KOOR(3,10)+FEM_KOOR(3,1)+
     .                          FEM_KOOR(3,11)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(10),INDCO(1),INDCO(11),INDCO(14))) THEN
        NTBAR(2,NTET+8) = NTET+27
        NTSEITE(2,NTET+8) = 2
        NTBAR(3,NTET+8) = NTET+1
        NTSEITE(3,NTET+8) = 4
        NTBAR(4,NTET+8) = NTET+7
        NTSEITE(4,NTET+8) = 3
      ELSE
        NTBAR(1:4,NTET+8) = -1
        NTSEITE(1:4,NTET+8) = -1
      END IF


      NTECK(1,NTET+9) = INDCO(3)
      NTECK(2,NTET+9) = INDCO(6)
      NTECK(3,NTET+9) = INDCO(15)
      NTECK(4,NTET+9) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(3),NTET+9)
      CALL EIRENE_EINFUEGEN (INDCO(6),NTET+9)
      CALL EIRENE_EINFUEGEN (INDCO(15),NTET+9)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+9)
      RTCEN(NTET+9) = 0.25_DP* (FEM_KOOR(1,3)+FEM_KOOR(1,6)+
     .                          FEM_KOOR(1,15)+FEM_KOOR(1,14))
      STCEN(NTET+9) = 0.25_DP* (FEM_KOOR(2,3)+FEM_KOOR(2,6)+
     .                          FEM_KOOR(2,15)+FEM_KOOR(2,14))
      TTCEN(NTET+9) = 0.25_DP* (FEM_KOOR(3,3)+FEM_KOOR(3,6)+
     .                          FEM_KOOR(3,15)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(3),INDCO(6),INDCO(15),INDCO(14))) THEN
        NTBAR(2,NTET+9) = NTET+40
        NTSEITE(2,NTET+9) = 2
        NTBAR(3,NTET+9) = NTET+10
        NTSEITE(3,NTET+9) = 4
        NTBAR(4,NTET+9) = NTET+16
        NTSEITE(4,NTET+9) = 3
      ELSE
        NTBAR(1:4,NTET+9) = -1
        NTSEITE(1:4,NTET+9) = -1
      END IF


      NTECK(1,NTET+10) = INDCO(6)
      NTECK(2,NTET+10) = INDCO(9)
      NTECK(3,NTET+10) = INDCO(15)
      NTECK(4,NTET+10) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(6),NTET+10)
      CALL EIRENE_EINFUEGEN (INDCO(9),NTET+10)
      CALL EIRENE_EINFUEGEN (INDCO(15),NTET+10)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+10)
      RTCEN(NTET+10) = 0.25_DP* (FEM_KOOR(1,6)+FEM_KOOR(1,9)+
     .                          FEM_KOOR(1,15)+FEM_KOOR(1,14))
      STCEN(NTET+10) = 0.25_DP* (FEM_KOOR(2,6)+FEM_KOOR(2,9)+
     .                          FEM_KOOR(2,15)+FEM_KOOR(2,14))
      TTCEN(NTET+10) = 0.25_DP* (FEM_KOOR(3,6)+FEM_KOOR(3,9)+
     .                          FEM_KOOR(3,15)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(6),INDCO(9),INDCO(15),INDCO(14))) THEN
        NTBAR(2,NTET+10) = NTET+39
        NTSEITE(2,NTET+10) = 2
        NTBAR(3,NTET+10) = NTET+11
        NTSEITE(3,NTET+10) = 4
        NTBAR(4,NTET+10) = NTET+9
        NTSEITE(4,NTET+10) = 3
      ELSE
        NTBAR(1:4,NTET+10) = -1
        NTSEITE(1:4,NTET+10) = -1
      END IF


      NTECK(1,NTET+11) = INDCO(9)
      NTECK(2,NTET+11) = INDCO(18)
      NTECK(3,NTET+11) = INDCO(15)
      NTECK(4,NTET+11) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(9),NTET+11)
      CALL EIRENE_EINFUEGEN (INDCO(18),NTET+11)
      CALL EIRENE_EINFUEGEN (INDCO(15),NTET+11)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+11)
      RTCEN(NTET+11) = 0.25_DP* (FEM_KOOR(1,9)+FEM_KOOR(1,18)+
     .                          FEM_KOOR(1,15)+FEM_KOOR(1,14))
      STCEN(NTET+11) = 0.25_DP* (FEM_KOOR(2,9)+FEM_KOOR(2,18)+
     .                          FEM_KOOR(2,15)+FEM_KOOR(2,14))
      TTCEN(NTET+11) = 0.25_DP* (FEM_KOOR(3,9)+FEM_KOOR(3,18)+
     .                          FEM_KOOR(3,15)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(9),INDCO(18),INDCO(15),INDCO(14))) THEN
        NTBAR(2,NTET+11) = NTET+24
        NTSEITE(2,NTET+11) = 2
        NTBAR(3,NTET+11) = NTET+12
        NTSEITE(3,NTET+11) = 4
        NTBAR(4,NTET+11) = NTET+10
        NTSEITE(4,NTET+11) = 3
      ELSE
        NTBAR(1:4,NTET+11) = -1
        NTSEITE(1:4,NTET+11) = -1
      END IF


      NTECK(1,NTET+12) = INDCO(18)
      NTECK(2,NTET+12) = INDCO(27)
      NTECK(3,NTET+12) = INDCO(15)
      NTECK(4,NTET+12) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(18),NTET+12)
      CALL EIRENE_EINFUEGEN (INDCO(27),NTET+12)
      CALL EIRENE_EINFUEGEN (INDCO(15),NTET+12)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+12)
      RTCEN(NTET+12) = 0.25_DP* (FEM_KOOR(1,18)+FEM_KOOR(1,27)+
     .                          FEM_KOOR(1,15)+FEM_KOOR(1,14))
      STCEN(NTET+12) = 0.25_DP* (FEM_KOOR(2,18)+FEM_KOOR(2,27)+
     .                          FEM_KOOR(2,15)+FEM_KOOR(2,14))
      TTCEN(NTET+12) = 0.25_DP* (FEM_KOOR(3,18)+FEM_KOOR(3,27)+
     .                          FEM_KOOR(3,15)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(18),INDCO(27),INDCO(15),INDCO(14))) THEN
        NTBAR(2,NTET+12) = NTET+23
        NTSEITE(2,NTET+12) = 2
        NTBAR(3,NTET+12) = NTET+13
        NTSEITE(3,NTET+12) = 4
        NTBAR(4,NTET+12) = NTET+11
        NTSEITE(4,NTET+12) = 3
      ELSE
        NTBAR(1:4,NTET+12) = -1
        NTSEITE(1:4,NTET+12) = -1
      END IF


      NTECK(1,NTET+13) = INDCO(27)
      NTECK(2,NTET+13) = INDCO(24)
      NTECK(3,NTET+13) = INDCO(15)
      NTECK(4,NTET+13) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(27),NTET+13)
      CALL EIRENE_EINFUEGEN (INDCO(24),NTET+13)
      CALL EIRENE_EINFUEGEN (INDCO(15),NTET+13)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+13)
      RTCEN(NTET+13) = 0.25_DP* (FEM_KOOR(1,27)+FEM_KOOR(1,24)+
     .                          FEM_KOOR(1,15)+FEM_KOOR(1,14))
      STCEN(NTET+13) = 0.25_DP* (FEM_KOOR(2,27)+FEM_KOOR(2,24)+
     .                          FEM_KOOR(2,15)+FEM_KOOR(2,14))
      TTCEN(NTET+13) = 0.25_DP* (FEM_KOOR(3,27)+FEM_KOOR(3,24)+
     .                          FEM_KOOR(3,15)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(27),INDCO(24),INDCO(15),INDCO(14))) THEN
        NTBAR(2,NTET+13) = NTET+44
        NTSEITE(2,NTET+13) = 2
        NTBAR(3,NTET+13) = NTET+14
        NTSEITE(3,NTET+13) = 4
        NTBAR(4,NTET+13) = NTET+12
        NTSEITE(4,NTET+13) = 3
      ELSE
        NTBAR(1:4,NTET+13) = -1
        NTSEITE(1:4,NTET+13) = -1
      END IF


      NTECK(1,NTET+14) = INDCO(24)
      NTECK(2,NTET+14) = INDCO(21)
      NTECK(3,NTET+14) = INDCO(15)
      NTECK(4,NTET+14) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(24),NTET+14)
      CALL EIRENE_EINFUEGEN (INDCO(21),NTET+14)
      CALL EIRENE_EINFUEGEN (INDCO(15),NTET+14)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+14)
      RTCEN(NTET+14) = 0.25_DP* (FEM_KOOR(1,24)+FEM_KOOR(1,21)+
     .                          FEM_KOOR(1,15)+FEM_KOOR(1,14))
      STCEN(NTET+14) = 0.25_DP* (FEM_KOOR(2,24)+FEM_KOOR(2,21)+
     .                          FEM_KOOR(2,15)+FEM_KOOR(2,14))
      TTCEN(NTET+14) = 0.25_DP* (FEM_KOOR(3,24)+FEM_KOOR(3,21)+
     .                          FEM_KOOR(3,15)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(24),INDCO(21),INDCO(15),INDCO(14))) THEN
        NTBAR(2,NTET+14) = NTET+43
        NTSEITE(2,NTET+14) = 2
        NTBAR(3,NTET+14) = NTET+15
        NTSEITE(3,NTET+14) = 4
        NTBAR(4,NTET+14) = NTET+13
        NTSEITE(4,NTET+14) = 3
      ELSE
        NTBAR(1:4,NTET+14) = -1
        NTSEITE(1:4,NTET+14) = -1
      END IF


      NTECK(1,NTET+15) = INDCO(21)
      NTECK(2,NTET+15) = INDCO(12)
      NTECK(3,NTET+15) = INDCO(15)
      NTECK(4,NTET+15) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(21),NTET+15)
      CALL EIRENE_EINFUEGEN (INDCO(12),NTET+15)
      CALL EIRENE_EINFUEGEN (INDCO(15),NTET+15)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+15)
      RTCEN(NTET+15) = 0.25_DP* (FEM_KOOR(1,21)+FEM_KOOR(1,12)+
     .                          FEM_KOOR(1,15)+FEM_KOOR(1,14))
      STCEN(NTET+15) = 0.25_DP* (FEM_KOOR(2,21)+FEM_KOOR(2,12)+
     .                          FEM_KOOR(2,15)+FEM_KOOR(2,14))
      TTCEN(NTET+15) = 0.25_DP* (FEM_KOOR(3,21)+FEM_KOOR(3,12)+
     .                          FEM_KOOR(3,15)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(21),INDCO(12),INDCO(15),INDCO(14))) THEN
        NTBAR(2,NTET+15) = NTET+4
        NTSEITE(2,NTET+15) = 2
        NTBAR(3,NTET+15) = NTET+16
        NTSEITE(3,NTET+15) = 4
        NTBAR(4,NTET+15) = NTET+14
        NTSEITE(4,NTET+15) = 3
      ELSE
        NTBAR(1:4,NTET+15) = -1
        NTSEITE(1:4,NTET+15) = -1
      END IF


      NTECK(1,NTET+16) = INDCO(12)
      NTECK(2,NTET+16) = INDCO(3)
      NTECK(3,NTET+16) = INDCO(15)
      NTECK(4,NTET+16) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(12),NTET+16)
      CALL EIRENE_EINFUEGEN (INDCO(3),NTET+16)
      CALL EIRENE_EINFUEGEN (INDCO(15),NTET+16)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+16)
      RTCEN(NTET+16) = 0.25_DP* (FEM_KOOR(1,12)+FEM_KOOR(1,3)+
     .                           FEM_KOOR(1,15)+FEM_KOOR(1,14))
      STCEN(NTET+16) = 0.25_DP* (FEM_KOOR(2,12)+FEM_KOOR(2,3)+
     .                           FEM_KOOR(2,15)+FEM_KOOR(2,14))
      TTCEN(NTET+16) = 0.25_DP* (FEM_KOOR(3,12)+FEM_KOOR(3,3)+
     .                           FEM_KOOR(3,15)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(12),INDCO(3),INDCO(15),INDCO(14))) THEN
        NTBAR(2,NTET+16) = NTET+3
        NTSEITE(2,NTET+16) = 2
        NTBAR(3,NTET+16) = NTET+9
        NTSEITE(3,NTET+16) = 4
        NTBAR(4,NTET+16) = NTET+15
        NTSEITE(4,NTET+16) = 3
      ELSE
        NTBAR(1:4,NTET+16) = -1
        NTSEITE(1:4,NTET+16) = -1
      END IF


      NTECK(1,NTET+17) = INDCO(9)
      NTECK(2,NTET+17) = INDCO(8)
      NTECK(3,NTET+17) = INDCO(17)
      NTECK(4,NTET+17) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(9),NTET+17)
      CALL EIRENE_EINFUEGEN (INDCO(8),NTET+17)
      CALL EIRENE_EINFUEGEN (INDCO(17),NTET+17)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+17)
      RTCEN(NTET+17) = 0.25_DP* (FEM_KOOR(1,9)+FEM_KOOR(1,8)+
     .                           FEM_KOOR(1,17)+FEM_KOOR(1,14))
      STCEN(NTET+17) = 0.25_DP* (FEM_KOOR(2,9)+FEM_KOOR(2,8)+
     .                           FEM_KOOR(2,17)+FEM_KOOR(2,14))
      TTCEN(NTET+17) = 0.25_DP* (FEM_KOOR(3,9)+FEM_KOOR(3,8)+
     .                           FEM_KOOR(3,17)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(9),INDCO(8),INDCO(17),INDCO(14))) THEN
        NTBAR(2,NTET+17) = NTET+38
        NTSEITE(2,NTET+17) = 2
        NTBAR(3,NTET+17) = NTET+18
        NTSEITE(3,NTET+17) = 4
        NTBAR(4,NTET+17) = NTET+24
        NTSEITE(4,NTET+17) = 3
      ELSE
        NTBAR(1:4,NTET+17) = -1
        NTSEITE(1:4,NTET+17) = -1
      END IF


      NTECK(1,NTET+18) = INDCO(8)
      NTECK(2,NTET+18) = INDCO(7)
      NTECK(3,NTET+18) = INDCO(17)
      NTECK(4,NTET+18) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(8),NTET+18)
      CALL EIRENE_EINFUEGEN (INDCO(7),NTET+18)
      CALL EIRENE_EINFUEGEN (INDCO(17),NTET+18)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+18)
      RTCEN(NTET+18) = 0.25_DP* (FEM_KOOR(1,8)+FEM_KOOR(1,7)+
     .                           FEM_KOOR(1,17)+FEM_KOOR(1,14))
      STCEN(NTET+18) = 0.25_DP* (FEM_KOOR(2,8)+FEM_KOOR(2,7)+
     .                           FEM_KOOR(2,17)+FEM_KOOR(2,14))
      TTCEN(NTET+18) = 0.25_DP* (FEM_KOOR(3,8)+FEM_KOOR(3,7)+
     .                           FEM_KOOR(3,17)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(8),INDCO(7),INDCO(17),INDCO(14))) THEN
        NTBAR(2,NTET+18) = NTET+37
        NTSEITE(2,NTET+18) = 2
        NTBAR(3,NTET+18) = NTET+19
        NTSEITE(3,NTET+18) = 4
        NTBAR(4,NTET+18) = NTET+17
        NTSEITE(4,NTET+18) = 3
      ELSE
        NTBAR(1:4,NTET+18) = -1
        NTSEITE(1:4,NTET+18) = -1
      END IF


      NTECK(1,NTET+19) = INDCO(7)
      NTECK(2,NTET+19) = INDCO(16)
      NTECK(3,NTET+19) = INDCO(17)
      NTECK(4,NTET+19) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(7),NTET+19)
      CALL EIRENE_EINFUEGEN (INDCO(16),NTET+19)
      CALL EIRENE_EINFUEGEN (INDCO(17),NTET+19)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+19)
      RTCEN(NTET+19) = 0.25_DP* (FEM_KOOR(1,7)+FEM_KOOR(1,16)+
     .                           FEM_KOOR(1,17)+FEM_KOOR(1,14))
      STCEN(NTET+19) = 0.25_DP* (FEM_KOOR(2,7)+FEM_KOOR(2,16)+
     .                           FEM_KOOR(2,17)+FEM_KOOR(2,14))
      TTCEN(NTET+19) = 0.25_DP* (FEM_KOOR(3,7)+FEM_KOOR(3,16)+
     .                           FEM_KOOR(3,17)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(7),INDCO(16),INDCO(17),INDCO(14))) THEN
        NTBAR(2,NTET+19) = NTET+32
        NTSEITE(2,NTET+19) = 2
        NTBAR(3,NTET+19) = NTET+20
        NTSEITE(3,NTET+19) = 4
        NTBAR(4,NTET+19) = NTET+18
        NTSEITE(4,NTET+19) = 3
      ELSE
        NTBAR(1:4,NTET+19) = -1
        NTSEITE(1:4,NTET+19) = -1
      END IF


      NTECK(1,NTET+20) = INDCO(16)
      NTECK(2,NTET+20) = INDCO(25)
      NTECK(3,NTET+20) = INDCO(17)
      NTECK(4,NTET+20) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(16),NTET+20)
      CALL EIRENE_EINFUEGEN (INDCO(25),NTET+20)
      CALL EIRENE_EINFUEGEN (INDCO(17),NTET+20)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+20)
      RTCEN(NTET+20) = 0.25_DP* (FEM_KOOR(1,16)+FEM_KOOR(1,25)+
     .                           FEM_KOOR(1,17)+FEM_KOOR(1,14))
      STCEN(NTET+20) = 0.25_DP* (FEM_KOOR(2,16)+FEM_KOOR(2,25)+
     .                           FEM_KOOR(2,17)+FEM_KOOR(2,14))
      TTCEN(NTET+20) = 0.25_DP* (FEM_KOOR(3,16)+FEM_KOOR(3,25)+
     .                           FEM_KOOR(3,17)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(16),INDCO(25),INDCO(17),INDCO(14))) THEN
        NTBAR(2,NTET+20) = NTET+31
        NTSEITE(2,NTET+20) = 2
        NTBAR(3,NTET+20) = NTET+21
        NTSEITE(3,NTET+20) = 4
        NTBAR(4,NTET+20) = NTET+19
        NTSEITE(4,NTET+20) = 3
      ELSE
        NTBAR(1:4,NTET+20) = -1
        NTSEITE(1:4,NTET+20) = -1
      END IF


      NTECK(1,NTET+21) = INDCO(25)
      NTECK(2,NTET+21) = INDCO(26)
      NTECK(3,NTET+21) = INDCO(17)
      NTECK(4,NTET+21) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(25),NTET+21)
      CALL EIRENE_EINFUEGEN (INDCO(26),NTET+21)
      CALL EIRENE_EINFUEGEN (INDCO(17),NTET+21)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+21)
      RTCEN(NTET+21) = 0.25_DP* (FEM_KOOR(1,25)+FEM_KOOR(1,26)+
     .                           FEM_KOOR(1,17)+FEM_KOOR(1,14))
      STCEN(NTET+21) = 0.25_DP* (FEM_KOOR(2,25)+FEM_KOOR(2,26)+
     .                           FEM_KOOR(2,17)+FEM_KOOR(2,14))
      TTCEN(NTET+21) = 0.25_DP* (FEM_KOOR(3,25)+FEM_KOOR(3,26)+
     .                           FEM_KOOR(3,17)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(25),INDCO(26),INDCO(17),INDCO(14))) THEN
        NTBAR(2,NTET+21) = NTET+46
        NTSEITE(2,NTET+21) = 2
        NTBAR(3,NTET+21) = NTET+22
        NTSEITE(3,NTET+21) = 4
        NTBAR(4,NTET+21) = NTET+20
        NTSEITE(4,NTET+21) = 3
      ELSE
        NTBAR(1:4,NTET+21) = -1
        NTSEITE(1:4,NTET+21) = -1
      END IF


      NTECK(1,NTET+22) = INDCO(26)
      NTECK(2,NTET+22) = INDCO(27)
      NTECK(3,NTET+22) = INDCO(17)
      NTECK(4,NTET+22) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(26),NTET+22)
      CALL EIRENE_EINFUEGEN (INDCO(27),NTET+22)
      CALL EIRENE_EINFUEGEN (INDCO(17),NTET+22)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+22)
      RTCEN(NTET+22) = 0.25_DP* (FEM_KOOR(1,26)+FEM_KOOR(1,27)+
     .                           FEM_KOOR(1,17)+FEM_KOOR(1,14))
      STCEN(NTET+22) = 0.25_DP* (FEM_KOOR(2,26)+FEM_KOOR(2,27)+
     .                           FEM_KOOR(2,17)+FEM_KOOR(2,14))
      TTCEN(NTET+22) = 0.25_DP* (FEM_KOOR(3,26)+FEM_KOOR(3,27)+
     .                           FEM_KOOR(3,17)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(26),INDCO(27),INDCO(17),INDCO(14))) THEN
        NTBAR(2,NTET+22) = NTET+45
        NTSEITE(2,NTET+22) = 2
        NTBAR(3,NTET+22) = NTET+23
        NTSEITE(3,NTET+22) = 4
        NTBAR(4,NTET+22) = NTET+21
        NTSEITE(4,NTET+22) = 3
      ELSE
        NTBAR(1:4,NTET+22) = -1
        NTSEITE(1:4,NTET+22) = -1
      END IF


      NTECK(1,NTET+23) = INDCO(27)
      NTECK(2,NTET+23) = INDCO(18)
      NTECK(3,NTET+23) = INDCO(17)
      NTECK(4,NTET+23) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(27),NTET+23)
      CALL EIRENE_EINFUEGEN (INDCO(18),NTET+23)
      CALL EIRENE_EINFUEGEN (INDCO(17),NTET+23)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+23)
      RTCEN(NTET+23) = 0.25_DP* (FEM_KOOR(1,27)+FEM_KOOR(1,18)+
     .                           FEM_KOOR(1,17)+FEM_KOOR(1,14))
      STCEN(NTET+23) = 0.25_DP* (FEM_KOOR(2,27)+FEM_KOOR(2,18)+
     .                           FEM_KOOR(2,17)+FEM_KOOR(2,14))
      TTCEN(NTET+23) = 0.25_DP* (FEM_KOOR(3,27)+FEM_KOOR(3,18)+
     .                           FEM_KOOR(3,17)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(27),INDCO(18),INDCO(17),INDCO(14))) THEN
        NTBAR(2,NTET+23) = NTET+12
        NTSEITE(2,NTET+23) = 2
        NTBAR(3,NTET+23) = NTET+24
        NTSEITE(3,NTET+23) = 4
        NTBAR(4,NTET+23) = NTET+22
        NTSEITE(4,NTET+23) = 3
      ELSE
        NTBAR(1:4,NTET+23) = -1
        NTSEITE(1:4,NTET+23) = -1
      END IF


      NTECK(1,NTET+24) = INDCO(18)
      NTECK(2,NTET+24) = INDCO(9)
      NTECK(3,NTET+24) = INDCO(17)
      NTECK(4,NTET+24) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(18),NTET+24)
      CALL EIRENE_EINFUEGEN (INDCO(9),NTET+24)
      CALL EIRENE_EINFUEGEN (INDCO(17),NTET+24)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+24)
      RTCEN(NTET+24) = 0.25_DP* (FEM_KOOR(1,18)+FEM_KOOR(1,9)+
     .                           FEM_KOOR(1,17)+FEM_KOOR(1,14))
      STCEN(NTET+24) = 0.25_DP* (FEM_KOOR(2,18)+FEM_KOOR(2,9)+
     .                           FEM_KOOR(2,17)+FEM_KOOR(2,14))
      TTCEN(NTET+24) = 0.25_DP* (FEM_KOOR(3,18)+FEM_KOOR(3,9)+
     .                           FEM_KOOR(3,17)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(18),INDCO(9),INDCO(17),INDCO(14))) THEN
        NTBAR(2,NTET+24) = NTET+11
        NTSEITE(2,NTET+24) = 2
        NTBAR(3,NTET+24) = NTET+17
        NTSEITE(3,NTET+24) = 4
        NTBAR(4,NTET+24) = NTET+23
        NTSEITE(4,NTET+24) = 3
      ELSE
        NTBAR(1:4,NTET+24) = -1
        NTSEITE(1:4,NTET+24) = -1
      END IF


      NTECK(1,NTET+25) = INDCO(7)
      NTECK(2,NTET+25) = INDCO(4)
      NTECK(3,NTET+25) = INDCO(13)
      NTECK(4,NTET+25) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(7),NTET+25)
      CALL EIRENE_EINFUEGEN (INDCO(4),NTET+25)
      CALL EIRENE_EINFUEGEN (INDCO(13),NTET+25)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+25)
      RTCEN(NTET+25) = 0.25_DP* (FEM_KOOR(1,7)+FEM_KOOR(1,4)+
     .                           FEM_KOOR(1,13)+FEM_KOOR(1,14))
      STCEN(NTET+25) = 0.25_DP* (FEM_KOOR(2,7)+FEM_KOOR(2,4)+
     .                           FEM_KOOR(2,13)+FEM_KOOR(2,14))
      TTCEN(NTET+25) = 0.25_DP* (FEM_KOOR(3,7)+FEM_KOOR(3,4)+
     .                           FEM_KOOR(3,13)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(7),INDCO(4),INDCO(13),INDCO(14))) THEN
        NTBAR(2,NTET+25) = NTET+36
        NTSEITE(2,NTET+25) = 2
        NTBAR(3,NTET+25) = NTET+26
        NTSEITE(3,NTET+25) = 4
        NTBAR(4,NTET+25) = NTET+32
        NTSEITE(4,NTET+25) = 3
      ELSE
        NTBAR(1:4,NTET+25) = -1
        NTSEITE(1:4,NTET+25) = -1
      END IF


      NTECK(1,NTET+26) = INDCO(4)
      NTECK(2,NTET+26) = INDCO(1)
      NTECK(3,NTET+26) = INDCO(13)
      NTECK(4,NTET+26) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(4),NTET+26)
      CALL EIRENE_EINFUEGEN (INDCO(1),NTET+26)
      CALL EIRENE_EINFUEGEN (INDCO(13),NTET+26)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+26)
      RTCEN(NTET+26) = 0.25_DP* (FEM_KOOR(1,4)+FEM_KOOR(1,1)+
     .                           FEM_KOOR(1,13)+FEM_KOOR(1,14))
      STCEN(NTET+26) = 0.25_DP* (FEM_KOOR(2,4)+FEM_KOOR(2,1)+
     .                           FEM_KOOR(2,13)+FEM_KOOR(2,14))
      TTCEN(NTET+26) = 0.25_DP* (FEM_KOOR(3,4)+FEM_KOOR(3,1)+
     .                           FEM_KOOR(3,13)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(4),INDCO(1),INDCO(13),INDCO(14))) THEN
        NTBAR(2,NTET+26) = NTET+35
        NTSEITE(2,NTET+26) = 2
        NTBAR(3,NTET+26) = NTET+27
        NTSEITE(3,NTET+26) = 4
        NTBAR(4,NTET+26) = NTET+25
        NTSEITE(4,NTET+26) = 3
      ELSE
        NTBAR(1:4,NTET+26) = -1
        NTSEITE(1:4,NTET+26) = -1
      END IF


      NTECK(1,NTET+27) = INDCO(1)
      NTECK(2,NTET+27) = INDCO(10)
      NTECK(3,NTET+27) = INDCO(13)
      NTECK(4,NTET+27) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(1),NTET+27)
      CALL EIRENE_EINFUEGEN (INDCO(10),NTET+27)
      CALL EIRENE_EINFUEGEN (INDCO(13),NTET+27)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+27)
      RTCEN(NTET+27) = 0.25_DP* (FEM_KOOR(1,1)+FEM_KOOR(1,10)+
     .                           FEM_KOOR(1,13)+FEM_KOOR(1,14))
      STCEN(NTET+27) = 0.25_DP* (FEM_KOOR(2,1)+FEM_KOOR(2,10)+
     .                           FEM_KOOR(2,13)+FEM_KOOR(2,14))
      TTCEN(NTET+27) = 0.25_DP* (FEM_KOOR(3,1)+FEM_KOOR(3,10)+
     .                           FEM_KOOR(3,13)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(1),INDCO(10),INDCO(13),INDCO(14))) THEN
        NTBAR(2,NTET+27) = NTET+8
        NTSEITE(2,NTET+27) = 2
        NTBAR(3,NTET+27) = NTET+28
        NTSEITE(3,NTET+27) = 4
        NTBAR(4,NTET+27) = NTET+26
        NTSEITE(4,NTET+27) = 3
      ELSE
        NTBAR(1:4,NTET+27) = -1
        NTSEITE(1:4,NTET+27) = -1
      END IF


      NTECK(1,NTET+28) = INDCO(10)
      NTECK(2,NTET+28) = INDCO(19)
      NTECK(3,NTET+28) = INDCO(13)
      NTECK(4,NTET+28) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(10),NTET+28)
      CALL EIRENE_EINFUEGEN (INDCO(19),NTET+28)
      CALL EIRENE_EINFUEGEN (INDCO(13),NTET+28)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+28)
      RTCEN(NTET+28) = 0.25_DP* (FEM_KOOR(1,10)+FEM_KOOR(1,19)+
     .                           FEM_KOOR(1,13)+FEM_KOOR(1,14))
      STCEN(NTET+28) = 0.25_DP* (FEM_KOOR(2,10)+FEM_KOOR(2,19)+
     .                           FEM_KOOR(2,13)+FEM_KOOR(2,14))
      TTCEN(NTET+28) = 0.25_DP* (FEM_KOOR(3,10)+FEM_KOOR(3,19)+
     .                           FEM_KOOR(3,13)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(10),INDCO(19),INDCO(13),INDCO(14))) THEN
        NTBAR(2,NTET+28) = NTET+7
        NTSEITE(2,NTET+28) = 2
        NTBAR(3,NTET+28) = NTET+29
        NTSEITE(3,NTET+28) = 4
        NTBAR(4,NTET+28) = NTET+27
        NTSEITE(4,NTET+28) = 3
      ELSE
        NTBAR(1:4,NTET+28) = -1
        NTSEITE(1:4,NTET+28) = -1
      END IF

      NTECK(1,NTET+29) = INDCO(19)
      NTECK(2,NTET+29) = INDCO(22)
      NTECK(3,NTET+29) = INDCO(13)
      NTECK(4,NTET+29) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(19),NTET+29)
      CALL EIRENE_EINFUEGEN (INDCO(22),NTET+29)
      CALL EIRENE_EINFUEGEN (INDCO(13),NTET+29)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+29)
      RTCEN(NTET+29) = 0.25_DP* (FEM_KOOR(1,19)+FEM_KOOR(1,22)+
     .                           FEM_KOOR(1,13)+FEM_KOOR(1,14))
      STCEN(NTET+29) = 0.25_DP* (FEM_KOOR(2,19)+FEM_KOOR(2,22)+
     .                           FEM_KOOR(2,13)+FEM_KOOR(2,14))
      TTCEN(NTET+29) = 0.25_DP* (FEM_KOOR(3,19)+FEM_KOOR(3,22)+
     .                           FEM_KOOR(3,13)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(19),INDCO(22),INDCO(13),INDCO(14))) THEN
        NTBAR(2,NTET+29) = NTET+48
        NTSEITE(2,NTET+29) = 2
        NTBAR(3,NTET+29) = NTET+30
        NTSEITE(3,NTET+29) = 4
        NTBAR(4,NTET+29) = NTET+28
        NTSEITE(4,NTET+29) = 3
      ELSE
        NTBAR(1:4,NTET+29) = -1
        NTSEITE(1:4,NTET+29) = -1
      END IF


      NTECK(1,NTET+30) = INDCO(22)
      NTECK(2,NTET+30) = INDCO(25)
      NTECK(3,NTET+30) = INDCO(13)
      NTECK(4,NTET+30) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(22),NTET+30)
      CALL EIRENE_EINFUEGEN (INDCO(25),NTET+30)
      CALL EIRENE_EINFUEGEN (INDCO(13),NTET+30)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+30)
      RTCEN(NTET+30) = 0.25_DP* (FEM_KOOR(1,22)+FEM_KOOR(1,25)+
     .                           FEM_KOOR(1,13)+FEM_KOOR(1,14))
      STCEN(NTET+30) = 0.25_DP* (FEM_KOOR(2,22)+FEM_KOOR(2,25)+
     .                           FEM_KOOR(2,13)+FEM_KOOR(2,14))
      TTCEN(NTET+30) = 0.25_DP* (FEM_KOOR(3,22)+FEM_KOOR(3,25)+
     .                           FEM_KOOR(3,13)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(22),INDCO(25),INDCO(13),INDCO(14))) THEN
        NTBAR(2,NTET+30) = NTET+47
        NTSEITE(2,NTET+30) = 2
        NTBAR(3,NTET+30) = NTET+31
        NTSEITE(3,NTET+30) = 4
        NTBAR(4,NTET+30) = NTET+29
        NTSEITE(4,NTET+30) = 3
      ELSE
        NTBAR(1:4,NTET+30) = -1
        NTSEITE(1:4,NTET+30) = -1
      END IF


      NTECK(1,NTET+31) = INDCO(25)
      NTECK(2,NTET+31) = INDCO(16)
      NTECK(3,NTET+31) = INDCO(13)
      NTECK(4,NTET+31) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(25),NTET+31)
      CALL EIRENE_EINFUEGEN (INDCO(16),NTET+31)
      CALL EIRENE_EINFUEGEN (INDCO(13),NTET+31)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+31)
      RTCEN(NTET+31) = 0.25_DP* (FEM_KOOR(1,25)+FEM_KOOR(1,16)+
     .                           FEM_KOOR(1,13)+FEM_KOOR(1,14))
      STCEN(NTET+31) = 0.25_DP* (FEM_KOOR(2,25)+FEM_KOOR(2,16)+
     .                           FEM_KOOR(2,13)+FEM_KOOR(2,14))
      TTCEN(NTET+31) = 0.25_DP* (FEM_KOOR(3,25)+FEM_KOOR(3,16)+
     .                           FEM_KOOR(3,13)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(25),INDCO(16),INDCO(13),INDCO(14))) THEN
        NTBAR(2,NTET+31) = NTET+20
        NTSEITE(2,NTET+31) = 2
        NTBAR(3,NTET+31) = NTET+32
        NTSEITE(3,NTET+31) = 4
        NTBAR(4,NTET+31) = NTET+30
        NTSEITE(4,NTET+31) = 3
      ELSE
        NTBAR(1:4,NTET+31) = -1
        NTSEITE(1:4,NTET+31) = -1
      END IF


      NTECK(1,NTET+32) = INDCO(16)
      NTECK(2,NTET+32) = INDCO(7)
      NTECK(3,NTET+32) = INDCO(13)
      NTECK(4,NTET+32) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(16),NTET+32)
      CALL EIRENE_EINFUEGEN (INDCO(7),NTET+32)
      CALL EIRENE_EINFUEGEN (INDCO(13),NTET+32)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+32)
      RTCEN(NTET+32) = 0.25_DP* (FEM_KOOR(1,16)+FEM_KOOR(1,7)+
     .                           FEM_KOOR(1,13)+FEM_KOOR(1,14))
      STCEN(NTET+32) = 0.25_DP* (FEM_KOOR(2,16)+FEM_KOOR(2,7)+
     .                           FEM_KOOR(2,13)+FEM_KOOR(2,14))
      TTCEN(NTET+32) = 0.25_DP* (FEM_KOOR(3,16)+FEM_KOOR(3,7)+
     .                           FEM_KOOR(3,13)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(16),INDCO(7),INDCO(13),INDCO(14))) THEN
        NTBAR(2,NTET+32) = NTET+19
        NTSEITE(2,NTET+32) = 2
        NTBAR(3,NTET+32) = NTET+25
        NTSEITE(3,NTET+32) = 4
        NTBAR(4,NTET+32) = NTET+31
        NTSEITE(4,NTET+32) = 3
      ELSE
        NTBAR(1:4,NTET+32) = -1
        NTSEITE(1:4,NTET+32) = -1
      END IF


      NTECK(1,NTET+33) = INDCO(3)
      NTECK(2,NTET+33) = INDCO(2)
      NTECK(3,NTET+33) = INDCO(5)
      NTECK(4,NTET+33) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(3),NTET+33)
      CALL EIRENE_EINFUEGEN (INDCO(2),NTET+33)
      CALL EIRENE_EINFUEGEN (INDCO(5),NTET+33)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+33)
      RTCEN(NTET+33) = 0.25_DP* (FEM_KOOR(1,3)+FEM_KOOR(1,2)+
     .                           FEM_KOOR(1,5)+FEM_KOOR(1,14))
      STCEN(NTET+33) = 0.25_DP* (FEM_KOOR(2,3)+FEM_KOOR(2,2)+
     .                           FEM_KOOR(2,5)+FEM_KOOR(2,14))
      TTCEN(NTET+33) = 0.25_DP* (FEM_KOOR(3,3)+FEM_KOOR(3,2)+
     .                           FEM_KOOR(3,5)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(3),INDCO(2),INDCO(5),INDCO(14))) THEN
        NTBAR(2,NTET+33) = NTET+2
        NTSEITE(2,NTET+33) = 2
        NTBAR(3,NTET+33) = NTET+34
        NTSEITE(3,NTET+33) = 4
        NTBAR(4,NTET+33) = NTET+40
        NTSEITE(4,NTET+33) = 3
      ELSE
        NTBAR(1:4,NTET+33) = -1
        NTSEITE(1:4,NTET+33) = -1
      END IF


      NTECK(1,NTET+34) = INDCO(2)
      NTECK(2,NTET+34) = INDCO(1)
      NTECK(3,NTET+34) = INDCO(5)
      NTECK(4,NTET+34) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(2),NTET+34)
      CALL EIRENE_EINFUEGEN (INDCO(1),NTET+34)
      CALL EIRENE_EINFUEGEN (INDCO(5),NTET+34)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+34)
      RTCEN(NTET+34) = 0.25_DP* (FEM_KOOR(1,2)+FEM_KOOR(1,1)+
     .                           FEM_KOOR(1,5)+FEM_KOOR(1,14))
      STCEN(NTET+34) = 0.25_DP* (FEM_KOOR(2,2)+FEM_KOOR(2,1)+
     .                           FEM_KOOR(2,5)+FEM_KOOR(2,14))
      TTCEN(NTET+34) = 0.25_DP* (FEM_KOOR(3,2)+FEM_KOOR(3,1)+
     .                           FEM_KOOR(3,5)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(2),INDCO(1),INDCO(5),INDCO(14))) THEN
        NTBAR(2,NTET+34) = NTET+1
        NTSEITE(2,NTET+34) = 2
        NTBAR(3,NTET+34) = NTET+35
        NTSEITE(3,NTET+34) = 4
        NTBAR(4,NTET+34) = NTET+33
        NTSEITE(4,NTET+34) = 3
      ELSE
        NTBAR(1:4,NTET+34) = -1
        NTSEITE(1:4,NTET+34) = -1
      END IF


      NTECK(1,NTET+35) = INDCO(1)
      NTECK(2,NTET+35) = INDCO(4)
      NTECK(3,NTET+35) = INDCO(5)
      NTECK(4,NTET+35) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(1),NTET+35)
      CALL EIRENE_EINFUEGEN (INDCO(4),NTET+35)
      CALL EIRENE_EINFUEGEN (INDCO(5),NTET+35)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+35)
      RTCEN(NTET+35) = 0.25_DP* (FEM_KOOR(1,1)+FEM_KOOR(1,4)+
     .                           FEM_KOOR(1,5)+FEM_KOOR(1,14))
      STCEN(NTET+35) = 0.25_DP* (FEM_KOOR(2,1)+FEM_KOOR(2,4)+
     .                           FEM_KOOR(2,5)+FEM_KOOR(2,14))
      TTCEN(NTET+35) = 0.25_DP* (FEM_KOOR(3,1)+FEM_KOOR(3,4)+
     .                           FEM_KOOR(3,5)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(1),INDCO(4),INDCO(5),INDCO(14))) THEN
        NTBAR(2,NTET+35) = NTET+26
        NTSEITE(2,NTET+35) = 2
        NTBAR(3,NTET+35) = NTET+36
        NTSEITE(3,NTET+35) = 4
        NTBAR(4,NTET+35) = NTET+34
        NTSEITE(4,NTET+35) = 3
      ELSE
        NTBAR(1:4,NTET+35) = -1
        NTSEITE(1:4,NTET+35) = -1
      END IF


      NTECK(1,NTET+36) = INDCO(4)
      NTECK(2,NTET+36) = INDCO(7)
      NTECK(3,NTET+36) = INDCO(5)
      NTECK(4,NTET+36) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(4),NTET+36)
      CALL EIRENE_EINFUEGEN (INDCO(7),NTET+36)
      CALL EIRENE_EINFUEGEN (INDCO(5),NTET+36)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+36)
      RTCEN(NTET+36) = 0.25_DP* (FEM_KOOR(1,4)+FEM_KOOR(1,7)+
     .                           FEM_KOOR(1,5)+FEM_KOOR(1,14))
      STCEN(NTET+36) = 0.25_DP* (FEM_KOOR(2,4)+FEM_KOOR(2,7)+
     .                           FEM_KOOR(2,5)+FEM_KOOR(2,14))
      TTCEN(NTET+36) = 0.25_DP* (FEM_KOOR(3,4)+FEM_KOOR(3,7)+
     .                           FEM_KOOR(3,5)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(4),INDCO(7),INDCO(5),INDCO(14))) THEN
        NTBAR(2,NTET+36) = NTET+25
        NTSEITE(2,NTET+36) = 2
        NTBAR(3,NTET+36) = NTET+37
        NTSEITE(3,NTET+36) = 4
        NTBAR(4,NTET+36) = NTET+35
        NTSEITE(4,NTET+36) = 3
      ELSE
        NTBAR(1:4,NTET+36) = -1
        NTSEITE(1:4,NTET+36) = -1
      END IF


      NTECK(1,NTET+37) = INDCO(7)
      NTECK(2,NTET+37) = INDCO(8)
      NTECK(3,NTET+37) = INDCO(5)
      NTECK(4,NTET+37) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(7),NTET+37)
      CALL EIRENE_EINFUEGEN (INDCO(8),NTET+37)
      CALL EIRENE_EINFUEGEN (INDCO(5),NTET+37)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+37)
      RTCEN(NTET+37) = 0.25_DP* (FEM_KOOR(1,7)+FEM_KOOR(1,8)+
     .                           FEM_KOOR(1,5)+FEM_KOOR(1,14))
      STCEN(NTET+37) = 0.25_DP* (FEM_KOOR(2,7)+FEM_KOOR(2,8)+
     .                           FEM_KOOR(2,5)+FEM_KOOR(2,14))
      TTCEN(NTET+37) = 0.25_DP* (FEM_KOOR(3,7)+FEM_KOOR(3,8)+
     .                           FEM_KOOR(3,5)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(7),INDCO(8),INDCO(5),INDCO(14))) THEN
        NTBAR(2,NTET+37) = NTET+18
        NTSEITE(2,NTET+37) = 2
        NTBAR(3,NTET+37) = NTET+38
        NTSEITE(3,NTET+37) = 4
        NTBAR(4,NTET+37) = NTET+36
        NTSEITE(4,NTET+37) = 3
      ELSE
        NTBAR(1:4,NTET+37) = -1
        NTSEITE(1:4,NTET+37) = -1
      END IF


      NTECK(1,NTET+38) = INDCO(8)
      NTECK(2,NTET+38) = INDCO(9)
      NTECK(3,NTET+38) = INDCO(5)
      NTECK(4,NTET+38) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(8),NTET+38)
      CALL EIRENE_EINFUEGEN (INDCO(9),NTET+38)
      CALL EIRENE_EINFUEGEN (INDCO(5),NTET+38)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+38)
      RTCEN(NTET+38) = 0.25_DP* (FEM_KOOR(1,8)+FEM_KOOR(1,9)+
     .                           FEM_KOOR(1,5)+FEM_KOOR(1,14))
      STCEN(NTET+38) = 0.25_DP* (FEM_KOOR(2,8)+FEM_KOOR(2,9)+
     .                           FEM_KOOR(2,5)+FEM_KOOR(2,14))
      TTCEN(NTET+38) = 0.25_DP* (FEM_KOOR(3,8)+FEM_KOOR(3,9)+
     .                           FEM_KOOR(3,5)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(8),INDCO(9),INDCO(5),INDCO(14))) THEN
        NTBAR(2,NTET+38) = NTET+17
        NTSEITE(2,NTET+38) = 2
        NTBAR(3,NTET+38) = NTET+39
        NTSEITE(3,NTET+38) = 4
        NTBAR(4,NTET+38) = NTET+37
        NTSEITE(4,NTET+38) = 3
      ELSE
        NTBAR(1:4,NTET+38) = -1
        NTSEITE(1:4,NTET+38) = -1
      END IF


      NTECK(1,NTET+39) = INDCO(9)
      NTECK(2,NTET+39) = INDCO(6)
      NTECK(3,NTET+39) = INDCO(5)
      NTECK(4,NTET+39) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(9),NTET+39)
      CALL EIRENE_EINFUEGEN (INDCO(6),NTET+39)
      CALL EIRENE_EINFUEGEN (INDCO(5),NTET+39)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+39)
      RTCEN(NTET+39) = 0.25_DP* (FEM_KOOR(1,9)+FEM_KOOR(1,6)+
     .                           FEM_KOOR(1,5)+FEM_KOOR(1,14))
      STCEN(NTET+39) = 0.25_DP* (FEM_KOOR(2,9)+FEM_KOOR(2,6)+
     .                           FEM_KOOR(2,5)+FEM_KOOR(2,14))
      TTCEN(NTET+39) = 0.25_DP* (FEM_KOOR(3,9)+FEM_KOOR(3,6)+
     .                           FEM_KOOR(3,5)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(9),INDCO(6),INDCO(5),INDCO(14))) THEN
        NTBAR(2,NTET+39) = NTET+10
        NTSEITE(2,NTET+39) = 2
        NTBAR(3,NTET+39) = NTET+40
        NTSEITE(3,NTET+39) = 4
        NTBAR(4,NTET+39) = NTET+38
        NTSEITE(4,NTET+39) = 3
      ELSE
        NTBAR(1:4,NTET+39) = -1
        NTSEITE(1:4,NTET+39) = -1
      END IF


      NTECK(1,NTET+40) = INDCO(6)
      NTECK(2,NTET+40) = INDCO(3)
      NTECK(3,NTET+40) = INDCO(5)
      NTECK(4,NTET+40) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(6),NTET+40)
      CALL EIRENE_EINFUEGEN (INDCO(3),NTET+40)
      CALL EIRENE_EINFUEGEN (INDCO(5),NTET+40)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+40)
      RTCEN(NTET+40) = 0.25_DP* (FEM_KOOR(1,6)+FEM_KOOR(1,3)+
     .                           FEM_KOOR(1,5)+FEM_KOOR(1,14))
      STCEN(NTET+40) = 0.25_DP* (FEM_KOOR(2,6)+FEM_KOOR(2,3)+
     .                           FEM_KOOR(2,5)+FEM_KOOR(2,14))
      TTCEN(NTET+40) = 0.25_DP* (FEM_KOOR(3,6)+FEM_KOOR(3,3)+
     .                           FEM_KOOR(3,5)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(6),INDCO(3),INDCO(5),INDCO(14))) THEN
        NTBAR(2,NTET+40) = NTET+9
        NTSEITE(2,NTET+40) = 2
        NTBAR(3,NTET+40) = NTET+33
        NTSEITE(3,NTET+40) = 4
        NTBAR(4,NTET+40) = NTET+39
        NTSEITE(4,NTET+40) = 3
      ELSE
        NTBAR(1:4,NTET+40) = -1
        NTSEITE(1:4,NTET+40) = -1
      END IF


      NTECK(1,NTET+41) = INDCO(19)
      NTECK(2,NTET+41) = INDCO(20)
      NTECK(3,NTET+41) = INDCO(23)
      NTECK(4,NTET+41) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(19),NTET+41)
      CALL EIRENE_EINFUEGEN (INDCO(20),NTET+41)
      CALL EIRENE_EINFUEGEN (INDCO(23),NTET+41)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+41)
      RTCEN(NTET+41) = 0.25_DP* (FEM_KOOR(1,19)+FEM_KOOR(1,20)+
     .                           FEM_KOOR(1,23)+FEM_KOOR(1,14))
      STCEN(NTET+41) = 0.25_DP* (FEM_KOOR(2,19)+FEM_KOOR(2,20)+
     .                           FEM_KOOR(2,23)+FEM_KOOR(2,14))
      TTCEN(NTET+41) = 0.25_DP* (FEM_KOOR(3,19)+FEM_KOOR(3,20)+
     .                           FEM_KOOR(3,23)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(19),INDCO(20),INDCO(23),INDCO(14))) THEN
        NTBAR(2,NTET+41) = NTET+6
        NTSEITE(2,NTET+41) = 2
        NTBAR(3,NTET+41) = NTET+42
        NTSEITE(3,NTET+41) = 4
        NTBAR(4,NTET+41) = NTET+48
        NTSEITE(4,NTET+41) = 3
      ELSE
        NTBAR(1:4,NTET+41) = -1
        NTSEITE(1:4,NTET+41) = -1
      END IF


      NTECK(1,NTET+42) = INDCO(20)
      NTECK(2,NTET+42) = INDCO(21)
      NTECK(3,NTET+42) = INDCO(23)
      NTECK(4,NTET+42) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(20),NTET+42)
      CALL EIRENE_EINFUEGEN (INDCO(21),NTET+42)
      CALL EIRENE_EINFUEGEN (INDCO(23),NTET+42)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+42)
      RTCEN(NTET+42) = 0.25_DP* (FEM_KOOR(1,20)+FEM_KOOR(1,21)+
     .                           FEM_KOOR(1,23)+FEM_KOOR(1,14))
      STCEN(NTET+42) = 0.25_DP* (FEM_KOOR(2,20)+FEM_KOOR(2,21)+
     .                           FEM_KOOR(2,23)+FEM_KOOR(2,14))
      TTCEN(NTET+42) = 0.25_DP* (FEM_KOOR(3,20)+FEM_KOOR(3,21)+
     .                           FEM_KOOR(3,23)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(20),INDCO(21),INDCO(23),INDCO(14))) THEN
        NTBAR(2,NTET+42) = NTET+5
        NTSEITE(2,NTET+42) = 2
        NTBAR(3,NTET+42) = NTET+43
        NTSEITE(3,NTET+42) = 4
        NTBAR(4,NTET+42) = NTET+41
        NTSEITE(4,NTET+42) = 3
      ELSE
        NTBAR(1:4,NTET+42) = -1
        NTSEITE(1:4,NTET+42) = -1
      END IF


      NTECK(1,NTET+43) = INDCO(21)
      NTECK(2,NTET+43) = INDCO(24)
      NTECK(3,NTET+43) = INDCO(23)
      NTECK(4,NTET+43) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(21),NTET+43)
      CALL EIRENE_EINFUEGEN (INDCO(24),NTET+43)
      CALL EIRENE_EINFUEGEN (INDCO(23),NTET+43)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+43)
      RTCEN(NTET+43) = 0.25_DP* (FEM_KOOR(1,21)+FEM_KOOR(1,24)+
     .                           FEM_KOOR(1,23)+FEM_KOOR(1,14))
      STCEN(NTET+43) = 0.25_DP* (FEM_KOOR(2,21)+FEM_KOOR(2,24)+
     .                           FEM_KOOR(2,23)+FEM_KOOR(2,14))
      TTCEN(NTET+43) = 0.25_DP* (FEM_KOOR(3,21)+FEM_KOOR(3,24)+
     .                           FEM_KOOR(3,23)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(21),INDCO(24),INDCO(23),INDCO(14))) THEN
        NTBAR(2,NTET+43) = NTET+14
        NTSEITE(2,NTET+43) = 2
        NTBAR(3,NTET+43) = NTET+44
        NTSEITE(3,NTET+43) = 4
        NTBAR(4,NTET+43) = NTET+42
        NTSEITE(4,NTET+43) = 3
      ELSE
        NTBAR(1:4,NTET+43) = -1
        NTSEITE(1:4,NTET+43) = -1
      END IF


      NTECK(1,NTET+44) = INDCO(24)
      NTECK(2,NTET+44) = INDCO(27)
      NTECK(3,NTET+44) = INDCO(23)
      NTECK(4,NTET+44) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(24),NTET+44)
      CALL EIRENE_EINFUEGEN (INDCO(27),NTET+44)
      CALL EIRENE_EINFUEGEN (INDCO(23),NTET+44)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+44)
      RTCEN(NTET+44) = 0.25_DP* (FEM_KOOR(1,24)+FEM_KOOR(1,27)+
     .                           FEM_KOOR(1,23)+FEM_KOOR(1,14))
      STCEN(NTET+44) = 0.25_DP* (FEM_KOOR(2,24)+FEM_KOOR(2,27)+
     .                           FEM_KOOR(2,23)+FEM_KOOR(2,14))
      TTCEN(NTET+44) = 0.25_DP* (FEM_KOOR(3,24)+FEM_KOOR(3,27)+
     .                           FEM_KOOR(3,23)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(24),INDCO(27),INDCO(23),INDCO(14))) THEN
        NTBAR(2,NTET+44) = NTET+13
        NTSEITE(2,NTET+44) = 2
        NTBAR(3,NTET+44) = NTET+45
        NTSEITE(3,NTET+44) = 4
        NTBAR(4,NTET+44) = NTET+43
        NTSEITE(4,NTET+44) = 3
      ELSE
        NTBAR(1:4,NTET+44) = -1
        NTSEITE(1:4,NTET+44) = -1
      END IF


      NTECK(1,NTET+45) = INDCO(27)
      NTECK(2,NTET+45) = INDCO(26)
      NTECK(3,NTET+45) = INDCO(23)
      NTECK(4,NTET+45) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(27),NTET+45)
      CALL EIRENE_EINFUEGEN (INDCO(26),NTET+45)
      CALL EIRENE_EINFUEGEN (INDCO(23),NTET+45)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+45)
      RTCEN(NTET+45) = 0.25_DP* (FEM_KOOR(1,27)+FEM_KOOR(1,26)+
     .                           FEM_KOOR(1,23)+FEM_KOOR(1,14))
      STCEN(NTET+45) = 0.25_DP* (FEM_KOOR(2,27)+FEM_KOOR(2,26)+
     .                           FEM_KOOR(2,23)+FEM_KOOR(2,14))
      TTCEN(NTET+45) = 0.25_DP* (FEM_KOOR(3,27)+FEM_KOOR(3,26)+
     .                           FEM_KOOR(3,23)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(27),INDCO(26),INDCO(23),INDCO(14))) THEN
        NTBAR(2,NTET+45) = NTET+22
        NTSEITE(2,NTET+45) = 2
        NTBAR(3,NTET+45) = NTET+46
        NTSEITE(3,NTET+45) = 4
        NTBAR(4,NTET+45) = NTET+44
        NTSEITE(4,NTET+45) = 3
      ELSE
        NTBAR(1:4,NTET+45) = -1
        NTSEITE(1:4,NTET+45) = -1
      END IF


      NTECK(1,NTET+46) = INDCO(26)
      NTECK(2,NTET+46) = INDCO(25)
      NTECK(3,NTET+46) = INDCO(23)
      NTECK(4,NTET+46) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(26),NTET+46)
      CALL EIRENE_EINFUEGEN (INDCO(25),NTET+46)
      CALL EIRENE_EINFUEGEN (INDCO(23),NTET+46)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+46)
      RTCEN(NTET+46) = 0.25_DP* (FEM_KOOR(1,26)+FEM_KOOR(1,25)+
     .                           FEM_KOOR(1,23)+FEM_KOOR(1,14))
      STCEN(NTET+46) = 0.25_DP* (FEM_KOOR(2,26)+FEM_KOOR(2,25)+
     .                           FEM_KOOR(2,23)+FEM_KOOR(2,14))
      TTCEN(NTET+46) = 0.25_DP* (FEM_KOOR(3,26)+FEM_KOOR(3,25)+
     .                           FEM_KOOR(3,23)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(26),INDCO(25),INDCO(23),INDCO(14))) THEN
        NTBAR(2,NTET+46) = NTET+21
        NTSEITE(2,NTET+46) = 2
        NTBAR(3,NTET+46) = NTET+47
        NTSEITE(3,NTET+46) = 4
        NTBAR(4,NTET+46) = NTET+45
        NTSEITE(4,NTET+46) = 3
      ELSE
        NTBAR(1:4,NTET+46) = -1
        NTSEITE(1:4,NTET+46) = -1
      END IF


      NTECK(1,NTET+47) = INDCO(25)
      NTECK(2,NTET+47) = INDCO(22)
      NTECK(3,NTET+47) = INDCO(23)
      NTECK(4,NTET+47) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(25),NTET+47)
      CALL EIRENE_EINFUEGEN (INDCO(22),NTET+47)
      CALL EIRENE_EINFUEGEN (INDCO(23),NTET+47)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+47)
      RTCEN(NTET+47) = 0.25_DP* (FEM_KOOR(1,25)+FEM_KOOR(1,22)+
     .                           FEM_KOOR(1,23)+FEM_KOOR(1,14))
      STCEN(NTET+47) = 0.25_DP* (FEM_KOOR(2,25)+FEM_KOOR(2,22)+
     .                           FEM_KOOR(2,23)+FEM_KOOR(2,14))
      TTCEN(NTET+47) = 0.25_DP* (FEM_KOOR(3,25)+FEM_KOOR(3,22)+
     .                           FEM_KOOR(3,23)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(25),INDCO(22),INDCO(23),INDCO(14))) THEN
        NTBAR(2,NTET+47) = NTET+30
        NTSEITE(2,NTET+47) = 2
        NTBAR(3,NTET+47) = NTET+48
        NTSEITE(3,NTET+47) = 4
        NTBAR(4,NTET+47) = NTET+46
        NTSEITE(4,NTET+47) = 3
      ELSE
        NTBAR(1:4,NTET+47) = -1
        NTSEITE(1:4,NTET+47) = -1
      END IF


      NTECK(1,NTET+48) = INDCO(22)
      NTECK(2,NTET+48) = INDCO(19)
      NTECK(3,NTET+48) = INDCO(23)
      NTECK(4,NTET+48) = INDCO(14)
      CALL EIRENE_EINFUEGEN (INDCO(22),NTET+48)
      CALL EIRENE_EINFUEGEN (INDCO(19),NTET+48)
      CALL EIRENE_EINFUEGEN (INDCO(23),NTET+48)
      CALL EIRENE_EINFUEGEN (INDCO(14),NTET+48)
      RTCEN(NTET+48) = 0.25_DP* (FEM_KOOR(1,22)+FEM_KOOR(1,19)+
     .                           FEM_KOOR(1,23)+FEM_KOOR(1,14))
      STCEN(NTET+48) = 0.25_DP* (FEM_KOOR(2,22)+FEM_KOOR(2,19)+
     .                           FEM_KOOR(2,23)+FEM_KOOR(2,14))
      TTCEN(NTET+48) = 0.25_DP* (FEM_KOOR(3,22)+FEM_KOOR(3,19)+
     .                           FEM_KOOR(3,23)+FEM_KOOR(3,14))

      IF (COORD_TEST(INDCO(22),INDCO(19),INDCO(23),INDCO(14))) THEN
        NTBAR(2,NTET+48) = NTET+29
        NTSEITE(2,NTET+48) = 2
        NTBAR(3,NTET+48) = NTET+41
        NTSEITE(3,NTET+48) = 4
        NTBAR(4,NTET+48) = NTET+47
        NTSEITE(4,NTET+48) = 3
      ELSE
        NTBAR(1:4,NTET+48) = -1
        NTSEITE(1:4,NTET+48) = -1
      END IF


      DO ITET = NTET+1, NTET+48
        DO IS = 1,4
          JTET = NTBAR(IS,ITET)    ! NUMBER OF NEIGHBORING TETRAHEDRON
          IF (JTET > 0) THEN
            JS = NTSEITE(IS,ITET)
            IF (NTBAR(JS,JTET) < 0) THEN  ! SIDE POINTS TO A COLLAPSED
              NTBAR(IS,ITET) = 0          ! TETRAHEDRON
              NTSEITE(IS,ITET) = 0
            END IF
          END IF
        END DO
      END DO

      NTET = NTET+48

      RETURN

      CONTAINS

      SUBROUTINE EIRENE_EINFUEGEN (IC,ITET)
        INTEGER, INTENT(IN) :: IC, ITET
        TYPE(TET_ELEM), POINTER :: CUR

        ALLOCATE (CUR)
        CUR%NOTET = ITET
        CUR%NEXT_TET => COORTET(IC)%PTET
        COORTET(IC)%PTET => CUR
        MCLSTR = MCLSTR+1
      END SUBROUTINE EIRENE_EINFUEGEN


      FUNCTION COORD_TEST (I1,I2,I3,I4)
        INTEGER, INTENT(IN) :: I1,I2,I3,I4
        LOGICAL COORD_TEST
        LOGICAL LTEST

        LTEST= (I1==I2) .OR. (I1==I3) .OR. (I1==I4) .OR.
     .         (I2==I3) .OR. (I2==I4) .OR. (I3==I4)
        COORD_TEST = .NOT. LTEST
        RETURN
      END FUNCTION COORD_TEST

      END SUBROUTINE EIRENE_MAKE_TETRA_48
