

      SUBROUTINE EIRENE_MAKE_TETRA
     .  (IC1,IC2,IC3,IC4,IC5,IC6,IC7,IC8,IR,IP,IT)

      USE EIRMOD_PARMMOD
      USE EIRMOD_CTETRA
      USE EIRMOD_COMPRT, ONLY: IUNOUT
      USE EIRMOD_CLGIN

      IMPLICIT NONE

      INTEGER,INTENT(IN) :: IC1,IC2,IC3,IC4,IC5,IC6,IC7,IC8,IR,IP,IT
      EXTERNAL :: EIRENE_EXIT_OWN

      IF (NTET+6 > NTETRA) THEN
        WRITE (iunout,*) ' ALLOWED NUMBER OF TETRAHEDRA EXCEEDED '
        WRITE (iunout,*) ' INCREASE NTETRA '
        CALL EIRENE_EXIT_OWN(1)
      END IF

      INMTIT(1:4,NTET+1:NTET+6) = 0

      NTECK(1,NTET+1) = IC1
      NTECK(2,NTET+1) = IC4
      NTECK(3,NTET+1) = IC3
      NTECK(4,NTET+1) = IC7
      CALL EIRENE_EINFUEGEN (IC1,NTET+1)
      CALL EIRENE_EINFUEGEN (IC4,NTET+1)
      CALL EIRENE_EINFUEGEN (IC3,NTET+1)
      CALL EIRENE_EINFUEGEN (IC7,NTET+1)
      IF (COORD_TEST(IC1,IC4,IC3,IC7)) THEN
        NTBAR(2,NTET+1) = NTET+2
        NTSEITE(2,NTET+1) = 4
        NTBAR(4,NTET+1) = NTET+6
        NTSEITE(4,NTET+1) = 2
      ELSE
        NTBAR(1:4,NTET+1) = -1
        NTSEITE(1:4,NTET+1) = -1
      END IF

      NTECK(1,NTET+2) = IC1
      NTECK(2,NTET+2) = IC8
      NTECK(3,NTET+2) = IC4
      NTECK(4,NTET+2) = IC7
      CALL EIRENE_EINFUEGEN (IC1,NTET+2)
      CALL EIRENE_EINFUEGEN (IC8,NTET+2)
      CALL EIRENE_EINFUEGEN (IC4,NTET+2)
      CALL EIRENE_EINFUEGEN (IC7,NTET+2)
      IF (COORD_TEST(IC1,IC8,IC4,IC7)) THEN
        NTBAR(2,NTET+2) = NTET+3
        NTSEITE(2,NTET+2) = 4
        NTBAR(4,NTET+2) = NTET+1
        NTSEITE(4,NTET+2) = 2
      ELSE
        NTBAR(1:4,NTET+2) = -1
        NTSEITE(1:4,NTET+2) = -1
      END IF

      NTECK(1,NTET+3) = IC1
      NTECK(2,NTET+3) = IC5
      NTECK(3,NTET+3) = IC8
      NTECK(4,NTET+3) = IC7
      CALL EIRENE_EINFUEGEN (IC1,NTET+3)
      CALL EIRENE_EINFUEGEN (IC5,NTET+3)
      CALL EIRENE_EINFUEGEN (IC8,NTET+3)
      CALL EIRENE_EINFUEGEN (IC7,NTET+3)
      IF (COORD_TEST(IC1,IC5,IC8,IC7)) THEN
        NTBAR(2,NTET+3) = NTET+4
        NTSEITE(2,NTET+3) = 4
        NTBAR(4,NTET+3) = NTET+2
        NTSEITE(4,NTET+3) = 2
      ELSE
        NTBAR(1:4,NTET+3) = -1
        NTSEITE(1:4,NTET+3) = -1
      END IF

      NTECK(1,NTET+4) = IC1
      NTECK(2,NTET+4) = IC6
      NTECK(3,NTET+4) = IC5
      NTECK(4,NTET+4) = IC7
      CALL EIRENE_EINFUEGEN (IC1,NTET+4)
      CALL EIRENE_EINFUEGEN (IC6,NTET+4)
      CALL EIRENE_EINFUEGEN (IC5,NTET+4)
      CALL EIRENE_EINFUEGEN (IC7,NTET+4)
      IF (COORD_TEST(IC1,IC6,IC5,IC7)) THEN
        NTBAR(4,NTET+4) = NTET+3
        NTSEITE(4,NTET+4) = 2
        NTBAR(2,NTET+4) = NTET+5
        NTSEITE(2,NTET+4) = 4
      ELSE
        NTBAR(1:4,NTET+4) = -1
        NTSEITE(1:4,NTET+4) = -1
      END IF

      NTECK(1,NTET+5) = IC1
      NTECK(2,NTET+5) = IC2
      NTECK(3,NTET+5) = IC6
      NTECK(4,NTET+5) = IC7
      CALL EIRENE_EINFUEGEN (IC1,NTET+5)
      CALL EIRENE_EINFUEGEN (IC2,NTET+5)
      CALL EIRENE_EINFUEGEN (IC6,NTET+5)
      CALL EIRENE_EINFUEGEN (IC7,NTET+5)
      IF (COORD_TEST(IC1,IC2,IC6,IC7)) THEN
        NTBAR(2,NTET+5) = NTET+6
        NTSEITE(2,NTET+5) = 4
        NTBAR(4,NTET+5) = NTET+4
        NTSEITE(4,NTET+5) = 2
      ELSE
        NTBAR(1:4,NTET+5) = -1
        NTSEITE(1:4,NTET+5) = -1
      END IF

      NTECK(1,NTET+6) = IC1
      NTECK(2,NTET+6) = IC3
      NTECK(3,NTET+6) = IC2
      NTECK(4,NTET+6) = IC7
      CALL EIRENE_EINFUEGEN (IC1,NTET+6)
      CALL EIRENE_EINFUEGEN (IC3,NTET+6)
      CALL EIRENE_EINFUEGEN (IC2,NTET+6)
      CALL EIRENE_EINFUEGEN (IC7,NTET+6)
      IF (COORD_TEST(IC1,IC3,IC2,IC7)) THEN
        NTBAR(2,NTET+6) = NTET+1
        NTSEITE(2,NTET+6) = 4
        NTBAR(4,NTET+6) = NTET+5
        NTSEITE(4,NTET+6) = 2
      ELSE
        NTBAR(1:4,NTET+6) = -1
        NTSEITE(1:4,NTET+6) = -1
      END IF

! In the blocks below, intervert the commented lines related to INMP3I
! dependeing on whether the tetrahedra in the grid are right-handed
! or left-handed
      INMTIT(1,NTET+1) = INMP3I(IR,IP,IT)
!pb      INMTIT(1,NTET+1) = INMP3I(IR,IP,IT+1)
      INMTIT(3,NTET+1) = INMP2I(IR,IP+1,IT)

      INMTIT(1,NTET+2) = INMP1I(IR,IP,IT)
      INMTIT(3,NTET+2) = INMP2I(IR,IP+1,IT)

      INMTIT(1,NTET+3) = INMP1I(IR,IP,IT)
      INMTIT(3,NTET+3) = INMP3I(IR,IP,IT+1)
!pb      INMTIT(3,NTET+3) = INMP3I(IR,IP,IT)

      INMTIT(1,NTET+4) = INMP2I(IR,IP,IT)
      INMTIT(3,NTET+4) = INMP3I(IR,IP,IT+1)
!pb      INMTIT(3,NTET+4) = INMP3I(IR,IP,IT)

      INMTIT(1,NTET+5) = INMP2I(IR,IP,IT)
      INMTIT(3,NTET+5) = INMP1I(IR+1,IP,IT)

      INMTIT(1,NTET+6) = INMP3I(IR,IP,IT)
!pb      INMTIT(1,NTET+6) = INMP3I(IR,IP,IT+1)
      INMTIT(3,NTET+6) = INMP1I(IR+1,IP,IT)

      NTET = NTET+6

      RETURN

      CONTAINS

      SUBROUTINE EIRENE_EINFUEGEN (IC,ITET)
        INTEGER, INTENT(IN) :: IC, ITET
        TYPE(TET_ELEM), POINTER :: CUR

        ALLOCATE (CUR)
        CUR%NOTET = ITET
        CUR%NEXT_TET => COORTET(IC)%PTET
        COORTET(IC)%PTET => CUR
        MCLSTR = MCLSTR+1
      END SUBROUTINE EIRENE_EINFUEGEN


      FUNCTION COORD_TEST (I1,I2,I3,I4)
        INTEGER, INTENT(IN) :: I1,I2,I3,I4
        LOGICAL COORD_TEST
        LOGICAL LTEST

        LTEST= (I1==I2) .OR. (I1==I3) .OR. (I1==I4) .OR.
     .         (I2==I3) .OR. (I2==I4) .OR. (I3==I4)
        COORD_TEST = .NOT. LTEST
        RETURN
      END FUNCTION COORD_TEST

      END SUBROUTINE EIRENE_MAKE_TETRA
