C
      SUBROUTINE EIRENE_REFANG
     .  (COSP,COSM,CRTXR,CRTYR,CRTZR,NMODEL,SNORM)
C
C   ANGLE OF REFLECTION, GAUSSIAN, COSINE LIKE, SPECULAR OR MIXED
C   THIS ROUTINE IS USED FOR SPECIAL ANGULAR SOURCE DISTRIBUTIONS
C   FOR PRIMARY SOURCE PARTICLES (CALLED FROM SUBR. LOCATE)

C   INPUT : VELX,VELY,VELZ VIA COMPRT : INCIDENT VELOCITY (SPEED) UNIT VECTOR
C           CRTX,CRTY,CRTZ VIA COMPRT : OUTER NORMAL (UNIT) VECTOR AT POINT OF INCIDENCE
C           COSP: 1ST PARAMETER FOR ANGULAR DISTRIBUTION
C           COSM: 2ND PARAMETER FOR ANGULAR DISTRIBUTION
C           CRTXR,CRTYR,CRTZR: MODIFIED SURFACE NORMAL REFERENCE VECTOR FOR RE-EMISSION
C           SNORM: =0. IF NO MODIFIED SURFACE NORMAL (THEN: USE DEFAULT: CRTX,CRTY,CRTZ)
C           NMODEL: FLAG, FOR SELECTION OF ANGULAR DISTRIBUTION MODEL
C
C   OUTPUT: VELX,VELY,VELZ VIA COMPRT, THEN IN OPPOSITE DIRECTION WRT CRT SURFACE NORMAL
C
      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD
      USE EIRMOD_CCONA
      USE EIRMOD_CRAND
      USE EIRMOD_COMPRT
      USE EIRMOD_RANF, ONLY: RANF_EIRENE

      IMPLICIT NONE

      REAL(DP), INTENT(IN) :: COSP, COSM, CRTXR, CRTYR, CRTZR, SNORM
      INTEGER, INTENT(IN) :: NMODEL
      REAL(DP) :: A, ZCPHI, ZCTHET, ZSTHET, VX, VY, VZ, ZPHI,
     .            ZTHET, CRTXL, CRTYL, CRTZL, COSIN, ZSPHI
      INTEGER :: ICOUNT
      EXTERNAL :: EIRENE_FGAUSS, EIRENE_ROTATF

C  DO WE HAVE A MODIFIED OUTER SURFACE NORMAL ?
C  THIS ROUTINE CAN ALSO BE USED FOR GAUSSIAN LOBE BI-DIRECTIONAL REFLECTION DISTRIBUTION FUNCTION
      IF (SNORM.GE.EPS10) THEN
        CRTXL=CRTXR
        CRTYL=CRTYR
        CRTZL=CRTZR
        COSIN=CRTXL*VELX+CRTYL*VELY+CRTZL*VELZ
      ELSE
C  NO MODIFIED REFERENCE ORIENTATION VECTOR DEFINED. USE DEFAULT.
        COSIN=CRTX*VELX+CRTY*VELY+CRTZ*VELZ
        CRTXL=CRTX
        CRTYL=CRTY
        CRTZL=CRTZ
      ENDIF

C   AZIMUTHAL ANGLE: EQUIDISTRIBUTION
      ZTHET=PI2A*RANF_EIRENE( )
      ZSTHET=SIN(ZTHET)
      ZCTHET=COS(ZTHET)
C
      IF (NMODEL.EQ.1) THEN
C   POLAR ANGLE: MODIFIED COSINE WITH CUT-OFF COSM
        A=RANF_EIRENE( )
        ZCPHI=(1._DP-A*COSM)**COSP
      ELSE
C   POLAR ANGLE: FROM GAUSSIAN, St. dev.= COSP , with cut-off COSM, done by rejection sampling
        ICOUNT=0
  410   IF (INIV2.EQ.0) CALL EIRENE_FGAUSS

cdr  this sampling from Gaussian is currently highly inefficient.
cdr  a) due to rejection
cdr  b) because a full triplet of Gaussian random numbers is generated, but just the first
cdr     component is used

        ZPHI=COSP*FG1(INIV2)
        INIV2=INIV2-1
        ICOUNT=ICOUNT+1
C   CUT-OFF ANGLE: COSM (RADIANS)
        IF (ICOUNT.GT.1000) THEN
          WRITE (iunout,*) 'WARNING FROM REFANG: IC=1000, CUT-OFF AT ',
     .                      COSM
          GOTO 420
        ENDIF
        IF (ABS(ZPHI).GT.COSM) GOTO 410
  420   ZCPHI=COS(ZPHI)
      ENDIF
C
      ZSPHI=SQRT(1._DP-ZCPHI*ZCPHI)
C
C  NO SPECULAR CONTRIBUTION IN MODIFIED COSINE
      VX=-ZCPHI
      VY=ZSPHI*ZCTHET
      VZ=ZSPHI*ZSTHET
C
      IF (ABS(COSIN).LT.EPS10) THEN
C  NO SPECIFIED DIRECTION, EG. POINT ISOTROPIC SOURCE
        VELX=VX
        VELY=VY
        VELZ=VZ
      ELSE
C  ROTATE, TO ACCOUNT FOR SURFACE NORMAL VECTOR CRTXL,CRTYL,CRTZL
        CALL EIRENE_ROTATF (VELX,VELY,VELZ,VX,VY,VZ,CRTXL,CRTYL,CRTZL)
      ENDIF
C
      RETURN
      END SUBROUTINE EIRENE_REFANG
