C
C
      FUNCTION EIRENE_EMAXW(TI,VPER,VPAR)
C
C  MEAN SURFACE CROSSING ENERGY (EV) OF AN ION, FROM A TRUNCATED AND DISPLACED MAXWELLIAN
C  FLUX DENSITY AT TEMPERATURE TI (EV).

C  DISPLACED:
C  BY A DRIFT VECTOR WITH NORMALIZED
C  VELOCITY VPER NORMAL TO AND
C  VELOCITY VPAR PARALLEL TO THE REFERENCE SURFACE.
C  TRUNCATED: VPER > 0  ?? dr: really ? what if macros. vper < 0
C
C  IF VDRIFT=(VDRIFT_PER,VDRIFT_PAR) IS A FLOW VELOCITY,
C  THEN THE NORMALIZED PARAMETERS VPER AND VPAR ARE
C  VPER = VDRIFT_PER/VTERM
C  VPAR = VDRIFT_PAR/VTERM
C  WITH VTERM=SQRT(2*TI/RMASS), THE "THERMAL SPEED",
C  RESPECTIVELY.
C  IN EIRENE UNITS: VDRIFT: CM/SEC
C                   VTERM : SQRT(2*TI/RMASS)*CVEL2A (CM/SEC)
C                           (WITH TI (EV), RMASS (AMU) CVEL2A=9.8226 E5)
      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD
      USE EIRMOD_CCONA

      IMPLICIT NONE

      REAL(DP), INTENT(IN) :: TI, VPER, VPAR
      REAL(DP) :: XMM, XMM2, YMM2, ER1, ER2, FACTOR, EIRENE_EMAXW
#ifdef PGF90
      REAL(DP) :: DERF
#endif

      IF (VPER.NE.0.D0) THEN
cdr  valid also for negative VPER ?
        XMM=VPER
        XMM2=VPER*VPER
        YMM2=VPAR*VPAR
        ER1=EXP(-XMM2)/SQRT(PIA)
#ifdef PGF90
        ER2=(1.+DERF(XMM))*XMM
#else
        ER2=(1.+ERF(XMM))*XMM
#endif
        FACTOR=((XMM2+2.+YMM2)*ER1+(XMM2+2.5+YMM2)*ER2)/(ER1+ER2)
      ELSE
        YMM2=VPAR*VPAR
        FACTOR=2.+YMM2
      ENDIF
      EIRENE_EMAXW=FACTOR*TI
      RETURN
      END FUNCTION EIRENE_EMAXW
