cdr 150423   comments added. Noted that storage tests for volume and surface tallies
cdr          are removed  (now elsewhere?)
cdr          to be done: nvoltl vs. ntalv  (nvoltl: number of living 1d tallies,
cdr                      counting individual species indices as one 1D tally
cdr          check:      nfirst(ital): which value for removed tallies?  storage ? used ?

cdr dec 15:  energy balance tallies for bulk ions: now have a species index (ipls):
cdr          tallies 38,44,50,56,84
cdr june 17: comments
cdr oct 18 : nfrstp (leading dimension of input tallies) now set in setprm_intal.f
cdr mar 21 : commments, cleanup

C
C  *************************
C  *                       *
C  * INITIALIZATION PHASE  *
C  *                       *
C  *************************
C
C      SUBROUTINE SETPRM
C
      SUBROUTINE EIRENE_SETPRM
cdr  called from main routine EIRENE, for MY_P=0:
c
cdr  1) set storage parameters (leading dimension)  for tally (targets) in CESTIM
cdr  2) then: call alloc_cestim(2)   (allocate storage for targets)
cdr  3) then: call associate_cestim  (pointers to tally targets)

cdr  Steps 2 and 3 are repeated for other compute nodes in a call:
cdr  EIRENE --> BROADCAST --> call BROADCAST_CESTIM(ME)

cdr careful: spec. resolved particle balance tallies
cdr          may be allocated multiple times in associate_cestim?

      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD
      USE EIRMOD_COMUSR
      USE EIRMOD_COMPRT, ONLY: IUNOUT
      USE EIRMOD_CESTIM
      USE EIRMOD_CPOLYG
      USE EIRMOD_CGRID
      USE EIRMOD_CGEOM
      USE EIRMOD_CSDVI
      USE EIRMOD_CLGIN
      USE EIRMOD_COUTAU
      USE EIRMOD_COMXS
      USE EIRMOD_CSPEI
      USE EIRMOD_CTEXT
      USE EIRMOD_CTRCEI
      USE EIRMOD_CLOGAU

      IMPLICIT NONE

      REAL(DP) :: RSAVE
      INTEGER :: ISAVE, J, ITAL, NLSTTL, NLSTTW
      LOGICAL :: LEXTALV(NTALV), LEXTALS(NTALS),
     .           LEXGENA, LEXGENM, LEXGENI, LEXGENPH
      EXTERNAL :: EIRENE_LEER, EIRENE_EXIT_OWN
C

      IF (NSTORDT.LT.1 .OR. NSTORDT.GT.9) THEN
        WRITE (iunout,*)
     .    'POSSIBLE STORAGE CONFLICT. NSTORDT OUT OF RANGE '
        CALL EIRENE_EXIT_OWN(1)
      ENDIF

C  SWITCH OFF SOME VOLUME-AVERAGED OUTPUT TALLIES AUTOMATICALLY;
C  TRY TO KEEP ONLY THOSE TALLIES THAT ARE NEEDED FOR THE TYPE OF
C  SPECIES PRESENT IN THE PARTICULAR CASE.
c   e.g.  no photon tallies unless photons are included (NPHOT>0)
c   e.g.  no test ion tallies unless test ions are included (NION>0)
c   e.g.  no generation limit tallies unless there is, indeed a
c         generation limit activated

      LEXGENA  = ANY(NGENA(1:NATM) /= 0)
      LEXGENM  = ANY(NGENM(1:NMOL) /= 0)
      LEXGENI  = ANY(NGENI(1:NION) /= 0)
      LEXGENPH = ANY(NGENPH(1:NPHOT) /= 0)

      LEXTALV(1)  =  NATM>0
      LEXTALV(2)  =  NMOL>0
      LEXTALV(3)  =  NION>0
      LEXTALV(4)  =  NPHOT>0
      LEXTALV(5)  =  NATM>0
      LEXTALV(6)  =  NMOL>0
      LEXTALV(7)  =  NION>0
      LEXTALV(8)  =  NPHOT>0

      LEXTALV(9)  =  NATM>0
      LEXTALV(10) =  NATM>0
      LEXTALV(11) = (NATM>0).and.(NMOL>0)
      LEXTALV(12) = (NATM>0).and.(NION>0)
      LEXTALV(13) = (NATM>0).and.(NPHOT>0)
      LEXTALV(14) = (NATM>0).and.(NPLS>0)

      LEXTALV(15) =  NMOL>0
      LEXTALV(16) = (NMOL>0).and.(NATM>0)
      LEXTALV(17) =  NMOL>0
      LEXTALV(18) = (NMOL>0).and.(NION>0)
      LEXTALV(19) = (NMOL>0).and.(NPHOT>0)
      LEXTALV(20) = (NMOL>0).and.(NPLS>0)

      LEXTALV(21) =  NION>0
      LEXTALV(22) = (NION>0).and.(NATM>0)
      LEXTALV(23) = (NION>0).and.(NMOL>0)
      LEXTALV(24) =  NION>0
      LEXTALV(25) = (NION>0).and.(NPHOT>0)
      LEXTALV(26) = (NION>0).and.(NPLS>0)

      LEXTALV(27) =  NPHOT>0
      LEXTALV(28) = (NPHOT>0).and.(NATM>0)
      LEXTALV(29) = (NPHOT>0).and.(NMOL>0)
      LEXTALV(30) = (NPHOT>0).and.(NION>0)
      LEXTALV(31) =  NPHOT>0
      LEXTALV(32) = (NPHOT>0).and.(NPLS>0)

      LEXTALV(33) =                NATM>0
      LEXTALV(34) =                NATM>0
      LEXTALV(35) = (NMOL>0) .and.(NATM>0)
      LEXTALV(36) = (NION>0) .and.(NATM>0)
      LEXTALV(37) = (NPHOT>0).and.(NATM>0)
      LEXTALV(38) = (NPLS>0) .and.(NATM>0)

      LEXTALV(39) =                NMOL>0
      LEXTALV(40) = (NATM>0) .and.(NMOL>0)
      LEXTALV(41) =                NMOL>0
      LEXTALV(42) = (NION>0) .and.(NMOL>0)
      LEXTALV(43) = (NPHOT>0).and.(NMOL>0)
      LEXTALV(44) = (NPLS>0) .and.(NMOL>0)

      LEXTALV(45) =                NION>0
      LEXTALV(46) = (NATM>0) .and.(NION>0)
      LEXTALV(47) = (NMOL>0) .and.(NION>0)
      LEXTALV(48) =                NION>0
      LEXTALV(49) = (NPHOT>0).and.(NION>0)
      LEXTALV(50) = (NPLS>0) .and.(NION>0)

      LEXTALV(51) =               NPHOT>0
      LEXTALV(52) = (NATM>0).and.(NPHOT>0)
      LEXTALV(53) = (NMOL>0).and.(NPHOT>0)
      LEXTALV(54) = (NION>0).and.(NPHOT>0)
      LEXTALV(55) =               NPHOT>0
      LEXTALV(56) = (NPLS<0).and.(NPHOT>0)

      LEXTALV(NTALA) = NADV>0  ! additional tracklength estimator tally
                               ! (update.f)
      LEXTALV(NTALC) = NCLV>0  ! additional collision estimator tally
                               ! (collide.f)
      LEXTALV(NTALT) = NSNV>0  ! additional snapshot tally
      LEXTALV(NTALM) = NCPV>0  ! additional tallies for interfacing to
                               ! external codes
      LEXTALV(NTALB) = NBGV>0  ! additional tallies for BGK iterations
      LEXTALV(NTALR) = NALV>0  ! additional tally, algebraic expression,
                               ! postprocessing
C  GENERATION LIMIT TALLIES
C  some of these tallies may be
c  turned off, depending upon whether generation limits
c  are activated or not.

      LEXTALV(63) = NATM>0  .AND. LEXGENA
      LEXTALV(64) = NMOL>0  .AND. LEXGENM
      LEXTALV(65) = NION>0  .AND. LEXGENI
      LEXTALV(66) = NPHOT>0 .AND. LEXGENPH
      LEXTALV(67) = NATM>0  .AND. LEXGENA
      LEXTALV(68) = NMOL>0  .AND. LEXGENM
      LEXTALV(69) = NION>0  .AND. LEXGENI
      LEXTALV(70) = NPHOT>0 .AND. LEXGENPH
      LEXTALV(71) = NATM>0  .AND. LEXGENA
      LEXTALV(72) = NMOL>0  .AND. LEXGENM
      LEXTALV(73) = NION>0  .AND. LEXGENI
      LEXTALV(74) = NPHOT>0 .AND. LEXGENPH
C  PRIMARY SOURCE RATES, PARTICLES
      LEXTALV(75) = NATM>0
      LEXTALV(76) = NMOL>0
      LEXTALV(77) = NION>0
      LEXTALV(78) = NPHOT>0
      LEXTALV(79) = NPLS>0
C  PRIMARY SOURCE RATES, ENERGY
      LEXTALV(80) = NATM>0
      LEXTALV(81) = NMOL>0
      LEXTALV(82) = NION>0
      LEXTALV(83) = NPHOT>0
      LEXTALV(84) = NPLS>0
C  MOMENTUM DENSITY, X DIRECTION
      LEXTALV(85) = NATM>0
      LEXTALV(86) = NMOL>0
      LEXTALV(87) = NION>0
      LEXTALV(88) = NPHOT>0
C  MOMENTUM DENSITY, Y DIRECTION
      LEXTALV(89) = NATM>0
      LEXTALV(90) = NMOL>0
      LEXTALV(91) = NION>0
      LEXTALV(92) = NPHOT>0
C  MOMENTUM DENSITY, Z DIRECTION
      LEXTALV(93) = NATM>0
      LEXTALV(94) = NMOL>0
      LEXTALV(95) = NION>0
      LEXTALV(96) = NPHOT>0
C  PARALLEL (TO B FIELD) MOMENTUM SOURCE RATES
      LEXTALV(97) = (NPLS>0) .AND. (NATM>0)
      LEXTALV(98) = (NPLS>0) .AND. (NMOL>0)
      LEXTALV(99) = (NPLS>0) .AND. (NION>0)
      LEXTALV(100) = (NPLS>0) .AND. (NPHOT>0)

C  RADIATION RATES
      LEXTALV(101) = NATM>0
      LEXTALV(102) = NMOL>0
      LEXTALV(103) = NION>0

C  CURRENTLY THE LAST DEFAULT OUTPUT VOLUME TALLY IS TALLY NO. 103

C  LMISTALV(ITAL) = TRUE: TALLY HAS BEEN DEACTIVATED BY INPUT FLAGS SET IN INPUT BLOCK 11
C  DEFAULT: LMISTALV=.FALSE. FOR ALL TALLIES, I.E. "ALL TALLIES ARE LIVING"
      LIVTALV = LEXTALV .AND. .NOT.LMISTALV

C  LMISTALV = TRUE: TURNING OFF A TALLY IN BLOCK 11 IS ONLY POSSIBLE
C                   IF THE CORRESPONDING TYPE OF PARTICLE EXISTS
      LMISTALV = LEXTALV .AND. LMISTALV

      ! ATOM PLASMA INTERACTION --> ANY ENERGY EXCHANGE TALLY ?
      LEA  = LEAAT .OR. LEAML .OR. LEAIO .OR. LEAPHT .OR. LEAPL
      ! MOLECULE PLASMA INTERACTION --> ANY ENERGY EXCHANGE TALLY ?
      LEM  = LEMAT .OR. LEMML .OR. LEMIO .OR. LEMPHT .OR. LEMPL
      ! TEST ION PLASMA INTERACTION --> ANY ENERGY EXCHANGE TALLY ?
      LEIO = LEIAT .OR. LEIML .OR. LEIIO .OR. LEIPHT .OR. LEIPL
      ! PHOTON PLASMA INTERACTION --> ANY ENERGY EXCHANGE TALLY ?
      LEPH = LEPHAT .OR. LEPHML .OR. LEPHIO .OR. LEPHPHT .OR. LEPHPL

C
C  LEADING DIMENSIONS OF FIELDS IN COMMON BLOCK CESTIM AND COUTAU
C                (i.e. of volume- or surface-averaged output tallies)
C
C  DENSITIES; ENERGY DENSITIES
      NFIRST(1)=NATM
      NFIRST(2)=NMOL
      NFIRST(3)=NION
      NFIRST(4)=NPHOT
      NFIRST(5)=NATM
      NFIRST(6)=NMOL
      NFIRST(7)=NION
      NFIRST(8)=NPHOT
C  PARTICLE SOURCES
      NFIRST(9)=0
      NFIRST(10)=NATM
      NFIRST(11)=NMOL
      NFIRST(12)=NION
      NFIRST(13)=NPHOT
      NFIRST(14)=NPLS
      IF (NLSPCSCL_ATM) THEN
        NFIRST(10)=NATM*NATMP
        NFIRST(11)=NMOL*NATMP
        NFIRST(12)=NION*NATMP
        NFIRST(13)=NPHOT*NATMP
        NFIRST(14)=NPLS*NATMP
      END IF
      NFIRST(15)=0
      NFIRST(16)=NATM
      NFIRST(17)=NMOL
      NFIRST(18)=NION
      NFIRST(19)=NPHOT
      NFIRST(20)=NPLS
      IF (NLSPCSCL_MOL) THEN
        NFIRST(16)=NATM*NMOLP
        NFIRST(17)=NMOL*NMOLP
        NFIRST(18)=NION*NMOLP
        NFIRST(19)=NPHOT*NMOLP
        NFIRST(20)=NPLS*NMOLP
      END IF
      NFIRST(21)=0
      NFIRST(22)=NATM
      NFIRST(23)=NMOL
      NFIRST(24)=NION
      NFIRST(25)=NPHOT
      NFIRST(26)=NPLS
      IF (NLSPCSCL_ION) THEN
        NFIRST(22)=NATM*NIONP
        NFIRST(23)=NMOL*NIONP
        NFIRST(24)=NION*NIONP
        NFIRST(25)=NPHOT*NIONP
        NFIRST(26)=NPLS*NIONP
      END IF
      NFIRST(27)=0
      NFIRST(28)=NATM
      NFIRST(29)=NMOL
      NFIRST(30)=NION
      NFIRST(31)=NPHOT
      NFIRST(32)=NPLS
      IF (NLSPCSCL_PHOT) THEN
        NFIRST(28)=NATM*NPHOTP
        NFIRST(29)=NMOL*NPHOTP
        NFIRST(30)=NION*NPHOTP
        NFIRST(31)=NPHOT*NPHOTP
        NFIRST(32)=NPLS*NPHOTP
      END IF
C  ENERGY SOURCES
      NFIRST(33)=0
      NFIRST(34)=0
      NFIRST(35)=0
      NFIRST(36)=0
      NFIRST(37)=0
      NFIRST(38)=NPLS
      NFIRST(39)=0
      NFIRST(40)=0
      NFIRST(41)=0
      NFIRST(42)=0
      NFIRST(43)=0
      NFIRST(44)=NPLS
      NFIRST(45)=0
      NFIRST(46)=0
      NFIRST(47)=0
      NFIRST(48)=0
      NFIRST(49)=0
      NFIRST(50)=NPLS
      NFIRST(51)=0
      NFIRST(52)=0
      NFIRST(53)=0
      NFIRST(54)=0
      NFIRST(55)=0
      NFIRST(56)=NPLS
C  VARIOUS ADDITIONAL TALLIES
      NFIRST(NTALA)=NADV
      NFIRST(NTALC)=NCLV
      NFIRST(NTALT)=NSNV
      NFIRST(NTALM)=NCPV
      NFIRST(NTALB)=NBGV
      NFIRST(NTALR)=NALV
C  GENERATION LIMIT TALLIES
      NFIRST(63)=NATM
      NFIRST(64)=NMOL
      NFIRST(65)=NION
      NFIRST(66)=NPHOT
      NFIRST(67)=NATM
      NFIRST(68)=NMOL
      NFIRST(69)=NION
      NFIRST(70)=NPHOT
      NFIRST(71)=NATM
      NFIRST(72)=NMOL
      NFIRST(73)=NION
      NFIRST(74)=NPHOT
C  PRIMARY SOURCE TALLIES, PARTICLES
      NFIRST(75)=NATM
      NFIRST(76)=NMOL
      NFIRST(77)=NION
      NFIRST(78)=NPHOT
      NFIRST(79)=NPLS
C  PRIMARY SOURCE TALLIES, ENERGY
      NFIRST(80)=0
      NFIRST(81)=0
      NFIRST(82)=0
      NFIRST(83)=0
      NFIRST(84)=NPLS
C  MOMENTUM DENSITY, X DIRECTION
      NFIRST(85)=NATM
      NFIRST(86)=NMOL
      NFIRST(87)=NION
      NFIRST(88)=NPHOT
C  MOMENTUM DENSITY, Y DIRECTION
      NFIRST(89)=NATM
      NFIRST(90)=NMOL
      NFIRST(91)=NION
      NFIRST(92)=NPHOT
C  MOMENTUM DENSITY, Z DIRECTION
      NFIRST(93)=NATM
      NFIRST(94)=NMOL
      NFIRST(95)=NION
      NFIRST(96)=NPHOT
C  PARALLEL (TO B FIELD) MOMENTUM SOURCE RATES
      NFIRST(97)=NPLS
      NFIRST(98)=NPLS
      NFIRST(99)=NPLS
      NFIRST(100)=NPLS

C  RADIATION RATES
      NFIRST(101)=NATM
      NFIRST(102)=NMOL
      NFIRST(103)=NION
C
C  NTALV=103 ?
C
      DO 1 J=1,NTALV
        NFRSTI(J)=NFIRST(J)+1
        IF (LIVTALV(J)) NFIRST(J)=MAX0(1,NFIRST(J))
    1 CONTINUE
C
C  SET INCREMENT NADDV(J) TO IDENTIFY TALLY J ON LARGE 1D ARRAY
C  CONSIDER ONLY "LIVING TALLIES"
C  SET NLSTTL: NUMBER OF LAST LIVING TALLY (MAY BE LESS THAN 100)
      NADDI(1)=0
      NADDV(1)=0
      NLSTTL = 0
      DO 2 J=2,NTALV
        NADDI(J)=NADDI(J-1)+NFRSTI(J-1)
        IF (LIVTALV(J-1)) THEN
          NADDV(J)=NADDV(J-1)+NFIRST(J-1)
          NLSTTL = J-1
        ELSE
          NADDV(J)=NADDV(J-1)
        END IF
    2 CONTINUE

      IF (LIVTALV(NTALV)) NLSTTL = NTALV
C
C  TOTAL NUMBER OF "LIVING" VOLUME-AVERAGED TALLIES
      NVOLTL=NADDV(NTALV)+NFIRST(NLSTTL)
      WRITE (IUNOUT,*) 'NVOLTL = ', NVOLTL
      WRITE (IUNOUT,*) 'NADDV'
      WRITE (IUNOUT,'(10I6)') NADDV

cdr  NEXT VARIABLES WERE USED FOR TESTING STORAGE FOR VOLUME-AVERAGED TALLIES
cdr  NOW OUT, TEST NOT CARRIED OUT ANYMORE, PERHAPS BECAUSE OF TALLY REDUCTION
cdr  (LIVTALV(ITAL) OPTION TO REMOVE TALLIES.
cdr
cdr   NTEST=NADDV(NTALV)+NFIRST(NTALV)
cdr   NTESTI=NADDI(NTALV)+NFRSTI(NTALV)
cdr   NTEST=NTEST*NRTAL
cdr   NTESTI=NTESTI*NSTRAP
C
c  now do the same for surface-averaged tallies, incident, emitted, sputtered
c  three times similar structure, 25 tallies each. sputter tallies: total by emitted type and species missing
c  surface tallies: incident bulk ions resolved wrt. emitted type and species missing
C   1 --25  particle fluxes
      LEXTALS(1) =                (NATM>0)  ! outgoing, atoms

      LEXTALS(2) =                (NATM>0)  ! ingoing, atoms, from atoms
      LEXTALS(3) = (NMOL>0)  .and.(NATM>0)  ! ingoing, atoms,
                                            ! from molecules
      LEXTALS(4) = (NION>0)  .and.(NATM>0)
      LEXTALS(5) = (NPHOT>0) .and.(NATM>0)
      LEXTALS(6) = (NPLS>0)  .and.(NATM>0)

      LEXTALS(7) =                (NMOL>0)

      LEXTALS(8) = (NATM>0)  .and.(NMOL>0)
      LEXTALS(9) =                (NMOL>0)
      LEXTALS(10) =(NION>0)  .and.(NMOL>0)
      LEXTALS(11) =(NPHOT>0) .and.(NMOL>0)
      LEXTALS(12) =(NPLS>0)  .and.(NMOL>0)

      LEXTALS(13) =               (NION>0)

      LEXTALS(14) =(NATM>0)  .and.(NION>0)
      LEXTALS(15) =(NMOL>0)  .and.(NION>0)
      LEXTALS(16) =               (NION>0)
      LEXTALS(17) =(NPHOT>0) .and.(NION>0)
      LEXTALS(18) =(NPLS>0)  .and.(NION>0)

      LEXTALS(19) =               (NPHOT>0)

      LEXTALS(20) =(NATM>0)  .and.(NPHOT>0)
      LEXTALS(21) =(NMOL>0)  .and.(NPHOT>0)
      LEXTALS(22) =(NION>0)  .and.(NPHOT>0)
      LEXTALS(23) =               (NPHOT>0)
      LEXTALS(24) =(NPLS>0)  .and.(NPHOT>0)

      LEXTALS(25) =               (NPLS>0)

C   26 --> 50  energy fluxes
      LEXTALS(26) =               (NATM>0)

      LEXTALS(27) =               (NATM>0)
      LEXTALS(28) =(NMOL>0)  .and.(NATM>0)
      LEXTALS(29) =(NION>0)  .and.(NATM>0)
      LEXTALS(30) =(NPHOT>0) .and.(NATM>0)
      LEXTALS(31) =(NPLS>0)  .and.(NATM>0)

      LEXTALS(32) =               (NMOL>0)

      LEXTALS(33) =(NATM>0)  .and.(NMOL>0)
      LEXTALS(34) =               (NMOL>0)
      LEXTALS(35) =(NION>0)  .and.(NMOL>0)
      LEXTALS(36) =(NPHOT>0) .and.(NMOL>0)
      LEXTALS(37) =(NPLS>0)  .and.(NMOL>0)

      LEXTALS(38) =               (NION>0)

      LEXTALS(39) =(NATM>0)  .and.(NION>0)
      LEXTALS(40) =(NMOL>0)  .and.(NION>0)
      LEXTALS(41) =               (NION>0)
      LEXTALS(42) =(NPHOT>0) .and.(NION>0)
      LEXTALS(43) =(NPLS>0)  .and.(NION>0)

      LEXTALS(44) =               (NPHOT>0)

      LEXTALS(45) =(NATM>0)  .and.(NPHOT>0)
      LEXTALS(46) =(NMOL>0)  .and.(NPHOT>0)
      LEXTALS(47) =(NION>0)  .and.(NPHOT>0)
      LEXTALS(48) =               (NPHOT>0)
      LEXTALS(49) =(NPLS>0)  .and.(NPHOT>0)

      LEXTALS(50) =               (NPLS>0)

C  SPUTTERED FLUXES; BY INGOING TYPE AND OUTGOING SPECIES
      LEXTALS(51) =                (NATM>0)  !A -AT
      LEXTALS(52) = (NMOL>0)  .AND.(NATM>0)  !M -AT
      LEXTALS(53) = (NION>0)  .AND.(NATM>0)  !I -AT
      LEXTALS(54) = (NPHOT>0) .AND.(NATM>0)  !PH-AT
      LEXTALS(55) = (NPLS>0)  .AND.(NATM>0)  !P -AT

      LEXTALS(56) = (NATM>0)  .AND.(NMOL>0)
      LEXTALS(57) =                (NMOL>0)
      LEXTALS(58) = (NION>0)  .AND.(NMOL>0)
      LEXTALS(59) = (NPHOT>0) .AND.(NMOL>0)
      LEXTALS(60) = (NPLS>0)  .AND.(NMOL>0)

      LEXTALS(61) = (NATM>0)  .AND.(NION>0)
      LEXTALS(62) = (NMOL>0)  .AND.(NION>0)
      LEXTALS(63) =                (NION>0)
      LEXTALS(64) = (NPHOT>0) .AND.(NION>0)
      LEXTALS(65) = (NPLS>0)  .AND.(NION>0)

      LEXTALS(66) = (NATM>0)  .AND.(NPHOT>0)
      LEXTALS(67) = (NMOL>0)  .AND.(NPHOT>0)
      LEXTALS(68) = (NION>0)  .AND.(NPHOT>0)
      LEXTALS(69) =                (NPHOT>0)
      LEXTALS(70) = (NPLS>0)  .AND.(NPHOT>0)

      LEXTALS(71) = (NATM>0)  .AND.(NPLS>0)
      LEXTALS(72) = (NMOL>0)  .AND.(NPLS>0)
      LEXTALS(73) = (NION>0)  .AND.(NPLS>0)
      LEXTALS(74) = (NPHOT>0) .AND.(NPLS>0)
      LEXTALS(75) =                (NPLS>0)

C  SPUTTERED FLUX; TOTAL BY INGOING TYPE
      LEXTALS(76) = (NATM>0)
      LEXTALS(77) = (NMOL>0)
      LEXTALS(78) = (NION>0)
      LEXTALS(79) = (NPHOT>0)
      LEXTALS(80) = (NPLS>0)
C  SPUTTERED FLUX; TOTAL, NOT SCALED BY NLSCL OPTION
      LEXTALS(81) = .TRUE.

      LEXTALS(NTLSA) = NADS>0
      LEXTALS(NTLSR) = NALS>0
C  TALLY NTALS=84: PUMPED FLUX
      LEXTALS(NTALS) = NSPZ>0

      LIVTALS  = LEXTALS .AND. .NOT.LMISTALS
      LMISTALS = LEXTALS .AND.      LMISTALS
C
      NFRSTW(1)=NATM
      NFRSTW(2)=NATM
      IF (NLSPCSCL_ATM) NFRSTW(2)=NATM*NATMP
      NFRSTW(3)=NATM
      IF (NLSPCSCL_MOL) NFRSTW(3)=NATM*NMOLP
      NFRSTW(4)=NATM
      IF (NLSPCSCL_ION) NFRSTW(4)=NATM*NIONP
      NFRSTW(5)=NATM
      IF (NLSPCSCL_PHOT) NFRSTW(5)=NATM*NPHOTP
      NFRSTW(6)=NATM
      NFRSTW(7)=NMOL
      NFRSTW(8)=NMOL
      IF (NLSPCSCL_ATM) NFRSTW(8)=NMOL*NATMP
      NFRSTW(9)=NMOL
      IF (NLSPCSCL_MOL) NFRSTW(9)=NMOL*NMOLP
      NFRSTW(10)=NMOL
      IF (NLSPCSCL_ION) NFRSTW(10)=NMOL*NIONP
      NFRSTW(11)=NMOL
      IF (NLSPCSCL_PHOT) NFRSTW(11)=NMOL*NPHOTP
      NFRSTW(12)=NMOL
      NFRSTW(13)=NION
      NFRSTW(14)=NION
      IF (NLSPCSCL_ATM) NFRSTW(14)=NION*NATMP
      NFRSTW(15)=NION
      IF (NLSPCSCL_MOL) NFRSTW(15)=NION*NMOLP
      NFRSTW(16)=NION
      IF (NLSPCSCL_ION) NFRSTW(16)=NION*NIONP
      NFRSTW(17)=NION
      IF (NLSPCSCL_PHOT) NFRSTW(17)=NION*NPHOTP
      NFRSTW(18)=NION
      NFRSTW(19)=NPHOT
      NFRSTW(20)=NPHOT
      IF (NLSPCSCL_ATM) NFRSTW(20)=NPHOT*NATMP
      NFRSTW(21)=NPHOT
      IF (NLSPCSCL_MOL) NFRSTW(21)=NPHOT*NMOLP
      NFRSTW(22)=NPHOT
      IF (NLSPCSCL_ION) NFRSTW(22)=NPHOT*NIONP
      NFRSTW(23)=NPHOT
      IF (NLSPCSCL_PHOT) NFRSTW(23)=NPHOT*NPHOTP
      NFRSTW(24)=NPHOT
      NFRSTW(25)=NPLS

      NFRSTW(26)=NATM
      NFRSTW(27)=NATM
      NFRSTW(28)=NATM
      NFRSTW(29)=NATM
      NFRSTW(30)=NATM
      NFRSTW(31)=NATM
      NFRSTW(32)=NMOL
      NFRSTW(33)=NMOL
      NFRSTW(34)=NMOL
      NFRSTW(35)=NMOL
      NFRSTW(36)=NMOL
      NFRSTW(37)=NMOL
      NFRSTW(38)=NION
      NFRSTW(39)=NION
      NFRSTW(40)=NION
      NFRSTW(41)=NION
      NFRSTW(42)=NION
      NFRSTW(43)=NION
      NFRSTW(44)=NPHOT
      NFRSTW(45)=NPHOT
      NFRSTW(46)=NPHOT
      NFRSTW(47)=NPHOT
      NFRSTW(48)=NPHOT
      NFRSTW(49)=NPHOT
      NFRSTW(50)=NPLS

      NFRSTW(51)=NATM
      NFRSTW(52)=NATM
      NFRSTW(53)=NATM
      NFRSTW(54)=NATM
      NFRSTW(55)=NATM
      NFRSTW(56)=NMOL
      NFRSTW(57)=NMOL
      NFRSTW(58)=NMOL
      NFRSTW(59)=NMOL
      NFRSTW(60)=NMOL
      NFRSTW(61)=NION
      NFRSTW(62)=NION
      NFRSTW(63)=NION
      NFRSTW(64)=NION
      NFRSTW(65)=NION
      NFRSTW(66)=NPHOT
      NFRSTW(67)=NPHOT
      NFRSTW(68)=NPHOT
      NFRSTW(69)=NPHOT
      NFRSTW(70)=NPHOT
      NFRSTW(71)=NPLS
      NFRSTW(72)=NPLS
      NFRSTW(73)=NPLS
      NFRSTW(74)=NPLS
      NFRSTW(75)=NPLS
C  TOTAL SPUTTER TALLY
      NFRSTW(76)=0
      NFRSTW(77)=0
      NFRSTW(78)=0
      NFRSTW(79)=0
      NFRSTW(80)=0
      NFRSTW(81)=0

      NFRSTW(NTLSA)=NADS  !  no. 82, additional surface tallies
      NFRSTW(NTLSR)=NALS  !  no. 83, additional algebr. surface tally
C  last surface tally
      NFRSTW(NTALS)=NSPZ  !  SPUMP
C
C  NTALS=84 ?
C
      DO 4 J=1,NTALS
        NFRTWI(J)=NFRSTW(J)+1
        IF (LIVTALS(J)) NFRSTW(J)=MAX0(1,NFRSTW(J))
    4 CONTINUE
C
      NDDWI(1)=0
      NADDW(1)=0
      NLSTTW = 0
      DO 3 J=2,NTALS
        NDDWI(J)=NDDWI(J-1)+NFRTWI(J-1)
        IF (LIVTALS(J-1)) THEN
          NADDW(J)=NADDW(J-1)+NFRSTW(J-1)
          NLSTTW = J-1
        ELSE
          NADDW(J)=NADDW(J-1)
        END IF
    3 CONTINUE

      IF (LIVTALS(NTALS)) NLSTTW = NTALS

C  TOTAL NUMBER OF SURFACE-AVERAGED TALLIES
      NSRFTL=NADDW(NTALS)+NFRSTW(NLSTTW)
      WRITE (IUNOUT,*) 'NSRFTL = ', NSRFTL
      WRITE (IUNOUT,*) 'NADDW'
      WRITE (IUNOUT,'(10I6)') NADDW

cdr  NEXT VARIABLES WERE USED FOR TESTING STORAGE FOR SURFACE-AVERAGED TALLIES
cdr  NOW OUT, TEST IS NOT CARRIED OUT ANYMORE, PERHAPS BECAUSE OF TALLY REDUCTION
cdr  LIVTALS(ITAL) OPTION TO REMOVE TALLIES?
cdr
cdr   NTEST=NADDW(NTALS)+NFRSTW(NTALS)
cdr   NTESTI=NDDWI(NTALS)+NFRTWI(NTALS)
cdr   NTEST=NTEST*NLMPGS
cdr   NTESTI=NTESTI*NSTRAP

      CALL EIRENE_ALLOC_CESTIM(2)
      CALL EIRENE_ASSOCIATE_CESTIM

C
C  CHECK LENGTH OF ALLOCATABLE ARRAYS, WHICH ARE I/O IN DUMP FILES,
c  E.G. FORT.10, FORT.11, ETC....
C
C
      IF (.FALSE.) THEN
cdr  March 2017: checking of allocatable array sizes has been deactivated,
cdr              at some point in time.
cdr              Probable reason: it did not work properly together with
cdr              compiler optimization. And in case of estimv, estims
cdr              arrays: apparently some parts may have been moved to cemetery,
cdr              so that the programmed size checks would not work anyway.
cdr  unresolved story.....
c.......................................................
c  standard deviation volume-averaged tallies
      RSAVE=SGMS(NSD)
      SGMS(NSD)=1.234567
      write (iunout,*) nsd,nrtal
      IF (SDVI1(NSD,NRTAL+1).NE.1.234567) THEN
        WRITE (iunout,*) 'PARAMETER ERROR DETECTED IN SETPRM: NSDVI1?'
        CALL EIRENE_EXIT_OWN(1)
      ENDIF
      SGMS(NSD)=RSAVE
C
c  standard deviation surface-averaged tallies
      RSAVE=SGMWS(NSDW)
      SGMWS(NSDW)=1.234567
      write (iunout,*) nsdw,nlimps
      IF (SDVI2(NSDW,NLIMPS+1).NE.1.234567) THEN
        WRITE (iunout,*) 'PARAMETER ERROR DETECTED IN SETPRM: NSDVI2?'
        CALL EIRENE_EXIT_OWN(1)
      ENDIF
      SGMWS(NSDW)=RSAVE
C
c  volume-averaged output tallies. Note: some volume tallies are removed from
c  the run (put to cemeteryv), see eirmod_cestim.f
      RSAVE=MPHPL(NPHOT,NRTAL)
      MPHPL(NPHOT,NRTAL)=1.234567
      write (iunout,*) nvoltl,nrtal
      IF (ESTIMV(NVOLTL,NRTAL).NE.1.234567) THEN
        WRITE (iunout,*) 'PARAMETER ERROR DETECTED IN SETPRM: NESTM1?'
C       CALL EIRENE_EXIT_OWN(1)
      ENDIF
      MPHPL(NPHOT,NRTAL)=RSAVE
C
c  surface-averaged output tallies. Note: some surface tallies are removed from
c  the run (put to cemeterys), see eirmod_cestim.f
      RSAVE=SPUMP(NSPZ,NLMPGS)
      SPUMP(NSPZ,NLMPGS)=1.234567
      write (iunout,*) nsrftl,nlmpgs
      IF (ESTIMS(NSRFTL,NLMPGS).NE.1.234567) THEN
        WRITE (iunout,*) 'PARAMETER ERROR DETECTED IN SETPRM: NESTM2?'
C       CALL EIRENE_EXIT_OWN(1)
      ENDIF
      SPUMP(NSPZ,NLMPGS)=RSAVE
C
C  NOW ATOMIC DATA ARRAYS: COMXS
C
      RSAVE=ZMFPI
      ZMFPI=1.234567
      write (iunout,*) nstorv
      IF (XSTORV(NSTORV).NE.1.234567) THEN
        WRITE (iunout,*) 'PARAMETER ERROR DETECTED IN SETPRM: NSTOR?'
C       CALL EIRENE_EXIT_OWN(1)
      ENDIF
      ZMFPI=RSAVE
C
      RSAVE=VOLTOT
      VOLTOT=1.234567
      write (iunout,*) ncgm1
      IF (RCGM1(NCGM1).NE.1.234567) THEN
        WRITE (iunout,*) 'PARAMETER ERROR DETECTED IN SETPRM: NCGM1?'
C       CALL EIRENE_EXIT_OWN(1)
      ENDIF
      VOLTOT=RSAVE
C
      RSAVE=ZDF
      ZDF=1.234567
      write (iunout,*) ncgrd
      IF (RCGRID(NCGRD).NE.1.234567) THEN
        WRITE (iunout,*) 'PARAMETER ERROR DETECTED IN SETPRM: NCGRD?'
C       CALL EIRENE_EXIT_OWN(1)
      ENDIF
      ZDF=RSAVE
C
      ISAVE=NSBOX_TAL
      NSBOX_TAL=1234567
      write (iunout,*) mcgrd
      IF (ICGRID(MCGRD).NE.1234567) THEN
        WRITE (iunout,*) 'PARAMETER ERROR DETECTED IN SETPRM: MCGRD?'
C       CALL EIRENE_EXIT_OWN(1)
      ENDIF
      NSBOX_TAL=ISAVE
C
      ISAVE=NPPLG
      NPPLG=1234567
      write (iunout,*) mcplyg
      IF (ICPLYG(MCPLYG).NE.1234567) THEN
        WRITE (iunout,*) 'PARAMETER ERROR DETECTED IN SETPRM: MCPLYG?'
C       CALL EIRENE_EXIT_OWN(1)
      ENDIF
      NPPLG=ISAVE

c.....................................................................

      END IF  ! FALSE   storage tests deactivated

cdr  correct for the derived tallies mixed into primary input tallies.
cdr  Aug.18: also this storage test is now de-activated,
cdr          due to new options to turn off input tallies
cdr          and to remove their storage
c     NPLPRM_TEST=NPLPRM + (2+NPLS)*NRAD
c     IF (NTESTP.NE.NPLPRM_TEST) THEN
c        WRITE (iunout,*) 'PARAMETER ERROR DETECTED IN SETPRM: NPLPRM'
c        WRITE (iunout,*) 'NTESTP, NPLPRM ',NTESTP,NPLPRM_TEST
c        CALL EIRENE_EXIT_OWN(1)
c     ENDIF
c.............................................................................

      IF (TRCTAL) THEN
        CALL EIRENE_LEER(2)
        WRITE(IUNOUT,*) 'VOLUME-AVERAGED TALLIES CALCULATED IN THIS RUN'
        CALL EIRENE_LEER(1)
        WRITE(IUNOUT,'(A6,1X,A)') 'NO.','DESCRIPTION'
        DO ITAL=1,NTALV
          IF (LIVTALV(ITAL)) THEN
            WRITE (IUNOUT,'(I6,1X,A72)') ITAL,TXTTAL(1,ITAL)
          ENDIF
        END DO

        IF (.NOT.ALL(LIVTALV)) THEN
          CALL EIRENE_LEER(2)
          WRITE(IUNOUT,*) 'VOLUME-AVERAGED TALLIES NOT CALCULATED ',
     .                    'IN THIS RUN'
          CALL EIRENE_LEER(1)
          WRITE(IUNOUT,'(A6,1X,A)') 'NO.','DESCRIPTION'
          DO ITAL=1,NTALV
            IF (.NOT.LIVTALV(ITAL)) THEN
              WRITE (IUNOUT,'(I6,1X,A72)') ITAL,TXTTAL(1,ITAL)
            ENDIF
          END DO
        END IF

        IF (ANY(LMISTALV)) THEN
          CALL EIRENE_LEER(2)
          WRITE(IUNOUT,*) 'VOLUME-AVERAGED TALLIES EXPLICITLY ',
     .                'SWITCHED OFF VIA INPUT FILE '
          CALL EIRENE_LEER(1)
          WRITE(IUNOUT,'(A6,1X,A)') 'NO.','DESCRIPTION'
          DO ITAL=1,NTALV
            IF (LMISTALV(ITAL)) THEN
              WRITE (IUNOUT,'(I6,1X,A72)') ITAL,TXTTAL(1,ITAL)
            ENDIF
          END DO
        END IF

        CALL EIRENE_LEER(2)
        WRITE(IUNOUT,*)'SURFACE-AVERAGED TALLIES CALCULATED IN THIS RUN'
        CALL EIRENE_LEER(1)
        WRITE(IUNOUT,'(A6,1X,A)') 'NO.','DESCRIPTION'
        DO ITAL=1,NTALS
          IF (LIVTALS(ITAL))
     .      WRITE (IUNOUT,'(I6,1X,A72)') ITAL,TXTTLW(1,ITAL)
        END DO

        IF (.NOT.ALL(LIVTALS)) THEN
          CALL EIRENE_LEER(2)
          WRITE(IUNOUT,*) 'SURFACE-AVERAGED TALLIES NOT CALCULATED ',
     .                    'IN THIS RUN'
          CALL EIRENE_LEER(1)
          WRITE(IUNOUT,'(A6,1X,A)') 'NO.','DESCRIPTION'
          DO ITAL=1,NTALS
            IF (.NOT.LIVTALS(ITAL))
     .        WRITE (IUNOUT,'(I6,1X,A72)') ITAL,TXTTLW(1,ITAL)
          END DO
        END IF

        IF (ANY(LMISTALS)) THEN
          CALL EIRENE_LEER(2)
          WRITE(IUNOUT,*) 'SURFACE-AVERAGED TALLIES EXPLICITLY ',
     .                'SWITCHED OFF VIA INPUT FILE '
          CALL EIRENE_LEER(1)
          WRITE(IUNOUT,'(A6,1X,A)') 'NO.','DESCRIPTION'
          DO ITAL=1,NTALS
            IF (LMISTALS(ITAL))
     .        WRITE (IUNOUT,'(I6,1X,A72)') ITAL,TXTTLW(1,ITAL)
          END DO
        END IF

        CALL EIRENE_LEER(1)

      END IF
C
      RETURN
      END SUBROUTINE EIRENE_SETPRM
