
      SUBROUTINE EIRENE_SET_DERIVED_INPUT_PARAMETERS(IERROR)

      USE EIRMOD_PARMMOD
      USE EIRMOD_CGRID
      USE EIRMOD_CTRIG
      USE EIRMOD_CTETRA
      USE EIRMOD_CLOGAU
      USE EIRMOD_COMPRT, ONLY : IUNOUT

      IMPLICIT NONE
      INTEGER, INTENT(INOUT) :: IERROR
      INTEGER :: NS, NB, NA
      EXTERNAL :: EIRENE_MASPRM, EIRENE_EXIT_OWN
C
C  SET DERIVED INPUT PARAMETERS, GRIDS AND PROFILES
C
      NSURF=NR1ST*NP2ND*NT3RD*NBMLT
      NSTRD=NR1ST*NP2ND*NT3RD
      NBLCKS=NBMLT*NP2ND*NT3RD
      NSBOX=NSURF+NRADD
      NS=NSURF_TAL
      NB=NSBOX_TAL
      NA=NRADD_TAL
      NSURF_TAL=NR1TAL*NP2TAL*NT3TAL*NBMLT
      NSBOX_TAL=NR1TAL*NP2TAL*NT3TAL*NBMLT+NRADD_TAL
      IF (NS.NE.NSURF_TAL.OR.NB.NE.NSBOX_TAL.OR.
     .    NA.NE.NRADD_TAL) THEN
        WRITE (IUNOUT,*) 'INCONSISTENCY IN MULTI-GRID DATA '
        WRITE (IUNOUT,*) 'NSBOX_TAL, NB ', NSBOX_TAL, NB
        WRITE (IUNOUT,*) 'NSURF_TAL, NS ', NSURF_TAL, NS
        WRITE (IUNOUT,*) 'NRADD_TAL, NA ', NRADD_TAL, NA
      ENDIF

      IF (NSBOX.GT.NRAD) THEN
        CALL EIRENE_MASPRM('NRAD',4,NRAD,'NSBOX',5,NSBOX,IERROR)
        CALL EIRENE_EXIT_OWN(1)
      ENDIF
      NSURFM=NSURF-1
      NR1STM=NR1ST-1
      NP2NDM=NP2ND-1
      NT3RDM=NT3RD-1
      NTTRAM=NTTRA-1
      NBMLTP=NBMLT+1

      select case (LEVGEO)
      case (1)
        NGITT = NR1ST
        IF (NLPOL) NGITT = MAX(NGITT, NP2ND)
        IF (NLTOR) NGITT = MAX(NGITT, NT3RD)
      case (4)
        NGITT = COUNT(INMTI(1:3,1:NTRII) .NE. 0) + 1
      case (5)
        NGITT = COUNT(INMTIT(1:4,1:NTET) .NE. 0) + 1
      end select

      RETURN
      END SUBROUTINE EIRENE_SET_DERIVED_INPUT_PARAMETERS
