C
C
!  6.12.05  bugfix: avoid calculation of B field in dead cells
!                   because geometrical parameters may not be known there.
!  6.8. 06  bugfix of bugfix: avoid calculation of B field in dead cells, but
!                             still make sure to set B field in 1D cases.
!  15.12.06 bug fix: index error corrected in call to prousr when called for ADIN
!  10.06.08 new: default BFIN=1 T, rather than 0 T
!  10.06.08 new option: profile type 3 (profs): set BFIN using B2 and B3 parameters
!  22.09.14 bug fix re. this ind=3 option in case of type (=ind) = 1,2 .
!                       help2 was undefined --> zero B field
!
cdr try to re-unify treatment of 1st dimension (species index) in parameters
cdr n,T,V for background (bulk) velocity distribution: not finished.
!  sept. 16 change variable names ipls --> iplsti, (for TI)
!                                 ipls --> iplsv,  (for VX,VY,VZ)
!  oct. 16  comments, one minor bug fix (VZIN(IPLSV) in one (unused) option)
!  nov. 16  nlpitch option added, for orientation of B field in 1D and 2D runs
cdr jan 19: SELECT CASE(IND)
cdr feb 19: parameter NDIM: check 1st dimension of input tallies.
cdr         Still unclear treatment in case of Ti (ion temperature).
cpb: reading tiin from profr: set 1st dimension of tiin array.

cdr: check under which conditions can nplsti be different from npls, and is that still needed?
cdr: why is that not needed for V and n profiles?
!
!
      SUBROUTINE EIRENE_PLASMA
C  SET DENSITY, TEMPERATURE AND MACH NUMBER PROFILES, B AND E FIELDS,
C  ON:
C  INDPRO=1,2,3 1D MESH "RHOZNE(J)", 1,NR1STM, CELL-CENTERED
C               B FIELD (INDPRO(5)) SET ON 1:NSURF
C
C  INDPRO=4     READ FROM EXTERNAL FILE JSTREAM, EVERYWHERE, 1,NSBOX,
C  INDPRO=5     PROUSR: ONLY IN STANDARD GRID, 1:NSURF
C  INDPRO=6     PROFR : ONLY IN STANDARD GRID, 1:NSURF
C  INDPRO=7     PROFR : EVERYWHERE, 1,NSBOX
C  INDPRO=8     INPUT TALLY IS FOUND "ON THE FLY" DURING PART. TRACING
C               CURRENTLY: B field (BFIELD.F), flow field (VDION.F)
C  INDPRO=9     INPUT TALLIES ARE ALREADY SET ELSEWHERE, 1:NSURF ??
C

      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD
      USE EIRMOD_COMUSR
      USE EIRMOD_CCONA
      USE EIRMOD_CLOGAU
      USE EIRMOD_CINIT
      USE EIRMOD_CPOLYG
      USE EIRMOD_CGRID
      USE EIRMOD_CGEOM
      USE EIRMOD_CTEXT
      USE EIRMOD_COMPRT
      USE EIRMOD_PROFILES, ONLY : EIRENE_PROFR, EIRENE_PROFE,
     .                            EIRENE_PROFN, EIRENE_PROFS

      IMPLICIT NONE

      REAL(DP), ALLOCATABLE :: HELP(:), HELP2(:), RDUMMY(:,:)
      REAL(DP) :: PUX, PUY, EL, EP, PN, BD, B, BVAC, FACT
      INTEGER :: IB, IAIN, K, JJ, ITALI, ICELL, IND, JSTREAM,
     .           IP, IT, IA, J, IR, IPLSTI, IPLSV, JPLS, INI, NDIM
      EXTERNAL :: EIRENE_NCELLN, EIRENE_READTL, EIRENE_PROUSR,
     .            EIRENE_LEER, EIRENE_EXIT_OWN
C
C  INDPRO=9 MEANS: THESE ARRAYS ARE ALREADY SET IN COUPLE_... (SUBR. INFCOP)
      IF (INDPRO(1) /= 9) TEIN = 0.D0
      IF (INDPRO(2) /= 9) TIIN = 0.D0
                          DEIN = 0.D0 ! DERIVED TALLY DEIN IS SET
                                      ! IN PLASMA_DERIV
      IF (INDPRO(3) /= 9) DIIN = 0.D0

c flow field
      IF (INDPRO(4) /= 9) THEN
        VXIN = 0.D0
        VYIN = 0.D0
        VZIN = 0.D0
      ENDIF

      IF (INDPRO(11)/= 9) ZIIN = 0.D0
c  magnetic field
      IF (LBIN .AND. (INDPRO(5) /= 9)) THEN
        BXIN = 0.D0
        BYIN = 0.D0
        BZIN = 0.D0
        BFIN = 0.D0
cdr     PSI     : not there yet
      ENDIF

      IF (LADIN .AND. (INDPRO(6) /= 9)) ADIN = 0.D0

c  electric field
      IF (LEIN .AND. (INDPRO(7) /= 9)) THEN
        EXIN = 0.D0
        EYIN = 0.D0
        EZIN = 0.D0
        EFIN = 0.D0
        POT  = 0.D0
      ENDIF

      ALLOCATE (HELP(NRAD))
      ALLOCATE (HELP2(NRAD))
      HELP=0.
      HELP2=0.
C
C  SET EIRENE VACUUM BACKGROUND MODEL DATA. I.E. IF TEMPERATURES ARE
C  LESS THAN TVAC OR THE BACKGROUND DENSITY IS LESS THAN DVAC,
C  THEN THIS ZONE IS CONSIDERED TO BE AN "EIRENE VACUUM ZONE",
C  FOR A PARTICULAR BACKGROUND SPECIES:
C  PARTICLE MEAN FREE PATHS IN SUCH ZONES            ARE SET EQUAL TO 1.D10 (CM)
C  AND ALL REACTION RATES WRT: TO THIS BULK PARTICLE ARE SET EQUAL TO ZERO (1/S)
      TVAC=0.02_dp
      DVAC=1.E2_dp
      VVAC=0._dp
      BVAC=1._dp  ! dr: B field must not be "vacuum". check use of BVAC
      ZVAC=0._dp  ! nh
C
C
C  ELECTRON TEMPERATURE
      IND=INDPRO(1)
      SELECT CASE (IND)
      CASE (1)
        CALL EIRENE_PROFN (HELP,TE0,TE1,TE2,TE3,TE4,TE5,TVAC)
        TEIN(1:NR1ST)=HELP(1:NR1ST)
      CASE (2)
        CALL EIRENE_PROFE (HELP,TE0,TE1,TE2,TE4,TE5,TVAC)
        TEIN(1:NR1ST)=HELP(1:NR1ST)
      CASE (3)
        CALL EIRENE_PROFS (HELP,TE0,TE1,TE5,TVAC)
        TEIN(1:NR1ST)=HELP(1:NR1ST)
      CASE (4)
c  INDPRO=4: read tally from stream TEO
        JSTREAM=NINT(TE0)
        ITALI=1
        CALL EIRENE_READTL(TXTPLS(1,ITALI),TXTPSP(1,ITALI),
     .              TXTPUN(1,ITALI),
     .              HELP,NR1ST,NP2ND,NT3RD,NBMLT,NSBOX,
     .              3,JSTREAM)
        TEIN(1:NSBOX)=HELP(1:NSBOX)
      CASE (5)
c  INDPRO=5: tally from PROUSR, indx=0
        CALL EIRENE_PROUSR (HELP,0,TE0,TE1,TE2,TE3,TE4,TE5,TVAC,NSURF)
        TEIN(1:NSURF)=HELP(1:NSURF)
      CASE (6)
c  INDPRO=6: tally from PROFR, pointer TEINTF(1:NSURF,.)
        ALLOCATE(RDUMMY(1,1:NSURF))
        INI=0
        CALL EIRENE_PROFR (RDUMMY,INI,1,1,NSURF)
        TEIN(1:NSURF) = RDUMMY(1,1:NSURF)
        DEALLOCATE(RDUMMY)
      CASE (7)
c  INDPRO=7: tally from PROFR, pointer TEINTF(1:NSBOX=NSURF+NRADD,.)
        ALLOCATE(RDUMMY(1,1:NSBOX))
        INI=0
        CALL EIRENE_PROFR (RDUMMY,INI,1,1,NSBOX)
        TEIN(1:NSBOX) = RDUMMY(1,1:NSBOX)
        DEALLOCATE(RDUMMY)
      END SELECT

C  ION TEMPERATURE
      IND=INDPRO(2)
cdr first dimension of arrays: NDIM .ne. NPLSTI possible ?
      NDIM = SIZE(TIIN,DIM=1)
      IF (NDIM.LT.NPLSTI) GOTO 996

      DO 120 IPLSTI=1,NPLSTI
cdr one profile iplsti set at a time
        select case (IND)
        case (1)
          CALL EIRENE_PROFN (HELP,TI0(IPLSTI),TI1(IPLSTI),TI2(IPLSTI),
     .                            TI3(IPLSTI),TI4(IPLSTI),TI5(IPLSTI),
     .                            TVAC)
          TIIN(IPLSTI,1:NR1ST)=HELP(1:NR1ST)
        case (2)
          CALL EIRENE_PROFE (HELP,TI0(IPLSTI),TI1(IPLSTI),TI2(IPLSTI),
     .                            TI4(IPLSTI),TI5(IPLSTI),TVAC)
          TIIN(IPLSTI,1:NR1ST)=HELP(1:NR1ST)
        case (3)
          CALL EIRENE_PROFS (HELP,TI0(IPLSTI),TI1(IPLSTI),
     .                            TI5(IPLSTI),TVAC)
          TIIN(IPLSTI,1:NR1ST)=HELP(1:NR1ST)
        case (4)
c  INDPRO=4: read tally from stream TIO(IPLSTI)
          JSTREAM=NINT(TI0(IPLSTI))
          ITALI=2
          CALL EIRENE_READTL(TXTPLS(IPLSTI,ITALI),TXTPSP(IPLSTI,ITALI),
     .              TXTPUN(IPLSTI,ITALI),
     .              HELP,NR1ST,NP2ND,NT3RD,NBMLT,NSBOX,
     .              3,JSTREAM)
          TIIN(IPLSTI,1:NSBOX)=HELP(1:NSBOX)
        case (5)
c  INDPRO=5: tally from PROUSR, indx=1, but NPLSTI calls, one for each IPLSTI
          CALL EIRENE_PROUSR (HELP,1+0*NPLS,TI0(IPLSTI),TI1(IPLSTI),
     .                      TI2(IPLSTI),TI3(IPLSTI),TI4(IPLSTI),
     .                      TI5(IPLSTI),TVAC,NSURF)
          TIIN(IPLSTI,1:NSURF)=HELP(1:NSURF)

cdr distinct from indpro=1,...5: now one single call for all IPLS=1,NPLSTI
        case(6)
c  INDPRO=6: tally from PROFR, indx=1, all TIINTF pointer fields in one single call
          ALLOCATE(RDUMMY(NDIM,NSURF))
          INI=1
          CALL EIRENE_PROFR (RDUMMY,INI,NPLSTI,NDIM,NSURF)
          TIIN(1:NPLSTI,1:NSURF) = RDUMMY(1:NPLSTI,1:NSURF)
          DEALLOCATE(RDUMMY)
!pb all species fields have been filled in this call thus exit loop
          EXIT
        case (7)
c  INDPRO=7: tally from PROFR, indx=1, all TIINTF pointer fields in one single call
          ALLOCATE(RDUMMY(NDIM,NSBOX))
          INI=1
          CALL EIRENE_PROFR (RDUMMY,INI,NPLSTI,NDIM,NSBOX)
          TIIN(1:NPLSTI,1:NSBOX) = RDUMMY(1:NPLSTI,1:NSBOX)
          DEALLOCATE(RDUMMY)
!pb all species fields have been filled in this call thus exit loop
          EXIT
        end select
  120 CONTINUE

C  ION DENSITY
      IND=INDPRO(3)
cdr first dimension of arrays: NDIM .ne. NPLS possible ?
      NDIM = SIZE(DIIN,DIM=1)
      IF (NDIM.LT.NPLSI) GOTO 997

      DO 130 JPLS=1,NPLSI
        IPLS=JPLS
        IF (LEN_TRIM(CDENMODEL(IPLS)) > 0) CYCLE
        select case (IND)
cdr one profile ipls set at a time
        case (1)
          CALL EIRENE_PROFN (HELP,DI0(IPLS),DI1(IPLS),DI2(IPLS),
     .                       DI3(IPLS),DI4(IPLS),DI5(IPLS),DVAC)
          DIIN(IPLS,1:NR1ST)=HELP(1:NR1ST)
        case (2)
          CALL EIRENE_PROFE (HELP,DI0(IPLS),DI1(IPLS),DI2(IPLS),
     .                       DI4(IPLS),DI5(IPLS),DVAC)
          DIIN(IPLS,1:NR1ST)=HELP(1:NR1ST)
        case (3)
          CALL EIRENE_PROFS (HELP,DI0(IPLS),DI1(IPLS),DI5(IPLS),DVAC)
          DIIN(IPLS,1:NR1ST)=HELP(1:NR1ST)
        case (4)
c  INDPRO=4: read tally from stream DIO(IPLS)
          JSTREAM=NINT(DI0(IPLS))
          ITALI=4
          CALL EIRENE_READTL(TXTPLS(IPLS,ITALI),TXTPSP(IPLS,ITALI),
     .              TXTPUN(IPLS,ITALI),
     .              HELP,NR1ST,NP2ND,NT3RD,NBMLT,NSBOX,
     .              3,JSTREAM)
          DIIN(IPLS,1:NSBOX)=HELP(1:NSBOX)
        case (5)
c  INDPRO=5: tally from PROUSR, indx=1+1*NPLS, but NPLSI calls, one for each IPLS
          CALL EIRENE_PROUSR (HELP,1+1*NPLS,DI0(IPLS),DI1(IPLS),
     .                        DI2(IPLS),DI3(IPLS),DI4(IPLS),DI5(IPLS),
     .                        DVAC,NSURF)
          DIIN(IPLS,1:NSURF)=HELP(1:NSURF)

cdr distinct from indpro=1,...5: now one single call for all IPLS=1,NPLSI
        case (6)
c  INDPRO=6:
cdr first dimension of arrays: pointer DIINTF(1:NPLS,.), always NPLS
          ALLOCATE(RDUMMY(NPLS,NSURF))
          INI=1+NPLSTI
          CALL EIRENE_PROFR (RDUMMY,INI,NPLSI,NPLS,NSURF)
          DIIN(1:NPLSI,1:NSURF) = RDUMMY(1:NPLSI,1:NSURF)
          DEALLOCATE(RDUMMY)
!pb all species fields have been filled in this call thus exit loop
          EXIT
        case (7)
c  INDPRO=7:
cdr first dimension of arrays: pointer DIINTF(1:NPLS,.), always NPLS
          ALLOCATE(RDUMMY(NPLS,NSBOX))
          INI=1+NPLSTI
          CALL EIRENE_PROFR (RDUMMY,INI,NPLSI,NPLS,NSBOX)
          DIIN(1:NPLSI,1:NSBOX) = RDUMMY(1:NPLSI,1:NSBOX)
          DEALLOCATE(RDUMMY)
!pb all species fields have been filled in this call thus exit loop
          EXIT
        end select
  130 CONTINUE

C  DRIFT VELOCITY
      IND=INDPRO(4)
cdr first dimension of arrays: NDIM .ne. NPLSV possible ?
      NDIM = MIN(SIZE(VXIN,DIM=1),SIZE(VYIN,DIM=1),SIZE(VZIN,DIM=1))
      IF (NDIM.LT.NPLSV) GOTO 998

      DO 140 IPLSV=1,NPLSV
        select case (IND)
        case (1)
cdr one vector component profile (vx,vy,vz), and one value of iplsv set at a time
          CALL EIRENE_PROFN (HELP,VX0(IPLSV),VX1(IPLSV),VX2(IPLSV),
     .                   VX3(IPLSV),VX4(IPLSV),VX5(IPLSV),VVAC)
          VXIN(IPLSV,1:NR1ST)=HELP(1:NR1ST)
          CALL EIRENE_PROFN (HELP,VY0(IPLSV),VY1(IPLSV),VY2(IPLSV),
     .                   VY3(IPLSV),VY4(IPLSV),VY5(IPLSV),VVAC)
          VYIN(IPLSV,1:NR1ST)=HELP(1:NR1ST)
          CALL EIRENE_PROFN (HELP,VZ0(IPLSV),VZ1(IPLSV),VZ2(IPLSV),
     .                   VZ3(IPLSV),VZ4(IPLSV),VZ5(IPLSV),VVAC)
          VZIN(IPLSV,1:NR1ST)=HELP(1:NR1ST)
        case (2)
          CALL EIRENE_PROFE (HELP,VX0(IPLSV),VX1(IPLSV),VX2(IPLSV),
     .                   VX4(IPLSV),VX5(IPLSV),VVAC)
          VXIN(IPLSV,1:NR1ST)=HELP(1:NR1ST)
          CALL EIRENE_PROFE (HELP,VY0(IPLSV),VY1(IPLSV),VY2(IPLSV),
     .                   VY4(IPLSV),VY5(IPLSV),VVAC)
          VYIN(IPLSV,1:NR1ST)=HELP(1:NR1ST)
          CALL EIRENE_PROFE (HELP,VZ0(IPLSV),VZ1(IPLSV),VZ2(IPLSV),
     .                   VZ4(IPLSV),VZ5(IPLSV),VVAC)
          VZIN(IPLSV,1:NR1ST)=HELP(1:NR1ST)
        case (3)
          CALL EIRENE_PROFS (HELP,VX0(IPLSV),VX1(IPLSV),VX5(IPLSV),VVAC)
          VXIN(IPLSV,1:NR1ST)=HELP(1:NR1ST)
          CALL EIRENE_PROFS (HELP,VY0(IPLSV),VY1(IPLSV),VY5(IPLSV),VVAC)
          VYIN(IPLSV,1:NR1ST)=HELP(1:NR1ST)
          CALL EIRENE_PROFS (HELP,VZ0(IPLSV),VZ1(IPLSV),VZ5(IPLSV),VVAC)
          VZIN(IPLSV,1:NR1ST)=HELP(1:NR1ST)
        case (4)
C  INDPRO=4: read tallies from streams VXO(IPLSV), VY0(IPLSV),VZ0(IPLSV)
c            NOT READY FOR FLOW FIELDS
        case (5)
c  INDPRO=5: tally from PROUSR,
c            VX: indx=1+2*NPLS, but NPLSV calls, one for each IPLSV
c            VY: indx=1+3*NPLS, but NPLSV calls, one for each IPLSV
c            VZ: indx=1+4*NPLS, but NPLSV calls, one for each IPLSV
          CALL EIRENE_PROUSR (HELP,1+2*NPLS,VX0(IPLSV),VX1(IPLSV),
     .                      VX2(IPLSV),VX3(IPLSV),
     .                      VX4(IPLSV),VX5(IPLSV),VVAC,NSURF)
          VXIN(IPLSV,1:NSURF)=HELP(1:NSURF)
          CALL EIRENE_PROUSR (HELP,1+3*NPLS,VY0(IPLSV),VY1(IPLSV),
     .                      VY2(IPLSV),VY3(IPLSV),
     .                      VY4(IPLSV),VY5(IPLSV),VVAC,NSURF)
          VYIN(IPLSV,1:NSURF)=HELP(1:NSURF)
          CALL EIRENE_PROUSR (HELP,1+4*NPLS,VZ0(IPLSV),VZ1(IPLSV),
     .                      VZ2(IPLSV),VZ3(IPLSV),
     .                      VZ4(IPLSV),VZ5(IPLSV),VVAC,NSURF)
          VZIN(IPLSV,1:NSURF)=HELP(1:NSURF)

cdr distinct from indpro=1,...5: now one single call for all IPLS=1,NPLSV
        case (6)
c  read tally from external data structure, all V.IN fields in one single call
cdr first dimension of arrays:  always NPLSV
          ALLOCATE(RDUMMY(NDIM,NSURF))
          INI=1+NPLS+NPLSTI
          CALL EIRENE_PROFR (RDUMMY,INI,NPLSV,NDIM,NSURF)
          VXIN(1:NPLSV,1:NSURF) = RDUMMY(1:NPLSV,1:NSURF)
          INI=1+NPLS+NPLSTI+1*NPLSV
          CALL EIRENE_PROFR (RDUMMY,INI,NPLSV,NDIM,NSURF)
          VYIN(1:NPLSV,1:NSURF) = RDUMMY(1:NPLSV,1:NSURF)
          INI=1+NPLS+NPLSTI+2*NPLSV
          CALL EIRENE_PROFR (RDUMMY,INI,NPLSV,NDIM,NSURF)
          VZIN(1:NPLSV,1:NSURF) = RDUMMY(1:NPLSV,1:NSURF)
          DEALLOCATE(RDUMMY)
!pb all species fields have been filled in this call thus exit loop
          EXIT
        case (7)
cdr all nplsv vector component profiles set in a single call
c  read tally from external data structure, all V.IN fields in one single call
cdr first dimension of arrays:  always NPLSV
          ALLOCATE(RDUMMY(NDIM,NSBOX))
          INI=1+NPLS+NPLSTI
          CALL EIRENE_PROFR (RDUMMY,INI,NPLSV,NDIM,NSBOX)
          VXIN(1:NPLSV,1:NSBOX) = RDUMMY(1:NPLSV,1:NSBOX)
          INI=1+NPLS+NPLSTI+1*NPLSV
          CALL EIRENE_PROFR (RDUMMY,INI,NPLSV,NDIM,NSBOX)
          VYIN(1:NPLSV,1:NSBOX) = RDUMMY(1:NPLSV,1:NSBOX)
          INI=1+NPLS+NPLSTI+2*NPLSV
          CALL EIRENE_PROFR (RDUMMY,INI,NPLSV,NDIM,NSBOX)
          VZIN(1:NPLSV,1:NSBOX) = RDUMMY(1:NPLSV,1:NSBOX)
          DEALLOCATE(RDUMMY)
!pb all species fields have been filled in this call thus exit loop
          EXIT
        end select
  140 CONTINUE

C  SCALE FROM MACH NUMBER PROFILE TO CM/SEC PROFILE?
C  USE ISOTHERMAL ACOUSTIC SPEED OF ION IPLS.
      IF (NLMACH .AND. (IND <= 5)) THEN
        DO 1141 JPLS=1,NPLSI
          IPLSTI=MPLSTI(JPLS)
          IPLSV=MPLSV(JPLS)
          DO 1142 ICELL=1,NSURF
CDR FACT is the isothermal ion acoustic speed, [cm/s], for species IPLS=JPLS
            FACT=CVEL2A*SQRT((TIIN(IPLSTI,ICELL)+
     .                        TEIN(ICELL))/RMASSP(JPLS))
            VXIN(IPLSV,ICELL)=VXIN(IPLSV,ICELL)*FACT
            VYIN(IPLSV,ICELL)=VYIN(IPLSV,ICELL)*FACT
            VZIN(IPLSV,ICELL)=VZIN(IPLSV,ICELL)*FACT
 1142     CONTINUE
 1141   CONTINUE
      ENDIF
C
C
C  MAGNETIC FIELD UNIT VECTOR
C
      IF (.NOT.LBIN) GOTO 154

C  FOR IND=4,5,6,7 OR 9: ALSO THE ABSOLUTE B FIELD STRENGTH BF CAN BE SET
      IND=INDPRO(5)
C  DEFAULT: 1 TESLA B FIELD IN Z-DIRECTION, i.e., PITCH=0
      IF (IND /= 9) THEN
        BXIN=0.
        BYIN=0.
        BZIN=1.
        BFIN=1.
      END IF

      select case (ind)
C  HELP IS FIELD LINE PITCH ANGLE: B_POL/B_TOT
      case (1)
C  INDPRO(5)=1:
        CALL EIRENE_PROFN (HELP,B0,B1,B2,B3,B4,B5,BVAC)
      case (2)
C  INDPRO(5)=2:
        CALL EIRENE_PROFE (HELP,B0,B1,B2,B4,B5,BVAC)
      case (3)
C  INDPRO(5)=3:
        CALL EIRENE_PROFS (HELP,B0,B1,B5,BVAC)
        CALL EIRENE_PROFS (HELP2,B2,B3,B5,BVAC) ! new (2008)
                        ! set constant B profile, ONLY INDPRO(5)=3
      case (4)
C  INDPRO(5)=4: read tally from stream B0:  NOT IN USE
      case (5)
c  INDPRO(5)=5: call prousr
        CALL EIRENE_PROUSR (BXIN,1+1*NPLS+NPLSTI+3*NPLSV,
     .                      B0,B1,B2,B3,B4,B5,0._DP,NSURF)
        CALL EIRENE_PROUSR (BYIN,2+1*NPLS+NPLSTI+3*NPLSV,
     .                      B0,B1,B2,B3,B4,B5,0._DP,NSURF)
        CALL EIRENE_PROUSR (BZIN,3+1*NPLS+NPLSTI+3*NPLSV,
     .                      B0,B1,B2,B3,B4,B5,1._DP,NSURF)
        CALL EIRENE_PROUSR (BFIN,4+1*NPLS+NPLSTI+3*NPLSV,
     .                      B0,B1,B2,B3,B4,B5,1._DP,NSURF)
      case (6)
c  INDPRO(5) =6: call profr (information comes from interfacing code)
c                default (vacuum) parameters in additional cells
        ALLOCATE(RDUMMY(1,1:NSURF))
        INI=1+NPLS+NPLSTI+3*NPLSV
        CALL EIRENE_PROFR (RDUMMY,INI,1,1,NSURF)
        BXIN(1:NSURF) = RDUMMY(1,1:NSURF)
        INI=2+NPLS+NPLSTI+3*NPLSV
        CALL EIRENE_PROFR (RDUMMY,INI,1,1,NSURF)
        BYIN(1:NSURF) = RDUMMY(1,1:NSURF)
        INI=3+NPLS+NPLSTI+3*NPLSV
        CALL EIRENE_PROFR (RDUMMY,INI,1,1,NSURF)
        BZIN(1:NSURF) = RDUMMY(1,1:NSURF)
        INI=4+NPLS+NPLSTI+3*NPLSV
        CALL EIRENE_PROFR (RDUMMY,INI,1,1,NSURF)
        BFIN(1:NSURF) = RDUMMY(1,1:NSURF)
        DEALLOCATE(RDUMMY)
      case (7)
c  INDPRO(5) =7: call profr (information comes from interfacing code)
c                include also additional cells
        ALLOCATE(RDUMMY(1,1:NSBOX))
        INI=1+NPLS+NPLSTI+3*NPLSV
        CALL EIRENE_PROFR (RDUMMY,INI,1,1,NSBOX)
        BXIN(1:NSBOX) = RDUMMY(1,1:NSBOX)
        INI=2+NPLS+NPLSTI+3*NPLSV
        CALL EIRENE_PROFR (RDUMMY,INI,1,1,NSBOX)
        BYIN(1:NSBOX) = RDUMMY(1,1:NSBOX)
        INI=3+NPLS+NPLSTI+3*NPLSV
        CALL EIRENE_PROFR (RDUMMY,INI,1,1,NSBOX)
        BZIN(1:NSBOX) = RDUMMY(1,1:NSBOX)
        INI=4+NPLS+NPLSTI+3*NPLSV
        CALL EIRENE_PROFR (RDUMMY,INI,1,1,NSBOX)
        BFIN(1:NSBOX) = RDUMMY(1,1:NSBOX)
        DEALLOCATE(RDUMMY)
      end select

C  CONVERT PITCH ANGLE INTO B FIELD UNIT VECTOR
        IF (IND <= 3) then
C  AT THIS POINT: INDPRO= 1,2, OR =3.
C                 HELP2 IS KNOWN ONLY IN CASE INDPRO=3
        IF (LEVGEO.EQ.1) THEN
          DO 1401 J=1,NSURF
            CALL EIRENE_NCELLN(J,IR,IP,IT,IA,IB,
     .                  NR1ST,NP2ND,NT3RD,NBMLT,NLRAD,NLPOL,NLTOR)
            IF (IR.GE.NR1ST) GOTO 1401
            IF ((NP2ND.GT.1).AND.(IP.GE.NP2ND)) GOTO 1401
C
            IF (.NOT.NLPITCH) THEN ! OLD DEFAULT:
                                   ! B FIELD IS parallel TO Y,Z
              BXIN(J)=0.0
              BYIN(J)=HELP(IR)
            ELSEIF (NLPITCH) THEN  ! NEW OPTION :
                                   ! B FIELD IS parallel TO X,Z
              BXIN(J)=HELP(IR)
              BYIN(J)=0.0
            ENDIF
C
            BZIN(J)=SQRT(1.-HELP(IR)*HELP(IR))
C
            IF (IND.EQ.3) THEN
              BFIN(J)=HELP2(IR)
            ELSE
              BFIN(J)=1.
            ENDIF
 1401     CONTINUE
        ELSEIF (LEVGEO.EQ.2.AND.NLPOL) THEN
          DO 1402 J=1,NSURF
            CALL EIRENE_NCELLN(J,IR,IP,IT,IA,IB,
     .                  NR1ST,NP2ND,NT3RD,NBMLT,NLRAD,NLPOL,NLTOR)
            IF (IR.GE.NR1ST) GOTO 1402
            IF ((NP2ND.GT.1).AND.(IP.GE.NP2ND)) GOTO 1402
            EP=0.5*(EP1(IR)+EP1(IR+1))
            EL=0.5*(ELL(IR)+ELL(IR+1))
            JJ=IR+(IP-1)*NR1ST
            PUY= XCOM(JJ)-EP
            PUX=-YCOM(JJ)/EL/EL
            PN=SQRT(PUX*PUX+PUY*PUY+EPS60)
            BXIN(J)=HELP(IR)*PUX/PN
            BYIN(J)=HELP(IR)*PUY/PN
            BZIN(J)=SQRT(1.-HELP(IR)*HELP(IR))
            IF (IND.EQ.3) THEN
              BFIN(J)=HELP2(IR)
            ELSE
              BFIN(J)=1.
            ENDIF
 1402     CONTINUE
        ELSEIF (LEVGEO.EQ.3.AND.NLPOL) THEN
          DO 1403 J=1,NSURF
            IF (NSTGRD(J) /= 0) CYCLE
            CALL EIRENE_NCELLN(J,IR,IP,IT,IA,IB,
     .                  NR1ST,NP2ND,NT3RD,NBMLT,NLRAD,NLPOL,NLTOR)
            IF (IR.GE.NR1ST) GOTO 1403
            IF ((NP2ND.GT.1).AND.(IP.GE.NP2ND)) GOTO 1403
            PUX=VPLX(IR,IP)+VPLX(IR+1,IP)
            PUY=VPLY(IR,IP)+VPLY(IR+1,IP)
            PN=SQRT(PUX*PUX+PUY*PUY+EPS60)
            BXIN(J)=HELP(IR)*PUX/PN
            BYIN(J)=HELP(IR)*PUY/PN
            BZIN(J)=SQRT(1.-HELP(IR)*HELP(IR))
            IF (IND.EQ.3) THEN
              BFIN(J)=HELP2(IR)
            ELSE
              BFIN(J)=1.
            ENDIF
 1403     CONTINUE
        ELSE
          CALL EIRENE_LEER(1)
          WRITE (iunout,*)
     .      'NO MAGNETIC PITCH PROFILE COULD BE DEFINED FOR THIS CASE'
          WRITE (iunout,*)
     .      'DEFAULT MAGNETIC FIELD (IN Z-DIRECTION) IS USED'
          CALL EIRENE_LEER(1)
        ENDIF
        END IF
C
C  CHECK FOR ZERO MAGNETIC FIELD IN ANY CELL (INCL. ADD. CELL REGION)
      DO 153 JJ=1,NSBOX
        IF (BXIN(JJ)**2+BYIN(JJ)**2+BZIN(JJ)**2.LE.EPS30) THEN
          WRITE (iunout,*)
     .       'ZERO B FIELD UNIT VECTOR IN STANDARD CELL JJ= ',JJ
          CALL EIRENE_EXIT_OWN(1)
        ENDIF
        B=SQRT(BXIN(JJ)**2+BYIN(JJ)**2+BZIN(JJ)**2)
        IF (ABS(B-1.D0).GT.EPS12) THEN
          WRITE (iunout,*)
     .       'B FIELD UNIT VECTOR IN STANDARD CELL JJ= ',JJ,B
          CALL EIRENE_EXIT_OWN(1)
        ENDIF
        IF (ABS(BFIN(JJ)).LT.EPS12) THEN
          WRITE (iunout,*) 'MAGNETIC FIELD STRENGTH = ZERO, JJ= ',JJ
          CALL EIRENE_EXIT_OWN(1)
        ENDIF
  153 CONTINUE

  154 CONTINUE  !  B FIELD SPECIFIED AT ALL ??
C
C  ADDITIONAL INPUT TALLIES

      IF (LADIN) THEN
      IND=INDPRO(6)
      NDIM=SIZE(ADIN,DIM=1)
      IF (NDIM.LT.NAINI) GOTO 999

      DO 160 K=1,NAINI
        select case (IND)
        case (1:4)
C  DEFAULT: ADIN == 0.0, only options ind=5,6,7 are available
c          (transfer from problem-specific codes or external data structures)
          DO 1151 J=1,NR1ST
            ADIN(K,J)=0.
 1151     CONTINUE
        case (5)
          CALL EIRENE_PROUSR (HELP,6+1*NPLS+NPLSTI+3*NPLSV,
     .                        BD,BD,BD,BD,BD,BD,0._DP,NSURF)
          ADIN(K,1:NSURF)=HELP(1:NSURF)

cdr distinct from indpro=1,...5: now one single call for all K=1,NAINI
        case (6)
          ALLOCATE(RDUMMY(NDIM,NSURF))
          CALL EIRENE_PROFR (RDUMMY,6+1*NPLS+NPLSTI+3*NPLSV,
     .                       NAINI,NDIM,NSURF)
          ADIN(1:NAINI,1:NSURF) = RDUMMY(1:NAINI,1:NSURF)
          DEALLOCATE(RDUMMY)
!pb all species fields have been filled in this call thus exit loop
          EXIT
        case (7)
          ALLOCATE(RDUMMY(NDIM,NSBOX))
          CALL EIRENE_PROFR (RDUMMY,6+1*NPLS+NPLSTI+3*NPLSV,
     .                       NAINI,NDIM,NSBOX)
          ADIN(1:NAINI,1:NSBOX) = RDUMMY(1:NAINI,1:NSBOX)
          DEALLOCATE(RDUMMY)
!pb all species fields have been filled in this call thus exit loop
          EXIT
        end select
  160 CONTINUE
      END IF
C
C  ELECTRIC FIELD
      IF (LEIN) THEN
      IND=INDPRO(7)
C  DEFAULT: E==0.0 (no electric field), only options ind=5,6,7 overrule this
c          (transfer from problem-specific codes or external data structures)
      select case (IND)
      case (5)
        CALL EIRENE_PROUSR (EXIN, 7+1*NPLS+NPLSTI+3*NPLSV,
     .                      EF0,EF1,EF2,EF3,EF4,EF5,0._DP,NSURF)
        CALL EIRENE_PROUSR (EYIN, 8+1*NPLS+NPLSTI+3*NPLSV,
     .                      EF0,EF1,EF2,EF3,EF4,EF5,0._DP,NSURF)
        CALL EIRENE_PROUSR (EZIN, 9+1*NPLS+NPLSTI+3*NPLSV,
     .                      EF0,EF1,EF2,EF3,EF4,EF5,0._DP,NSURF)
        CALL EIRENE_PROUSR (EFIN,10+1*NPLS+NPLSTI+3*NPLSV,
     .                      EF0,EF1,EF2,EF3,EF4,EF5,0._DP,NSURF)
      case (6)
        ALLOCATE(RDUMMY(1,1:NSURF))
        INI= 7+NPLS+NPLSTI+3*NPLSV
        CALL EIRENE_PROFR (RDUMMY,INI,1,1,NSURF)
        EXIN(1:NSURF) = RDUMMY(1,1:NSURF)
        INI= 8+NPLS+NPLSTI+3*NPLSV
        CALL EIRENE_PROFR (RDUMMY,INI,1,1,NSURF)
        EYIN(1:NSURF) = RDUMMY(1,1:NSURF)
        INI= 9+NPLS+NPLSTI+3*NPLSV
        CALL EIRENE_PROFR (RDUMMY,INI,1,1,NSURF)
        EZIN(1:NSURF) = RDUMMY(1,1:NSURF)
        INI= 10+NPLS+NPLSTI+3*NPLSV
        CALL EIRENE_PROFR (RDUMMY,INI,1,1,NSURF)
        EFIN(1:NSURF) = RDUMMY(1,1:NSURF)
        DEALLOCATE(RDUMMY)
      case (7)
        ALLOCATE(RDUMMY(1,1:NSBOX))
        INI= 7+NPLS+NPLSTI+3*NPLSV
        CALL EIRENE_PROFR (RDUMMY,INI,1,1,NSBOX)
        EXIN(1:NSBOX) = RDUMMY(1,1:NSBOX)
        INI= 8+NPLS+NPLSTI+3*NPLSV
        CALL EIRENE_PROFR (RDUMMY,INI,1,1,NSBOX)
        EYIN(1:NSBOX) = RDUMMY(1,1:NSBOX)
        INI= 9+NPLS+NPLSTI+3*NPLSV
        CALL EIRENE_PROFR (RDUMMY,INI,1,1,NSBOX)
        EZIN(1:NSBOX) = RDUMMY(1,1:NSBOX)
        INI= 10+NPLS+NPLSTI+3*NPLSV
        CALL EIRENE_PROFR (RDUMMY,INI,1,1,NSBOX)
        EFIN(1:NSBOX) = RDUMMY(1,1:NSBOX)
        DEALLOCATE(RDUMMY)
      end select
      END IF

cnh 28.10.2019
C
C     ION CHARGE
      IND=INDPRO(11)
cdr first dimension of arrays: NDIM .ne. NPLSI possible ?
      NDIM = SIZE(ZIIN,DIM=1)
      IF (NDIM.LT.NPLSI) GOTO 995

      DO JPLS=1,NPLSI
        IPLS=JPLS
        SELECT CASE (IND)
!pb default if no input was given
        CASE(0)
          ZIIN(IPLS,:) = DBLE(NCHRGP(IPLS))
        CASE(1)
          CALL EIRENE_PROFN (HELP,ZI0(IPLS),ZI1(IPLS),ZI2(IPLS),
     .                       ZI3(IPLS),ZI4(IPLS),ZI5(IPLS),ZVAC)
          ZIIN(IPLS,1:NR1ST)=HELP(1:NR1ST)
        CASE(2)
          CALL EIRENE_PROFE (HELP,ZI0(IPLS),ZI1(IPLS),ZI2(IPLS),
     .                       ZI4(IPLS),ZI5(IPLS),ZVAC)
          ZIIN(IPLS,1:NR1ST)=HELP(1:NR1ST)
        CASE(3)
          CALL EIRENE_PROFS (HELP,ZI0(IPLS),ZI1(IPLS),ZI5(IPLS),ZVAC)
          ZIIN(IPLS,1:NR1ST)=HELP(1:NR1ST)
        CASE(4)
c     INDPRO=4: read from stream ZIO(IPLS)
          write(*,*) 'EIRENE: ZIIN, indpro(11)=4 not in use'
          CALL EIRENE_EXIT_OWN(1)
          JSTREAM=NINT(ZI0(IPLS))
          ITALI=26
          CALL EIRENE_READTL(TXTPLS(IPLS,ITALI),TXTPSP(IPLS,ITALI),
     .                       TXTPUN(IPLS,ITALI),
     .                       HELP,NR1ST,NP2ND,NT3RD,NBMLT,NSBOX,
     .                       3,JSTREAM)
          ZIIN(IPLS,1:NSBOX)=HELP(1:NSBOX)

        CASE(5)
c  INDPRO=5: tally from PROUSR, indx=12+1*NPLS+NPLSTI+3*NPLSV, but NPLSI calls, one for each IPLS
          CALL EIRENE_PROUSR (HELP,12+1*NPLS+NPLSTI+3*NPLSV,ZI0(IPLS),
     .                        ZI1(IPLS),ZI2(IPLS),
     .                        ZI3(IPLS),ZI4(IPLS),ZI5(IPLS),ZVAC,NSURF)
          ZIIN(IPLS,1:NSURF)=HELP(1:NSURF)
cdr distinct from indpro=1,...5: now one single call for all IPLS=1,NPLSI
        CASE(6)
c  INDPRO=6:
cdr first dimension of arrays: always NPLS
          write(*,*)
     .     'EIRENE: ZIIN, indpro(11)=6 not in use, assigning defaults'
          ZIIN(IPLS,1:NSURF)=DBLE(NCHRGP(IPLS))
c          ALLOCATE(RDUMMY(NPLS,NSURF))
c          CALL EIRENE_PROFR (RDUMMY,12+1*NPLS+NPLSTI+3*NPLSV,
c     .                       NPLSI,NPLS,NSURF)
c          ZIIN(1:NPLSI,1:NSURF) = RDUMMY(1:NPLSI,1:NSURF)
c          DEALLOCATE(RDUMMY)
!pb all species fields have been filled in this call thus exit loop
c          EXIT
        CASE(7)
          write(*,*)
     .     'EIRENE: ZIIN, indpro(11)=7 not in use, assigning defaults'
          ZIIN(IPLS,1:NSBOX)=DBLE(NCHRGP(IPLS))
c          CALL EIRENE_EXIT_OWN(1)
c          ALLOCATE(RDUMMY(NPLS,NSBOX))
c          CALL EIRENE_PROFR (RDUMMY,12+1*NPLS+NPLSTI+3*NPLSV,
c     .                       NPLSI,NPLS,NSBOX)
c          ZIIN(1:NPLSI,1:NSBOX) = RDUMMY(1:NPLSI,1:NSBOX)
c          DEALLOCATE(RDUMMY)
!pb all species fields have been filled in this call thus exit loop
c          EXIT
        END SELECT
      ENDDO

C
CDR
C   SET VACUUM DATA IN ADDITIONAL REGIONS OUTSIDE THE
C   THE STANDARD MESH.
C   EXCLUDE: INDPRO=4: ADDITIONAL CELL REGION FROM FILE JSTREAM
C   EXCLUDE: INDPRO=7: ADDITIONAL CELL REGION DATA FROM EXTERNAL CODE (PROFR)
C   EXCLUDE: INDPRO=8: ??
C   EXCLUDE: INDPRO=9: TRANSFER FROM PLASMA_BCKGRND, EXTERNAL CODE

cdr tbd: indpro=4: are data set on 1:nsurf, or on 1:nsbox=nsurf+nradd ?
C
      IF (INDPRO(1).LE.6 .OR. INDPRO(1).EQ.9) THEN
        DO J=NSURF+1,NSURF+NRADD
          TEIN(J)=TVAC
        ENDDO
      ENDIF
      IF (INDPRO(2).LE.6 .OR. INDPRO(2).EQ.9) THEN
        DO J=NSURF+1,NSURF+NRADD
          DO 17 JPLS=1,NPLSI
            IPLSTI=MPLSTI(JPLS)
            TIIN(IPLSTI,J)=TVAC
   17     CONTINUE
        ENDDO
      ENDIF
      IF (INDPRO(3).LE.6 .OR. INDPRO(3).EQ.9) THEN
        DO J=NSURF+1,NSURF+NRADD
          DO 18 JPLS=1,NPLSI
            DIIN(JPLS,J)=DVAC
   18     CONTINUE
        ENDDO
      ENDIF
      IF (LVIN) THEN
        IF (INDPRO(4).LE.6 .OR. INDPRO(4).EQ.9) THEN
          DO J=NSURF+1,NSURF+NRADD
            DO 19 JPLS=1,NPLSI
              IPLSV=MPLSV(JPLS)
              VXIN(IPLSV,J)=VVAC
              VYIN(IPLSV,J)=VVAC
              VZIN(IPLSV,J)=VVAC
   19       CONTINUE
          ENDDO
        ENDIF
      ENDIF
      IF (LBIN) THEN
        IF (INDPRO(5).LE.6 .OR. INDPRO(5).EQ.9) THEN
          DO J=NSURF+1,NSURF+NRADD
            BXIN(J)=0.
            BYIN(J)=0.
            BZIN(J)=1.
            BFIN(J)=1.
          ENDDO
        ENDIF
      ENDIF
      IF (LADIN .AND. (INDPRO(6).LE.6 .OR. INDPRO(6).EQ.9)) THEN
        DO J=NSURF+1,NSURF+NRADD
          DO 20 IAIN=1,NAINI
            ADIN(IAIN,J)=0.
   20     CONTINUE
        ENDDO
      ENDIF
      IF (LEIN) THEN
        IF (INDPRO(7) == 5 .OR. INDPRO(5).EQ.6
     .                     .OR. INDPRO(5).EQ.9) THEN
          DO J=NSURF+1,NSURF+NRADD
            EXIN(J)=0.
            EYIN(J)=0.
            EZIN(J)=0.
            EFIN(J)=1.
          ENDDO
        ENDIF
      ENDIF
      IF (LZIIN) THEN
        IF (INDPRO(11).LE.6 .OR. INDPRO(11).EQ.9) THEN
          DO J=NSURF+1,NSURF+NRADD
            DO JPLS=1,NPLSI
              ZIIN(JPLS,J)=ZVAC
            ENDDO
          ENDDO
        ENDIF
      ENDIF

      DEALLOCATE(HELP)
      DEALLOCATE(HELP2)
C
      RETURN

  995 CONTINUE
      WRITE (iunout,*) 'ERROR IN PLASMA: 1ST DIMENSION OF ZIIN TALLY'
      WRITE (iunout,*) 'NDIM,NPLSI ',NDIM,NPLSI
      CALL EIRENE_EXIT_OWN(1)
  996 CONTINUE
      WRITE (iunout,*) 'ERROR IN PLASMA: 1ST DIMENSION OF TIIN TALLY'
      WRITE (iunout,*) 'NDIM,NPLSTI ',NDIM,NPLSTI
      CALL EIRENE_EXIT_OWN(1)
  997 CONTINUE
      WRITE (iunout,*) 'ERROR IN PLASMA: 1ST DIMENSION OF DIIN TALLY'
      WRITE (iunout,*) 'NDIM,NPLSI ',NDIM,NPLSI
      CALL EIRENE_EXIT_OWN(1)
  998 CONTINUE
      WRITE (iunout,*) 'ERROR IN PLASMA: 1ST DIMENSION OF V..IN TALLIES'
      WRITE (iunout,*) 'NDIM,NPLSV ',NDIM,NPLSV
      CALL EIRENE_EXIT_OWN(1)
  999 CONTINUE
      WRITE (iunout,*) 'ERROR IN PLASMA: 1ST DIMENSION OF ADIN TALLY'
      WRITE (iunout,*) 'NDIM,NAINI ',NDIM,NAINI
      CALL EIRENE_EXIT_OWN(1)
      END SUBROUTINE EIRENE_PLASMA
