C
C   *****************************
C   *  NON-ANALOG METHODS, A.I. *
C   *****************************
C
C      SUBROUTINE NANALG
C
      SUBROUTINE EIRENE_NANALG
C
C   SET UP SPLITTING SURFACES
C
      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD
      USE EIRMOD_CADGEO
      USE EIRMOD_CLOGAU
      USE EIRMOD_CGRID
      USE EIRMOD_CTRCEI
      USE EIRMOD_COMPRT
      USE EIRMOD_COMSPL

      IMPLICIT NONE

      REAL(DP) :: RSPLIT(N1ST)
      REAL(DP) :: XMAXR1, ZR1, ZR2
      INTEGER :: IR, IP, IT, IRT, IRP, IA, IRA, IRD, J, MMXRAD, MAXR1,
     .           JR, JS, IADD, NA, NE, NANZ
      EXTERNAL :: EIRENE_LEER, EIRENE_MASAL1

C---------------------------------------------------------------------
      NODES=0
      RSPLIT=0.D0
      NLSPLT(1:N1ST+N2ND+N3RD+NLIM)=.FALSE.
C
C
C  SET RADIAL SPLITTING SURFACES
      IF(NR1ST.LE.2) GOTO 200
C
C  DEFAULT MODEL: 101--119
C
C  HARD-WIRED OPTIONS FOR RADIAL SPLITTING SURFACES
C  USES: MAXRAD, SPLPAR, AND RHOSRF-GRID
C  SETS: RSPLIT(ISURF) : SPLITTING SURFACE RADIA
C  FINDS: JS: RADIAL SURFACE NUMBER TO BE USED AS SPLITTING SURFACE
C
      IF (LEVGEO.LE.3.AND.MAXRAD.LT.0) THEN
        MMXRAD=ABS(MAXRAD)
        MAXR1=MMXRAD+1
        XMAXR1=MMXRAD+1
        DO 101 J=2,MAXR1
          RSPLIT(J-1)=RHOSRF(1)+(J-1)/XMAXR1*(RHOSRF(NR1ST)-RHOSRF(1))
  101   CONTINUE
C
C
C
        DO 110 JS=2,MIN(NR1ST,N1ST+N2ND+N3RD+NLIM)
          ZR1=RHOSRF(JS-1)
          ZR2=RHOSRF(JS)
          DO 104 JR=1,MMXRAD
            IF(RSPLIT(JR).GE.ZR2.OR.RSPLIT(JR).LT.ZR1) GOTO 104
C  RADIAL SURFACE JS SHOULD BE USED AS SPLITTING SURFACE
            RNUMB(JS)=SPLPAR
            NLSPLT(JS)=.TRUE.
  104     CONTINUE
  110   CONTINUE
        GOTO 200
      ENDIF
C
C  NON-DEFAULT MODEL; EXPLICITLY SELECTED RADIAL SURFACES: 121--199
C
      IADD=0
      DO 121 IRD=1,MAXRAD
        DO IR=1,MIN(NR1ST,N1ST+N2ND+N3RD+NLIM)
          IF (IR.EQ.NSSPL(IRD)) THEN
            RNUMB(IR)=PRMSPL(IRD)
            NLSPLT(IR)=.TRUE.
          ENDIF
        ENDDO
  121 CONTINUE
C
  200 CONTINUE
C
C  SET POLOIDAL SPLITTING SURFACES
      IF(NP2ND.LE.2) GOTO 300
C
C  NON-DEFAULT MODEL; EXPLICITLY SELECTED POLOIDAL SURFACES: 221--299
C
      IADD=N1ST
      DO 221 IRP=1,MAXPOL
        DO IP=1,NP2ND
          IF (IP.EQ.NSSPL(IADD+IRP)) THEN
            RNUMB(IADD+IP)=PRMSPL(IADD+IRP)
            NLSPLT(IADD+IP)=.TRUE.
          ENDIF
        ENDDO
  221 CONTINUE
C
  300 CONTINUE
C
C  SET TOROIDAL SPLITTING SURFACES
      IF(NT3RD.LE.2) GOTO 400
C
C  NON-DEFAULT MODEL; EXPLICITLY SELECTED TOROIDAL SURFACES: 321--399
C
      IADD=N1ST+N2ND
      DO 321 IRT=1,MAXTOR
        DO IT=1,NT3RD
          IF (IT.EQ.NSSPL(IADD+IRT)) THEN
            RNUMB(IADD+IT)=PRMSPL(IADD+IRT)
            NLSPLT(IADD+IT)=.TRUE.
          ENDIF
        ENDDO
  321 CONTINUE
C
  400 CONTINUE
C  SET ADDITIONAL SPLITTING SURFACES
      IF(NLIMI.LE.0) GOTO 500
C
C  NON-DEFAULT MODEL: 421--499
C
      DO 421 IRA=1,MAXADD
        DO IA=1,NLIMI
          IF (IA.EQ.NSSPL(N1ST+N2ND+N3RD+IRA)) THEN
            RNUMB(N1ST+N2ND+N3RD+IA)=PRMSPL(N1ST+N2ND+N3RD+IRA)
            NLSPLT(N1ST+N2ND+N3RD+IA)=.TRUE.
          ENDIF
        ENDDO
  421 CONTINUE
C
  500 IF (.NOT.TRCNAL) RETURN
      WRITE (iunout,*)
     .  'SPLITTING SURFACES, BELONGING TO THE STANDARD  MESH '
      CALL EIRENE_LEER(1)
      WRITE (iunout,*) 'NLSPLT(ISURF)=TRUE INDICATES THAT THE'
      WRITE (iunout,*) 'SURFACE WITH NUMBER ISURF IS SPLITTING'

      CALL EIRENE_LEER(1)
      IF (NR1ST.GT.1) THEN
        WRITE (iunout,*) 'RADIAL SURFACES: '
        NA = 1
        NANZ = MIN(NR1ST,N1ST+N2ND+N3RD+NLIM)
        NE = NANZ
        CALL EIRENE_MASAL1 ('NLSPLT',NLSPLT(NA:NE),NANZ)
        CALL EIRENE_LEER(1)
      ENDIF
      IF (NP2ND.GT.1) THEN
        WRITE (iunout,*) 'POLOIDAL SURFACES: '
        NA = N1ST + 1
        NANZ = NP2ND
        NE = N1ST + NANZ
        CALL EIRENE_MASAL1 ('NLSPLT',NLSPLT(NA:NE),NANZ)
        CALL EIRENE_LEER(1)
      ENDIF
      IF (NT3RD.GT.1) THEN
        WRITE (iunout,*) 'TOROIDAL SURFACES: '
        NA = N1ST + N2ND + 1
        NANZ = NT3RD
        NE = N1ST + N2ND + NT3RD
        CALL EIRENE_MASAL1 ('NLSPLT',NLSPLT(NA:NE),NANZ)
        CALL EIRENE_LEER(1)
      ENDIF
      IF (NLIMI.GE.1) THEN
        WRITE (iunout,*) 'ADDITIONAL SURFACES: '
        NA = N1ST + N2ND + NT3RD + 1
        NANZ = NLIMI
        NE = N1ST + N2ND + NT3RD + NLIMI
        CALL EIRENE_MASAL1 ('NLSPLT',NLSPLT(NA:NE),NANZ)
        CALL EIRENE_LEER(1)
      ENDIF
      RETURN
      END SUBROUTINE EIRENE_NANALG
