      SUBROUTINE EIRENE_FIND_PARAM(STANDARD_INPUT)
C
C   SET DIMENSIONS (PARAMETERS) FOR ALLOCATABLE ARRAYS (TALLIES, GRIDS, ETC..) AND SET SOME FURTHER DEFAULT VALUES
C
      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD
      USE EIRMOD_CLOGAU, ONLY: EIRENE_ALLOC_CLOGAU, NLSPCSCL,
     .                         NLSPCSCL_ATM, NLSPCSCL_MOL, NLSPCSCL_ION,
     .                         NLSPCSCL_PHOT, NLSPCSCL_ON
      USE EIRMOD_COMPRT, ONLY: IUNIN, IUNOUT
      USE EIRMOD_CPES, ONLY: NPRS
      USE EIRMOD_CESTIM

      IMPLICIT NONE
      INTEGER, INTENT(IN) :: STANDARD_INPUT
      INTEGER :: IUNIN_OLD
      character(80) :: ZEILE
      LOGICAL :: UEX, op
      EXTERNAL :: EIRENE_COUPLE_INIT_OUTPUT, EIRENE_DEFAULTS_USR,
     .            EIRENE_FIND_PARAM_FIXFORM, EIRENE_FIND_PARAM_JSON,
     .            EIRENE_LEER, EIRENE_MASL5, EIRENE_EXIT_OWN
C
C  UNIT NUMBER FOR INPUT FILE: MUST BE DIFFERENT FROM: 5,8,10,11,12
C  13,14, AND 15
C
      IF (STANDARD_INPUT.EQ.0) THEN  !XPB CALL FROM EIRENE_MAIN
        IF (NPRS.GT.1) THEN
          IUNIN=1+IFOFF !VK SWITCHING TO READING FROM FORT.1
        ELSE
          INQUIRE(UNIT=1+IFOFF,EXIST=UEX)
          IF (UEX) THEN
            IUNIN=1+IFOFF
          ELSE
            IUNIN=5 !VK "NORMAL" READING
          ENDIF
        END IF
      ELSE
        IUNIN=STANDARD_INPUT !VK !XPB PASSED AS ARGUMENT
                                 !    SO B2PLOT AND B2MDS CAN WORK
        IUNOUT=6
      ENDIF
      IF (IUNOUT.EQ. 5.OR.IUNOUT.EQ. 8.OR.IUNOUT.EQ.10.OR.
     .    IUNOUT.EQ.11.OR.IUNOUT.EQ.12.OR.IUNOUT.EQ.13.OR.
     .    IUNOUT.EQ.14.OR.IUNOUT.EQ.15) THEN
        WRITE (*,*) 'INVALID OUTPUT STREAM IUNOUT: ',IUNOUT
        WRITE (*,*) 'ERROR EXIT FROM FIND_PARAM.F      '
        CALL EIRENE_EXIT_OWN(1)
      ENDIF
      inquire(unit=iunout,opened=op)
      IF (.not.op) THEN
        CALL EIRENE_COUPLE_INIT_OUTPUT
      ENDIF

      IF (IUNIN.EQ. 5.OR.IUNIN.EQ. 8.OR.IUNIN.EQ.10.OR.
     .    IUNIN.EQ.11.OR.IUNIN.EQ.12.OR.IUNIN.EQ.13.OR.
     .    IUNIN.EQ.14.OR.IUNIN.EQ.15) THEN
        WRITE (IUNOUT,*) 'INVALID INPUT STREAM IUNIN: ',IUNIN
        WRITE (IUNOUT,*) 'ERROR EXIT FROM FIND_PARAM.F      '
        CALL EIRENE_EXIT_OWN(1)
      ENDIF
C
      CALL EIRENE_ALLOC_CLOGAU
      IUNIN_OLD = IUNIN
      CALL EIRENE_DEFAULTS_USR
CNH   24.08.2020
C     Add IFOFF again if IUNIN is adapted in EIRENE_DEFAULTS_USR.
      IF (IUNIN.NE.IUNIN_OLD) THEN
        IUNIN = IUNIN + IFOFF
      ENDIF
      CALL EIRENE_LEER(3)

      IF (IUNIN.NE.5) THEN
        INQUIRE(UNIT=IUNIN,OPENED=UEX)
        IF (UEX) THEN
          REWIND IUNIN
        ELSE
          OPEN(UNIT=IUNIN,ACCESS='SEQUENTIAL',FORM='FORMATTED',
     .         ERR=7999)
        ENDIF
      ENDIF

      READ (IUNIN,'(A80)',END=6999) ZEILE

      REWIND IUNIN

      IF (ZEILE(1:1) == '*') THEN
        CALL EIRENE_FIND_PARAM_FIXFORM
      ELSE IF (ZEILE(1:1) == '{') THEN
        close (unit=iunin)
        CALL EIRENE_FIND_PARAM_JSON
      ELSE
        WRITE (IUNOUT,'(A,I0,A)')
     .    ' EIRENE INPUT FORT.',iunin,' HAS WRONG FORMAT'
        CALL EIRENE_EXIT_OWN(1)
      END IF

!PB   switch off species specific rescaling if only one species per
!PB   particle type is used
      IF (NLSPCSCL_ON) NLSPCSCL=.TRUE.
      IF (MAX(NATM,NMOL,NION,NPLS,NPHOT) <= 1) THEN
        NLSPCSCL=.FALSE.
        NLSPCSCL_ON=.FALSE.
      END IF

      NLSPCSCL_ATM = NLSPCSCL .AND. NATM > 1
      NLSPCSCL_MOL = NLSPCSCL .AND. NMOL > 1
      NLSPCSCL_ION = NLSPCSCL .AND. NION > 1
      NLSPCSCL_PHOT = NLSPCSCL .AND. NPHOT > 1

      LB_ATM=1
      LB_MOL=1
      LB_ION=1
      LB_PHOT=1
      IF (NLSPCSCL_ATM) LB_ATM=0
      IF (NLSPCSCL_MOL) LB_MOL=0
      IF (NLSPCSCL_ION) LB_ION=0
      IF (NLSPCSCL_PHOT) LB_PHOT=0

      WRITE (IUNOUT,*) 'FLAGS FOR SPECIES SPECIFIC RESCALING'
      CALL EIRENE_MASL5('NLSPCSCL, _ATM, _MOL, _ION, _PHOT       ',
     .                   NLSPCSCL, NLSPCSCL_ATM, NLSPCSCL_MOL,
     .                   NLSPCSCL_ION, NLSPCSCL_PHOT)
      CALL EIRENE_LEER(1)

      RETURN

 6999 WRITE (IUNOUT,*) 'Empty input file found!'
      WRITE (IUNOUT,*)
     . 'Either remove it or replace it with a correct file.'
      CALL EIRENE_EXIT_OWN(1)
 7999 WRITE (IUNOUT,*) 'Could not open input file!'
      CALL EIRENE_EXIT_OWN(1)
      RETURN

      END SUBROUTINE EIRENE_FIND_PARAM
