C
      SUBROUTINE EIRENE_ERGOD

C  MODIFICATIONS TO INPUT, IN ORDER TO PERFORM A CELL VOLUME ESTIMATION RUN
C  BASED UPON AN ERGODIC PRINCIPLE

      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD
      USE EIRMOD_COMUSR
      USE EIRMOD_CTRCEI
      USE EIRMOD_COMPRT
      USE EIRMOD_COMNNL
      USE EIRMOD_COMSOU
      USE EIRMOD_CTEXT
      USE EIRMOD_CSDVI
      USE EIRMOD_CLGIN
      USE EIRMOD_COMXS

      IMPLICIT NONE

      REAL(DP) :: SORL4
      INTEGER :: ISTR, ISPR, ISTR2, J, JATM, JMOL, JION, JSPZ, ISTR_ERG
      INTEGER, EXTERNAL :: EIRENE_IDEZ
C
C  1.)  MAKE ALL NON-TRANSPARENT SURFACES 100% REFLECTING, 1.5 EV MONOENERGETIC
C       "THERMAL RE-EMISSION" MODEL
C
      DO J=1,NLIMPS
        IF (ILIIN(J).GT.0) THEN
          IF (ILIIN(J) < 4) ILIIN(J)=1
          ILSPT(J)=0
          ILSIDE(J)=0
          EWALL(J)=1.5
C         RINTEG(J)=0.0
          DO JSPZ=1,NSPZ
            EXPIL(JSPZ,J)=0.0
C  THESE SETTINGS: EITHER RESULT ON PDENA(1,...), THEN: PDENM(1,....)=0.
C                  OR     RESULT ON PDENM(1,...), THEN: PDENA(1,....)=0.
            TRANSP(JSPZ,1,J)=0.0
            TRANSP(JSPZ,2,J)=0.0
            RECYCF(JSPZ,J)=0.0
            RECYCT(JSPZ,J)=1.0
            ISRF(JSPZ,J)=0
            ISRT(JSPZ,J)=1
          ENDDO
        ENDIF
      ENDDO
C
C  2.)  TURN OFF ALL VOLUME PROCESSES
C
      DO JATM=1,NATM
        NRCA(JATM)=-1
      ENDDO
      DO JMOL=1,NMOL
        NRCM(JMOL)=-1
      ENDDO
      DO JION=1,NION
        NRCI(JION)=-1
      ENDDO
C
C  3.)  TURN ON TIME HORIZON, CENSUS ARRAYS, ETC.
c       CONSIDER ONLY ONE STRATUM: ISTR_ERG
C       PLUS ONE FURTHER STRATUM FOR CENSUS
C
      DO ISTR=1,NSTRAI-1
        IF (FLUX(ISTR).GT.0.AND.NPTS(ISTR).GT.0) THEN
          ISTR_ERG=ISTR
C   ENFORCE 4TH DIGIT OF SORLIM = 1: starting at a fixed point in time: TIME0
c   BUT KEEP THE 1,2, AND 3RD DIGIT OF SORLIM AS BEFORE.
          DO J=1,NSRFSI(ISTR_ERG)
            SORL4=EIRENE_IDEZ(INT(SORLIM(J,ISTR_ERG)),4,4)
            SORLIM(J,ISTR_ERG)=SORLIM(J,ISTR_ERG)-SORL4*1000+1000
          ENDDO
C  TURN OFF ALL FURTHER STRATA
          DO ISTR2=ISTR+1,NSTRAI-1
            NPTS(ISTR2)=0
            FLUX(ISTR2)=0.
          ENDDO
        ENDIF
      ENDDO
      NPTS(NSTRAI)=0
      FLUX(NSTRAI)=0
C
C  4.)  TURN ON PRINTOUT OF PARTICLE DENSITY, VOLUME AND CENSUS FLUXES
C
C     TRCHST=.FALSE.
      TRCAMD=.FALSE.
      DO ISPR=1,NSURPR
        IF (NPRSRF(ISPR).EQ.NLIM+NSTSI) GOTO 401
      ENDDO
      NSURPR=NSURPR+1
      NPRSRF(NSURPR)=NLIM+NSTSI
  401 CONTINUE
C
      NVOLPR=4
C  PRINT CELL VOLUMES
      NPRTLV(1)=-NTALO
      NFLAGV(1)=3
      NSPEZV(1,1)=1
      NSPEZV(1,2)=1
      NTLVFL(1)=91
C  PRINT EITHER THERMAL ATOMS, SPECIES 1
      NPRTLV(2)=1
      NFLAGV(2)=3
      NSPEZV(2,1)=1
      NSPEZV(2,2)=1
      NTLVFL(2)=92
C  OR PRINT THERMAL MOLECULES, SPECIES 1
      NPRTLV(3)=2
      NFLAGV(3)=3
      NSPEZV(3,1)=1
      NSPEZV(3,2)=1
      NTLVFL(3)=93
C  OR PRINT USER-DEFINED OUTPUT FROM TALUSR
      NPRTLV(4)=0
      NFLAGV(4)=3
      NSPEZV(4,1)=1
      NSPEZV(4,2)=1
      NTLVFL(4)=99
C
C  TENTATIVELY: TURN ON STATISTICAL ERROR ESTIMATOR FOR ATOMS, SPECIES 1
C               CORRECT THAT IN CASE OF MOLECULES, SPECIES 1, LATER
      NSIGVI=1
      NSIGCI=0
      NSIGI =NSIGVI+NSIGSI+NSIGCI
      IIH(1)=1
C  ...OR: IIH(1)=2, SEE: PARTICLE LOOP IN SUBR. MCARLO, AFTER FIRST HISTORY
      IGH(1)=1
C
      RETURN
      END SUBROUTINE EIRENE_ERGOD
