c
Cdr  sept 17: call learca  --> learca2  (search along 1 coordinate in 2D array)
cdr  aug. 20: code safeties from ITER branch

      FUNCTION EIRENE_STEP(NSPZI,NSPZE,NS,ISTEP,ITYP)
C
C   SET CUMULATIVE DISTRIBUTION FUNCTION VF(I),I=1,NS; VF(1)=0;
C   VF(NS)=1. ON THE GRID RRSTEP(I),I=1,NS
C   FROM PIECEWISE CONSTANT DISTRIBUTION DENSITY FLSTEP(..,I),I=1,NS-1
C   FLSTEP(0,..,I) IS THE VALUE OF THE UNNORMALIZED DENSITY IN THE
C   INTERVAL RRSTEP(I)<X<=RRSTEP(I+1), AFTER SUMMATION OVER THE
C   FIRST (SPECIES) INDEX ISPZ=NSPZI,NSPZE
C
C   THE NORMALIZING FACTOR: INTEGR. FLSTEP(0,X) DX IS RETURNED AS
C   "STEP"
C
      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD
      USE EIRMOD_COMUSR
      USE EIRMOD_COMPRT, ONLY: IUNOUT
      USE EIRMOD_CCONA
      USE EIRMOD_CTRCEI
      USE EIRMOD_CSTEP
      USE EIRMOD_COMXS, ONLY: NPBGKP

      IMPLICIT NONE

      INTEGER, INTENT(IN) :: ISTEP, ITYP, NSPZI, NSPZE, NS
      REAL(DP), ALLOCATABLE ::
     .            SP0(:,:),SP1(:,:),SP2(:,:),
     .            SP3(:,:),SP4(:,:),SP5(:,:)
      INTEGER, ALLOCATABLE :: IP0(:),IP1(:),IP2(:),IP3(:),IP4(:)
      REAL(DP) :: DELR, EIRENE_STEP
      INTEGER :: ISPZ, I, J, IS, NSM,
     .           ISPZTI, ISPZV, IBGK
      LOGICAL :: NLINV
      EXTERNAL :: EIRENE_LEER, EIRENE_EXIT_OWN
      SAVE
C
      IF (NSPZE.GT.NSPZ) GOTO 991
      IF (NSPZI.LT.1) GOTO 991
      NSM=NS-1
      NSMAX(ISTEP)=NS
      NSPSTI(ISTEP)=NSPZI
      NSPSTE(ISTEP)=NSPZE
C
      NLINV=.FALSE.

    1 CONTINUE  !  POSSIBLY: COME BACK HERE FROM DO 21 LOOP,
CDR                AND REVERT THE ORDERING OF STEP FUNCION
CDR                SUCH THAT RRSTEP IS MONOTONICALLY INCREASING

      IF (NLINV) THEN

cdr  temporarily allocate intermediate work arrays,
c    for preparing step-function no. ISTEP

        allocate (sp0(nspz,ngitt))
        allocate (sp1(nspz,ngitt))
        allocate (sp2(nspz,ngitt))
        allocate (sp3(nspz,ngitt))
        allocate (sp4(nspz,ngitt))
        allocate (sp5(nspz,ngitt))
        allocate (ip0(ngitt))
        allocate (ip1(ngitt))
        allocate (ip2(ngitt))
        allocate (ip3(ngitt))
        allocate (ip4(ngitt))

        DO 2 J=1,NS
          SP0(1,J)=RRSTEP(ISTEP,J)
    2   CONTINUE
        DO 3 J=1,NS
          RRSTEP(ISTEP,J)=SP0(1,NS-J+1)
    3   CONTINUE
C
        DO 4 ISPZ=NSPZI,NSPZE
          DO J=1,NSM
            SP0(ISPZ,J)=FLSTEP(ISPZ,ISTEP,J)
            SP1(ISPZ,J)=ELSTEP(ISPZ,ISTEP,J)
          ENDDO
    4   CONTINUE
        DO 5 ISPZ=NSPZI,NSPZE
          DO J=1,NSM
            FLSTEP(ISPZ,ISTEP,J)=SP0(ISPZ,NSM-J+1)
            ELSTEP(ISPZ,ISTEP,J)=SP1(ISPZ,NSM-J+1)
          ENDDO
    5   CONTINUE
C
        DO 8 ISPZ=NSPZI,NSPZE
          IF (ITYP.EQ.4) THEN
            ISPZTI=MPLSTI(ISPZ)
            ISPZV=MPLSV(ISPZ)
          ELSE
            ISPZTI=ISPZ
            ISPZV=ISPZ
          END IF
          DO J=1,NSM
            SP1(ISPZ,J)=VXSTEP(ISPZV,ISTEP,J)
            SP2(ISPZ,J)=VYSTEP(ISPZV,ISTEP,J)
            SP3(ISPZ,J)=VZSTEP(ISPZV,ISTEP,J)
            SP4(ISPZ,J)=DISTEP(ISPZ,ISTEP,J)
            SP5(ISPZTI,J)=TISTEP(ISPZTI,ISTEP,J)
          END DO
    8   CONTINUE
        DO 9 ISPZ=NSPZI,NSPZE
          IF (ITYP.EQ.4) THEN
            ISPZTI=MPLSTI(ISPZ)
            ISPZV=MPLSV(ISPZ)
          ELSE
            ISPZTI=ISPZ
            ISPZV=ISPZ
          END IF
          DO J=1,NSM
            VXSTEP(ISPZV,ISTEP,J)=SP1(ISPZ,NSM-J+1)
            VYSTEP(ISPZV,ISTEP,J)=SP2(ISPZ,NSM-J+1)
            VZSTEP(ISPZV,ISTEP,J)=SP3(ISPZ,NSM-J+1)
            DISTEP(ISPZ,ISTEP,J)=SP4(ISPZ,NSM-J+1)
            TISTEP(ISPZTI,ISTEP,J)=SP5(ISPZTI,NSM-J+1)
          END DO
    9   CONTINUE
        DO ISPZ=NSPZI,NSPZE
          IF (ITYP.EQ.4) THEN
            ISPZTI=MPLSTI(ISPZ)
            ISPZV=MPLSV(ISPZ)
          ELSE
            ISPZTI=ISPZ
            ISPZV=ISPZ
          END IF
          DO J=1,NSM
            SP1(ISPZ,J)=VPSTEP(ISPZV,ISTEP,J)
            SP2(ISPZ,J)=MCSTEP(ISPZ,ISTEP,J)
            SP3(ISPZ,J)=FISTEP(ISPZ,ISTEP,J)
          END DO
        END DO
        DO ISPZ=NSPZI,NSPZE
          IF (ITYP.EQ.4) THEN
            ISPZTI=MPLSTI(ISPZ)
            ISPZV=MPLSV(ISPZ)
          ELSE
            ISPZTI=ISPZ
            ISPZV=ISPZ
          ENDIF
          DO J=1,NSM
            VPSTEP(ISPZV,ISTEP,J)=SP1(ISPZ,NSM-J+1)
            MCSTEP(ISPZ,ISTEP,J)=SP2(ISPZ,NSM-J+1)
            FISTEP(ISPZ,ISTEP,J)=SP3(ISPZ,NSM-J+1)
          END DO
        END DO
C
        DO 6 J=1,NSM
          SP0(1,J)=TESTEP(ISTEP,J)
          SP1(1,J)=SHSTEP(ISTEP,J)
          SP2(1,J)=FESTEP(ISTEP,J)
          IP0(J)=IRSTEP(ISTEP,J)
          IP1(J)=IPSTEP(ISTEP,J)
          IP2(J)=ITSTEP(ISTEP,J)
          IP3(J)=IASTEP(ISTEP,J)
          IP4(J)=IBSTEP(ISTEP,J)
    6   CONTINUE
        DO 7 J=1,NSM
          TESTEP(ISTEP,J)=SP0(1,NSM-J+1)
          SHSTEP(ISTEP,J)=SP1(1,NSM-J+1)
          FESTEP(ISTEP,J)=SP2(1,NSM-J+1)
          IRSTEP(ISTEP,J)=IP0(NSM-J+1)
          IPSTEP(ISTEP,J)=IP1(NSM-J+1)
          ITSTEP(ISTEP,J)=IP2(NSM-J+1)
          IASTEP(ISTEP,J)=IP3(NSM-J+1)
          IBSTEP(ISTEP,J)=IP4(NSM-J+1)
    7   CONTINUE

cdr  de-allocate temporary work arrays
        deallocate (sp0)
        deallocate (sp1)
        deallocate (sp2)
        deallocate (sp3)
        deallocate (sp4)
        deallocate (sp5)
        deallocate (ip0)
        deallocate (ip1)
        deallocate (ip2)
        deallocate (ip3)
        deallocate (ip4)
      ENDIF

C  inverting stepfunction: done
C
C  now: sum over species
C
      DO 10 J=1,NSM
        FLSTEP(0,ISTEP,J)=0.
        ELSTEP(0,ISTEP,J)=0.
        DO 11 ISPZ=NSPZI,NSPZE
          FLSTEP(0,ISTEP,J)=FLSTEP(0,ISTEP,J)+FLSTEP(ISPZ,ISTEP,J)
          ELSTEP(0,ISTEP,J)=ELSTEP(0,ISTEP,J)+ELSTEP(ISPZ,ISTEP,J)
   11   CONTINUE
        DO ISPZ=NSPZE+1,NSPZ
          FLSTEP(ISPZ,ISTEP,J)=0.
          ELSTEP(ISPZ,ISTEP,J)=0.
        ENDDO
        DO ISPZ=1,NSPZI-1
          FLSTEP(ISPZ,ISTEP,J)=0.
          ELSTEP(ISPZ,ISTEP,J)=0.
        ENDDO
   10 CONTINUE

C
C   set cumulative distribution VL (particles) and EL (energy),
C                   for all species: ispz and for sum over species: ispz=0
C
      DO 20 ISPZ=0,NSPZ
        IF (ISPZ.GT.NSPZE.OR.(ISPZ.LT.NSPZI.AND.ISPZ.GT.0)) GOTO 20
        VF(ISPZ,ISTEP,1)=0.
        VE(ISPZ,ISTEP,1)=0.
        DO 21 J=2,NS
          DELR=RRSTEP(ISTEP,J)-RRSTEP(ISTEP,J-1)
          IF (DELR.LT.0.D0) THEN
            IF (NLINV) GOTO 993
C  INVERT COMPLETE STEP FUNCTION ISTEP (ONLY ONCE)
            IF (TRCSOU) WRITE (iunout,*)
     .        'STEP FUNCTION NO. ISTEP= ',ISTEP,' REVERSED'
            NLINV=.TRUE.
            GOTO 1
          ENDIF
          VF(ISPZ,ISTEP,J)=VF(ISPZ,ISTEP,J-1)+
     .                      FLSTEP(ISPZ,ISTEP,J-1)*DELR
          IF (VF(ISPZ,ISTEP,J).LT.VF(ISPZ,ISTEP,J-1)) GOTO 994
          VE(ISPZ,ISTEP,J)=VE(ISPZ,ISTEP,J-1)+
     .                     ELSTEP(ISPZ,ISTEP,J-1)
   21   CONTINUE
   20 CONTINUE
C  CUMULATIVE STEP FUNCTION "VF" NO. ISTEP IS DEFINED NOW
C  RETURN TOTAL FLUX, SUM OVER SPECIES

      EIRENE_STEP=VF(0,ISTEP,NS)

C  NORMALIZE VF TO 1.
C
      DO 25 ISPZ=0,NSPZ
        IF (ISPZ.GT.NSPZE.OR.(ISPZ.LT.NSPZI.AND.ISPZ.GT.0)) GOTO 25
C  save totals before normalization
        FLTOT(ISPZ,ISTEP)=VF(ISPZ,ISTEP,NS)
        ELTOT(ISPZ,ISTEP)=VE(ISPZ,ISTEP,NS)

cdr IBGK: Try to remove virtual background species 
cdr      (those used for BGK iterations)
cdr from the surface flux step functions
        IBGK=0
        IF (ISPZ.GT.0 .AND. ITYP.EQ.4) IBGK = NPBGKP(ISPZ,1)
        IF (FLTOT(ISPZ,ISTEP).LE.0.D0.AND.IBGK.EQ.0) THEN
          WRITE (iunout,*) 'WARNING FROM FUNCTION "STEP"'
          WRITE (iunout,*)
     .      'DENSITY FUNCTION FLSTEP(ISPZ,ISTEP) VANISHES '
          WRITE (iunout,*) 'ISPZ,ISTEP ',ISPZ,ISTEP
        ENDIF
   25 CONTINUE
C
      DO 30 ISPZ=0,NSPZ
        IF (ISPZ.GT.NSPZE.OR.(ISPZ.LT.NSPZI.AND.ISPZ.GT.0)) GOTO 30
        DO 31 J=1,NS
          VF(ISPZ,ISTEP,J)=VF(ISPZ,ISTEP,J)/(FLTOT(ISPZ,ISTEP)+EPS60)
   31   CONTINUE
   30 CONTINUE
C
C  SET SOME ARRAYS TO SPEED UP SAMPLING FROM VF(ISPZ,ISTEP,...)
      DO 40 ISPZ=0,NSPZ
        IF (ISPZ.GT.NSPZE.OR.(ISPZ.LT.NSPZI.AND.ISPZ.GT.0)) GOTO 40
        DO 41 J=1,NSM
          QUOT(ISPZ,ISTEP,J)=(RRSTEP(ISTEP,J+1)-RRSTEP(ISTEP,J))/
     .               (VF(ISPZ,ISTEP,J+1)-VF(ISPZ,ISTEP,J)+EPS60)
          ADD (ISPZ,ISTEP,J)=-QUOT(ISPZ,ISTEP,J)*VF(ISPZ,ISTEP,J)+
     .                         RRSTEP(ISTEP,J)
          QUOTI(ISPZ,ISTEP,J)=(VF(ISPZ,ISTEP,J+1)-VF(ISPZ,ISTEP,J))/
     .                   (RRSTEP(ISTEP,J+1)-RRSTEP(ISTEP,J)+EPS60)
          ADDIV(ISPZ,ISTEP,J)=-QUOTI(ISPZ,ISTEP,J)*RRSTEP(ISTEP,J)+
     .                          VF(ISPZ,ISTEP,J)
   41   CONTINUE
   40 CONTINUE
C
      IF (ISTUF(ISTEP).NE.0) THEN
        WRITE (iunout,'(a,a,i3)')
     .  'WARNING FROM FUNCTION EIRENE_STEP: VF(ISTEP) IS ',
     .  'OVERWRITTEN. ISTEP= ',ISTEP
      ENDIF
      ISTUF(ISTEP)=1
      IF (TRCSOU) THEN
        WRITE (iunout,*) 'STEP FUNCTION NO. ISTEP= ',
     .                                      ISTEP,' INITIALISED'
        CALL EIRENE_LEER(1)
      ENDIF
      RETURN
  991 CONTINUE
      WRITE (iunout,*) 'PARAMETER ERROR IN FUNCTION EIRENE_STEP '
      WRITE (iunout,*) 'NSPZE MUST BE .LE. NSPZ '
      WRITE (iunout,*) 'NSPZI MUST BE .GE. 1    '
      WRITE (iunout,*) 'NSPZI,NSPZE,NSPZ = ',NSPZI,NSPZE,NSPZ
      CALL EIRENE_EXIT_OWN(1)
  993 CONTINUE
      WRITE (iunout,*) 'ERROR IN FUNCTION EIRENE_STEP, ISTEP= ',ISTEP
      WRITE (iunout,*) 'RRSTEP NEITHER MONOTONICALLY INCREASING NOR'
      WRITE (iunout,*) 'DECREASING'
      CALL EIRENE_EXIT_OWN(1)
  994 CONTINUE
      WRITE (iunout,*) 'ERROR IN FUNCTION EIRENE_"STEP" '
      WRITE (iunout,*) 'VF IS NOT MONOTONICALLY INCREASING'
      WRITE (iunout,*) 'POSSIBLE REASON: FLSTEP NEGATIVE SOMEWHERE? '
      WRITE (iunout,*) 'ISTEP, J ',ISTEP,J
      WRITE (iunout,*) ' I   RRSTEP     VF '
      DO 995 I=1,J
        WRITE (iunout,'(1X,I3,1P,5E12.4)')
     .         I,RRSTEP(ISTEP,I),(VF(IS,ISTEP,I),IS=NSPZI,NSPZE)
  995 CONTINUE
      CALL EIRENE_EXIT_OWN(1)
      END FUNCTION EIRENE_STEP
C
C
C
      FUNCTION EIRENE_STEP0(NSPZ1,ISTEP,X)
      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD
      USE EIRMOD_COMUSR
      USE EIRMOD_COMPRT, ONLY: IUNOUT
      USE EIRMOD_CCONA
      USE EIRMOD_CTRCEI
      USE EIRMOD_CSTEP
      IMPLICIT NONE

      REAL(DP), INTENT(IN) :: X
      INTEGER, INTENT(IN) :: NSPZ1, ISTEP

      REAL(DP) :: EIRENE_STEP0
      INTEGER :: ISPZ1, NS1, IND, EIRENE_LEARCA2
      EXTERNAL :: EIRENE_EXIT_OWN, EIRENE_LEARCA2

      ISPZ1=NSPZ1
C
C   EVALUATE CUMULATIVE DISTRIBUTION VF(X) NO. ISTEP, AT POINT X,  BY LINEAR INTERPOLATION
C
      IF (ISPZ1.LT.0) GOTO 990
      IF (ISPZ1.GT.0.AND.ISPZ1.LT.NSPSTI(ISTEP)) GOTO 990
      IF (ISPZ1.GT.NSPSTE(ISTEP)) GOTO 990
C
      IF (ISTEP.LE.0.OR.ISTEP.GT.NSTEP) GOTO  990
      IF (ISTUF(ISTEP).EQ.0) GOTO 990
C
      NS1=NSMAX(ISTEP)
      IF (X.LT.RRSTEP(ISTEP,1)) THEN
        WRITE (iunout,*) 'X OUT OF RANGE IN STEP0, X,RRSTEP(1) ',X,
     .               RRSTEP(ISTEP,1)
        EIRENE_STEP0=0.
      ELSEIF (X.GT.RRSTEP(ISTEP,NS1)) THEN
        WRITE (iunout,*) 'X OUT OF RANGE IN STEP0, X,RRSTEP(NS1) ',X,
     .               RRSTEP(ISTEP,NS1)
        EIRENE_STEP0=1.
      ELSE
        IND=EIRENE_LEARCA2(X,RRSTEP,NSTEP,NS1,ISTEP,'STEP0       ')
        EIRENE_STEP0=ADDIV(ISPZ1,ISTEP,IND)+X*QUOTI(ISPZ1,ISTEP,IND)
      ENDIF
      RETURN
  990 CONTINUE
      WRITE (iunout,*) 'ERROR IN FUNCTION EIRENE_STEP0, ISTEP= ',ISTEP
      CALL EIRENE_EXIT_OWN(1)
      END FUNCTION EIRENE_STEP0
C
C
C
      FUNCTION EIRENE_STEP1(IINDEX,ISTEP,Y,NSPZ1)
      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD
      USE EIRMOD_COMUSR
      USE EIRMOD_COMPRT, ONLY: IUNOUT
      USE EIRMOD_CCONA
      USE EIRMOD_CTRCEI
      USE EIRMOD_CSTEP
      IMPLICIT NONE

      REAL(DP), INTENT(IN) :: Y
      INTEGER, INTENT(IN) :: NSPZ1, ISTEP
      INTEGER, INTENT(OUT) :: IINDEX

      REAL(DP) :: EIRENE_STEP1, XX
      INTEGER :: ISPZ1, NS1, J, JJ, JJM
      EXTERNAL :: EIRENE_EXIT_OWN

      ISPZ1=NSPZ1
C
C  INVERT FUNCTION VF(ISPZ1,X)=Y. NO. ISTEP, E.G.
C  SAMPLE FROM VF WITH Y=RANF, RRSTEP(ISTEP,1)<=X<=RRSTEP(ISTEP,NS1)
C  RETURN THE VALUE X AS STEP1, AND THE INTERVAL NUMBER IINDEX OF
C  THE INTERVAL CONTAINING THIS X.
C
      IF (ISTEP.LE.0.OR.ISTEP.GT.NSTEP) GOTO  990
      IF (ISTUF(ISTEP).EQ.0) GOTO 990
C
      IF (ISPZ1.LT.0) ISPZ1=0
      IF (ISPZ1.GT.0.AND.ISPZ1.LT.NSPSTI(ISTEP)) ISPZ1=0
      IF (ISPZ1.GT.NSPSTE(ISTEP)) ISPZ1=0
C
      JJ=2
      NS1=NSMAX(ISTEP)
      DO 100 J=2,NS1
        JJ=J
        IF (Y.LE.VF(ISPZ1,ISTEP,J)) GOTO 110
  100 CONTINUE
  110 JJM=JJ-1
      IINDEX=JJM
      XX=ADD(ISPZ1,ISTEP,JJM)+Y*QUOT(ISPZ1,ISTEP,JJM)
      EIRENE_STEP1=XX
      RETURN
C
  990 CONTINUE
      WRITE (iunout,*) 'ERROR IN FUNCTION EIRENE_STEP1, ISTEP= ',ISTEP
      CALL EIRENE_EXIT_OWN(1)
      END FUNCTION EIRENE_STEP1
