C
C
      FUNCTION EIRENE_FTHOMP(UB,EMAX)
C
C  RANDOM NUMBER "E" FROM A THOMPSON FUNCTION F(E,UB,EMAX)
C  F(E,UB,EMAX)=CONST*E/(E+UB)**3,  0<E<EMAX
C  CONST=UB/(0.5*1./(EMAX/UB+1.)**2-1./(EMAX/UB+1.)+0.5)
C
      USE EIRMOD_PRECISION
      USE EIRMOD_RANF, ONLY: RANF_EIRENE

      IMPLICIT NONE

      REAL(DP), INTENT(IN) :: UB, EMAX
      REAL(DP) :: A, E, ARG, BETAD2, EIRENE_FTHOMP, EMU
ctk      REAL(DP), EXTERNAL :: RANF_EIRENE

      EMU=1.0_DP/(EMAX/UB+1.0_DP)
      BETAD2=1.0_DP/((1.0_DP-EMU)*(1.0_DP-EMU))
C
      A=RANF_EIRENE()
      ARG=A/BETAD2
      E=UB/(1.0_DP-SQRT(ARG))-UB
      EIRENE_FTHOMP=E
C
      RETURN
      END FUNCTION EIRENE_FTHOMP
