C  code segment contains: fpolyt_3  and fpolyt_4
C
C
C   CONVEX POLYTOP SAMPLING
C   L.DEVROYE, "NON UNIFORM RANDOM VARIATE GENERATION", SPRINGER
C   1986, P 568
C
      SUBROUTINE EIRENE_FPOLYT_3(X1,Y1,Z1,X2,Y2,Z2,X3,Y3,Z3,X,Y,Z)
      USE EIRMOD_PRECISION
      USE EIRMOD_RANF, ONLY: RANF_EIRENE

      IMPLICIT NONE

      REAL(DP) :: D(3)
      REAL(DP), INTENT(IN) :: X1, Y1, Z1, X2, Y2, Z2, X3, Y3, Z3
      REAL(DP), INTENT(OUT) :: X, Y, Z
      REAL(DP) :: R1, R2, RMI, RMA
C
C
C  SAMPLE UNIFORMLY ON TRIANGLE P1,P2,P3. (POLYTOP IN R3, 3 VERTICES). RETURN P
C
      R1=RANF_EIRENE()
      R2=RANF_EIRENE()
      RMA=MAX(R1,R2)
      RMI=MIN(R1,R2)
      D(1)=RMI-0.
      D(2)=RMA-RMI
      D(3)=1.-RMA
      X=D(1)*X1+D(2)*X2+D(3)*X3
      Y=D(1)*Y1+D(2)*Y2+D(3)*Y3
      Z=D(1)*Z1+D(2)*Z2+D(3)*Z3
      RETURN
      END SUBROUTINE EIRENE_FPOLYT_3
C
      SUBROUTINE EIRENE_FPOLYT_4(X1,Y1,Z1,X2,Y2,Z2,X3,Y3,Z3,X4,Y4,Z4,
     .                           X,Y,Z)
      USE EIRMOD_PRECISION
      USE EIRMOD_RANF, ONLY: RANF_EIRENE

      IMPLICIT NONE

      REAL(DP) :: D(4)
      REAL(DP), INTENT(IN) :: X1, Y1, Z1, X2, Y2, Z2, X3, Y3, Z3,
     .                        X4, Y4, Z4
      REAL(DP), INTENT(OUT) :: X, Y, Z
      REAL(DP) :: R1, R2, R3, RMI, RMA, RCT
C
C  SAMPLE UNIFORMLY ON TETRAHEDRON P1,P2,P3,P4 (POLYTOP IN R3, 4 VERTICES).
C  RETURN P
      R1=RANF_EIRENE()
      R2=RANF_EIRENE()
      R3=RANF_EIRENE()
      RMA=MAX(R1,R2,R3)
      RMI=MIN(R1,R2,R3)
      RCT=R1+R2+R3-RMI-RMA
      D(1)=RMI-0.
      D(2)=RCT-RMI
      D(3)=RMA-RCT
      D(4)=1.-RMA
      X=D(1)*X1+D(2)*X2+D(3)*X3+D(4)*X4
      Y=D(1)*Y1+D(2)*Y2+D(3)*Y3+D(4)*Y4
      Z=D(1)*Z1+D(2)*Z2+D(3)*Z3+D(4)*Z4
      RETURN
C
      END SUBROUTINE EIRENE_FPOLYT_4
