C
C
      SUBROUTINE EIRENE_FISOTR
C
C  SAMPLE IRNDVC TRIPLES OF RANDOM UNIT VECTORS FROM A 3D ISOTROPIC
C  DISTRIBUTION
C  AND RETURN THEM IN THE ARRAYS FI1,FI2,FI3
C  THE NORM OF THE VECTOR (FI1,FI2,FI3) IS == 1.0, BY CONSTRUCTION
C  THIS ROUTINE IS CALLED, IF INIV3=0, AND IT RETURNS INIV3=IRNDVC
C
      USE EIRMOD_CRAND
      USE EIRMOD_RANF, ONLY: RANF_EIRENE
      USE EIRMOD_CCONA, ONLY: PI2 => PI2A

      IMPLICIT NONE

      REAL(DP) :: ZCTHET, ZTHETA, ZSTHET, ZSPHI, ZCPHI, ZEP1, ZEP2
      INTEGER :: J

!pb   DATA PI2/6.283185_DP/
C
      DO 100 J=1,IRNDVC
        ZEP1=RANF_EIRENE( )
        ZEP2=RANF_EIRENE( )
C  THETA
        ZTHETA=PI2*ZEP2
        ZCTHET=COS(ZTHETA)
        ZSTHET=SIN(ZTHETA)
C  PHI
        ZCPHI=ZEP1+ZEP1-1._DP
        ZSPHI=SQRT(1._DP-ZCPHI*ZCPHI)
C
        FI1(J)=ZCPHI
        FI2(J)=ZSPHI*ZSTHET
        FI3(J)=ZSPHI*ZCTHET
  100 CONTINUE
      INIV3=IRNDVC
      RETURN
      END SUBROUTINE EIRENE_FISOTR
