C
C
      SUBROUTINE EIRENE_FGAUSS
C
C  SAMPLE IRNDVC TRIPLES OF RANDOM NUMBER FROM A GAUSSIAN
C  AND RETURN THEM IN THE ARRAYS FG1,FG2,FG3
C  IT FIRST GENERATES IRNDVC PAIRS, AND THEN IRNDVC/2 PAIRS
C  THIS ROUTINE IS CALLED IF INIV2=0. IT RETURNS INIV2=IRNDVC
C
      USE EIRMOD_CRAND
      USE EIRMOD_RANF, ONLY: RANF_EIRENE
      USE EIRMOD_CCONA, ONLY: PI2 => PI2A

      IMPLICIT NONE

      REAL(DP) :: ZCOS, ZSIN, ZT, AR, ZZ
      INTEGER :: JJ

!PB   DATA PI2/6.283185_DP/
C
C    THIS FUNCTION SAMPLES FROM A GAUSSIAN OF THE
C    FORM EXP(-(X-ZA)**2/(2.*ZS**2))/(ZS*SQRT(2*PI))
C    ZA=0.
C    ZS=1.
C
C  IT IS THE BOX-MUELLER METHOD
C
C
      DO 1 JJ=1,IRNDVC
C   1. COMPUTE THE SINE AND COSINE OF 2*PI*RAN(1)
C
        ZZ=PI2*RANF_EIRENE( )
        ZSIN=SIN(ZZ)
        ZCOS=COS(ZZ)
C
        AR=LOG(RANF_EIRENE( ))
        ZT=SQRT(-(AR+AR))
        FG1(JJ)=ZT*ZSIN
        FG2(JJ)=ZT*ZCOS
    1 CONTINUE
C
      DO 2 JJ=1,IRNDVH
C
        ZZ=PI2*RANF_EIRENE( )
        ZSIN=SIN(ZZ)
        ZCOS=COS(ZZ)
C
        AR=LOG(RANF_EIRENE( ))
        ZT=SQRT(-(AR+AR))
        FG3(JJ)=ZT*ZSIN
        FG3(JJ+IRNDVH)=ZT*ZCOS
    2 CONTINUE
C
      INIV2=IRNDVC
      RETURN
      END SUBROUTINE EIRENE_FGAUSS
