C
C
      SUBROUTINE EIRENE_FCOSIN
C
C  VECTOR VERSION OF COSINE DISTRIBUTION SAMPLER
C  SAMPLES IRNDVC TRIPLES  FROM A COSINE POLAR AND
C  AN EQUI AZIMUTAL DISTRIBUTION.
C  THIS COSINE (LAMBERTIAN) IS
c  AROUND SURFACE NORMAL VECTOR (-1,0,0)
C  RETURN the three cartesian components
C  of the sampled unit vector IN THE ARRAYS FC1,FC2,FC3
C  THIS ROUTINE IS CALLED, WHEN INIV4=0, AND IT RETURNS INIV4=IRNDVC TRIPLES
C
      USE EIRMOD_CRAND
      USE EIRMOD_RANF, ONLY: RANF_EIRENE
      USE EIRMOD_CCONA, ONLY: PI2 => PI2A

      IMPLICIT NONE

      REAL(DP) :: A, ZCTHET, ZSTHET, ZCPHI, ZSPHI, ZTHET
      INTEGER :: J

!pb   DATA PI2/6.283185_DP/
C
      DO 100 J=1,IRNDVC
        ZTHET=PI2*RANF_EIRENE( )
        ZSTHET=SIN(ZTHET)
        ZCTHET=COS(ZTHET)
        A=RANF_EIRENE( )
        ZCPHI=SQRT(A)
        ZSPHI=SQRT(1._DP-A)
        FC1(J)=-ZCPHI
        FC2(J)=ZSPHI*ZCTHET
        FC3(J)=ZSPHI*ZSTHET
  100 CONTINUE
      INIV4=IRNDVC
      RETURN
      END SUBROUTINE EIRENE_FCOSIN
