!pb 19.12.06: write minimum and maximum value onto RAPS logfile
C
      SUBROUTINE EIRENE_RPSCOL (AORIG,IBLD,ICURV,
     .                   I1,I2,XX,YY,
     .                   TEXT1,TEXT2,TEXT3,
     .                   LOGL,ZMA,ZMI,
     .                   HEAD,RUNID,TXHEAD,TRC)
C
C  THIS SUBROUTINE PRODUCES A PLOTFILE FOR THE RAPS GRAPHICS SYSTEM
C
C  IT CALLS SUBR. CELINT, WHERE INTERPOLATION ONTO VERTICES IS PERFORMED
C
C
C    ******M******
C    *     *     *
C    *  D  I  E  *
C    *     *     *   |
C    L**H**A**F**J   |
C    *     *     *
C    *  C  G  B  *   IP
C    *     *     *
C    ******K******
C
C        <--- IR
C
      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD
      USE EIRMOD_COMUSR
      USE EIRMOD_CLOGAU
      USE EIRMOD_CPLOT
      USE EIRMOD_CPOLYG
      USE EIRMOD_CGRID
      USE EIRMOD_CGEOM
      USE EIRMOD_CTRIG
      USE EIRMOD_COMPRT, ONLY: IUNOUT
      USE EIRMOD_CCONA

      IMPLICIT NONE
C
      REAL(DP), INTENT(IN) :: AORIG(*)
      REAL(DP), INTENT(IN) :: XX(*), YY(*)
      REAL(DP), INTENT(IN) :: ZMA, ZMI
      INTEGER, INTENT(IN) :: IBLD, ICURV, I1, I2
      LOGICAL, INTENT(IN) :: LOGL, TRC
      CHARACTER(72), INTENT(IN) :: TEXT1, HEAD, RUNID, TXHEAD
      CHARACTER(24), INTENT(IN) :: TEXT2, TEXT3

      REAL(DP), ALLOCATABLE :: YWERT(:,:),ywert1(:,:), BORIG(:)
      REAL(DP) :: WMIN, WMAX
      INTEGER :: IR, IERR, IT, I, IPART, IP, ICASE, IRD
      EXTERNAL :: EIRENE_CELINT, EIRENE_RPSCUT
C
      WRITE (IUNRAPSVEC,*) RUNID
      WRITE (IUNRAPSVEC,*) TXHEAD
      WRITE (IUNRAPSVEC,*) HEAD
      WRITE (IUNRAPSVEC,*) TEXT1
      WRITE (IUNRAPSVEC,*) TEXT2
      WRITE (IUNRAPSVEC,*) TEXT3
C
      NRAPS=NRAPS+1
      IRAPS=IRAPS+1
C
      OPEN (UNIT=NRAPS+ifoff,ACCESS='SEQUENTIAL',FORM='FORMATTED')
      REWIND NRAPS+ifoff
C
      ICASE=0
      IERR=0
C  2D (X,Y) FEM MESH
      IF (LEVGEO.EQ.4.AND.LPTOR3(IBLD)) THEN
         ALLOCATE (YWERT1(NRAD,1))
         CALL EIRENE_CELINT(AORIG,YWERT1,LOGL,IBLD,ICURV,NRAD,IERR)
         ICASE=4
         WMIN=MINVAL(YWERT1(1:NRAD,1))
         WMAX=MAXVAL(YWERT1(1:NRAD,1))
C  2D MESH, EITHER X,Y  OR X,Z OR Y,Z PROJECTION
      ELSEIF (LEVGEO.LE.3.AND.
     .       (LPPOL3(IBLD).OR.LPTOR3(IBLD).OR.LPRAD3(IBLD))) THEN
         ALLOCATE (YWERT(N1ST,N2ND+N3RD))
         CALL EIRENE_CELINT(AORIG,YWERT,LOGL,IBLD,ICURV,N1ST,IERR)
         ICASE=3
         WMIN=MINVAL(YWERT(1:N1ST,1:N2ND+N3RD))
         WMAX=MAXVAL(YWERT(1:N1ST,1:N2ND+N3RD))
C  3D MESH, X,Y,Z CUBE,  NO PROJECTION
      ELSEIF (LEVGEO.EQ.1.AND.NLTRZ
     .   .AND.NLRAD.AND.NLPOL.AND.NLTOR
     .   .AND..NOT.(LPPOL3(IBLD).OR.LPTOR3(IBLD).OR.LPRAD3(IBLD))) THEN
         ALLOCATE (YWERT1(NRAD,1))
         CALL EIRENE_CELINT(AORIG,YWERT1,LOGL,IBLD,ICURV,NRAD,IERR)
         ICASE=1
         WMIN=MINVAL(YWERT1(1:NRAD,1))
         WMAX=MAXVAL(YWERT1(1:NRAD,1))
C  3D MESH, TETRAHEDRA, NO PROJECTION
      ELSEIF ((LEVGEO.EQ.5).AND..NOT.LRPSCUT) THEN
         ALLOCATE (YWERT1(NRAD,1))
         CALL EIRENE_CELINT(AORIG,YWERT1,LOGL,IBLD,ICURV,NRAD,IERR)
         ICASE=5
         WMIN=MINVAL(YWERT1(1:NRAD,1))
         WMAX=MAXVAL(YWERT1(1:NRAD,1))
C  3D MESH, TETRAHEDRA, PROJECTION INTO PLANE
      ELSEIF ((LEVGEO.EQ.5).AND.LRPSCUT) THEN
         ALLOCATE (YWERT1(NRAD,1))
         ALLOCATE (BORIG(NRAD))
         CALL EIRENE_RPSCUT (AORIG,BORIG)
         CALL EIRENE_CELINT(BORIG,YWERT1,LOGL,IBLD,ICURV,NRAD,IERR)
         DEALLOCATE (BORIG)
         ICASE=4
         WMIN=MINVAL(YWERT1(1:NRAD,1))
         WMAX=MAXVAL(YWERT1(1:NRAD,1))
      ENDIF
      IF (ZMI .NE. 666.) WMIN = MIN(ZMI, WMIN)
      IF (ZMA .NE. 666.) WMAX = MAX(ZMA, WMAX)
      WRITE (IUNRAPSVEC,*) WMIN, WMAX
      WRITE (IUNRAPSVEC,*)

      IF (IERR.GT.0) THEN
        IF (ALLOCATED(YWERT)) DEALLOCATE (YWERT)
        IF (ALLOCATED(YWERT1)) DEALLOCATE (YWERT1)
        RETURN
      END IF
C
      IF (ICASE.EQ.1) THEN

         do ir=1,nr1st
            do ip=1,np2nd
               do it=1,nt3rd
                  IRD=IR+((IP-1)+(IT-1)*NP2T3)*NR1P2
                  IF (ZMI.NE.666.) YWERT1(IRD,1)=
     .                             MAX(YWERT1(IRD,1),ZMI)
                  IF (ZMA.NE.666.) YWERT1(IRD,1)=
     .                             MIN(YWERT1(IRD,1),ZMA)
                  IF (ABS(YWERT1(IRD,1)) < EPS30) YWERT1(IRD,1)=0._DP
                  WRITE (NRAPS+ifoff,*) YWERT1(IRD,1)
               enddo
            enddo
         enddo


      ELSEIF (LEVGEO.LE.2.AND.LPPOL3(IBLD)) THEN
        LPPOLR=.TRUE.
        IPPOLR=MAX(1,IPROJ3(IBLD,ICURV))
        IF (.NOT.NLRAD.OR..NOT.NLTOR) THEN
          WRITE (iunout,*) 'ERROR IN RPSCOL. LPPOL3? '
          IF (ALLOCATED(YWERT)) DEALLOCATE (YWERT)
          IF (ALLOCATED(YWERT1)) DEALLOCATE (YWERT1)
          RETURN
        ENDIF
        DO 1100 IR=1,NR1ST
          DO 3100 IT=1,NT3RD
            IF (ZMI.NE.666.) YWERT(IR,IT)=MAX(YWERT(IR,IT),ZMI)
            IF (ZMA.NE.666.) YWERT(IR,IT)=MIN(YWERT(IR,IT),ZMA)
            IF (ABS(YWERT(IR,IT)) < EPS30) YWERT(IR,IT)=0._DP
            WRITE (NRAPS+ifoff,*) YWERT(IR,IT)
 3100     CONTINUE
 1100   CONTINUE
C
      ELSEIF (LEVGEO.LE.2.AND.LPTOR3(IBLD)) THEN
        LPTORR=.TRUE.
        IPTORR=MAX(1,IPROJ3(IBLD,ICURV))
        IF (.NOT.NLRAD.OR..NOT.NLPOL) THEN
          WRITE (iunout,*) 'ERROR IN RPSCOL. LPTOR3? '
          IF (ALLOCATED(YWERT)) DEALLOCATE (YWERT)
          IF (ALLOCATED(YWERT1)) DEALLOCATE (YWERT1)
          RETURN
        ENDIF
        DO 1 IR=1,NR1ST
          DO 3 IP=1,NP2ND
            IF (ZMI.NE.666.) YWERT(IR,IP)=MAX(YWERT(IR,IP),ZMI)
            IF (ZMA.NE.666.) YWERT(IR,IP)=MIN(YWERT(IR,IP),ZMA)
            IF (ABS(YWERT(IR,IP)) < EPS30) YWERT(IR,IP)=0._DP
            WRITE (NRAPS+ifoff,*) YWERT(IR,IP)
    3     CONTINUE
    1   CONTINUE
C
      ELSEIF (LEVGEO.EQ.3.AND.LPTOR3(IBLD)) THEN
        LPTORR=.TRUE.
        IPTORR=MAX(1,IPROJ3(IBLD,ICURV))
        IF (.NOT.NLRAD.OR..NOT.NLPOL) THEN
          WRITE (iunout,*) 'ERROR IN RPSCOL. LPTOR3? '
          IF (ALLOCATED(YWERT)) DEALLOCATE (YWERT)
          IF (ALLOCATED(YWERT1)) DEALLOCATE (YWERT1)
          RETURN
        ENDIF
        DO 10 IR=1,NR1ST
          DO 20 IPART=1,NPPLG
            DO 30 IP=NPOINT(1,IPART),NPOINT(2,IPART)
              IF (ZMI.NE.666.) YWERT(IR,IP)=MAX(YWERT(IR,IP),ZMI)
              IF (ZMA.NE.666.) YWERT(IR,IP)=MIN(YWERT(IR,IP),ZMA)
              IF (ABS(YWERT(IR,IP)) < EPS30) YWERT(IR,IP)=0._DP
              WRITE (NRAPS+ifoff,*) YWERT(IR,IP)
   30       CONTINUE
   20     CONTINUE
   10   CONTINUE
C
C  icase=4
!PB      ELSEIF (LEVGEO.EQ.4.AND.LPTOR3(IBLD)) THEN
      ELSEIF (ICASE == 4) THEN
        LPTORR=.TRUE.
        IPTORR=MAX(1,IPROJ3(IBLD,ICURV))
        DO 60 I=1,NRKNOT
          IF (ZMI.NE.666.) YWERT1(I,1)=MAX(YWERT1(I,1),ZMI)
          IF (ZMA.NE.666.) YWERT1(I,1)=MIN(YWERT1(I,1),ZMA)
          IF (ABS(YWERT1(I,1)) < EPS30) YWERT1(I,1)=0._DP
          WRITE(NRAPS+ifoff,*) YWERT1(I,1)
   60   CONTINUE
C
C  icase=5
      ELSEIF ((LEVGEO.EQ.5).AND..NOT.LRPSCUT) THEN
        DO I=1,NCOORD
          IF (ZMI.NE.666.) YWERT1(I,1)=MAX(YWERT1(I,1),ZMI)
          IF (ZMA.NE.666.) YWERT1(I,1)=MIN(YWERT1(I,1),ZMA)
          IF (ABS(YWERT1(I,1)) < EPS30) YWERT1(I,1)=0._DP
          WRITE(NRAPS+ifoff,*) YWERT1(I,1)
        enddo
C
      ELSE
        WRITE (iunout,*) 'UNWRITTEN OPTION IN RPSCOL: PLOT ABANDONED '
      ENDIF
C
      CLOSE (UNIT=NRAPS+ifoff)
C
      IF (ALLOCATED(YWERT)) DEALLOCATE (YWERT)
      IF (ALLOCATED(YWERT1)) DEALLOCATE (YWERT1)

      RETURN
      END SUBROUTINE EIRENE_RPSCOL
