C  code segment contains: plgelr, plgelp
C
      SUBROUTINE EIRENE_PLGELR (AHALB,EP,ELL,TRI,DM,N,XX,YY,NRET,
     .                          THETA,NP)
C
C  THIS SUBROUTINE FITS A POLYGON OF LENGTH N
C  TO A RADIAL SURFACE (E.G.: ELLIPSE, CENTERED AT X=EP,Y=0.,...)
C  THE TWO SEMIAXES MEASURED FROM X=EP ARE:
C  AHALB: X DIRECTION, BHALB: Y DIRECTION
C  DM IS THE MINIMAL DISTANCE OF TWO POINTS FOR PLOTTING. E.G:
C  DM=0.01*MIN(CHXM,CHYM), IF PLGELL IS CALLED FROM SUBR. PLT2D
C  DM=0.0, IF PLGELL IS CALLED FORM SUBR. PLT3D


C  OUTPUT: XX(J),YY(J),J=1,NRET (ACTUAL NUMBER OF POINTS ON POLYGON,
C                                PROBABLY LESS THAN N)
C
      USE EIRMOD_PRECISION
      USE EIRMOD_CCONA

      IMPLICIT NONE

      REAL(DP), INTENT(IN) :: THETA(*)
      REAL(DP), INTENT(OUT) :: XX(*), YY(*)
      REAL(DP), INTENT(IN) :: AHALB, EP, ELL, TRI, DM
      INTEGER, INTENT(IN) :: N, NP
      INTEGER, INTENT(OUT) :: NRET
      REAL(DP) :: XOLD, YOLD, ATR, BTR, DX, XNEW, YNEW, DMM, XAD, XH,
     .          BHB, AHB
      INTEGER :: ICOU, I
C
      AHB=AHALB
      BHB=AHALB*ELL
      ATR=TRI
      BTR=-TRI*ELL
      IF (NP.GT.1) THEN
        DX=(THETA(NP)-THETA(1))/DBLE(N-1)
      ELSE
        DX=PI2A/DBLE(N-1)
      ENDIF
C  START AT THE RIGHTMOST POINT THETA(1)=0
      XOLD=EP+AHB*COS(THETA(1))+ATR*COS(THETA(1)*2.)
      YOLD=   BHB*SIN(THETA(1))+BTR*SIN(THETA(1)*2.)
      XX(1)=XOLD
      YY(1)=YOLD
      ICOU=1
C
      DO 100 I=2,N
        XAD=DBLE(I-1)*DX
        XH=THETA(1)+XAD
        XNEW=EP+AHB*COS(XH)+ATR*COS(2.*XH)
        YNEW=   BHB*SIN(XH)+BTR*SIN(2.*XH)
C
C   SKIP THIS PART?
        DMM=SQRT((XNEW-XOLD)**2+(YNEW-YOLD)**2)
        IF (DMM.LT.DM.AND.I.LT.N) GOTO 100
C   NO!
        ICOU=ICOU+1
        XX(ICOU)=XNEW
        YY(ICOU)=YNEW
        XOLD=XX(ICOU)
        YOLD=YY(ICOU)
  100 CONTINUE
C
      NRET=ICOU
      RETURN
      END SUBROUTINE EIRENE_PLGELR
C
      SUBROUTINE EIRENE_PLGELP

C  THIS SUBROUTINE FITS A POLYGON OF LENGTH N
C  TO A POLOIDAL SURFACE (E.G.: THETA=CONST, IF NLCRC,...)
C
      RETURN
      END SUBROUTINE EIRENE_PLGELP
