C  3D HISTOGRAM PLOT
C
      SUBROUTINE EIRENE_PL3DPG (ARR,IBLD,ICURV,
     .                   IX,IY,XX,YY,
     .                   TEXT1,TEXT2,TEXT3,LOGL,
     .                   ZMA,ZMI,W1,W2,
     .                   HEAD,RUNID,TXHEAD,TRC)

      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD
      USE EIRMOD_CPLOT
      USE EIRMOD_CPOLYG
      USE EIRMOD_CGRID
      USE EIRMOD_CGEOM
      USE EIRMOD_COMPRT, ONLY: IUNOUT

      IMPLICIT NONE
C
      INTEGER, PARAMETER :: LAR=46*128*128

      REAL(DP), INTENT(IN) :: XX(*), YY(*)
      REAL(DP), INTENT(INOUT) :: ARR(*)
      REAL(DP), INTENT(IN) :: ZMA, ZMI, W1, W2
      INTEGER, INTENT(IN) :: IBLD, ICURV, IX, IY
      LOGICAL, INTENT(IN) :: LOGL,TRC
      CHARACTER(72), INTENT(IN) :: TEXT1, HEAD, RUNID, TXHEAD
      CHARACTER(24), INTENT(IN) :: TEXT2, TEXT3

      REAL(DP) :: REMIN, REMAX, XMT, DX, YMI, YMA, RMI, RMA, AAR, XMINN,
     .          XMAXN, YMINN, YMAXN, YMT, XMI, XMA
      REAL(SP) :: AR(LAR), EXT(3,3), VALU(3,2)
      REAL(SP) :: XYZ(3,128,128)
      real(sp) :: yh
      INTEGER :: IR, IPX, IPY, IER, IPAN, IPEN, K, I, J
      CHARACTER(17) :: CH
      CHARACTER(20) :: CHAXS(3)
      EXTERNAL :: EIRENE_PLNXTB
      EXTERNAL :: GR3AXS, GR3DIM, GR3EXT, GR3NET, GR3PLO, GR3ROT,
     .            GRSCLC, GRSCLV, GRTXT, GRTXTC
C
      XYZ=-75.75E20
C
      IF (LEVGEO.LE.1.OR.LEVGEO.GT.3.OR..NOT.LPTOR3(IBLD)) THEN
        WRITE (iunout,*) 'PLOT OPTION NOT READY. RETURN FROM PL3DPG'
        RETURN
      ENDIF
C
      IPAN=1
      IPEN=NP2ND
C
C  SEARCH MINIMA AND MAXIMA OF INDEPENDENT VARIABLES X AND Y
C
      XMI=1.D60
      XMA=-1.D60
      YMI=1.D60
      YMA=-1.D60
      RMI=1.D60
      RMA=-1.D60
      DO 10 I=1,NR1ST
        DO J=1,NPPLG
          DO K=NPOINT(1,J),NPOINT(2,J)
            XMI=MIN(XMI,XPOL(I,K))
            XMA=MAX(XMA,XPOL(I,K))
            YMI=MIN(YMI,YPOL(I,K))
            YMA=MAX(YMA,YPOL(I,K))
C  SEARCH MINIMA AND MAXIMA OF DEPENDENT VARIABLE Z=ARR
            IF (K.LT.NPOINT(2,J).AND.I.LT.NR1ST) THEN
              IR=I+(K-1)*NR1ST
              IF (LOGL) THEN
                RMI=MIN(RMI,MAX(1.E-48_DP,ARR(IR)))
                RMA=MAX(RMA,MAX(1.E-48_DP,ARR(IR)))
                ARR(IR)=LOG10(MAX(1.E-48_DP,ARR(IR)))
              ELSE
                RMI=MIN(RMI,ARR(IR))
                RMA=MAX(RMA,ARR(IR))
              ENDIF
            ENDIF
          END DO
        END DO
   10 CONTINUE
C
      REMIN=ZMI
      REMAX=ZMA
      IF (LOGL) THEN
        IF (ZMI.EQ.666.) THEN
          REMIN=LOG10(RMI)
        ELSE
          REMIN=LOG10(MAX(1.E-48_DP,ZMI))
        ENDIF
        IF (ZMA.EQ.666.) THEN
          REMAX=LOG10(RMA)
        ELSE
          REMAX=LOG10(MAX(1.E-48_DP,ZMA))
        ENDIF
      ELSE
        IF (ZMI.EQ.666.) REMIN=RMI
        IF (ZMA.EQ.666.) REMAX=RMA
      ENDIF
C
      IF (TRC) THEN
        WRITE (iunout,*)
     .    'PL3DPG:  ,IPAN,IPEN,XMI,XMA,YMI,YMA,REMIN,REMAX'
        WRITE (iunout,*)
     .    '        ',IPAN,IPEN,XMI,XMA,YMI,YMA,REMIN,REMAX
      ENDIF
C
      IF (ABS(REMAX-REMIN)/MAX(REMAX,1.E-30_DP).LT.0.01)
     .    REMAX=REMIN+0.01*REMIN*SIGN(1._DP,REMIN)
C
C
      DX=MAX(ABS(XMA-XMI),ABS(YMA-YMI))*0.5
      XMT=0.5*(XMA+XMI)
      YMT=0.5*(YMA+YMI)
      XMINN=XMT-DX
      XMAXN=XMT+DX
      YMINN=YMT-DX
      YMAXN=YMT+DX
C
C     SET PLOT PARAMETER
C
C  DRDMPA(15) FOR EACH VALID PART, SEE BELOW
      CALL EIRENE_PLNXTB (1,'PL3DPG.F')
      CALL GRSCLC(10.,3.,34.,27.)
      CALL GRSCLV(2.,2.,26.,26.)
      CALL GR3DIM(LAR,IER)
C
      DO 30 K=1,NPPLG
        IPX=1
        DO 25 I=1,NR1ST-1
          IPY=1
          DO 20 J=NPOINT(1,K),NPOINT(2,K)-1
            IF (IPX+2.GT.128) GOTO 999
            IF (IPY+2.GT.128) GOTO 999
            XYZ(1,IPX+1,IPY+1)=REAL(XPOL(I,J),SP)
            XYZ(1,IPX+1,IPY+2)=REAL(XPOL(I,J+1),SP)
            XYZ(1,IPX+2,IPY+1)=REAL(XPOL(I+1,J),SP)
            XYZ(1,IPX+2,IPY+2)=REAL(XPOL(I+1,J+1),SP)
C
            XYZ(2,IPX+1,IPY+1)=REAL(YPOL(I,J),SP)
            XYZ(2,IPX+1,IPY+2)=REAL(YPOL(I,J+1),SP)
            XYZ(2,IPX+2,IPY+1)=REAL(YPOL(I+1,J),SP)
            XYZ(2,IPX+2,IPY+2)=REAL(YPOL(I+1,J+1),SP)
C
            IR=I+(J-1)*NR1ST
            AAR=ARR(IR)
            AAR=MAX(MIN(REMAX,AAR),REMIN)
            XYZ(3,IPX+1,IPY+1)=REAL(AAR,SP)
            XYZ(3,IPX+1,IPY+2)=REAL(AAR,SP)
            XYZ(3,IPX+2,IPY+1)=REAL(AAR,SP)
            XYZ(3,IPX+2,IPY+2)=REAL(AAR,SP)
            IPY=IPY+2
   20     CONTINUE
          IPX=IPX+2
   25   CONTINUE
C
        IF (IPX+1.GT.128) GOTO 999
        IF (IPY+1.GT.128) GOTO 999
        DO 26 I=2,IPY
          XYZ(1,1,I)=XYZ(1,2,I)
          XYZ(2,1,I)=XYZ(2,2,I)
          XYZ(3,1,I)=REAL(REMIN,SP)
          XYZ(1,IPX+1,I)=XYZ(1,IPX,I)
          XYZ(2,IPX+1,I)=XYZ(2,IPX,I)
          XYZ(3,IPX+1,I)=REAL(REMIN,SP)
   26   CONTINUE
        DO 27 I=2,IPX
          XYZ(1,I,1)=XYZ(1,I,2)
          XYZ(2,I,1)=XYZ(2,I,2)
          XYZ(3,I,1)=REAL(REMIN,SP)
          XYZ(1,I,IPY+1)=XYZ(1,I,IPY)
          XYZ(2,I,IPY+1)=XYZ(2,I,IPY)
          XYZ(3,I,IPY+1)=REAL(REMIN,SP)
   27   CONTINUE
        XYZ(1,1,1)=XYZ(1,2,2)
        XYZ(2,1,1)=XYZ(2,2,2)
        XYZ(3,1,1)=REAL(REMIN,SP)
        XYZ(1,IPX+1,1)=XYZ(1,IPX,2)
        XYZ(2,IPX+1,1)=XYZ(2,IPX,2)
        XYZ(3,IPX+1,1)=REAL(REMIN,SP)
        XYZ(1,IPX+1,IPY+1)=XYZ(1,IPX,IPY)
        XYZ(2,IPX+1,IPY+1)=XYZ(2,IPX,IPY)
        XYZ(3,IPX+1,IPY+1)=REAL(REMIN,SP)
        XYZ(1,1,IPY+1)=XYZ(1,2,IPY)
        XYZ(2,1,IPY+1)=XYZ(2,2,IPY)
        XYZ(3,1,IPY+1)=REAL(REMIN,SP)
        DO I=1,IPX+1
          DO J=1,IPY+1
            XYZ(1,I,J)=REAL((XYZ(1,I,J)-XMINN)/(XMAXN-XMINN),SP)
            XYZ(2,I,J)=REAL((XYZ(2,I,J)-YMINN)/(YMAXN-YMINN),SP)
            XYZ(3,I,J)=REAL((XYZ(3,I,J)-REMIN)/(REMAX-REMIN),SP)
          ENDDO
        ENDDO
        CALL GR3NET(AR,IER,128,XYZ,IPX+1,1,IPY+1,1,1,2)
   30 CONTINUE
      CALL GR3EXT(AR,IER,EXT)
      VALU(1,1)=REAL(XMI,SP)
      VALU(1,2)=REAL(XMA,SP)
      VALU(2,1)=REAL(YMI,SP)
      VALU(2,2)=REAL(YMA,SP)
      VALU(3,1)=REAL(REMIN,SP)
      VALU(3,2)=REAL(REMAX,SP)
      CHAXS(1) = ' '
      CHAXS(2) = ' '
      CHAXS(3) = ' '
      CALL GR3AXS(AR,IER,EXT,VALU,CHAXS,.FALSE.,4,1)
      CALL GR3ROT(AR,IER,'Z',REAL(W1,SP),
     .                   'X',REAL(W2,SP),'Y',0.0)
      CALL GR3PLO(AR,IER,'HID')
C
C     WRITE TEXT AND MEAN VALUE ONTO THE PLOT
C
      CALL GRSCLC (0.,0.,39.,28.)
      CALL GRSCLV (0.,0.,39.,28.)
      YH=27.5
      CALL GRTXT (1.,REAL(YH,SP),72,RUNID)
      YH=26.75
      CALL GRTXT (1.,REAL(YH,SP),72,HEAD)
      YH=26.00
      CALL GRTXT (1.,REAL(YH,SP),72,TXHEAD)
      YH=25.25
      CALL GRTXT (1.,REAL(YH,SP),10,'TALLY :  ')
      CALL GRTXTC (72,TEXT1)
      CALL GRTXT (1.,REAL(YH-0.5,SP),10,'SPECIES :')
      CALL GRTXTC (24,TEXT2)
      CALL GRTXT (1.,REAL(YH-1.,SP),10,'UNITS :   ')
      CALL GRTXTC (24,TEXT3)
      CALL GRTXT (1.,REAL(YH-2.,SP),10,'MAX. VALUE')
      WRITE (CH,'(1P,E10.3)') RMA
      CALL GRTXT (1.,REAL(YH-2.5,SP),10,CH)
      CALL GRTXT (1.,REAL(YH-3.,SP),10,'MIN. VALUE')
      WRITE (CH,'(1P,E10.3)') RMI
      CALL GRTXT (1.,REAL(YH-3.5,SP),10,CH)
C
      RETURN
  999 CONTINUE
      WRITE (iunout,*) 'NOT ENOUGH STORAGE FOR 3D HISTOGRAM PLOT'
      WRITE (iunout,*) 'REDUCE PLOT AREA'
      WRITE (iunout,*) 'PLOT ABANDONED'
      RETURN
      END SUBROUTINE EIRENE_PL3DPG
