      MODULE EIRMOD_PL3D
      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD
      USE EIRMOD_CPL3D
      USE EIRMOD_CPLOT

      IMPLICIT NONE
      PRIVATE

      PUBLIC :: EIRENE_PL3D, EIRENE_PL3D_REINIT
      INTEGER, SAVE :: IFIRST=0, IPBOX=0

      CONTAINS
C
C
      SUBROUTINE EIRENE_PL3D(PX,PY,PZ,PP1,PP2)

      IMPLICIT NONE

      REAL(DP), INTENT(IN) :: PX, PY, PZ
      REAL(DP), INTENT(OUT) :: PP1, PP2
      REAL(DP) :: X, Y, Z, COP, COT, SIP, SIT, PPY11, PPX11,
     .          YO, ZO, DY, DZ, CH, TH, PPX12, PPX13, PPX14, PPX21,
     .          PPX22, PPX23, PPX24, PPY12, PPY13, PPY14, PPY21, PPY22,
     .          PPY23, PPY24, DX, F00, F01, F02, F03, F10, F11, F12,
     .          BREITE, XMIN, YMIN, ZMIN, XMAX, YMAX, ZMAX, XO, W3, FA,
     .          BREI
      EXTERNAL :: EIRENE_LOCTOR, EIRENE_TORLOC
      EXTERNAL :: GRDRW, GRJMP, GRJMPS, GRMRKS, GRNWPN
      SAVE

      X=PX
      Y=PY
      Z=PZ
      XMIN = CH3X0-CH3MX
      YMIN = CH3Y0-CH3MY
      ZMIN = CH3Z0-CH3MZ
      XMAX = CH3X0+CH3MX
      YMAX = CH3Y0+CH3MY
      ZMAX = CH3Z0+CH3MZ
      BREITE = 24.
      IF (IFIRST.EQ.0) THEN
        IFIRST=1
        FA = ATAN(1.)/45.
        W3=SQRT(3.)
        XO=.5*(XMIN+XMAX)
        DX=XMAX-XMIN
        YO=.5*(YMIN+YMAX)
        DY=YMAX-YMIN
        ZO=.5*(ZMIN+ZMAX)
        DZ=ZMAX-ZMIN
        TH=FA*ANGLE2
        CH=FA*ANGLE1
        SIT=SIN(TH)
        SIP=SIN(CH)
        COT=COS(TH)
        COP=COS(CH)
        BREI=BREITE/W3
        F00=(.5+((XO/DX*SIP-YO/DY*COP)*SIT-ZO/DZ*COT)/W3)*BREITE
        F01=-SIP*SIT/DX*BREI
        F02=COP*SIT/DY*BREI
        F03=COT/DZ*BREI
        F10=(.5-(YO/DY*SIP+XO/DX*COP)/W3)*BREITE
        F11=COP/DX*BREI
        F12=SIP/DY*BREI
      ENDIF
      IF (PLBOX.AND.IPBOX.EQ.0) THEN
        IPBOX=1
        PP1 = FXI(CH3X0,CH3Z0)
        PP2 = FZETA(CH3X0,CH3Z0,CH3Y0)
        CALL GRMRKS(0.4)
        CALL GRNWPN(2)
        CALL GRJMPS(REAL(PP1),REAL(PP2),203)
        CALL GRMRKS(0.2)
        PPX11= FXI(XMIN,ZMIN)
        PPY11= FZETA(XMIN,ZMIN,YMIN)
        CALL GRJMP(REAL(PPX11,SP),REAL(PPY11,SP))
        PPX12 = FXI(XMAX,ZMIN)
        PPY12 = FZETA(XMAX,ZMIN,YMIN)
        CALL GRDRW(REAL(PPX12,SP),REAL(PPY12,SP))
        PPX13 = FXI(XMAX,ZMIN)
        PPY13 = FZETA(XMAX,ZMIN,YMAX)
        CALL GRDRW(REAL(PPX13,SP),REAL(PPY13,SP))
        PPX14 = FXI(XMIN,ZMIN)
        PPY14 = FZETA(XMIN,ZMIN,YMAX)
        CALL GRDRW(REAL(PPX14,SP),REAL(PPY14,SP))
        CALL GRDRW(REAL(PPX11,SP),REAL(PPY11,SP))
        PPX21= FXI(XMIN,ZMAX)
        PPY21= FZETA(XMIN,ZMAX,YMIN)
        CALL GRDRW(REAL(PPX21,SP),REAL(PPY21,SP))
        PPX22 = FXI(XMAX,ZMAX)
        PPY22 = FZETA(XMAX,ZMAX,YMIN)
        CALL GRDRW(REAL(PPX22,SP),REAL(PPY22,SP))
        PPX23 = FXI(XMAX,ZMAX)
        PPY23 = FZETA(XMAX,ZMAX,YMAX)
        CALL GRDRW(REAL(PPX23,SP),REAL(PPY23,SP))
        PPX24 = FXI(XMIN,ZMAX)
        PPY24 = FZETA(XMIN,ZMAX,YMAX)
        CALL GRDRW(REAL(PPX24,SP),REAL(PPY24,SP))
        CALL GRDRW(REAL(PPX21,SP),REAL(PPY21,SP))
        CALL GRJMP(REAL(PPX12,SP),REAL(PPY12,SP))
        CALL GRDRW(REAL(PPX22,SP),REAL(PPY22,SP))
        CALL GRJMP(REAL(PPX13,SP),REAL(PPY13,SP))
        CALL GRDRW(REAL(PPX23,SP),REAL(PPY23,SP))
        CALL GRJMP(REAL(PPX14,SP),REAL(PPY14,SP))
        CALL GRDRW(REAL(PPX24,SP),REAL(PPY24,SP))
        CALL GRNWPN(1)
      ENDIF
C
      IF (RMT.EQ.0.OR.WIN.EQ.WINJ) GOTO 1
C
C  TOROIDAL GEOMETRY, PLOT IN LOCAL COORDINATE SYSTEM AT WIN, BUT
C  X,Y,Z ARE GIVEN IN LOCAL COORDINATE SYSTEM AT WINJ
      CALL EIRENE_LOCTOR(WINJ,RMT,X,Z)
      CALL EIRENE_TORLOC(WIN,RMT,X,Z)
C
    1 CONTINUE
C
      PP1 = FXI(X,Z)
      PP2 = FZETA(X,Z,Y)

      RETURN

      CONTAINS

      FUNCTION FXI(X,Y)
      IMPLICIT NONE
      REAL(DP) :: FXI
      REAL(DP), INTENT(IN) :: X, Y

      FXI = (F10+F11*X)+F12*Y

      RETURN
      END FUNCTION FXI

      FUNCTION FZETA(X,Y,Z)
      IMPLICIT NONE
      REAL(DP) :: FZETA
      REAL(DP), INTENT(IN) :: X, Y, Z

      FZETA = ((F00+F01*X)+F02*Y)+F03*Z

      RETURN
      END FUNCTION FZETA

      END SUBROUTINE EIRENE_PL3D

C     the following SUBROUTINE is for reinitialization of EIRENE (DMH)

      SUBROUTINE EIRENE_PL3D_REINIT
      IMPLICIT NONE
      IFIRST = 0
      IPBOX = 0
      RETURN

      END SUBROUTINE EIRENE_PL3D_REINIT

      END MODULE EIRMOD_PL3D
