C
C
      SUBROUTINE EIRENE_CONE
     .  (X0,Y0,Z0,VX,VY,VZ,T1,T2,ALF,NK,NP,NA,IO,NF,NUM,
     .                 ILEFT,AL,IRIGHT,AR)
C
C  KEGELACHSE IST GERADE X+T*V, T1<T<T2, OEFFNUNGSWINKEL ALF
C  NK KREISE, NA STUETZSTELLEN AUF KREIS (POLYGON, NA-ECK)
C  NP ANZAHL DER LINIEN FUER PHI=CONST.
C  WENN ILEFT (IRIGHT) .NE. 0, DANN WIRD DER ERSTE (I=1, D.H.T=T1)
C  BZW DER LETZTE (I=NK, T=T2) KREIS DES KEGELS DURCH DIE SCHNITT-
C  FLAECHE DIESES KEGELS MIT DER GLEICHUNG
C  A(1)+A(2)*X+A(3)*Y+....+A(10)*Y*Z=0.
C  ERSETZT. T1 UND T2 SIND SO EINZUGEBEN, DASS DIE SCHNITTFLAECHEN
C  AUSSERHALB DIESES PARAMETERBEREICHES LIEGEN.
C  DABEI SIND NUR DIE ERSTEN ILEFT (IRIGHT) KOEFFIZIENTEN .NE.0
C  D.H. ILEFT (IRIGHT) <= 4 ENTSPRICHT DEM SCHNITT MIT EINER EBENE.
C
      USE EIRMOD_PRECISION
      USE EIRMOD_COMPRT, ONLY: IUNOUT
      USE EIRMOD_PL3D, ONLY: EIRENE_PL3D

      IMPLICIT NONE

      REAL(DP), INTENT(IN) :: X0, Y0, Z0, VX, VY, VZ, T1, T2
      REAL(DP), INTENT(IN) :: AL(10), AR(10)
      INTEGER, INTENT(IN) :: NK, NP, NA, IO, NUM, ILEFT, IRIGHT
      LOGICAL, INTENT(IN) :: NF
      REAL(DP), ALLOCATABLE :: XP(:), YP(:)
      REAL(DP) :: T, TH, PX, PY, PZ, DANG, CX, CY, CZ, BA, BB, BC, PXX,
     .          PYY, PZZ, PHI, RAD, XK, YK, ALF, AX, AY, AZ, BX, BY, BZ,
     .          PI, DT
      REAL(SP), ALLOCATABLE :: XPS(:), YPS(:)
      INTEGER :: I, IA, JJ, NAPK, IE, J
      EXTERNAL :: EIRENE_SCCONE, EIRENE_EXIT_OWN
      EXTERNAL :: GRFILL, GRLN, GRNWPN
C
      NAPK = MAX(NA,NP,NK) + 1
      ALLOCATE (XP(NAPK))
      ALLOCATE (YP(NAPK))
      ALLOCATE (XPS(NAPK))
      ALLOCATE (YPS(NAPK))
C
      IF (NK.EQ.1) THEN
        DT=0.
      ELSE
        DT=(T2-T1)/DBLE(NK-1)
      ENDIF
      PI=4.*ATAN(1.)
C
      AX=VX
      AY=VY
      AZ=VZ
      IF (ABS(AZ).GT.1.E-20) THEN
        BX=1.
        BY=1.
        BZ=-(AX+AY)/AZ
      ELSE IF (ABS(AX).GT.1.E-20) THEN
        BY=1.
        BZ=1.
        BX=-(AY+AZ)/AX
      ELSE IF (ABS(AY).GT.1.E-20) THEN
        BX=1.
        BZ=1.
        BY=-(AX+AZ)/AY
      ELSE
        WRITE (iunout,*) 'FEHLER IN DER EINGABE VON VX,VY,VZ ',
     .                    NUM,VX,VY,VZ
        CALL EIRENE_EXIT_OWN(1)
      ENDIF
      CX=AY*BZ-AZ*BY
      CY=AZ*BX-AX*BZ
      CZ=AX*BY-AY*BX
      BA=SQRT(AX*AX+AY*AY+AZ*AZ)
      BB=SQRT(BX*BX+BY*BY+BZ*BZ)
      BC=SQRT(CX*CX+CY*CY+CZ*CZ)
      AX=AX/BA
      AY=AY/BA
      AZ=AZ/BA
      BX=BX/BB
      BY=BY/BB
      BZ=BZ/BB
      CX=CX/BC
      CY=CY/BC
      CZ=CZ/BC
C
      DANG=2.*PI/DBLE(NA)
C  BERECHNE EINEN KREIS IN RICHTUNG DER ZYLINDERACHSE, MIT
C  DEM 0-PUNKT ALS MITTELPUNKT UND RADIUS RAD
C  SETZTE EINEN VERSCHIEBUNGSVEKTOR AUF DER ZYLINDERACHSE
C  INNERHALB DES BEREICHES T1----T2, FUER SHNITT-OPTION
      TH=(T1+T2)/2.
C PLOTTE DIE KREISE
      DO 2 I=1,NK
        T=T1+(I-1)*DT
        IF (I.EQ.1.AND.ILEFT.NE.0) THEN
          CALL EIRENE_SCCONE(X0,Y0,Z0,-VX,-VY,-VZ,ALF,
     .                TH,T1,BX,BY,BZ,CX,CY,CZ,
     .                DANG,AL,ILEFT,XP,YP,1,NA+1,1)
        ELSEIF (I.EQ.NK.AND.IRIGHT.NE.0) THEN
          CALL EIRENE_SCCONE(X0,Y0,Z0,VX,VY,VZ,ALF,
     .                TH,T2,BX,BY,BZ,CX,CY,CZ,
     .                DANG,AR,IRIGHT,XP,YP,1,NA+1,1)
        ELSE
          PX=X0+T*VX
          PY=Y0+T*VY
          PZ=Z0+T*VZ
          RAD=T*TAN(ALF)
          DO 3 J=1,NA+1
            PHI=(J-1)*DANG
            XK=RAD*COS(PHI)
            YK=RAD*SIN(PHI)
            PXX=XK*BX+YK*CX+PX
            PYY=XK*BY+YK*CY+PY
            PZZ=XK*BZ+YK*CZ+PZ
            CALL EIRENE_PL3D (PXX,PYY,PZZ,XP(J),YP(J))
    3     END DO
        ENDIF
        IF (IO.GE.2) CALL GRNWPN(IO)
        do 7 jj=1,na+1
          xps(jj)=real(xp(jj),sp)
          yps(jj)=real(yp(jj),sp)
    7   continue
        CALL GRLN (XPS,YPS,NA+1)
C  FAERBE DIE ENDEN DES CONES EIN
        IF ((I.EQ.1.OR.I.EQ.NK).AND.NF)
     .   CALL GRFILL(NA+1,XPS,YPS,1,1)
        IF (IO.GE.2) CALL GRNWPN(1)
    2 CONTINUE
C
C  SETZE NEUEN KREIS UM 0-PUNKT, MIT NP STUETZSTELLEN
      DANG=2.*PI/DBLE(NP)
C
C  PLOTTE PHI=CONST LINIEN, INSGESAMT NP STUECK
      IA=1
      IE=NK
      IF (ILEFT.NE.0) IA=2
      IF (IRIGHT.NE.0) IE=NK-1
      DO 5 J=1,NP
        IF (ILEFT.NE.0) THEN
          CALL EIRENE_SCCONE
     .     (X0,Y0,Z0,-VX,-VY,-VZ,ALF,TH,T1,BX,BY,BZ,CX,CY,CZ,
     .      DANG,AL,ILEFT,XP,YP,J,J,1)
        ENDIF
        DO 4 I=IA,IE
          T=T1+(I-1)*DT
          PX=X0+T*VX
          PY=Y0+T*VY
          PZ=Z0+T*VZ
          RAD=T*TAN(ALF)
          PHI=(J-1)*DANG
          XK=RAD*COS(PHI)
          YK=RAD*SIN(PHI)
          PXX=XK*BX+YK*CX
          PYY=XK*BY+YK*CY
          PZZ=XK*BZ+YK*CZ
          CALL EIRENE_PL3D (PXX+PX,PYY+PY,PZZ+PZ,XP(I),YP(I))
    4   CONTINUE
        IF (IRIGHT.NE.0) THEN
          CALL EIRENE_SCCONE
     .     (X0,Y0,Z0,VX,VY,VZ,ALF,TH,T2,BX,BY,BZ,CX,CY,CZ,
     .      DANG,AR,IRIGHT,XP,YP,J,J,NK)
        ENDIF
        do 9 jj=1,nk
          xps(jj)=real(xp(jj),sp)
          yps(jj)=real(yp(jj),sp)
    9   continue
        CALL GRLN (XPS,YPS,NK)
    5 CONTINUE

      DEALLOCATE (XP)
      DEALLOCATE (YP)
      DEALLOCATE (XPS)
      DEALLOCATE (YPS)

      RETURN
      END SUBROUTINE EIRENE_CONE
