C  27. 6.05:  test for photon secondaries added
c  15.12.05:  irds --> irei,  comments
cdr Nov. 15:  comments re zep_in added
!pb APR  16:  eatds -> eatei
!pb APR  16:  emlds -> emlei
!pb APR  16:  eiods -> eioei
!pb JUL  16:  ehvds1 -> ehvei1
cdr june 17:  comments
cdr ?         connect with fehvei1 function for storage saving mode
C
      SUBROUTINE EIRENE_VELOEI(K,IREI,VXO,VYO,VZO,VLO,ZEP_IN)
C  AN ELECTRON IMPACT PROCESS NO. IREI HAS BEEN IDENTIFIED IN CALLING PROGRAM
C
C  FETCH A NEW SPECIES INDEX (SAMPLING FROM CUMULATIVE DISTR. P2ND)
C          AND A NEW VELOCITY OF TEST PARTICLE AFTER ELECTRON IMPACT COLLISION
C          IS SAMPLED FROM AN ISOTROPIC DISTRIBUTION IN THE CENTER OF MASS FRAME
C  AT THIS POINT: ONE NEXT GENERATION TEST PARTICLE WILL BE BORN
C                 I.E. WEIGHT ADJUSTMENT ALREADY DONE IN CALLING PROGRAM
C  NOTE: IN CASE OF EXACTLY TWO HEAVY FRAGMENTS, THEIR VELOCITIES SHOULD BE
C        OPPOSITE (NEGATIVELY CORRELATED) IN THE CENTER OF MASS FRAME
C  TBD:  DISTINCT FROM VELOEL, VELOPI, VELOCX HERE WE DO NOT SAMPLE
C        AN INDIVIDUAL COLLIDING ELECTRON (E.G. FROM A DRIFTING MAXWELLIAN
C        OR, BETTER, FROM SIGMA(VE)*VE*FMAXW/RATE-COEF)
C        TO DETERMINE (AT LEAST TO CONSTRAIN) POST-COLLISION KINETICS.
C        IN THAT LATTER CASE ONE WOULD AUTOMATICALLY ONLY FIND ELECTRONS ABOVE
C        THRESHOLD.
C        INSTEAD HERE, AT A GIVEN TE, SO FAR A CONSTANT (MEAN) ELECTRON ENERGY
C        TRANSFER IS ASSUMED, RESULTING IN MONOENERGETIC (IN COM-FRAME)
C        POST-COLLISION DISTRIBUTIONS: EDISS=EFRAC*EHEAVY
C

C
C  K   : CURRENT CELL INDEX
C  VXO : X COMPONENT OF SPEED UNIT VECTOR OF TEST PARTICLE BEFORE EVENT
C  VYO : Y COMPONENT OF SPEED UNIT VECTOR OF TEST PARTICLE BEFORE EVENT
C  VZO : Z COMPONENT OF SPEED UNIT VECTOR OF TEST PARTICLE BEFORE EVENT
C  VLO : VELOCITY OF TEST PARTICLE BEFORE EVENT

C
cdr ADDED AT SOME LATER STAGE: ZEP_IN:  if 0.0 < zep_in < 1.0, THEN
C   THIS NUMBER IS USED TO IDENTIFY THE SECONDARY TEST PARTICLE SPECIES.
C   ZEP_IN MAY BE A RANDOM NUMBER FROM CALLING PROGRAM, OR A FIXED NUMBER TO
C   ENFORCE A PARTICULAR SECONDARY SPECIES
C

      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD
      USE EIRMOD_COMUSR
      USE EIRMOD_CCONA
      USE EIRMOD_CRAND
      USE EIRMOD_CZT1
      USE EIRMOD_COMPRT
      USE EIRMOD_COMXS
      USE EIRMOD_RANF, ONLY: RANF_EIRENE

      IMPLICIT NONE

      REAL(DP), INTENT(IN) :: VXO, VYO, VZO, VLO, ZEP_IN
      INTEGER, INTENT(IN) :: K, IREI
      REAL(DP) :: EIRENE_FEHVEI1, VXDIS, VYDIS, VZDIS, EHEAVY,
     .            VX, VY, VZ,
     .            VELQ, CVRSS, RSQDV, EFRAC, EDISS, ZEP3, VELDS
ctk      REAL(DP), EXTERNAL :: RANF_EIRENE
      INTEGER :: ISPZI, ISPZM, ISPZA, JATM, JMOL, JION
      EXTERNAL :: EIRENE_FEHVEI1, EIRENE_FISOTR, EIRENE_EXIT_OWN

      IF ((ZEP_IN > 0._DP) .AND. (ZEP_IN <= 1._DP)) THEN
        ZEP3 = ZEP_IN
      ELSE ! zep_in = 0.0,
cdr  random sampling of post-collision species from discrete P2ND cumulative distribution
        ZEP3=RANF_EIRENE( )
      END IF

C
C  FIND TYPE OF NEXT GENERATION TEST PARTICLE (PHOTON, ATOM, MOLECULE, TEST ION)
C  BY SAMPLING FROM P2ND(IREI,...)
C  ALSO SET EFRAC: FRACTION OF KINETIC ENERGY RELEASE (KER) ASSIGNED TO PARTICULAR
C                  NEXT GENERATION PARTICLE
C
      IF (ZEP3.LE.P2ND(IREI,NSPH)) THEN
C
C  A PHOTON IS BORN, FIND SPECIES INDEX IPHOT AND VELOCITY
C
C  OPTION NOT WRITTEN
        WRITE (iunout,*) 'INVALID OPTION IN VELOEI. CALL EIRENE_EXIT '
        CALL EIRENE_EXIT_OWN(1)
C
      ELSEIF (ZEP3.LE.P2ND(IREI,NSPA)) THEN
C
C  A NEUTRAL ATOM IS BORN, FIND SPECIES INDEX IATM AND WEIGHT
C
        ITYP=1
        DO 448 JATM=1,NATMIM
          IATM=JATM
          ISPZA=NSPH+IATM
          IF (ZEP3.LE.P2ND(IREI,ISPZA)) GOTO 449
  448   CONTINUE
        IATM=NATMI
  449   CONTINUE
        CVRSS=CVRSSA(IATM)
        RSQDV=RSQDVA(IATM)
        EFRAC=EATEI(IREI,IATM,2)
C
      ELSEIF (ZEP3.LE.P2ND(IREI,NSPAM)) THEN
C
C  A NEUTRAL MOLECULE IS BORN, FIND SPECIES INDEX IMOL AND WEIGHT
C
        ITYP=2
        DO 458 JMOL=1,NMOLIM
          IMOL=JMOL
          ISPZM=NSPA+IMOL
          IF (ZEP3.LE.P2ND(IREI,ISPZM)) GOTO 459
  458   CONTINUE
        IMOL=NMOLI
  459   CONTINUE
        CVRSS=CVRSSM(IMOL)
        RSQDV=RSQDVM(IMOL)
        EFRAC=EMLEI(IREI,IMOL,2)
C
      ELSEIF (ZEP3.LE.P2ND(IREI,NSPAMI)) THEN
C
C  A TEST ION IS BORN, FIND SPECIES INDEX IION AND WEIGHT
C
        ITYP=3
        DO 468 JION=1,NIONIM
          IION=JION
          ISPZI=NSPAM+IION
          IF (ZEP3.LE.P2ND(IREI,ISPZI)) GOTO 469
  468   CONTINUE
        IION=NIONI
  469   CONTINUE
        CVRSS=CVRSSI(IION)
        RSQDV=RSQDVI(IION)
        EFRAC=EIOEI(IREI,IION,2)
C
      ELSE
        WRITE (iunout,*) 'ERROR IN VELOEI '
        WRITE (IUNOUT,*) 'NPANU ',NPANU
        WRITE (iunout,*) 'IREI ',IREI,P2ND(IREI,NSPAMI)
        CALL EIRENE_EXIT_OWN(1)
      ENDIF
C
      IF (NSTORDR >= NRAD) THEN
        EHEAVY=EHVEI1(IREI,K)
      ELSE
        EHEAVY=EIRENE_FEHVEI1(IREI,K)
      END IF

C  ENERGY IN CENTER OF MASS FRAME
      EDISS=EFRAC*EHEAVY
C
C  FIND SPEED VECTOR FROM ISOTROPIC DISTRIBUTION IN CENTER OF MASS
C  SYSTEM. COM IS TAKEN TO BE INCIDENT TEST PARTICLE; BECAUSE OF SMALL ELECTRON MASS
C

      IF (EDISS.GT.0.D0) THEN
C
C  NEXT LINES: E-NEW=E-OLD+EDIS, ON AVERAGE
C
        IF (INIV3.EQ.0) CALL EIRENE_FISOTR
C
        VXDIS=FI1(INIV3)
        VYDIS=FI2(INIV3)
        VZDIS=FI3(INIV3)
        INIV3=INIV3-1
C
        VELDS=SQRT(EDISS)*RSQDV
        VX=VLO*VXO+VELDS*VXDIS
        VY=VLO*VYO+VELDS*VYDIS
        VZ=VLO*VZO+VELDS*VZDIS
        VELQ=VX*VX+VY*VY+VZ*VZ
        VEL=SQRT(VELQ)
        VELX=VX/VEL
        VELY=VY/VEL
        VELZ=VZ/VEL
      ELSE
        VELX=VXO
        VELY=VYO
        VELZ=VZO
        VEL=VLO
        VELQ=VEL*VEL
      ENDIF
      E0=CVRSS*VELQ
C
      RETURN
      END SUBROUTINE EIRENE_VELOEI
