C  sept 2014: few minor comments
c
c  "weight" moved to argument list as "WGHTVS" (removed: use parmmod, use comprt, use ccona)
c  drift vector: vxwl,vywl,vzwl,vwl: intent(in). Do not modify ! (rather than intent(inout))

      SUBROUTINE EIRENE_VELOCS(WGHTVS,
     .   TIWL,ESHET,VWL,VXWL,VYWL,VZWL,RSQDV,CVRSS,
     .   CX,CY,CZ,
     .   E0S,VELXS,VELYS,VELZS,VELS)
C
C  FETCH A NEW VELOCITY FROM A MAXWELLIAN FLUX AT A SURFACE GIVEN
C  BY THE NORMAL: CX,CY,CZ
C  METHOD: WEIGHTED SAMPLING FROM NON-DRIFTING MAXWELLIAN AT NON-ANALOG TEMPERATURE
C
C  THE MAXWELLIAN IS DEFINED BY A TEMPERATURE TIWL (EV) AND A
C  DRIFT VECTOR VXWL,VYWL,VZWL (CM/SEC). VWL IS THE VECTOR
C  NORM OF THIS DRIFT VECTOR, AND IS NEEDED ONLY TO DECIDE, WHETHER
C  THERE IS A DRIFT AT ALL (VWL.GT.0) OR NOT (VWL.LE.0.).

C  UNIT CONVERSION FACTORS:
C  THE STANDARD DEVIATION OF THE MAXWELLIAN: SIGMA(CM/S) = SQRT(T/M)*1.38912E6/SQRT(2)
C                                                        = SQRT(T/M)*CVEL2A
C  WITH T IN EV, M IN AMU.

C  TIWL = T, TEMPERATURE IN EV,
C  RSQDV= CVELAA/SQRT(M)=1.38912E6/SQRT(M)  [CM/S] , M THE MASS IN AMU
c  CVRSS= 1/RSQDV**2 = M * CVELI2 = M *1/(1.39812E6)**2, AGAIN M = MASS IN AMU

C  THE PARTICLE MAY BE ACCELERATED PERPENDICULAR
C  TOWARDS THE TARGET BY A SHEATH POTENTIAL V WITH ENERGY eV = ESHET (EV)
C  (IF ESHET.GT.0.)
C  OUTPUT ENERGY, SPEED UNIT VECTOR AND VELOCITY ARE, RESP.:
C         E0S,    VELXS,VELYS,VELZS AND VELS
C         ALSO RETURNED: STAT. WEIGHT OF SAMPLE: WGHT_NEW = WGHTVS = WGHT_OLD * FACTOR.
C
      USE EIRMOD_PRECISION
C     USE EIRMOD_PARMMOD
C     USE EIRMOD_CCONA
      USE EIRMOD_CRAND
C     USE EIRMOD_COMPRT
      USE EIRMOD_RANF, ONLY: RANF_EIRENE

      IMPLICIT NONE
      REAL(DP), INTENT(IN) :: TIWL, ESHET, RSQDV, CVRSS, CX, CY, CZ,
     .                        VXWL, VYWL, VZWL, VWL
      REAL(DP), INTENT(INOUT) :: WGHTVS
      REAL(DP), INTENT(OUT) :: E0S, VELXS, VELYS, VELZS, VELS
      REAL(DP) :: ARBV, A1, A2, A3, A4, A5, A6,
     .          VLLX, VLLY, VLLZ, VMX, SHIFT,
     .          CCM, FNOM, VMXSQ, FACTOR, VELSQ, VELSH,
     .          VFKT, VLX, RCCM, ZARG, ZARG2, VXDR, VYDR, VZDR,
     .          PISQ, SQ2I
ctk      REAL(DP), EXTERNAL :: RANF_EIRENE
      DATA PISQ/1.772454_DP/  ! sqrt(pi)
      DATA SQ2I/0.707107_DP/  ! 1/sqrt(2)
#ifdef PGF90
      REAL(DP) :: DERF
#endif
      EXTERNAL :: EIRENE_FMAXWL, EIRENE_ROTATF, EIRENE_ROTATI
C
C---------------------------------------------------------------------
C
      IF (INIV1.EQ.0) CALL EIRENE_FMAXWL
C
      ZARG2=SQRT(TIWL)*RSQDV  ! THERMAL VELOCITY,
                              ! sqrt(2 kT/m) in cm/s
      ZARG=ZARG2*SQ2I         ! STANDARD DEVIATION IN GAUSSIAN:
                              ! sqrt(kT/m) in cm/s
C
C  ROTATE DRIFT VELOCITY VXWL,VYWL,VZWL FROM A GLOBAL CARTESIAN
C  INTO A CARTESIAN COORDINATE SYSTEM, IN WHICH THE TARGET NORMAL
C  IS NOW IN THE POSITIVE X-DIRECTION
C
      IF (VWL.GT.0.D0) THEN
        CALL EIRENE_ROTATI(VXWL,VYWL,VZWL,VXDR,VYDR,VZDR,CX,CY,CZ)
      ELSE
        VXDR=0.
        VYDR=0.
        VZDR=0.
      ENDIF
C
C  FROM NOW ON: TARGET NORMAL IS IN X DIRECTION, AND VXDR,VYDR,VZDR
C               IS THE PLASMA DRIFT VELOCITY IN THIS COORDINATE SYSTEM
C
C  MAXWELLIAN FLUX + DRIFT CONTRIBUTION
C  AT THIS POINT: THE SURFACE NORMAL IS IN THE POSITIVE X DIRECTION
C

      VLLX=FM1(INIV1)*ZARG
      VLLY=FM2(INIV1)*ZARG+VYDR
      VLLZ=FM3(INIV1)*ZARG+VZDR
      INIV1=INIV1-1
C  WEIGHT CORRECTION DUE TO DRIFT COMPONENT VXDR IN MAXWELLIAN FLUX:
C  NORMALIZED DRIFT COMPONENT    VMX=VXDR/ZARG2
C  NORMALIZED THERMAL COMPONENT  VLX=VLLX/ZARG2

C  IN CASE OF STATIONARY MAXWELLIAN: NOTHING MORE TO BE DONE

      IF (VXDR.NE.0.D0) THEN
        VMX=VXDR/ZARG2
        CCM=0.6026*VMX
        IF (CCM.GE.1.) THEN
C         WRITE (iunout,*) 'WARNING FROM SUBR. VELOCS:'
C         WRITE (iunout,*) 'MACH NUMBER PERP. TO TARGET TOO LARGE FOR'
C         WRITE (iunout,*) 'RANDOM SAMPLING ALGORITHM, M-PERP= ',VMX
C         WRITE (iunout,*) 'ARTIFICIAL CUT-OFF IS USED! '
C         CCM=0.95
C         VMX=CCM/0.6026
CDR USE REJECTION TECHNIQUE RATHER THAN WEIGHT CORRECTION TECHNIQUE
C         WEIGHT=1.
          VLLX=VXDR
          SHIFT=VMX
C  REJECTION LOOP STARTS HERE
  100     ARBV=RANF_EIRENE()*(SHIFT+4.)
          A1=SQRT(SHIFT**2+2.)
          A2=SHIFT+A1
          A3=SHIFT-A1
          A4=0.5+0.5*SHIFT*A3
          A5=A4-(ARBV-SHIFT)**2
          A6=EXP(A5)
          VFKT=2.*ARBV/A2*A6
          IF(RANF_EIRENE().GT.VFKT) GOTO 100
C   ACCEPT X-VELOCITY COMPONENT
          VLLX=ARBV*ZARG2
          GOTO 1000
CDR
        ENDIF
        RCCM=1./(1.-CCM)
        VLLX=VLLX*SQRT(RCCM)
        VLX=VLLX/ZARG2
C
        VMXSQ=-VMX*VMX
        FNOM=EXP(VLX*(VMX+VMX-CCM*VLX))*RCCM
#ifdef PGF90
        FACTOR=FNOM/(1.+VMX*PISQ*(1.+DERF(VMX))/EXP(VMXSQ))
#else
        FACTOR=FNOM/(1.+VMX*PISQ*(1.+ERF(VMX))/EXP(VMXSQ))
#endif
        WGHTVS=WGHTVS*FACTOR
      ENDIF

 1000 CONTINUE
C
C  SHEATH CONTRIBUTION: ADD A COMPONENT TO X-VELOCITY VLLX (CM/S),
C                       SUCH THAT ENERGY OF INCIDENT ION IS INCREASED BY
C                       ESHET (EV)
C
      IF (ESHET.GT.0.D0) THEN
        VELSH=SQRT(ESHET)*RSQDV
        VLLX=SQRT(VELSH**2+VLLX**2)
      ENDIF

C  NOW ROTATE BACK INTO GLOBAL CARTESIAN COODINATE SYSTEM

      CALL EIRENE_ROTATF(VELXS,VELYS,VELZS,VLLX,VLLY,VLLZ,CX,CY,CZ)
C
C  NORMALIZE CARTESIAN SPEED VECTOR, SET VEL=VELS(CM/S)  AND E0=E0S (EV)
      VELSQ=VELXS*VELXS+VELYS*VELYS+VELZS*VELZS
      VELS=SQRT(VELSQ)
      VELXS=VELXS/VELS
      VELYS=VELYS/VELS
      VELZS=VELZS/VELS
      E0S=CVRSS*VELSQ
C
      RETURN
      END SUBROUTINE EIRENE_VELOCS
