C    AUG. 05: NCELL UPDATED FOR SPLITTING AND THEN RESET
!pb 08.11.06: definition of splitting arrays changed
!             RSPLST(NLEVEL,1:NPARTC) --> RSPLST(1:NPARTC,NLEVEL)
!             ISPLST(NLEVEL,1:MPARTC) --> ISPLST(1:MPARTC,NLEVEL)
cdr Nov. 17 : remove call to STORE.F
cdr 2022
cdr nlevel.lt.maxlev is ensured in calling program
cdr Does that mean that RR cannot happen for NLEVEL=MAXLEV?
cdr Try to re-vive splitting and RR schemes.
cdr Procedure invalid for LEVGEO GT 3

C
!pb   SUBROUTINE EIRENE_SPLTRR(IDIM,MS,NINC,*,*)
      SUBROUTINE EIRENE_SPLTRR(IDIM,MS,NINC,IRET)
C
C  SPLITTING AND RUSSIAN ROULETTE SURFACE, called from FOLNEUT.
C  A SPLITTING SURFACE HAS BEEN REACHED, REMAINING FLIGHT DISTANCE: ZT.

C  IF SPLITTING:
C  1) PUSH PARTICLE TO SPLITTING SURFACE
C  2) SPLIT PARTICLE
C  3) RESET ORIGINAL PARTICLE COORDINATES.
cdr  input : nlevel
cdr  output: nlevel=nlevel+1, nodes(nlevel) is set.

C  IF RUSSIAN ROULETTE:
C  EITHER KILL PARTICLE, OR CONTINUE FLIGHT WITH INCREASED WEIGHT
cdr  input : weight
cdr  output: weight=weight*znu,  nlevel and nodes(nlevel) are unchanged
C
C  IDIM  =1: RADIAL SURFACE
C        =2: POLOIDAL SURFACE
C        =3: TOROIDAL SURFACE
C        =4: ADDITIONAL SURFACE
C        =0: NOT ON ANY SURFACE
C  NINC    : DECIDE SPLITTING OR RUSSIAN ROULETTE FROM SIGN OF NINC*IG,
C            IG BEING A SURFACE PROPERTY

C  RETURN: IRET = 1, SPLIT AND CONTINUE FLIGHT
C  RETURN: IRET = 2, STOP FLIGHT, BECAUSE OF RUSSIAN ROULETTE
C
C  SPLITTING AND RUSSIAN ROULETTE SURFACE MS
C
      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD
      USE EIRMOD_COMPRT
      USE EIRMOD_COMSPL
      USE EIRMOD_CGRID
      USE EIRMOD_RANF, ONLY: RANF_EIRENE
      USE EIRMOD_PLT2D, ONLY: EIRENE_CHCTRC

      IMPLICIT NONE

      INTEGER, INTENT(IN) :: IDIM, MS, NINC
      INTEGER, INTENT(OUT) :: IRET
      REAL(DP) :: XNU, XM, YM, ZM, ZNU1, ZEP1, ZNU, X0S, Y0S, Z0S,
     .            TIMES
      INTEGER :: IPOLGS, MASRFS, MSURFS, J, IADD, NU, IG, NCELLS

      IRET = 0
      IF (IDIM.EQ.1) THEN
        IADD=0
      ELSEIF (IDIM.EQ.2) THEN
        IADD=N1ST
      ELSEIF (IDIM.EQ.3) THEN
        IADD=N1ST+N2ND
      ELSEIF (IDIM.EQ.4) THEN
        IADD=N1ST+N2ND+N3RD
      ELSE
      ENDIF
C
      ZNU=ABS(RNUMB(IADD+MS))
      NU=NINT(ZNU)
      IG=NINT(SIGN(1._DP,RNUMB(IADD+MS)))
C
C  RUSSIAN ROULETTE?
      IF(NINC*IG.GT.0) GO TO 340
C
C  NO - SPLIT PARTICLE

C  PUSH PARTICLE TO SPLITTING POSITION (DISTANCE ZT)
C  THEN SPLIT,
C  THEN RESTORE OLD POSITION (STARTING POINT OF TRACK)

      X0S=X0
      Y0S=Y0
      Z0S=Z0
      TIMES=TIME
      NCELLS=NCELL
C
      X0=X0+VELX*ZT
      Y0=Y0+VELY*ZT
      Z0=Z0+VELZ*ZT
      TIME=TIME+ZT/VEL
      NCELL=NRCELL+((NPCELL-1)+(NTCELL-1)*NP2T3)*NR1P2+NBLCKA
C
C SPECIFIC FOR SPLITTING AT RADIAL SURFACES:
C
      MASRFS=MASURF
      MSURFS=MSURF
      IPOLGS=IPOLG
C
      IPOLG=IPOLGN
      MASURF=0
      MSURF=0
C
      IF (NLTRC) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP CRITICAL
#endif
       CALL EIRENE_CHCTRC(X0,Y0,Z0,16,9)
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP END CRITICAL
#endif
      ENDIF
C
C
      NLEVEL=NLEVEL+1
C  IS SPLITTING PARAMETER AN INTEGER?
      IF (NU.NE.ZNU) THEN
        XNU=ZNU-DBLE(NU)
        IF (RANF_EIRENE( ).LT.XNU) NU=NU+1
      ENDIF
C
C   SPLIT INTO SEVERAL PARTICLES WITH REDUCED WEIGHT
C   SAVE LOCATION, WEIGHT AND OTHER PARAMETERS AT CURRENT LEVEL
      WEIGHT=WEIGHT/ZNU
      DO 333 J=1,NPARTC
        RSPLST(J,NLEVEL)=RPST(J)
  333 CONTINUE
      DO 334 J=1,MPARTC
        ISPLST(J,NLEVEL)=IPST(J)
  334 CONTINUE
C  NUMBER OF NODES AT THIS LEVEL
      NODES(NLEVEL)=NU

C  RESTORE SOME PARTICLE COORDINATES,
C  because the push to surface will be done in calling program as well.
      X0=X0S
      Y0=Y0S
      Z0=Z0S
      TIME=TIMES
      NCELL=NCELLS
C
C  SPECIFIC FOR SPLITTING ON RADIAL SURFACES:
      MASURF=MASRFS
      MSURF=MSURFS
      IPOLG=IPOLGS
C
C  CONTINUE THE OLD TRACK WITH REDUCED WEIGHT
      IRET = 1
      RETURN
C
C   RUSSIAN ROULETTE
C
  340 CONTINUE
C  PROBABLITY OF DEATH
      ZNU1=1.0/ZNU
      ZEP1=RANF_EIRENE( )
C  IS THIS PARTICLE TO BE KILLED
      IF (ZEP1.LT.ZNU1) THEN
C  NO   INCREASE WEIGHT AND CONTINUE TRACKING
        WEIGHT=WEIGHT*ZNU
        IRET = 1
        RETURN
      ENDIF
C
C  YES   KILL PARTICLE AND STOP FLIGHT
C
      IF (NLTRC) THEN
        XM=X0+VELX*ZT
        YM=Y0+VELY*ZT
        ZM=Z0+VELZ*ZT
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP CRITICAL
#endif
        CALL EIRENE_CHCTRC(XM,YM,ZM,16,10)
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP END CRITICAL
#endif
      ENDIF
      LGPART=.FALSE.
      IRET = 2
      RETURN
      END SUBROUTINE EIRENE_SPLTRR
