C
      SUBROUTINE EIRENE_FOLSTAT_NEUT(IC_PART,VLX,VLY,VLZ,CFLAG,IRET)
C  FOLLOW NEUTRALS IN STATIC LOOP

C  IN CALLING PROGRAM ALREADY VERIFIED: FINITE CHANCE TO LEAVE STATIC LOOP.
C  IFPATH=1.
C  NRC>0, --> ZMFP NOT INFINITY
C  FURTHER: IF ONLY ELASTIC COLLISION, THEN STATIC LOOP CANNOT BE LEFT, INFINITE LOOP.
C  ALSO: NOT LGVAC(NCELL)
C
      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD
      USE EIRMOD_COMUSR
      USE EIRMOD_COMPRT
      USE EIRMOD_CLOGAU
      USE EIRMOD_CCONA
      USE EIRMOD_CTRCEI
      USE EIRMOD_CUPD
      USE EIRMOD_CGRID
      USE EIRMOD_CPOLYG
      USE EIRMOD_CTRIG
      USE EIRMOD_CTETRA
      USE EIRMOD_CSPEZ
      USE EIRMOD_COMXS
      USE EIRMOD_CFPLK
      USE EIRMOD_COUTAU
      USE EIRMOD_CLGIN
      USE EIRMOD_PLT2D, ONLY: EIRENE_CHCTRC
CYM FOLLOWING PGI COMPILATION
      USE EIRMOD_ADDCOL, ONLY: EIRENE_ADDCOL
      USE EIRMOD_STDCOL, ONLY: EIRENE_STDCOL

      IMPLICIT NONE
      REAL(DP), INTENT(IN) :: VLX,VLY,VLZ
      INTEGER,  INTENT(IN) :: IC_PART ! = IC_ION OR IC_NEUT,
                                      ! FROM CALLING PROGRAMS
                                      ! FOLION, FOLNEUT, RESP.
      INTEGER,  INTENT(OUT) :: IRET

      REAL(DP) :: CFLAG(7,MSTOR0)
      REAL(DP) :: XSTOR2(MSTOR1,MSTOR2,N2ND+N3RD),
     .            XSTORV2(NSTORV,N2ND+N3RD)
      REAL(DP) :: SCOS_NEW, ZMFP, SG,
     .            EIRENE_FPATH
      INTEGER :: ISTS, IFLAG, IRT
      EXTERNAL :: EIRENE_UPDATE, EIRENE_UPDATE_SPECTRUM,
     .            EIRENE_FPATH

      IRET = 0

c  particle enters the static loop, NFOL$(ISPZ)=-1

      IF (IC_PART.EQ.1.AND.NLTRC.AND.TRCHST) THEN
!FIRST ENTRY TO STATIC LOOP
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP CRITICAL
#endif
        WRITE (iunout,*) 'TRAJECTORY ENTERS STATIC LOOP, ITYP=', ITYP
        CALL EIRENE_CHCTRC(X0,Y0,Z0,0,21)
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP END CRITICAL
#endif
      ELSEIF (NLTRC.AND.TRCHST.and.ic_part.le.10) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP CRITICAL
#endif
        WRITE (iunout,*) 'neut static generation ic_part=',ic_part
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP END CRITICAL
#endif
      ENDIF

C***********************************************************************
C  STATIC APPROXIMATION
C  SIMULATE NEXT COLLISION (OR SURFACE EVENT) INSTANTANEOUSLY
C***********************************************************************

C  WEIGHT TOO SMALL? STOP HISTORY
      IF (WEIGHT.LT.EPS30) THEN
        LGPART=.FALSE.
        IRET = 0
        RETURN
      ENDIF
C
C  PARTICLE ON SURFACE ?
      IF (NLSRFX.OR.NLSRFY.OR.NLSRFZ.OR.NLSRFA) THEN
C  EMITTED  ?  CALL COLLIDE, AFTER UPDATE
        IF (IC_PART.EQ.1) THEN
C  FIRST ENTRY INTO "STATIC LOOP", ALWAYS: EMITTED FROM SURFACE
C    (CRTXG,....,...): NORMAL RELATIVE TO DEFAULT SETTINGS
C                      NEEDED LATER IF PARTICLE LEAVES STATIC LOOP
C                      VIA STDCOL OR ADDCOL
          CRTXG=CRTX*SCOS
          CRTYG=CRTY*SCOS
          CRTZG=CRTZ*SCOS
          SCOS = SIGN(1.D0,VLX*CRTXG+VLY*CRTYG+VLZ*CRTZG)
          SCOS_SAVE = SCOS
          SCOS_NEW  = SCOS
C  INCIDENT OR EMITTED DURING STATIC LOOP?
C  CALL ESCAPE OR CALL COLLIDE, AFTER UPDATE
        ELSE
          SCOS_NEW = SIGN(1.D0,VLX*CRTXG+VLY*CRTYG+VLZ*CRTZG)
        ENDIF

      ELSE
C  PARTICLE NOT ON SURFACE
        SCOS_SAVE = SCOS
        SCOS_NEW  = SCOS
      ENDIF
C
      NCOU=1
      IF (NR1P2 == 0) THEN
        NUPC(1)=0
      ELSE
        NUPC(1)=(NCELL-NRCELL-NBLCKA)/NR1P2
      END IF

      ZMFP=EIRENE_FPATH(NCELL,CFLAG,1,1)
C  XSTOR IN STATIC LOOP: NOT NEEDED, BECAUSE NCOU=1
C     XSTOR2(:,:,1)=XSTOR(:,:)
C     XSTORV2(:,1) =XSTORV(:)
C  DECIDE TO FOLLOW OR NOT TO FOLLOW THIS TRACK ON BASIS OF MFP
C
C  TO BE WRITTEN
C
      CLPD(1)=ZMFP
      IF (IUPDTE.GE.1) THEN
        IFLAG=4
        CALL EIRENE_UPDATE (XSTOR2,XSTORV2,IFLAG)
        IF (NADSPC_CD >= 1) CALL EIRENE_UPDATE_SPECTRUM (WEIGHT,IFLAG,1)
      ENDIF
C  CARRY OUT COLLISION EVENT, DIRECTLY AT PLACE OF BIRTH
      IF (SCOS_SAVE.EQ.SCOS_NEW) THEN
        GOTO 230
      ELSE
C  AT THIS POINT: PARTICLE INCIDENT ON SURFACE, IC_PART GT 1 NECESSARILY
        IF (ILIIN(MSURF).GT.0) THEN
C  SURFACE EVENT
          SCOS=SCOS_NEW
          GOTO 380
        ELSE
C  VOLUME EVENT
          GOTO 230
        END IF
      ENDIF
      WRITE (IUNOUT,*) 'FOLSTAT_NEUT: I SHOULD NOT BE HERE'
C
C..................................................................
C  AT THIS POINT: PARTICLE WAS IN STATIC APPROXIMATION,
C                 BUT NOW IT RETURNS TO FULL MOTION
C
      IF (IC_PART.GT.1.AND.NLTRC.AND.TRCHST)
     .  WRITE (iunout,*) 'TRAJECTORY LEAVES STATIC LOOP, ITYP=',ITYP

C  IN CASE THAT THE PARTICLE WAS IN STATIC LOOP AND ON A SURFACE,
C  SOME MORE WORK NEEDS TO BE DONE, TO REVIVE IT TO FULL KINETIC MODE.
      IF (IC_PART.GT.1.AND.
     .   (NLSRFX.OR.NLSRFY.OR.NLSRFZ.OR.NLSRFA)) THEN

C  PARTICLE CONTINUES FROM SURFACE AND FROM PREVIOUS "STATIC LOOP"
C  PREPARE CELL NUMBERS FOR FIRST FLIGHT
        IC_ION=0
        IC_NEUT=0
        SCOS_NEW = SIGN(1.D0,VLX*CRTXG+VLY*CRTYG+VLZ*CRTZG)
        IF (SCOS_SAVE.NE.SCOS_NEW) THEN
          SCOS=SCOS_NEW
          ZT=0.D0
          TL=0.D0
          IPOLGN=IPOLG
          IF (NLSRFA) THEN
            CALL EIRENE_ADDCOL (X0,Y0,Z0,SCOS,IRT)
            IF (IRT == 1) GOTO 101
            IF (IRT == 2) GOTO 380
          ELSEIF (NLSRFX) THEN
            select case (LEVGEO)
            case (:3)
              ISTS=INMP1I(MRSURF,IPCELL,ITCELL)
              MSURFG=NPCELL+(NTCELL-1)*NP2T3
              IF (ILIIN(NLIM+ISTS) .NE. 0)
     .          CALL EIRENE_STDCOL (ISTS,1,SCOS,IRT)
              IF (IRT == 1) GOTO 101
              IF (IRT == 2) GOTO 380
            case (4)
              ISTS=ABS(INMTI(IPOLGN,MRSURF))
              MSURFG=INSPAT(IPOLGN,MRSURF)
              IF (ILIIN(ISTS) .NE. 0)
     .          CALL EIRENE_STDCOL (ISTS,1,SCOS,IRT)
              IF (IRT == 1) GOTO 101
              IF (IRT == 2) GOTO 380
            case (5)
              ISTS=ABS(INMTIT(IPOLGN,MRSURF))
C             MSURFG= ??
              IF (ILIIN(ISTS) .NE. 0)
     .          CALL EIRENE_STDCOL (ISTS,1,SCOS,IRT)
              IF (IRT == 1) GOTO 101
              IF (IRT == 2) GOTO 380
            case (10)
              ISTS=INMP1I(MRSURF,IPCELL,ITCELL)
C             MSURFG= ??
              IF (ILIIN(NLIM+ISTS) .NE. 0)
     .          CALL EIRENE_STDCOL (ISTS,1,SCOS,IRT)
              IF (IRT == 1) GOTO 101
              IF (IRT == 2) GOTO 380
            end select
          ELSEIF (NLSRFY) THEN
            ISTS=INMP2I(IRCELL,MPSURF,ITCELL)
            MSURFG=NRCELL+(NTCELL-1)*NR1P2
            IF (ILIIN(NLIM+ISTS) .NE. 0)
     .        CALL EIRENE_STDCOL (ISTS,2,SCOS,IRT)
            IF (IRT == 1) GOTO 101
            IF (IRT == 2) GOTO 380
          ELSEIF (NLSRFZ) THEN
            ISTS=INMP3I(IRCELL,IPCELL,MTSURF)
            MSURFG=NRCELL+(NPCELL-1)*NR1P2
            IF (ILIIN(NLIM+ISTS) .NE. 0)
     .        CALL EIRENE_STDCOL (ISTS,3,SG,IRT)
            IF (IRT == 1) GOTO 101
            IF (IRT == 2) GOTO 380
          ENDIF
          WRITE (IUNOUT,*) 'FOLSTAT_NEUT: I SHOULD NOT BE HERE'
        ENDIF
      ENDIF

C**********************************************************************
C   STATIC LOOP FINISHED. REGULAR PARTICLE TRACKING CONTINUES
C**********************************************************************

      RETURN

  101 CONTINUE
      IRET = 1
      RETURN
  230 CONTINUE
      IRET = 2
      RETURN
  380 CONTINUE
      IRET = 3
      RETURN

      END SUBROUTINE EIRENE_FOLSTAT_NEUT
