      MODULE EIRMOD_ADDCOL
      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD
      USE EIRMOD_COMUSR
      USE EIRMOD_CESTIM
      USE EIRMOD_CADGEO
      USE EIRMOD_CCONA
      USE EIRMOD_CLOGAU
      USE EIRMOD_CUPD
      USE EIRMOD_CGRID
      USE EIRMOD_COMPRT
      USE EIRMOD_CLGIN
      USE EIRMOD_COUTAU
      use EIRMOD_cfplk
      use EIRMOD_csdvi
      use EIRMOD_PLT2D, ONLY: EIRENE_CHCTRC

      IMPLICIT NONE
      PRIVATE

      PUBLIC :: EIRENE_ADDCOL, EIRENE_ADDNOR

      REAL(DP) :: WINK, CNORM, XL,YL, ZL, CSAVE, ROT, PPP, XXR,
     .          XR, X0SA, Y0SA, Z0SA
      INTEGER :: IWEI, NACLLS, MM,
     .           ICOS, NN, NTNEW, MASRFS

#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP THREADPRIVATE(WINK, CNORM,XL,YL,ZL,CSAVE,ROT,PPP,XXR,
!$OMP&     XR,X0SA,Y0SA,Z0SA,
!$OMP&     IWEI,NACLLS,MM,
!$OMP&     ICOS,NN,NTNEW,MASRFS)
#endif


      CONTAINS

!pb  05.10.06: option for single-sided switching of additional surfaces introduced
!pb  07.07.09: additional surface is hit ==> NLSRFA=.TRUE.
cdr  Nov.17  : lmetspw arguments corrected
C
      SUBROUTINE EIRENE_ADDCOL (XLI,YLI,ZLI,SG,iret)
      use EIRMOD_LEARC1, ONLY: EIRENE_LEARC1
C
C  SG = SIGN OF COSINE OF ANGLE OF INCIDENCE
C  RETURN IRET=1: NO SURFACE TALLIES, FLIGHT CONTINUES
C  RETURN IRET=2: SURFACE TALLIES,
C                 THEN ABSORPTION, REFLECTION MODEL OR CONTINUATION OF FLIGHT
C                 (CALL SUBR. ESCAPE)
C

      IMPLICIT NONE
      REAL(DP), INTENT(IN) :: XLI, YLI, ZLI
      REAL(DP) :: SG
      INTEGER, INTENT(INOUT) :: IRET
      INTEGER :: EIRENE_LEARCA, EIRENE_LEARC2
      EXTERNAL :: EIRENE_FZRTOR, EIRENE_FZRTRI,
     .            EIRENE_LEARCA, EIRENE_LEARC2,
     .            EIRENE_MASJ1, EIRENE_MASR3, EIRENE_EXIT_OWN

      IRET = 0
C
C   COLLISION WITH ADDITIONAL SURFACE NO. MASURF
C
C  SAVE DATA OF OLD POINT FOR DIAGNOSTICS

      X0SA=X0
      Y0SA=Y0
      Z0SA=Z0
      MASRFS=MSURF
      NACLLS=NACELL
C  SET NEW POINT ON ADDITIONAL SURFACE MASURF. FLIGHT TIME: TL
      X0=XLI  ! = X0 + VELX * TL
      Y0=YLI  ! = Y0 + VELY * TL
      Z0=ZLI  ! = Z0 + VELZ * TL
      TIME=TIME+TL/VEL
      MSURF=MASURF
      MRSURF=0
      MPSURF=0
      MTSURF=0
      NLSRFX=.FALSE.
      NLSRFY=.FALSE.
      NLSRFZ=.FALSE.
!pb
      NLSRFA=.TRUE.
      ISPZ=ISPEZ(ITYP,IPHOT,IATM,IMOL,IION,IPLS)
      SCOS=SG
      ICOS=INT(SCOS)

      IF (IMETWL(MSURF) == 0) THEN
        NWLMT = NWLMT+1
        IWLMT(NWLMT) = MSURF
        IMETWL(MSURF) = NWLMT
      END IF

C  SET PHI AND X01
      IF (NLTRA) THEN
C  IN CASE OF NLTRA=TRUE, COORDINATES ARE GIVEN IN LOCAL COORDINATE SYSTEM
C  OF TOROIDAL CELL NO. ILTOR(MASURF),
C  WHICH MAY OR MAY NOT BE EQUAL IPERID!
C  FIND NEW LOCAL COORDINATES X0,Z0, IN THE CORRECT ZONE
C  FIND TOROIDAL ANGLE PHI
C  AND TEST, IF NTNEW=NTCELL AS IT SHOULD BE
C  NTCELL MAY NOT BE KNOWN, IN CASE NLTRA AND NOT NLTOR!!
C  USE IPERID INSTEAD
        IF (ILTOR(MASURF).GT.0.AND.ILTOR(MASURF).NE.IPERID) THEN
          CALL EIRENE_FZRTOR(X0,Z0,ILTOR(MASURF),XR,PHI,NTNEW,
     .                       NLTEST,IPERID)
          CALL EIRENE_FZRTRI(X0,Z0,NTNEW,XR,PHI,NTNEW)
        ELSE
          PHI=MOD(PHI-ATAN2(Z01,X01)+ATAN2(Z0,(RMTOR+X0)),PI2A)
        ENDIF
        X01=X0+RMTOR
      ENDIF
C  SET IPOLG
      IF (NRCELL.GT.0.AND.NRCELL.LE.NR1STM) THEN
        IF (LEVGEO.EQ.3.OR.(LEVGEO.EQ.2.AND.NLPOL))
     .  NN=EIRENE_LEARC1(X0,Y0,Z0,IPOLG,NRCELL,NRCELL,.FALSE.,.FALSE.,
     .                           NPANU,'ADDCOL  ')
      ENDIF
      X00=X0
      Y00=Y0
      Z00=Z0
      Z01=Z0
C
C  DEFAULT CELL SWITCHING NOT NEEDED HERE, BECAUSE ADDITIONAL SURFACE
C
      IWEI=ILSIDE(MASURF)*ICOS
      IF (IWEI.LT.0) GOTO 300
      IF (ILIIN(MASURF).EQ.2) GOTO 400
C
C  OPERATE A SWITCH
C
      IF (ILSWCH(MASURF).NE.0) THEN
C
C  TURN ON OR OFF THE STANDARD GRID CALCULATION (ONLY ADD. SRF).
        IF (ISWICH(1,MASURF).NE.0) ITIME=ICOS*ISWICH(1,MASURF)
C
C  TURN ON OR OFF MFP AND REACTION RATES: PARTICLE ENTERS VACUUM
        IF (ISWICH(2,MASURF).NE.0) IFPATH=ICOS*ISWICH(2,MASURF)
C
C  TURN ON OR OFF VOLUME-AVERAGED TALLIES
        IF (ISWICH(3,MASURF).NE.0) IUPDTE=ICOS*ISWICH(3,MASURF)
C
C  NEW ADD. CELL INDEX NACELL, IF PARTICLE IN ADDITIONAL CELL REGION
C  NEW BLOCK INDEX NBLOCK, IF PARTICLE IN STD. MESH REGION
        IF (ISWICH(4,MASURF).NE.0) THEN
          IF (NACELL.GT.0) THEN
            NACELL=NACELL+ISWICH(4,MASURF)*ICOS*ILACLL(MASURF)
            IF (NACELL.GT.NRADD.OR.NACELL.LT.1) THEN
              IWEI=-10
              GOTO 300
            ENDIF
          ELSEIF (NACELL.EQ.0) THEN
            NBLOCK=NBLOCK+ILBLCK(MASURF)*ICOS*ISWICH(4,MASURF)
            IF (.NOT.NLMLT.OR.(NBLOCK.GT.NBMLT.OR.NBLOCK.LT.1)) THEN
              IWEI=-10
              GOTO 300
            ENDIF
          ENDIF
          NBLCKA=NSTRD*(NBLOCK-1)+NACELL
C
C  ENTRANCE INTO STANDARD MESH, INTO BLOCK NBLOCK=ILBLCK
C  OR
C  EXIT FROM STANDARD MESH, INTO CELL NACELL=ILACLL
        ELSEIF (ISWICH(5,MASURF).NE.0) THEN
          IF (NACELL.EQ.0) THEN
C  SET CELL INDEX EQUAL TO ILACLL
            IF (ILACLL(MASURF) > 0) THEN
              NACELL=ILACLL(MASURF)
              NBLOCK=NBMLTP
              NRCELL=0
              NPCELL=1
              NTCELL=1
              IF (.NOT.NLADD.OR.NACELL.GT.NRADD.OR.NACELL.LT.1) THEN
                IWEI=-10
                GOTO 300
              ENDIF
            ENDIF
          ELSEIF (NACELL.GT.0) THEN
C  ENTRANCE INTO STANDARD MESH, INTO NBLOCK=ILBLCK
            NBLOCK=ILBLCK(MASURF)
            NACELL=0
C  FIND  NRCELL,IPOLG,NPCELL,NTCELL IN STANDARD MESH, BLOCK ILBLCK
C
            NRCELL=EIRENE_LEARC1(X0,Y0,Z0,IPOLG,1,NR1STM,.FALSE.,
     .                   .FALSE.,NPANU,'ADDCOL      ')
C
C  FIND NTCELL IN STANDARD MESH, BLOCK NBLOCK
            IF (NLTOR) THEN
              IF (NLTRZ) THEN
                NTCELL=EIRENE_LEARCA(Z0,ZSURF,1,NT3RD,1,'ADDCOL   ')
              ELSEIF (NLTRA) THEN
                NTCELL=EIRENE_LEARCA(PHI,ZSURF,1,NT3RD,1,'ADDCOL   ')
                IPERID=NTCELL
              ENDIF
            ELSE
              NTCELL=1
              IF (NLTRA) IPERID=EIRENE_LEARCA(PHI,ZSURF,1,NTTRA,1,
     .                                        'ADDCOL   ')
            ENDIF
            IF (NLPOL) THEN
              select case (LEVGEO)
              case (1)
                NPCELL=EIRENE_LEARCA(Y0,PSURF,1,NP2ND,1,'ADDCOL')
              case (2)
                IF (NLCRC) THEN
                  WINK=MOD(ATAN2(Y0,X0)+PI2A-PSURF(1),PI2A)+PSURF(1)
                  NPCELL=EIRENE_LEARCA(WINK,PSURF,1,NP2ND,1,'ADDCOL')
                ELSE
                  NPCELL=EIRENE_LEARC2(X0,Y0,NRCELL,NPANU,'ADDCOL')
                ENDIF
              case (3)
                NPCELL=IPOLG
              case default
                WRITE (iunout,*) 'ERROR EXIT FROM ADDCOL. NLPOL ',LEVGEO
                CALL EIRENE_EXIT_OWN(1)
              end select
            ELSE
              NPCELL=1
            ENDIF
          ENDIF
          NBLCKA=NSTRD*(NBLOCK-1)+NACELL
C  ENTRANCE INTO STANDARD MESH, BLOCK ILBLCK
C  OR
C  EXIT FROM STANDARD MESH, INTO NACELL=NBLOCK+ILACLL
        ELSEIF (ISWICH(6,MASURF).NE.0) THEN
          IF (NACELL.EQ.0) THEN
C  SET CELL INDEX EQUAL TO NBLOCK+ILACLL
            NACELL=NBLOCK+ICOS*ISWICH(6,MASURF)*ILACLL(MASURF)
            NBLOCK=NBMLTP
C
            NRCELL=0
            NPCELL=1
            NTCELL=1
            IF (.NOT.NLADD.OR.NACELL.GT.NRADD.OR.NACELL.LT.1) THEN
              IWEI=-10
              GOTO 300
            ENDIF
          ELSEIF (NACELL.GT.0) THEN
C  ENTRANCE INTO STANDARD MESH, INTO BLOCK NBLOCK=NACELL+ILBLCK
            NBLOCK=NACELL+ICOS*ISWICH(6,MASURF)*ILBLCK(MASURF)
            NACELL=0
C  FIND  NRCELL,IPOLG IN STANDARD MESH, BLOCK NBLOCK
C
C           IF (IDIM.EQ. ?) THEN
              NRCELL=EIRENE_LEARC1(X0,Y0,Z0,IPOLG,1,NR1STM,
     .                     .FALSE.,.FALSE.,NPANU,
     .                     'ADDCOL      ')
C           ENDIF
C  FIND NTCELL IN STANDARD MESH, BLOCK NBLOCK
            IF (NLTOR) THEN
              IF (NLTRZ) THEN
                NTCELL=EIRENE_LEARCA(Z0,ZSURF,1,NT3RD,1,'ADDCOL    ')
              ELSEIF (NLTRA) THEN
                NTCELL=EIRENE_LEARCA(PHI,ZSURF,1,NT3RD,1,'ADDCOL   ')
                IPERID=NTCELL
              ENDIF
            ELSE
              NTCELL=1
              IF (NLTRA) IPERID=EIRENE_LEARCA(PHI,ZSURF,1,NTTRA,1,
     .                                        'ADDCOL   ')
            ENDIF
C  FIND NPCELL IN STANDARD MESH, BLOCK NBLOCK
            IF (NLPOL) THEN
              select case (LEVGEO)
              case (1)
                NPCELL=EIRENE_LEARCA(Y0,PSURF,1,NP2ND,1,'ADDCOL')
              case (2)
                IF (NLCRC) THEN
                  WINK=MOD(ATAN2(Y0,X0)+PI2A-PSURF(1),PI2A)+PSURF(1)
                  NPCELL=EIRENE_LEARCA(WINK,PSURF,1,NP2ND,1,'ADDCOL')
                ELSE
                  NPCELL=EIRENE_LEARC2(X0,Y0,NRCELL,NPANU,'ADDCOL')
                ENDIF
              case (3)
                NPCELL=IPOLG
              case default
                WRITE (iunout,*) 'ERROR EXIT FROM ADDCOL. NLPOL ',LEVGEO
                CALL EIRENE_EXIT_OWN(1)
              end select
            ELSE
              NPCELL=1
            ENDIF
          ENDIF
          NBLCKA=NSTRD*(NBLOCK-1)+NACELL
        ENDIF
      ENDIF
C
C  SWITCHING DONE
C
      IF (NLTRC) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP CRITICAL
#endif
        CALL EIRENE_CHCTRC(X0,Y0,Z0,16,8)
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP END CRITICAL
#endif
      ENDIF
C
      IF (ILIIN(MASURF).LT.0) THEN
        IF (ILIIN(MASURF).EQ.-1) then
           colflag = .true.
           iret = 1
           RETURN
        endif
        iret = 2
        RETURN
      ENDIF
C
C  ILIIN(MASURF) .GT. 0, AND  ILIIN(MASURF) .NE. 2
C  PREPARE REFLECTION, I.E. SET OUTER NORMAL
C
      CALL EIRENE_SET_NORMALS
      IRET = 2
      RETURN

C
C
  300 CONTINUE
      IF (IWEI.EQ.-1) THEN
C  PARTICLE HAS HIT A SURFACE FROM AN ABSORBING SIDE
C  UPDATE FLUXES (DO NOT SET WEIGHT=0.D0) AND ABSORB PARTICLE
        IF (NLTRC) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP CRITICAL
#endif
          CALL EIRENE_CHCTRC(X0,Y0,Z0,16,8)
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP END CRITICAL
#endif
          WRITE (iunout,*) 'ABSORB PARTICLE: NPANU ',NPANU
        ENDIF
        IF (LSPUMP) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP ATOMIC
#endif
          SPUMP(ISPZ,MSURF)=SPUMP(ISPZ,MSURF)+WEIGHT
        ENDIF
        IF (MSURFG.GT.0) THEN
          IF (LSPUMP) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP ATOMIC
#endif
            SPUMP(ISPZ,MSURFG)=SPUMP(ISPZ,MSURFG)+WEIGHT
          ENDIF
        END IF
        IF (LSPUMP) LMETSPW(ISPZ) = .TRUE.
        LGPART=.FALSE.
        iret = 2
        RETURN
      ELSEIF (IWEI.EQ.-2) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP ATOMIC
#endif
        PTRASH(ISTRA)=PTRASH(ISTRA)-WEIGHT
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP ATOMIC
#endif
        ETRASH(ISTRA)=ETRASH(ISTRA)-WEIGHT*E0
C  KILL THIS PARTICLE BECAUSE IT COMES FROM WRONG SIDE
C  DO NOT UPDATE FLUXES (SET WEIGHT=0.D0)

        IF (NLTRC) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP CRITICAL
#endif
          CALL EIRENE_CHCTRC(X0,Y0,Z0,16,18)
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP END CRITICAL
#endif
        ENDIF

        WRITE (iunout,*) 'ERROR DETECTED IN SUBR. ADDCOL'
        WRITE (iunout,*) 'PARTICLE COMES FROM WRONG SIDE'
        CALL EIRENE_MASJ1 ('NPANU=  ',NPANU)
        CALL EIRENE_MASJ1 ('MASRF NW',MASURF)
        CALL EIRENE_MASJ1 ('MASRF OD',MASRFS)
        CALL EIRENE_MASR3 ('X0,Y0,Z0 (NEW)          ',X0,Y0,Z0)
        CALL EIRENE_MASR3 ('X0,Y0,Z0 (OLD)          ',X0SA,Y0SA,Z0SA)
        CALL EIRENE_MASR3 ('VELX,VELY,VELZ          ',VELX,VELY,VELZ)
        CALL EIRENE_MASR3 ('VEL,WEIGHT,E0           ',VEL,WEIGHT,E0)
        IF (LSPUMP) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP ATOMIC
#endif
          SPUMP(ISPZ,MSURF)=SPUMP(ISPZ,MSURF)+WEIGHT
        ENDIF
        IF (MSURFG.GT.0) THEN
          IF (LSPUMP) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP ATOMIC
#endif
            SPUMP(ISPZ,MSURFG)=SPUMP(ISPZ,MSURFG)+WEIGHT
          ENDIF
        END IF
        IF (LSPUMP) LMETSPW(ISPZ) = .TRUE.
        WEIGHT=0.
        LGPART=.FALSE.
        iret = 2
        RETURN
      ELSEIF (IWEI.EQ.-3) THEN
C  SURFACE IS NOT SEEN BY THE PARTICLE BECAUSE OF ILSIDE OPTION
C  I.E. SURFACE IS TRANSPARENT FROM THIS SIDE
C  ACTS AS ILIIN=0 OPTION (NO SURFACE TALLIES, NO SWITCHES)
        colflag = .true.
        iret = 1
        RETURN
      ELSEIF (IWEI.EQ.-10) THEN
C  KILL THIS PARTICLE BECAUSE CELL NUMBER OF RANGE DUE TO SWITCHING
C  DO NOT UPDATE FLUXES (SET WEIGHT=0.D0)
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP ATOMIC
#endif
        PTRASH(ISTRA)=PTRASH(ISTRA)-WEIGHT
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP ATOMIC
#endif
        ETRASH(ISTRA)=ETRASH(ISTRA)-WEIGHT*E0
        IF (NLTRC) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP CRITICAL
#endif
          CALL EIRENE_CHCTRC(X0,Y0,Z0,16,18)
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP END CRITICAL
#endif
        ENDIF
        WRITE (iunout,*) 'ERROR DETECTED IN SUBR. ADDCOL'
        WRITE (iunout,*) 'SOME CELL INDEX OUT OF RANGE'
        CALL EIRENE_MASJ1 ('NPANU=  ',NPANU)
        WRITE (iunout,*) 'NLMLT,NLADD ',NLMLT,NLADD
        WRITE (iunout,*) 'NBMLT,NRADD ',NBMLT,NRADD
        CALL EIRENE_MASJ1 ('MASRF NW',MASURF)
        CALL EIRENE_MASJ1 ('MASRF OD',MASRFS)
        CALL EIRENE_MASJ1 ('NACL NEW',NACELL)
        CALL EIRENE_MASJ1 ('NACL OLD',NACLLS)
        CALL EIRENE_MASJ1 ('NBLOCK  ',NBLOCK)
        CALL EIRENE_MASR3 ('X0,Y0,Z0 (NEW)          ',X0,Y0,Z0)
        CALL EIRENE_MASR3 ('X0,Y0,Z0 (OLD)          ',X0SA,Y0SA,Z0SA)
        CALL EIRENE_MASR3 ('VELX,VELY,VELZ          ',VELX,VELY,VELZ)
        CALL EIRENE_MASR3 ('VEL,WEIGHT,E0           ',VEL,WEIGHT,E0)
        IF (LSPUMP) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP ATOMIC
#endif
          SPUMP(ISPZ,MSURF)=SPUMP(ISPZ,MSURF)+WEIGHT
        ENDIF
        IF (MSURFG.GT.0) THEN
          IF (LSPUMP) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP ATOMIC
#endif
             SPUMP(ISPZ,MSURFG)=SPUMP(ISPZ,MSURFG)+WEIGHT
          ENDIF
        END IF
        IF (LSPUMP) LMETSPW(ISPZ) = .TRUE.
        WEIGHT=0.
        LGPART=.FALSE.
        iret = 2
        RETURN
      ENDIF
C
  400 CONTINUE
      IF (NLTRC) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP CRITICAL
#endif
        CALL EIRENE_CHCTRC(X0,Y0,Z0,16,8)
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP END CRITICAL
#endif
      ENDIF
      iret = 2
      RETURN
      END SUBROUTINE EIRENE_ADDCOL


      SUBROUTINE EIRENE_ADDNOR (X0E,Y0E,Z0E,SCOSE,MSURFE,IPERIDE)
      IMPLICIT NONE
      REAL(DP) :: X0E, Y0E, Z0E, SCOSE
      INTEGER :: MSURFE, IPERIDE

      X0=X0E
      Y0=Y0E
      Z0=Z0E
      SCOS=SCOSE
      MSURF=MSURFE
      IPERID=IPERIDE
      CALL EIRENE_SET_NORMALS
      END SUBROUTINE EIRENE_ADDNOR
C
      SUBROUTINE EIRENE_SET_NORMALS
      IMPLICIT NONE
      EXTERNAL :: EIRENE_FZRTOR, EIRENE_FZRTRI
C
C  COEFFICIENTS OF SURFACE MASURF MAY BE GIVEN IN LOCAL SYSTEM ILTOR(MASURF)
C  AND CURRENT PARTICLE COORDINATES CORRESPOND TO LOCAL SYSTEM IPERID
C
      MM=MASURF
      IF (JUMLIM(MM).GT.0) THEN
        CRTX=A1LM(MM)*SCOS
        CRTY=A2LM(MM)*SCOS
        CRTZ=A3LM(MM)*SCOS
      ELSE
        IF (NLTRA.AND.ILTOR(MM).NE.0.AND.(IPERID.NE.ILTOR(MM))) THEN
          CALL EIRENE_FZRTOR (X0,Z0,IPERID,XXR,PPP,NTNEW,.FALSE.,0)
          CALL EIRENE_FZRTRI (XL,ZL,ILTOR(MM),XXR,PPP,NTNEW)
          YL=Y0
        ELSE
          XL=X0
          YL=Y0
          ZL=Z0
        ENDIF
        CRTX=A1LM(MM)+ALM (MM)*XL+A7LM(MM)*YL+A8LM(MM)*ZL
        CRTY=A2LM(MM)+A7LM(MM)*XL+BLM (MM)*YL+A9LM(MM)*ZL
        CRTZ=A3LM(MM)+A8LM(MM)*XL+A9LM(MM)*YL+CLM (MM)*ZL
        CNORM=1./SQRT(CRTX*CRTX+CRTY*CRTY+CRTZ*CRTZ)*SCOS
        CRTX=CRTX*CNORM
        CRTY=CRTY*CNORM
        CRTZ=CRTZ*CNORM
      ENDIF
      IF (NLTRA.AND.ILTOR(MM).NE.0.AND.(IPERID.NE.ILTOR(MM))) THEN
        ROT=-2.*(IPERID-ILTOR(MM))*ALPHA
        CSAVE=CRTX
        CRTX=COS(ROT)*CSAVE-SIN(ROT)*CRTZ
        CRTZ=SIN(ROT)*CSAVE+COS(ROT)*CRTZ
      ENDIF
      END SUBROUTINE EIRENE_SET_NORMALS

      END MODULE EIRMOD_ADDCOL
