C  11.01.05:   text re. switching off generation limit corrected
C              electron particle balance wtote instead of wtotp
c  AUTUMN 2014:  Sputter tallies revised, also their printout
c  11.04.15:  SPATOT RENAMED TO PMPTOT (pumped flux, rather than sputtered flux)
c  dec.15:    species-resolved bulk ion energy balance eapl,empl,...etc..
cdr aug.16:   X1D(1:nrad): for 1d grids: spatial coordinate, for printout
cdr           new argument in prttal  (same: outpla, calls to prttal)
cdr aug.19:   bugfix: PAMLI instead of PMMLI in one instance (only affects printout)
cpb oct.22:   remove I0, unused
C
      SUBROUTINE EIRENE_OUTEIR(INDOUT)

      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD
      USE EIRMOD_COMUSR
      USE EIRMOD_CESTIM
      USE EIRMOD_CADGEO
      USE EIRMOD_CCONA
      USE EIRMOD_CLOGAU
      USE EIRMOD_CGRID
      USE EIRMOD_CSPEZ
      USE EIRMOD_CTRCEI
      USE EIRMOD_CGEOM
      USE EIRMOD_CSDVI
      USE EIRMOD_COMPRT
      USE EIRMOD_COMNNL
      USE EIRMOD_COMSOU
      USE EIRMOD_CTEXT
      USE EIRMOD_COUTAU
      USE EIRMOD_CSPEI

      IMPLICIT NONE
C
      INTEGER, INTENT(IN) :: INDOUT
      REAL(DP), allocatable :: VECTOR(:)
      REAL(DP), allocatable :: X1D(:)
      REAL(DP), allocatable :: DUMMY(:)
      REAL(DP) :: TOTA(0:NATM),DIFA(0:NATM,0:NSTRA),
     .            DIFRA(0:NATM,0:NSTRA)
      REAL(DP) :: TOTM(0:NMOL),DIFM(0:NMOL,0:NSTRA),
     .            DIFRM(0:NMOL,0:NSTRA)
      REAL(DP) :: TOTI(0:NION),DIFI(0:NION,0:NSTRA),
     .            DIFRI(0:NION,0:NSTRA)
      REAL(DP) :: TOTPH(0:NPHOT),DIFPH(0:NPHOT,0:NSTRA),
     .            DIFRPH(0:NPHOT,0:NSTRA)
      REAL(DP) :: PMPTOT(0:NSPZ)
      REAL(DP) :: DIFR, TOTT, PGAINP, PLOSSP, DIFT, EGAINE, SPA, ELOSSE,
     .            EGAINP, ELOSSP, PGAINE, PLOSSE, SMEAN, OUTAUI, TALAV,
     .            TALTOT, DIF, SMSPT, ERADE
      INTEGER :: IALS, IALV, J, JJ, IS, NFTI, NFTE, K, NF, N, IALG,
     .           ITAL, IPRV, ILAST, ICOUNT, I, ISPC,
     .           IT, JATM, JMOL, JION, JPHOT, IRET, N1D, KK
      INTEGER :: IADTYP(0:4)
      LOGICAL :: LCOVN(NCV)
C
      CHARACTER(72) :: TXTTL
      CHARACTER(24) :: TXTSP, TXTUN
      CHARACTER(6) :: CISTRA
      CHARACTER(10) :: TEXTYP(0:4)
      EXTERNAL :: EIRENE_ALGTAL, EIRENE_FTCRI, EIRENE_INTTAL,
     .            EIRENE_OUTFLX, EIRENE_OUTSPEC, EIRENE_PRTTAL,
     .            EIRENE_RSTRT, EIRENE_SYMET, EIRENE_TALUSR,
     .            EIRENE_HEADNG, EIRENE_LEER, EIRENE_MASAGE,
     .            EIRENE_MASBOX, EIRENE_MASJ1, EIRENE_MASL4,
     .            EIRENE_MASL5, EIRENE_MASR1, EIRENE_MASR2,
     .            EIRENE_MASYR1, EIRENE_PAGE
C
C
C ISTRA IS THE STRATUM NUMBER. ISTRA=0 STANDS FOR: SUM OVER STRATA
      ISTRA=INDOUT
C
C MAKE SURE TO PRINT COVARIANCE TALLIES ONLY ONCE
      DO N=1,NSIGCI
        LCOVN(N)=.FALSE.
      ENDDO
C
      IF (XMCP(ISTRA).LT.1.) THEN
        WRITE (IUNOUT,*) 'OUTEIR CALLED, ISTRA, XMCP: ',
     .                    ISTRA,XMCP(ISTRA)
        WRITE (IUNOUT,*) 'PRINTOUT ABANDONED FOR THIS STRATUM '
        CALL EIRENE_LEER(1)
        GOTO 1000
      ENDIF
C
C
      IF (ISTRA.EQ.IESTR) THEN
C  NOTHING TO BE DONE
      ELSEIF (NFILEN.EQ.1.OR.NFILEN.EQ.2) THEN
        IESTR=ISTRA
        IF (TRCFLE) WRITE (IUNOUT,*) 'FROM OUTEIR:'
        CALL EIRENE_RSTRT(ISTRA,NSTRAI,
     .             NESTM1,NESTM2,NADSPC,
     .             ESTIMV,ESTIMS,ESTIML,
     .             NSDVI1,SDVI1,NSDVI2,SDVI2,
     .             NSDVC1,SIGMAC,NSDVC2,SGMCS,
     .             NSIGI_SPC,TRCFLE)
        IF (NLSYMP(ISTRA).OR.NLSYMT(ISTRA)) THEN
          CALL EIRENE_SYMET(ESTIMV,NVOLTL,NRTAL,NR1TAL,NP2TAL,NT3TAL,
     .                      NLSYMP(ISTRA),NLSYMT(ISTRA))
        ENDIF
      ELSEIF ((NFILEN.EQ.6.OR.NFILEN.EQ.7).AND.ISTRA.EQ.0) THEN
        IESTR=ISTRA
        IF (TRCFLE) WRITE (IUNOUT,*) 'FROM OUTEIR:'
        CALL EIRENE_RSTRT(ISTRA,NSTRAI,
     .             NESTM1,NESTM2,NADSPC,
     .             ESTIMV,ESTIMS,ESTIML,
     .             NSDVI1,SDVI1,NSDVI2,SDVI2,
     .             NSDVC1,SIGMAC,NSDVC2,SGMCS,
     .             NSIGI_SPC,TRCFLE)
        IF (NLSYMP(ISTRA).OR.NLSYMT(ISTRA)) THEN
          CALL EIRENE_SYMET(ESTIMV,NVOLTL,NRTAL,NR1TAL,NP2TAL,NT3TAL,
     .                      NLSYMP(ISTRA),NLSYMT(ISTRA))
        ENDIF
      ELSE
        WRITE (iunout,*) 'ERROR IN OUTEIR: DATA FOR STRATUM ISTRA= ',
     .                    ISTRA
        WRITE (iunout,*) 'ARE NOT AVAILABLE. PRINTOUT ABANDONED'
        WRITE (iunout,*) 'NFILE-N = ',NFILEN
        RETURN
      ENDIF
C
      allocate (vector(nrad))
      allocate (X1D(nrad))
      allocate (dummy(nrtal))

C  SET A 1D GRID FOR PRINTOUT.  Currently only for truly 1D cases
      X1D=0.D0
      IF (LEVGEO.LE.3.AND.NP2ND.EQ.1.AND.NT3RD.EQ.1) THEN
        DO I=1,NR1ST
          X1D(I)=RHOZNE(I)
        ENDDO
      ENDIF
C
      CALL EIRENE_PAGE
      IF (ISTRA.NE.0) THEN
        CALL EIRENE_FTCRI(ISTRA,CISTRA)
        CALL EIRENE_MASBOX ('THIS IS STRATUM NUMBER ISTRA='//CISTRA)
        WRITE (iunout,*) TXTSOU(ISTRA)
        CALL EIRENE_LEER(1)
        CALL EIRENE_MASAGE('TYPE OF PRIMARY SOURCE:')
        CALL EIRENE_MASL4('NLPNT,NLLNE,NLSRF,NLVOL         ',
     .              NLPNT(ISTRA),NLLNE(ISTRA),NLSRF(ISTRA),NLVOL(ISTRA))
        CALL EIRENE_MASL5('NLPHOT,NLATM,NLMOL,NLION,NLPLS          ',
     .              NLPHOT(ISTRA),NLATM(ISTRA),NLMOL(ISTRA),
     .              NLION (ISTRA),NLPLS(ISTRA))
        CALL EIRENE_MASAGE('SPECIES INDEX OF SOURCE PARTICLES')
        CALL EIRENE_MASJ1 ('NSPEZ=  ',NSPEZ(ISTRA))
      ELSE
        CALL EIRENE_MASBOX ('THIS IS THE SUM OVER THE STRATA')
        CALL EIRENE_LEER(1)
      ENDIF

      CALL EIRENE_MASAGE('NUMBER OF MONTE CARLO HISTORIES')
      CALL EIRENE_MASR1('NHIST=  ',XMCP(ISTRA))
      CALL EIRENE_LEER(3)
C
C  PRINT THOSE VOLUME-AVERAGED TALLIES, WHICH HAVE BEEN SELECTED
C  AND WHICH ARE DIFFERENT FROM ZERO
      IALG=0
      DO 100 IPRV=1,NVOLPR
        ITAL=NPRTLV(IPRV)
        IF ((ITAL > 0) .AND. (ITAL <= NTALV)) THEN
          IF (.NOT.LIVTALV(ITAL)) THEN
            CALL EIRENE_LEER(2)
            WRITE (iunout,*) TXTTAL(1,ITAL)
            CALL EIRENE_MASAGE
     .        ('TALLY SWITCHED OFF => NO OUTPUT AVAILABLE')
            CALL EIRENE_LEER(2)
            CYCLE
          END IF
        END IF
C
C  USER-SUPPLIED POSTPROCESSED TALLY, ITAL=0
C
        IF (ITAL.EQ.0) THEN
C   CALL TO TALUSR: A POSTPROCESSED USER-SUPPLIED TALLY
          ICOUNT=1
  120     CALL EIRENE_TALUSR(ICOUNT,VECTOR,TALTOT,TALAV,
     .                       TXTTL,TXTSP,TXTUN,ILAST,IRET)
          IF (IRET == 1) GOTO 121
          WRITE (iunout,*) 'USER-SUPPLIED POSTPROCESSED TALLY NO. ',
     .                ICOUNT
          CALL EIRENE_PRTTAL(TXTTL,TXTSP,TXTUN,
     .                VECTOR,X1D,
     .                NR1ST,NP2ND,NT3RD,NBMLT,NSBOX,
     .                NFLAGV(IPRV),NTLVFL(IPRV))
          CALL EIRENE_LEER(2)
          CALL EIRENE_MASAGE
     .       ('TOTAL ("UNITS*CM**3), AND MEAN VALUE ("UNITS")')
          CALL EIRENE_MASR2 ('TOTAL, MEAN:    ',TALTOT,TALAV)
          CALL EIRENE_LEER(3)
  121     ICOUNT=ICOUNT+1
          IF (ICOUNT.LE.ILAST) GOTO 120

C  PRINT SELECTED (AND NONZERO) TALLIES OTHER THAN TALLY 0 AND TALLY NTALR

        ELSEIF (ITAL.GT.0.AND.ITAL.NE.NTALR) THEN
          NFTI=1
          NFTE=NFSTVI(ITAL)
          IF (NSPEZV(IPRV,1).GT.0) THEN
            NFTI=NSPEZV(IPRV,1)
            NFTE=MAX(NFTI,NSPEZV(IPRV,2))
          ENDIF
          NF=NFIRST(ITAL)
          KK = 0
          DO 119 K=NFTI,NFTE
            IF (K.GT.NFSTVI(ITAL)) GOTO 106
            IF (NEXTVI(ITAL) > 0) THEN
              KK = KK + 1
              IF ((K > NEXTVI(ITAL) .AND.
     .             (MOD(K,NEXTVI(ITAL)) == 1))) KK = KK + 1
            ELSE
              KK = K
            END IF
            CALL EIRENE_FETCH_OUTAU (OUTAUI,ITAL,KK,ISTRA,IUNOUT)
            IF (OUTAUI.EQ.0.D0) GOTO 118
C
            DO 110 I=1,NSBOX_TAL
              VECTOR(I)=ESTIMV(NADDV(ITAL)+K,I)
  110       CONTINUE
            TALTOT=OUTAUI
            TALAV=TALTOT/VOLTOT
C
            CALL EIRENE_PRTTAL
     .                 (TXTTAL(K,ITAL),TXTSPC(K,ITAL),TXTUNT(K,ITAL),
     .                  VECTOR,X1D,
     .                  NR1TAL,NP2TAL,NT3TAL,NBMLT,NSBOX_TAL,
     .                  NFLAGV(IPRV),NTLVFL(IPRV))
            CALL EIRENE_LEER(2)
            CALL EIRENE_MASAGE
     .      ('TOTAL ("UNITS*CM**3), AND MEAN VALUE ("UNITS")')
            CALL EIRENE_MASR2 ('TOTAL, MEAN:    ',TALTOT,TALAV)
            CALL EIRENE_LEER(3)
C
C  CHECK IF STANDARD DEVIATION IS AVAILABLE FOR THIS TALLY "ITAL"
            DO 101 N=1,NSIGVI
              IF (IIH(N).NE.ITAL) GOTO 101
              IF (IGH(N).NE.K.AND.IGH(N).NE.0) GOTO 101
              GOTO 111
  101       CONTINUE
            GOTO 106
  111       CONTINUE
            DO 112 I=1,NSBOX_TAL
              VECTOR(I)=SIGMA(N,I)
  112       CONTINUE
            SMEAN=SGMS(N)
C
            CALL EIRENE_MASAGE('RELATIVE STANDARD DEVIATION')
            IF (IGH(N).GT.0) TXTSP=TXTSPC(K,ITAL)
            IF (IGH(N).EQ.0) TXTSP='TOTAL                   '
            CALL EIRENE_PRTTAL
     .           (TXTTAL(K,ITAL),TXTSP,'%                       ',
     .            VECTOR,X1D,
     .            NR1TAL,NP2TAL,NT3TAL,NBMLT,NSBOX_TAL,
     .            NFLAGV(IPRV),NTLVFL(IPRV))
            CALL EIRENE_LEER(2)
            CALL EIRENE_MASAGE('STANDARD DEVIATION OF MEAN VALUE (%)')
            CALL EIRENE_MASR1 ('MEAN    ',SMEAN)
            CALL EIRENE_LEER(3)
C
  106       CONTINUE
C
C  CHECK IF COVARIANCE IS AVAILABLE
            DO 103 N=1,NSIGCI
              IF (LCOVN(N)) GOTO 103
              IF  (IIHC(1,N).NE.ITAL.AND.IIHC(2,N).NE.ITAL) GOTO 103
              IF  (IGHC(1,N).NE.K.AND.IGHC(1,N).NE.0.AND.
     .             IGHC(2,N).NE.K.AND.IGHC(2,N).NE.0) GOTO 103
              LCOVN(N)=.TRUE.
              GOTO 113
  103       CONTINUE
            GOTO 119
  113       CONTINUE
C
            DO 114 I=1,NSBOX_TAL
              VECTOR(I)=SIGMAC(0,N,I)
  114       CONTINUE
            SMEAN=SGMCS(0,N)
C
            CALL EIRENE_MASAGE
     .      ('COVARIANCE                                    ')
            IF (IGHC(1,N).GT.0) TXTSP=TXTSPC(IGHC(1,N),IIHC(1,N))
            IF (IGHC(1,N).EQ.0) TXTSP='TOTAL                   '
            WRITE (iunout,*) 'BETWEEN ESTIMATOR:'
            ISPZ=MAX(1,IGHC(1,N))
            CALL EIRENE_PRTTAL(TXTTAL(ISPZ,IIHC(1,N)),TXTSP,
     .                  TXTUNT(ISPZ,IIHC(1,N)),
     .                  VECTOR,X1D,
     .                  NR1TAL,NP2TAL,NT3TAL,NBMLT,NSBOX_TAL,
     .                 -1,0)
            WRITE (iunout,*) 'AND ESTIMATOR:'
            ISPZ=MAX(1,IGHC(2,N))
            CALL EIRENE_PRTTAL(TXTTAL(ISPZ,IIHC(2,N)),TXTSP,
     .                  TXTUNT(ISPZ,IIHC(2,N)),
     .                  VECTOR,X1D,
     .                  NR1TAL,NP2TAL,NT3TAL,NBMLT,NSBOX_TAL,
     .                  NFLAGV(IPRV),0)
            CALL EIRENE_LEER(2)
            CALL EIRENE_MASAGE('COVARIANCE OF MEAN VALUES')
            CALL EIRENE_MASR1 ('MEAN    ',SMEAN)
            CALL EIRENE_LEER(3)
C
            DO 115 I=1,NSBOX_TAL
              VECTOR(I)=SIGMAC(1,N,I)
  115       CONTINUE
            SMEAN=SGMCS(1,N)
C
            CALL EIRENE_MASAGE('STANDARD DEVIATION FOR 1ST TALLY')
            IF (IGHC(1,N).GT.0) TXTSP=TXTSPC(IGHC(1,N),IIHC(1,N))
            IF (IGHC(1,N).EQ.0) TXTSP='TOTAL                   '
            ISPZ=MAX(1,IGHC(1,N))
            CALL EIRENE_PRTTAL(TXTTAL(ISPZ,IIHC(1,N)),TXTSP,
     .                  TXTUNT(ISPZ,IIHC(1,N)),
     .                  VECTOR,X1D,
     .                  NR1TAL,NP2TAL,NT3TAL,NBMLT,NSBOX_TAL,
     .                  NFLAGV(IPRV),0)
            CALL EIRENE_LEER(2)
            CALL EIRENE_MASAGE('STANDARD DEVIATION OF MEAN VALUE')
            CALL EIRENE_MASR1 ('MEAN    ',SMEAN)
            CALL EIRENE_LEER(3)
C
            DO 116 I=1,NSBOX_TAL
              VECTOR(I)=SIGMAC(2,N,I)
  116       CONTINUE
            SMEAN=SGMCS(2,N)
C
            CALL EIRENE_MASAGE('STANDARD DEVIATION FOR 2ND TALLY')
            IF (IGHC(2,N).GT.0) TXTSP=TXTSPC(IGHC(2,N),IIHC(2,N))
            IF (IGHC(2,N).EQ.0) TXTSP='TOTAL                   '
            ISPZ=MAX(1,IGHC(2,N))
            CALL EIRENE_PRTTAL(TXTTAL(ISPZ,IIHC(2,N)),TXTSP,
     .                  TXTUNT(ISPZ,IIHC(2,N)),
     .                  VECTOR,X1D,
     .                  NR1TAL,NP2TAL,NT3TAL,NBMLT,NSBOX_TAL,
     .                  NFLAGV(IPRV),0)
            CALL EIRENE_LEER(2)
            CALL EIRENE_MASAGE('STANDARD DEVIATION OF MEAN VALUE')
            CALL EIRENE_MASR1 ('MEAN    ',SMEAN)
            CALL EIRENE_LEER(3)
            GOTO 119
C
  118       CONTINUE
            CALL EIRENE_PRTTAL
     .               (TXTTAL(K,ITAL),TXTSPC(K,ITAL),TXTUNT(K,ITAL),
     .                VECTOR,X1D,
     .                NR1TAL,NP2TAL,NT3TAL,NBMLT,NSBOX_TAL,-1,0)
            CALL EIRENE_MASAGE('IDENTICALLY ZERO, NOT PRINTED')
            CALL EIRENE_LEER(2)
  119     CONTINUE
C
C  ALGEBRAIC TALLY, ITAL=NTALR
C
        ELSEIF (ITAL.EQ.NTALR) THEN
C
C   REDO ALGEBRAIC EXPRESSION IN TALLIES, IN CASE NFILEN=2
          IF ((NFILEN.EQ.2..OR.NFILEN.EQ.7).AND.IALG.EQ.0) THEN
            IALG=1
            CALL EIRENE_ALGTAL
C
            DO 130 IALV=1,NALVI
              DUMMY(1:NSBOX_TAL) = ALGV(IALV,1:NSBOX_TAL)
              CALL EIRENE_INTTAL (DUMMY,VOLTAL,1,1,NSBOX_TAL,
     .                     ALGVI(IALV,ISTRA),
     .                     NR1TAL,NP2TAL,NT3TAL,NBMLT)
              ALGV(IALV,1:NSBOX_TAL) = DUMMY(1:NSBOX_TAL)
  130       CONTINUE
C
            DO 132 IALS=1,NALSI
              ALGSI(IALS,ISTRA)=0.
              DO 131 J=1,NLIMPS
                ALGSI(IALS,ISTRA)=ALGSI(IALS,ISTRA)+ALGS(IALS,J)
  131         CONTINUE
  132       CONTINUE
          ENDIF
C
          NFTI=1
          NFTE=NFSTVI(ITAL)
          IF (NSPEZV(IPRV,1).GT.0) THEN
            NFTI=NSPEZV(IPRV,1)
            NFTE=MAX(NFTI,NSPEZV(IPRV,2))
          ENDIF
          NF=NFIRST(ITAL)
          DO 159 K=NFTI,NFTE
            CALL EIRENE_FETCH_OUTAU (OUTAUI,ITAL,K,ISTRA,IUNOUT)
            IF (OUTAUI.EQ.0.D0) GOTO 158
C
            DO 155 I=1,NSBOX_TAL
              VECTOR(I)=ESTIMV(NADDV(ITAL)+K,I)
  155       CONTINUE
            TALTOT=OUTAUI
            TALAV=TALTOT/VOLTOT
            CALL EIRENE_PRTTAL
     .                 (TXTTAL(K,ITAL),TXTSPC(K,ITAL),TXTUNT(K,ITAL),
     .                  VECTOR,X1D,
     .                  NR1TAL,NP2TAL,NT3TAL,NBMLT,NSBOX_TAL,
     .                  NFLAGV(IPRV),NTLVFL(IPRV))
            CALL EIRENE_LEER(2)
            CALL EIRENE_MASAGE
     .         ('TOTAL ("UNITS*CM**3), AND MEAN VALUE ("UNITS") ')
                CALL EIRENE_MASR2 ('TOTAL, MEAN:    ',TALTOT,TALAV)
            CALL EIRENE_LEER(3)
            GOTO 159
C
  158       CONTINUE
            CALL EIRENE_PRTTAL
     .                 (TXTTAL(K,ITAL),TXTSPC(K,ITAL),TXTUNT(K,ITAL),
     .                  VECTOR,X1D,
     .                  NR1ST,NP2ND,NT3RD,NBMLT,NSBOX,-1,0)
            CALL EIRENE_MASAGE('IDENTICALLY ZERO, NOT PRINTED')
            CALL EIRENE_LEER(2)
  159     CONTINUE
C
        ENDIF
C
  100 CONTINUE

C  SPECTRA IN SELECTED CELLS

      TEXTYP(0) = 'PHOTONS   '
      TEXTYP(1) = 'ATOMS     '
      TEXTYP(2) = 'MOLECULES '
      TEXTYP(3) = 'TEST IONS '
      TEXTYP(4) = 'BULK IONS '
      IADTYP(0:4) = (/ 0, NSPH, NSPA, NSPAM, NSPAMI /)

      DO ISPC=1,NADSPC
        IF (ESTIML(ISPC)%ISRFCLL /= 0) THEN
          CALL EIRENE_LEER (1)
          WRITE (iunout,'(A,I6)') ' SPECTRUM CALCULATED FOR CELL ',
     .      ESTIML(ISPC)%ISPCSRF
          IF (ESTIML(ISPC)%IDIREC > 0) THEN
            WRITE (iunout,'(A,3(ES12.4,A1))')
     .      ' IN DIRECTION (',ESTIML(ISPC)%SPCVX,',',
     .      ESTIML(ISPC)%SPCVY,',',ESTIML(ISPC)%SPCVZ,')'
          END IF
          IT = ESTIML(ISPC)%ISPCTYP
          IF (IT == 1) THEN
            WRITE (iunout,'(A20,A)') ' TYPE OF SPECTRUM : ',
     .        'SPECTRAL PARTICLE DENSITY IN #/CM**3/BIN(EV)'
          ELSEIF (IT == 2) THEN
            WRITE (iunout,'(A20,A)') ' TYPE OF SPECTRUM : ',
     .        'SPECTRAL ENERGY DENSITY IN EV/CM**3/BIN(EV)'
          ELSEIF (IT == 3) THEN
            WRITE (iunout,'(A20,A)') ' TYPE OF SPECTRUM : ',
     .        'SPECTRAL MOMENTUM DENSITY IN (G*CM/S)/CM**3/BIN(EV)'
          END IF
          WRITE (iunout,'(A20,A8)') ' TYPE OF PARTICLE : ',
     .                       TEXTYP(ESTIML(ISPC)%IPRTYP)
          IF (ESTIML(ISPC)%IPRSP == 0) THEN
            WRITE (iunout,'(A10,10X,A16)') ' SPECIES :',
     .                                     'SUM OVER SPECIES'
          ELSE
            WRITE (iunout,'(A10,10X,A8)') ' SPECIES :',
     .             TEXTS(IADTYP(ESTIML(ISPC)%IPRTYP)+
     .                   ESTIML(ISPC)%IPRSP)
          END IF
          WRITE (iunout,'(A22,ES12.4)') ' INTEGRAL OF SPECTRUM ',
     .           ESTIML(ISPC)%SPCS
          IF (NSIGI_SPC > 0)
     .      WRITE (iunout,'(A22,ES12.4)') ' STANDARD DEVIATION   ',
     .           ESTIML(ISPC)%SGMS
        END IF
      END DO

      IF (NSPCPR > 0) CALL EIRENE_OUTSPEC(ISTRA)
C
C   OUTPUT OF VOLUME-AVERAGED TALLIES FINISHED
C
      IF (TRCBLPH.OR.TRCBLA.OR.TRCBLM.OR.TRCBLI.OR.
     .    TRCBLP .OR.TRCBLE) THEN
        CALL EIRENE_LEER (3)
        CALL EIRENE_HEADNG('                               ',31)
        CALL EIRENE_HEADNG('= GLOBAL BALANCES (AMP/WATT) = ',31)
        CALL EIRENE_LEER (3)
      ENDIF
C
C
C  TEST PARTICLE FLUX BALANCE - AND ENERGY FLUX BALANCE
C
      CALL EIRENE_MASAGE('TEST PARTICLE INFLUX FROM SOURCE (AMP)')
      CALL EIRENE_MASAGE
     .  ('INFLUX/(1.602*10**-19) IS THE "ATOMIC" FLUX, PART./SEC')
      CALL EIRENE_MASR1 ('INFLUX= ',FLUXT(ISTRA))
      CALL EIRENE_LEER(2)
C
C  NEUTRAL ATOMS PARTICLE BALANCE: 400 -- 410
C
      DIFA(0,ISTRA)=0.
      TOTA(0)=0.
      IF (.NOT.TRCBLA) GOTO 410
      IF (.NOT.LOGATM(0,ISTRA)) GOTO 410
      CALL EIRENE_HEADNG
     . ('PARTICLE FLUX BALANCE (AMP), NEUTRAL ATOMS',43)
      CALL EIRENE_LEER(1)
C   ATOMS FROM PRIMARY SOURCE
      IF (ANY(WTOTA(1:NATM,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('ATOMIC INFLUX FROM PRIMARY SOURCE')
        CALL EIRENE_MASYR1('WTOTA  = ',
     .       WTOTA,LOGATM,ISTRA,0,NATM,NATM,0,NSTRA,TEXTS(NSPH+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',WTOTA(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
C
      IF (.NOT.LPPAT) THEN
        IF (LMSPPAT) THEN
          CALL EIRENE_MASAGE('ATOMS FROM RECOMBINING BULK IONS')
          CALL EIRENE_MASAGE
     .     ('PPAT   SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PPATI(1:NATM,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('ATOMS FROM RECOMBINING BULK IONS')
        CALL EIRENE_MASYR1('PPATI  = ',
     .       PPATI,LOGATM,ISTRA,0,NATM,NATM,0,NSTRA,TEXTS(NSPH+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PPATI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
C
      IF (.NOT.LPAAT) THEN
        IF (LMSPAAT) THEN
          CALL EIRENE_MASAGE('ATOMS BORN BY ATOM - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('PAAT   SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PAATI(1:NATM,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('ATOMS BORN BY ATOM - PLASMA INTERACTIONS')
        N1D = NATM
        IF (NLSPCSCL_ATM) N1D=NATMP*NATMP-1
        CALL EIRENE_MASYR1('PAATI  = ',
     .       PAATI,LOGATM,ISTRA,0,NATM,N1D,0,NSTRA,TEXTS(NSPH+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PAATI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
      IF (.NOT.LPMAT) THEN
        IF (LMSPMAT) THEN
          CALL EIRENE_MASAGE
     .     ('ATOMS BORN BY MOLECULE - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('PMAT   SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PMATI(1:NATM,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .   ('ATOMS BORN BY MOLECULE - PLASMA INTERACTIONS   ')
        N1D = NATM
        IF (NLSPCSCL_MOL) N1D=NATMP*NMOLP-1
        CALL EIRENE_MASYR1('PMATI  = ',
     .       PMATI,LOGATM,ISTRA,0,NATM,N1D,0,NSTRA,TEXTS(NSPH+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PMATI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
      IF (.NOT.LPIAT) THEN
        IF (LMSPIAT) THEN
          CALL EIRENE_MASAGE
     .     ('ATOMS BORN BY TEST ION - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('PIAT   SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PIATI(1:NATM,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .   ('ATOMS BORN BY TEST ION - PLASMA INTERACTIONS')
        N1D = NATM
        IF (NLSPCSCL_ION) N1D=NATMP*NIONP-1
        CALL EIRENE_MASYR1('PIATI  = ',
     .       PIATI,LOGATM,ISTRA,0,NATM,N1D,0,NSTRA,TEXTS(NSPH+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PIATI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
      IF (.NOT.LPPHAT) THEN
        IF (LMSPPHAT) THEN
          CALL EIRENE_MASAGE
     .     ('ATOMS BORN BY PHOTON - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('PPHAT  SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PPHATI(1:NATM,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .   ('ATOMS BORN BY PHOTON - PLASMA INTERACTIONS')
        N1D = NATM
        IF (NLSPCSCL_ION) N1D=NATMP*NPHOTP-1
        CALL EIRENE_MASYR1('PPHATI = ',
     .       PPHATI,LOGATM,ISTRA,0,NATM,N1D,0,NSTRA,TEXTS(NSPH+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PPHATI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
C   GENERATION LIMIT
      IF (.NOT.LPGENA) THEN
        IF (LMSPGENA) THEN
          CALL EIRENE_MASAGE
     .     ('ATOMS LOST DUE TO GENERATION OR FLUID LIMIT')
          CALL EIRENE_MASAGE
     .     ('PGENA  SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PGENAI(1:NATM,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .   ('ATOMS LOST DUE TO GENERATION OR FLUID LIMIT')
        CALL EIRENE_MASYR1('PGENAI = ',
     .       PGENAI,LOGATM,ISTRA,0,NATM,NATM,0,NSTRA,TEXTS(NSPH+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PGENAI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
C   ESCAPING FLUX, OR CENSUS
      IF (.NOT.LPOTAT) THEN
        IF (LMSPOTAT) THEN
          CALL EIRENE_MASAGE('ATOMIC EFFLUX ONTO THE SURFACES')
          CALL EIRENE_MASAGE
     .     ('POTAT  SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(POTATI(1:NATM,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('ATOMIC EFFLUX ONTO THE SURFACES')
        CALL EIRENE_MASYR1('POTATI = ',
     .       POTATI,LOGATM,ISTRA,0,NATM,NATM,0,NSTRA,TEXTS(NSPH+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',POTATI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
C   REFLECTED FLUX
      IF (.NOT.LPRFAAT) THEN
        IF (LMSPRFAAT) THEN
          CALL EIRENE_MASAGE
     .     ('ATOMIC INFLUX FROM SURFACES, ORIG: ATOMS')
          CALL EIRENE_MASAGE
     .     ('PRFAAT SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PRFAAI(1:NATM,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('ATOMIC INFLUX FROM SURFACES, ORIG: ATOMS')
        N1D = NATM
        IF (NLSPCSCL_ATM) N1D = NATMP*NATMP-1
        CALL EIRENE_MASYR1('PRFAAI = ',
     .       PRFAAI,LOGATM,ISTRA,0,NATM,N1D,0,NSTRA,TEXTS(NSPH+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PRFAAI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
      IF (.NOT.LPRFMAT) THEN
        IF (LMSPRFMAT) THEN
          CALL EIRENE_MASAGE
     .     ('ATOMIC INFLUX FROM SURFACES, ORIG: MOLECULES')
          CALL EIRENE_MASAGE
     .     ('PRFMAT SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PRFMAI(1:NATM,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .   ('ATOMIC INFLUX FROM SURFACES, ORIG: MOLECULES')
        N1D = NATM
        IF (NLSPCSCL_MOL) N1D = NATMP*NMOLP-1
        CALL EIRENE_MASYR1('PRFMAI = ',
     .       PRFMAI,LOGATM,ISTRA,0,NATM,N1D,0,NSTRA,TEXTS(NSPH+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PRFMAI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
      IF (.NOT.LPRFIAT) THEN
        IF (LMSPRFIAT) THEN
          CALL EIRENE_MASAGE
     .     ('ATOMIC INFLUX FROM SURFACES, ORIG: TEST IONS')
          CALL EIRENE_MASAGE
     .     ('PRFIAT SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PRFIAI(1:NATM,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .   ('ATOMIC INFLUX FROM SURFACES, ORIG: TEST IONS')
        N1D = NATM
        IF (NLSPCSCL_ION) N1D = NATMP*NIONP-1
        CALL EIRENE_MASYR1('PRFIAI = ',
     .       PRFIAI,LOGATM,ISTRA,0,NATM,N1D,0,NSTRA,TEXTS(NSPH+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PRFIAI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
      IF (.NOT.LPRFPHAT) THEN
        IF (LMSPRFPHAT) THEN
          CALL EIRENE_MASAGE
     .     ('ATOMIC INFLUX FROM SURFACES, ORIG: PHOTONS')
          CALL EIRENE_MASAGE
     .     ('PRFPHAT SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PRFPHAI(1:NATM,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('ATOMIC INFLUX FROM SURFACES, ORIG: PHOTONS')
        N1D = NATM
        IF (NLSPCSCL_PHOT) N1D = NATMP*NPHOTP-1
        CALL EIRENE_MASYR1('PRFPHAI= ',
     .       PRFPHAI,LOGATM,ISTRA,0,NATM,N1D,0,NSTRA,TEXTS(NSPH+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PRFPHAI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
C  SPUTTERED ATOMIC FLUXES (I.E. PARTICLES SPUTTERED AS ATOMS IATM=1,NATMI)
      SMSPT = 0._DP
      IF (.NOT.LSPTAAT) THEN
        IF (LMSSPTAAT) THEN
          CALL EIRENE_MASAGE('ATOMIC FLUX SPUTTERED, ORIG: ATOMS')
          CALL EIRENE_MASAGE
     .     ('SPTAAT  SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(SPTAATI(1:NATM,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('ATOMIC FLUX SPUTTERED, ORIG: ATOMS')
        CALL EIRENE_MASYR1('SPTAATI =',
     .       SPTAATI,LOGATM,ISTRA,0,NATM,NATM,0,NSTRA,TEXTS(NSPH+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',SPTAATI(0,ISTRA))
        CALL EIRENE_LEER(1)
        SMSPT = SMSPT + SPTAATI(0,ISTRA)
      ENDIF
      IF (.NOT.LSPTMAT) THEN
        IF (LMSSPTMAT) THEN
          CALL EIRENE_MASAGE('ATOMIC FLUX SPUTTERED, ORIG: MOLECULES')
          CALL EIRENE_MASAGE
     .     ('SPTMAT  SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(SPTMATI(1:NATM,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('ATOMIC FLUX SPUTTERED, ORIG: MOLECULES')
        CALL EIRENE_MASYR1('SPTMATI =',
     .       SPTMATI,LOGATM,ISTRA,0,NATM,NATM,0,NSTRA,TEXTS(NSPH+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',SPTMATI(0,ISTRA))
        CALL EIRENE_LEER(1)
        SMSPT = SMSPT + SPTMATI(0,ISTRA)
      ENDIF
      IF (.NOT.LSPTIAT) THEN
        IF (LMSSPTIAT) THEN
          CALL EIRENE_MASAGE('ATOMIC FLUX SPUTTERED, ORIG: TEST IONS')
          CALL EIRENE_MASAGE
     .     ('SPTIAT  SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(SPTIATI(1:NATM,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('ATOMIC FLUX SPUTTERED, ORIG: TEST IONS')
        CALL EIRENE_MASYR1('SPTIATI =',
     .       SPTIATI,LOGATM,ISTRA,0,NATM,NATM,0,NSTRA,TEXTS(NSPH+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',SPTIATI(0,ISTRA))
        CALL EIRENE_LEER(1)
        SMSPT = SMSPT + SPTIATI(0,ISTRA)
      ENDIF
      IF (.NOT.LSPTPHAT) THEN
        IF (LMSSPTPHAT) THEN
          CALL EIRENE_MASAGE('ATOMIC FLUX SPUTTERED, ORIG: PHOTONS')
          CALL EIRENE_MASAGE
     .     ('SPTPHAT SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(SPTPHATI(1:NATM,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('ATOMIC FLUX SPUTTERED, ORIG: PHOTONS')
        CALL EIRENE_MASYR1('SPTPHATI=',
     .       SPTPHATI,LOGATM,ISTRA,0,NATM,NATM,0,NSTRA,TEXTS(NSPH+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',SPTPHATI(0,ISTRA))
        CALL EIRENE_LEER(1)
        SMSPT = SMSPT + SPTPHATI(0,ISTRA)
      ENDIF
      IF (.NOT.LSPTPAT) THEN
        IF (LMSSPTPAT) THEN
          CALL EIRENE_MASAGE('ATOMIC FLUX SPUTTERED, ORIG: BULK IONS')
          CALL EIRENE_MASAGE
     .     ('SPTPAT  SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(SPTPATI(1:NATM,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('ATOMIC FLUX SPUTTERED, ORIG: BULK IONS')
        CALL EIRENE_MASYR1('SPTPATI =',
     .       SPTPATI,LOGATM,ISTRA,0,NATM,NATM,0,NSTRA,TEXTS(NSPH+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',SPTPATI(0,ISTRA))
        CALL EIRENE_LEER(1)
        SMSPT = SMSPT + SPTPATI(0,ISTRA)
      ENDIF
      IF (ABS(SMSPT) > EPS10) THEN
        CALL EIRENE_MASAGE('TOTAL FLUX SPUTTERED AS ATOMS')
        CALL EIRENE_MASR1 ('TOTAL=  ',SMSPT)
      END IF
      IF (ABS(SPTATTI(ISTRA)) > EPS10) THEN
        CALL EIRENE_MASAGE('TOTAL FLUX SPUTTERED BY ATOMS')
        CALL EIRENE_MASR1 ('SPTATTI=',SPTATTI(ISTRA))
      END IF
C  CHECK ATOM PARTICLE BALANCES
      DO 405 JATM=0,NATMI
        DIFA(JATM,ISTRA)=
     +       POTATI(JATM,ISTRA)+PPATI(JATM,ISTRA)+
     +       PGENAI(JATM,ISTRA)+
     +       WTOTA(JATM,ISTRA)+
     +       PAATI (JATM,ISTRA)+PRFAAI (JATM,ISTRA)+
     +       PMATI (JATM,ISTRA)+PRFMAI (JATM,ISTRA)+
     +       PIATI (JATM,ISTRA)+PRFIAI (JATM,ISTRA)+
     +       PPHATI(JATM,ISTRA)+PRFPHAI(JATM,ISTRA)
        TOTA(JATM)=
     +  ABS(POTATI(JATM,ISTRA))+ABS(PAATI(JATM,ISTRA))+
     +       ABS(PPATI(JATM,ISTRA))+ABS(PMATI(JATM,ISTRA))+
     +       ABS(PIATI(JATM,ISTRA))+ABS(WTOTA(JATM,ISTRA))+
     +       ABS(PRFAAI(JATM,ISTRA))+ABS(PRFMAI(JATM,ISTRA))+
     +       ABS(PRFIAI(JATM,ISTRA))+ABS(PGENAI(JATM,ISTRA))+
     +       ABS(PPHATI(JATM,ISTRA))+ABS(PRFPHAI(JATM,ISTRA))
        TOTA(JATM)=TOTA(JATM)+EPS60
        DIF=SIGN (1._DP,DIFA(JATM,ISTRA))*
     .      MAX(0._DP,ABS(DIFA(JATM,ISTRA))/TOTA(JATM)-EPS10)
        DIFRA(JATM,ISTRA)=DIF*100.
        DIFA(JATM,ISTRA)=DIF*TOTA(JATM)
  405 CONTINUE
      CALL EIRENE_MASAGE('ABSOLUTE ERRORS IN PARTICLE BALANCE')
      CALL EIRENE_MASYR1('DIFA =   ',
     .     DIFA,LOGATM,ISTRA,0,NATM,NATM,0,NSTRA,TEXTS(NSPH+1))
      CALL EIRENE_MASAGE
     .  ('SUM OVER SPECIES                               ')
      CALL EIRENE_MASR1 ('TOTAL=  ',DIFA(0,ISTRA))
      CALL EIRENE_LEER(1)
      CALL EIRENE_MASAGE('RELATIVE ERRORS IN PARTICLE BALANCE (%)')
      CALL EIRENE_MASYR1('DIFRA =  ',
     .     DIFRA,LOGATM,ISTRA,0,NATM,NATM,0,NSTRA,TEXTS(NSPH+1))
      CALL EIRENE_MASAGE('SUM OVER SPECIES')
      CALL EIRENE_MASR1 ('TOTAL=  ',DIFRA(0,ISTRA))
      CALL EIRENE_LEER(2)
C
C  NEUTRAL MOLECULES PARTICLE BALANCE  410 -- 420
C
  410 CONTINUE
      DIFM(0,ISTRA)=0.
      TOTM(0)=0.
      IF (.NOT.TRCBLM) GOTO 420
      IF (.NOT.LOGMOL(0,ISTRA)) GOTO 420
      CALL EIRENE_LEER (2)
      CALL EIRENE_HEADNG
     .     ('PARTICLE FLUX BALANCE (AMP), NEUTRAL MOLECULES',47)
      CALL EIRENE_LEER(1)
C  MOLECULES FROM PRIMARY SOURCE
      IF (ANY(WTOTM(1:NMOL,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('MOLECULAR INFLUX FROM PRIMARY SOURCE')
        CALL EIRENE_MASYR1('WTOTM  = ',
     .       WTOTM,LOGMOL,ISTRA,0,NMOL,NMOL,0,NSTRA,TEXTS(NSPA+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',WTOTM(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
C
      IF (.NOT.LPPML) THEN
        IF (LMSPPML) THEN
          CALL EIRENE_MASAGE('MOLECULES FROM RECOMBINING BULK IONS')
          CALL EIRENE_MASAGE
     .     ('PPML    SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PPMLI(1:NMOL,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('MOLECULES FROM RECOMBINING BULK IONS')
        CALL EIRENE_MASYR1('PPMLI  = ',
     .       PPMLI,LOGMOL,ISTRA,0,NMOL,NMOL,0,NSTRA,TEXTS(NSPA+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PPMLI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
C
      IF (.NOT.LPAML) THEN
        IF (LMSPAML) THEN
          CALL EIRENE_MASAGE
     .     ('MOLECULES BORN BY ATOM - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('PAML    SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PAMLI(1:NMOL,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .   ('MOLECULES BORN BY ATOM - PLASMA INTERACTIONS')
        N1D = NMOL
        IF (NLSPCSCL_ATM) N1D=NMOLP*NATMP-1
        CALL EIRENE_MASYR1('PAMLI  = ',
     .       PAMLI,LOGMOL,ISTRA,0,NMOL,N1D,0,NSTRA,TEXTS(NSPA+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PAMLI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
      IF (.NOT.LPMML) THEN
        IF (LMSPMML) THEN
          CALL EIRENE_MASAGE
     .     ('MOLECULES BORN BY MOLECULE - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('PMML    SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PMMLI(1:NMOL,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .   ('MOLECULES BORN BY MOLECULE - PLASMA INTERACTIONS')
        N1D = NMOL
        IF (NLSPCSCL_MOL) N1D=NMOLP*NMOLP-1
        CALL EIRENE_MASYR1('PMMLI  = ',
     .       PMMLI,LOGMOL,ISTRA,0,NMOL,N1D,0,NSTRA,TEXTS(NSPA+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PMMLI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
      IF (.NOT.LPIML) THEN
        IF (LMSPIML) THEN
          CALL EIRENE_MASAGE
     .     ('MOLECULES BORN BY TEST ION - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('PIML    SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PIMLI(1:NMOL,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .   ('MOLECULES BORN BY TEST ION - PLASMA INTERACTIONS')
        N1D = NMOL
        IF (NLSPCSCL_ION) N1D=NMOLP*NIONP-1
        CALL EIRENE_MASYR1('PIMLI  = ',
     .       PIMLI,LOGMOL,ISTRA,0,NMOL,N1D,0,NSTRA,TEXTS(NSPA+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PIMLI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
      IF (.NOT.LPPHML) THEN
        IF (LMSPPHML) THEN
          CALL EIRENE_MASAGE
     .     ('MOLECULES BORN BY PHOTON - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('PPHML   SWITCHED OFF => MISSING IN BALANCE     ')
        ENDIF
      ELSE IF (ANY(PPHMLI(1:NMOL,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .   ('MOLECULES BORN BY PHOTON - PLASMA INTERACTIONS')
        N1D = NMOL
        IF (NLSPCSCL_PHOT) N1D=NMOLP*NPHOTP-1
        CALL EIRENE_MASYR1('PPHMLI = ',
     .       PPHMLI,LOGMOL,ISTRA,0,NMOL,N1D,0,NSTRA,TEXTS(NSPA+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PPHMLI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
C   GENERATION LIMIT
      IF (.NOT.LPGENM) THEN
        IF (LMSPGENM) THEN
          CALL EIRENE_MASAGE
     .     ('MOLECULES LOST DUE TO GENERATION OR FLUID LIMIT')
          CALL EIRENE_MASAGE
     .     ('PGENM   SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PGENMI(1:NMOL,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .   ('MOLECULES LOST DUE TO GENERATION OR FLUID LIMIT')
        CALL EIRENE_MASYR1('PGENMI = ',
     .       PGENMI,LOGMOL,ISTRA,0,NMOL,NMOL,0,NSTRA,TEXTS(NSPA+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PGENMI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
C  ESCAPING MOLECULES
      IF (.NOT.LPOTML) THEN
        IF (LMSPOTML) THEN
          CALL EIRENE_MASAGE('MOLECULAR EFFLUX ONTO THE SURFACES')
          CALL EIRENE_MASAGE
     .     ('POTML   SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(POTMLI(1:NMOL,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('MOLECULAR EFFLUX ONTO THE SURFACES')
        CALL EIRENE_MASYR1('POTMLI = ',
     .       POTMLI,LOGMOL,ISTRA,0,NMOL,NMOL,0,NSTRA,TEXTS(NSPA+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',POTMLI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
C  REFLECTED MOLECULES
      IF (.NOT.LPRFAML) THEN
        IF (LMSPRFAML) THEN
          CALL EIRENE_MASAGE
     .     ('MOLECULAR INFLUX FROM SURFACES, ORIG: ATOMS')
          CALL EIRENE_MASAGE
     .     ('PRFAML  SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PRFAMI(1:NMOL,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .   ('MOLECULAR INFLUX FROM SURFACES, ORIG: ATOMS')
        N1D = NMOL
        IF (NLSPCSCL_ATM) N1D = NMOLP*NATMP-1
        CALL EIRENE_MASYR1('PRFAMI = ',
     .       PRFAMI,LOGMOL,ISTRA,0,NMOL,N1D,0,NSTRA,TEXTS(NSPA+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PRFAMI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
      IF (.NOT.LPRFMML) THEN
        IF (LMSPRFMML) THEN
          CALL EIRENE_MASAGE
     .     ('MOLECULAR INFLUX FROM SURFACES, ORIG: MOLECULES')
          CALL EIRENE_MASAGE
     .     ('PRFMML  SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PRFMMI(1:NMOL,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .   ('MOLECULAR INFLUX FROM SURFACES, ORIG: MOLECULES')
        N1D = NMOL
        IF (NLSPCSCL_MOL) N1D = NMOLP*NMOLP-1
        CALL EIRENE_MASYR1('PRFMMI = ',
     .       PRFMMI,LOGMOL,ISTRA,0,NMOL,N1D,0,NSTRA,TEXTS(NSPA+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PRFMMI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
      IF (.NOT.LPRFIML) THEN
        IF (LMSPRFIML) THEN
          CALL EIRENE_MASAGE
     .     ('MOLECULAR INFLUX FROM SURFACES, ORIG: TEST IONS')
          CALL EIRENE_MASAGE
     .     ('PRFIML  SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PRFIMI(1:NMOL,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .   ('MOLECULAR INFLUX FROM SURFACES, ORIG: TEST IONS')
        N1D = NMOL
        IF (NLSPCSCL_ION) N1D = NMOLP*NIONP-1
        CALL EIRENE_MASYR1('PRFIMI = ',
     .       PRFIMI,LOGMOL,ISTRA,0,NMOL,N1D,0,NSTRA,TEXTS(NSPA+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PRFIMI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
      IF (.NOT.LPRFPHML) THEN
        IF (LMSPRFPHML) THEN
          CALL EIRENE_MASAGE
     .     ('MOLECULAR INFLUX FROM SURFACES, ORIG: PHOTONS')
          CALL EIRENE_MASAGE
     .     ('PRFPHML SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PRFPHMI(1:NMOL,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .   ('MOLECULAR INFLUX FROM SURFACES, ORIG: PHOTONS')
        N1D = NMOL
        IF (NLSPCSCL_PHOT) N1D = NMOLP*NPHOTP-1
        CALL EIRENE_MASYR1('PRFPHMI= ',
     .       PRFPHMI,LOGMOL,ISTRA,0,NMOL,N1D,0,NSTRA,TEXTS(NSPA+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PRFPHMI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
C  SPUTTERED MOLECULAR FLUXES (I.E. PARTICLES SPUTTERED AS MOLECULES IMOL=1,NMOLI)
      SMSPT = 0._DP
      IF (.NOT.LSPTAML) THEN
        IF (LMSSPTAML) THEN
          CALL EIRENE_MASAGE('MOLECULAR FLUX SPUTTERED, ORIG: ATOMS')
          CALL EIRENE_MASAGE
     .     ('SPTAML  SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(SPTAMLI(1:NMOL,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('MOLECULAR FLUX SPUTTERED, ORIG: ATOMS')
        CALL EIRENE_MASYR1('SPTAMLI =',
     .       SPTAMLI,LOGMOL,ISTRA,0,NMOL,NMOL,0,NSTRA,TEXTS(NSPA+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',SPTAMLI(0,ISTRA))
        CALL EIRENE_LEER(1)
        SMSPT = SMSPT + SPTAMLI(0,ISTRA)
      ENDIF
      IF (.NOT.LSPTMML) THEN
        IF (LMSSPTMML) THEN
          CALL EIRENE_MASAGE
     .     ('MOLECULAR FLUX SPUTTERED, ORIG: MOLECULES')
          CALL EIRENE_MASAGE
     .     ('SPTMML  SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(SPTMMLI(1:NMOL,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('MOLECULAR FLUX SPUTTERED, ORIG: MOLECULES')
        CALL EIRENE_MASYR1('SPTMMLI =',
     .       SPTMMLI,LOGMOL,ISTRA,0,NMOL,NMOL,0,NSTRA,TEXTS(NSPA+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',SPTMMLI(0,ISTRA))
        CALL EIRENE_LEER(1)
        SMSPT = SMSPT + SPTMMLI(0,ISTRA)
      ENDIF
      IF (.NOT.LSPTIML) THEN
        IF (LMSSPTIML) THEN
          CALL EIRENE_MASAGE
     .     ('MOLECULAR FLUX SPUTTERED, ORIG: TEST IONS')
          CALL EIRENE_MASAGE
     .     ('SPTIML  SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(SPTIMLI(1:NMOL,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('MOLECULAR FLUX SPUTTERED, ORIG: TEST IONS')
        CALL EIRENE_MASYR1('SPTIMLI =',
     .       SPTIMLI,LOGMOL,ISTRA,0,NMOL,NMOL,0,NSTRA,TEXTS(NSPA+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',SPTIMLI(0,ISTRA))
        CALL EIRENE_LEER(1)
        SMSPT = SMSPT + SPTIMLI(0,ISTRA)
      ENDIF
      IF (.NOT.LSPTPHML) THEN
        IF (LMSSPTPHML) THEN
          CALL EIRENE_MASAGE('MOLECULAR FLUX SPUTTERED, ORIG: PHOTONS')
          CALL EIRENE_MASAGE
     .     ('SPTPHML SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(SPTPHMLI(1:NMOL,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('MOLECULAR FLUX SPUTTERED, ORIG: PHOTONS')
        CALL EIRENE_MASYR1('SPTIMLI =',
     .       SPTPHMLI,LOGMOL,ISTRA,0,NMOL,NMOL,0,NSTRA,TEXTS(NSPA+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',SPTPHMLI(0,ISTRA))
        CALL EIRENE_LEER(1)
        SMSPT = SMSPT + SPTPHMLI(0,ISTRA)
      ENDIF
      IF (.NOT.LSPTPML) THEN
        IF (LMSSPTPML) THEN
          CALL EIRENE_MASAGE
     .     ('MOLECULAR FLUX SPUTTERED, ORIG: BULK IONS')
          CALL EIRENE_MASAGE
     .     ('SPTPML  SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(SPTPMLI(1:NMOL,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('MOLECULAR FLUX SPUTTERED, ORIG: BULK IONS')
        CALL EIRENE_MASYR1('SPTPMLI =',
     .       SPTPMLI,LOGMOL,ISTRA,0,NMOL,NMOL,0,NSTRA,TEXTS(NSPA+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',SPTPMLI(0,ISTRA))
        CALL EIRENE_LEER(1)
        SMSPT = SMSPT + SPTPMLI(0,ISTRA)
      ENDIF
      IF (ABS(SMSPT) > EPS10) THEN
        CALL EIRENE_MASAGE('TOTAL FLUX SPUTTERED AS MOLECULES')
        CALL EIRENE_MASR1 ('TOTAL=  ',SMSPT)
      END IF
      IF (ABS(SPTMTTI(ISTRA)) > EPS10) THEN
        CALL EIRENE_MASAGE('TOTAL FLUX SPUTTERED BY MOLECULES')
        CALL EIRENE_MASR1 ('SPTMTTI=',SPTMTTI(ISTRA))
      END IF
C  CHECK MOLECULE PARTICLE BALANCES
      DO 415 JMOL=0,NMOLI
        DIFM(JMOL,ISTRA)=
     +     POTMLI(JMOL,ISTRA)+PMMLI(JMOL,ISTRA)+PPMLI(JMOL,ISTRA)+
     +     PIMLI(JMOL,ISTRA)+PGENMI(JMOL,ISTRA)+
     +     WTOTM(JMOL,ISTRA)+PRFAMI(JMOL,ISTRA)+PRFMMI(JMOL,ISTRA)+
     +     PRFIMI(JMOL,ISTRA)+PAMLI(JMOL,ISTRA)+
     +     PPHMLI(JMOL,ISTRA)+PRFPHMI(JMOL,ISTRA)
        TOTM(JMOL)=
     +     ABS(POTMLI(JMOL,ISTRA))+ABS(PMMLI(JMOL,ISTRA))+
     +     ABS(PPMLI(JMOL,ISTRA))+ABS(WTOTM(JMOL,ISTRA))+
     +     ABS(PIMLI(JMOL,ISTRA))+ABS(PGENMI(JMOL,ISTRA))+
     +     ABS(PRFAMI(JMOL,ISTRA))+ABS(PRFMMI(JMOL,ISTRA))+
     +     ABS(PAMLI(JMOL,ISTRA))+
     +     ABS(PRFIMI(JMOL,ISTRA))+
     +     ABS(PPHMLI(JMOL,ISTRA))+ABS(PRFPHMI(JMOL,ISTRA))
        TOTM(JMOL)=TOTM(JMOL)+EPS60
        DIF=SIGN (1._DP,DIFM(JMOL,ISTRA))*
     .      MAX(0._DP,ABS(DIFM(JMOL,ISTRA))/TOTM(JMOL)-EPS10)
        DIFRM(JMOL,ISTRA)=DIF*100.
        DIFM(JMOL,ISTRA)=DIF*TOTM(JMOL)
  415 CONTINUE
      CALL EIRENE_MASAGE('ABSOLUTE ERRORS IN PARTICLE BALANCE')
      CALL EIRENE_MASYR1('DIFM =   ',
     .     DIFM,LOGMOL,ISTRA,0,NMOL,NMOL,0,NSTRA,TEXTS(NSPA+1))
      CALL EIRENE_MASAGE('SUM OVER SPECIES')
      CALL EIRENE_MASR1 ('TOTAL=  ',DIFM(0,ISTRA))
      CALL EIRENE_LEER(1)
      CALL EIRENE_MASAGE('RELATIVE ERRORS IN PARTICLE BALANCE (%)')
      CALL EIRENE_MASYR1('DIFRM =  ',
     .     DIFRM,LOGMOL,ISTRA,0,NMOL,NMOL,0,NSTRA,TEXTS(NSPA+1))
      CALL EIRENE_MASAGE('SUM OVER SPECIES')
      CALL EIRENE_MASR1 ('TOTAL=  ',DIFRM(0,ISTRA))
      CALL EIRENE_LEER(2)
C
C  TEST IONS PARTICLE BALANCE  420 -- 430
C
  420 CONTINUE
      DIFI(0,ISTRA)=0.
      TOTI(0)=0.
      IF (.NOT.TRCBLI) GOTO 430
      IF (.NOT.LOGION(0,ISTRA)) GOTO 430
      CALL EIRENE_LEER (2)
      CALL EIRENE_HEADNG('PARTICLE FLUX BALANCE (AMP), TEST IONS',39)
      CALL EIRENE_LEER(1)
C  TEST IONS FROM PRIMARY SOURCE
      IF (ANY(WTOTI(1:NION,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('TEST IONS INFLUX FROM PRIMARY SOURCE')
        CALL EIRENE_MASYR1('IOFLUX = ',
     .       WTOTI,LOGION,ISTRA,0,NION,NION,0,NSTRA,TEXTS(NSPAM+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',WTOTI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
C
      IF (.NOT.LPPIO) THEN
        IF (LMSPPIO) THEN
          CALL EIRENE_MASAGE('TEST IONS FROM RECOMBINING BULK IONS')
          CALL EIRENE_MASAGE
     .     ('PPIO    SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PPIOI(1:NION,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('TEST IONS FROM RECOMBINING BULK IONS')
        CALL EIRENE_MASYR1('PPIOI  = ',
     .       PPIOI,LOGION,ISTRA,0,NION,NION,0,NSTRA,TEXTS(NSPAM+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PPIOI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
C
      IF (.NOT.LPIIO) THEN
        IF (LMSPIIO) THEN
          CALL EIRENE_MASAGE
     .     ('TEST IONS BORN BY TEST ION - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('PIIO    SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PIIOI(1:NION,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .   ('TEST IONS BORN BY TEST ION - PLASMA INTERACTIONS')
        N1D = NION
        IF (NLSPCSCL_ION) N1D = NIONP*NIONP-1
        CALL EIRENE_MASYR1('PIIOI  = ',
     .       PIIOI,LOGION,ISTRA,0,NION,N1D,0,NSTRA,TEXTS(NSPAM+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PIIOI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
      IF (.NOT.LPAIO) THEN
        IF (LMSPAIO) THEN
          CALL EIRENE_MASAGE
     .     ('TEST IONS BORN BY ATOM - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('PAIO    SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PAIOI(1:NION,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .   ('TEST IONS BORN BY ATOM - PLASMA INTERACTIONS')
        N1D = NION
        IF (NLSPCSCL_ATM) N1D = NIONP*NATMP-1
        CALL EIRENE_MASYR1('PAIOI  = ',
     .       PAIOI,LOGION,ISTRA,0,NION,N1D,0,NSTRA,TEXTS(NSPAM+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PAIOI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
      IF (.NOT.LPMIO) THEN
        IF (LMSPMIO) THEN
          CALL EIRENE_MASAGE
     .     ('TEST IONS BORN BY MOLECULE - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('PMIO    SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PMIOI(1:NION,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .   ('TEST IONS BORN BY MOLECULE - PLASMA INTERACTIONS')
        N1D = NION
        IF (NLSPCSCL_MOL) N1D = NIONP*NMOLP-1
        CALL EIRENE_MASYR1('PMIOI  = ',
     .       PMIOI,LOGION,ISTRA,0,NION,N1D,0,NSTRA,TEXTS(NSPAM+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PMIOI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
      IF (.NOT.LPPHIO) THEN
        IF (LMSPPHIO) THEN
          CALL EIRENE_MASAGE
     .     ('TEST IONS BORN BY PHOTON - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('PPHIO   SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PPHIOI(1:NION,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .   ('TEST IONS BORN BY PHOTON - PLASMA INTERACTIONS')
        N1D = NION
        IF (NLSPCSCL_PHOT) N1D = NIONP*NPHOTP-1
        CALL EIRENE_MASYR1('PPHIOI = ',
     .       PPHIOI,LOGION,ISTRA,0,NION,N1D,0,NSTRA,TEXTS(NSPAM+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PPHIOI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
C   GENERATION LIMIT
      IF (.NOT.LPGENI) THEN
        IF (LMSPGENI) THEN
          CALL EIRENE_MASAGE
     .     ('TEST ION LOST DUE TO GENERATION OR FLUID LIMIT')
          CALL EIRENE_MASAGE
     .     ('PGENI   SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PGENII(1:NION,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .   ('TEST IONS LOST DUE TO GENERATION OR FLUID LIMIT')
        CALL EIRENE_MASYR1('PGENII = ',
     .       PGENII,LOGION,ISTRA,0,NION,NION,0,NSTRA,TEXTS(NSPAM+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PGENII(0,ISTRA))
      ENDIF
C  ESCAPING TEST IONS
      IF (.NOT.LPOTIO) THEN
        IF (LMSPOTIO) THEN
          CALL EIRENE_MASAGE('TEST IONS EFFLUX ONTO THE SURFACES')
          CALL EIRENE_MASAGE
     .     ('POTIO   SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(POTIOI(1:NION,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('TEST IONS EFFLUX ONTO THE SURFACES')
        CALL EIRENE_MASYR1('POTIOI = ',
     .       POTIOI,LOGION,ISTRA,0,NION,NION,0,NSTRA,TEXTS(NSPAM+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',POTIOI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
C  REFLECTED TEST IONS
      IF (.NOT.LPRFAIO) THEN
        IF (LMSPRFAIO) THEN
          CALL EIRENE_MASAGE
     .     ('TEST ION INFLUX FROM SURFACES, ORIG: ATOMS')
          CALL EIRENE_MASAGE
     .     ('PRFAIO  SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PRFAII(1:NION,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('TEST ION INFLUX FROM SURFACES, ORIG: ATOMS')
        N1D = NION
        IF (NLSPCSCL_ATM) N1D=NIONP*NATMP-1
        CALL EIRENE_MASYR1('PRFAII = ',
     .       PRFAII,LOGION,ISTRA,0,NION,N1D,0,NSTRA,TEXTS(NSPAM+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PRFAII(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
      IF (.NOT.LPRFMIO) THEN
        IF (LMSPRFMIO) THEN
          CALL EIRENE_MASAGE
     .     ('TEST ION INFLUX FROM SURFACES, ORIG: MOLECULES')
          CALL EIRENE_MASAGE
     .     ('PRFMIO  SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PRFMII(1:NION,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .   ('TEST ION INFLUX FROM SURFACES, ORIG: MOLECULES')
        N1D = NION
        IF (NLSPCSCL_MOL) N1D=NIONP*NMOLP-1
        CALL EIRENE_MASYR1('PRFMII = ',
     .       PRFMII,LOGION,ISTRA,0,NION,N1D,0,NSTRA,TEXTS(NSPAM+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PRFMII(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
      IF (.NOT.LPRFIIO) THEN
        IF (LMSPRFIIO) THEN
          CALL EIRENE_MASAGE
     .     ('TEST ION INFLUX FROM SURFACES, ORIG: TEST IONS')
          CALL EIRENE_MASAGE
     .     ('PRFIIO  SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PRFIII(1:NION,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .   ('TEST ION INFLUX FROM SURFACES, ORIG: TEST IONS')
        N1D = NION
        IF (NLSPCSCL_ION) N1D=NIONP*NIONP-1
        CALL EIRENE_MASYR1('PRFIII = ',
     .       PRFIII,LOGION,ISTRA,0,NION,N1D,0,NSTRA,TEXTS(NSPAM+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PRFIII(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
      IF (.NOT.LPRFPHIO) THEN
        IF (LMSPRFPHIO) THEN
          CALL EIRENE_MASAGE
     .     ('TEST ION INFLUX FROM SURFACES, ORIG: PHOTONS')
          CALL EIRENE_MASAGE
     .     ('PRFPHIO SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PRFPHII(1:NION,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .   ('TEST ION INFLUX FROM SURFACES, ORIG: PHOTONS')
        N1D = NION
        IF (NLSPCSCL_PHOT) N1D=NIONP*NPHOTP-1
        CALL EIRENE_MASYR1('PRFPHII= ',
     .       PRFPHII,LOGION,ISTRA,0,NION,N1D,0,NSTRA,TEXTS(NSPAM+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PRFPHII(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
C  SPUTTERED TEST ION FLUXES (I.E. PARTICLES SPUTTERED AS TEST IONS IION=1,NIONI)
      SMSPT = 0._DP
      IF (.NOT.LSPTAIO) THEN
        IF (LMSSPTAIO) THEN
          CALL EIRENE_MASAGE('TEST ION FLUX SPUTTERED, ORIG: ATOMS')
          CALL EIRENE_MASAGE
     .     ('SPTAIO  SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(SPTAIOI(1:NION,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('TEST ION  FLUX SPUTTERED, ORIG: ATOMS')
        CALL EIRENE_MASYR1('SPTAIOI =',
     .       SPTAIOI,LOGION,ISTRA,0,NION,NION,0,NSTRA,TEXTS(NSPAM+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',SPTAIOI(0,ISTRA))
        CALL EIRENE_LEER(1)
        SMSPT = SMSPT + SPTAIOI(0,ISTRA)
      ENDIF
      IF (.NOT.LSPTMIO) THEN
        IF (LMSSPTMIO) THEN
          CALL EIRENE_MASAGE('TEST ION FLUX SPUTTERED, ORIG: MOLECULES')
          CALL EIRENE_MASAGE
     .     ('SPTMIO  SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(SPTMIOI(1:NION,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('TEST ION FLUX SPUTTERED, ORIG: MOLECULES')
        CALL EIRENE_MASYR1('SPTMIOI =',
     .       SPTMIOI,LOGION,ISTRA,0,NION,NION,0,NSTRA,TEXTS(NSPAM+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',SPTMIOI(0,ISTRA))
        CALL EIRENE_LEER(1)
        SMSPT = SMSPT + SPTMIOI(0,ISTRA)
      ENDIF
      IF (.NOT.LSPTIIO) THEN
        IF (LMSSPTIIO) THEN
          CALL EIRENE_MASAGE('TEST ION FLUX SPUTTERED, ORIG: TEST IONS')
          CALL EIRENE_MASAGE
     .     ('SPTIIO  SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(SPTIIOI(1:NION,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('TEST ION FLUX SPUTTERED, ORIG: TEST IONS')
        CALL EIRENE_MASYR1('SPTIIOI =',
     .       SPTIIOI,LOGION,ISTRA,0,NION,NION,0,NSTRA,TEXTS(NSPAM+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',SPTIIOI(0,ISTRA))
        CALL EIRENE_LEER(1)
        SMSPT = SMSPT + SPTIIOI(0,ISTRA)
      ENDIF
      IF (.NOT.LSPTPHIO) THEN
        IF (LMSSPTPHIO) THEN
          CALL EIRENE_MASAGE('TEST ION FLUX SPUTTERED, ORIG: PHOTONS')
          CALL EIRENE_MASAGE
     .     ('SPTPHIO SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(SPTPHIOI(1:NION,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('TEST ION FLUX SPUTTERED, ORIG: PHOTONS')
        CALL EIRENE_MASYR1('SPTIIOI =',
     .       SPTPHIOI,LOGION,ISTRA,0,NION,NION,0,NSTRA,TEXTS(NSPAM+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',SPTPHIOI(0,ISTRA))
        CALL EIRENE_LEER(1)
        SMSPT = SMSPT + SPTPHIOI(0,ISTRA)
      ENDIF
      IF (.NOT.LSPTPIO) THEN
        IF (LMSSPTPIO) THEN
          CALL EIRENE_MASAGE('TEST ION FLUX SPUTTERED, ORIG: BULK IONS')
          CALL EIRENE_MASAGE
     .     ('SPTPIO  SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(SPTPIOI(1:NION,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('TEST ION FLUX SPUTTERED, ORIG: BULK IONS')
        CALL EIRENE_MASYR1('SPPIIOI =',
     .       SPTPIOI,LOGION,ISTRA,0,NION,NION,0,NSTRA,TEXTS(NSPAM+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',SPTPIOI(0,ISTRA))
        CALL EIRENE_LEER(1)
        SMSPT = SMSPT + SPTPIOI(0,ISTRA)
      ENDIF
      IF (ABS(SMSPT) > EPS10) THEN
        CALL EIRENE_MASAGE('TOTAL FLUX SPUTTERED AS TEST IONS')
        CALL EIRENE_MASR1 ('TOTAL=  ',SMSPT)
      END IF
      IF (ABS(SPTITTI(ISTRA)) > EPS10) THEN
        CALL EIRENE_MASAGE('TOTAL FLUX SPUTTERED BY TEST IONS')
        CALL EIRENE_MASR1 ('SPTITTI=',SPTITTI(ISTRA))
      END IF
C  CHECK TEST ION PARTICLE BALANCES
      DIFI(0,ISTRA)=0.
      TOTI(0)=0.
      DO 425 JION=0,NIONI
        DIFI(JION,ISTRA)=
     +     PIIOI(JION,ISTRA)+POTIOI(JION,ISTRA)+PPIOI(JION,ISTRA)+
     +     WTOTI(JION,ISTRA)+PMIOI(JION,ISTRA)+PAIOI(JION,ISTRA)+
     +     PRFAII(JION,ISTRA)+PRFMII(JION,ISTRA)+
     +     PRFIII(JION,ISTRA)+
     +     PPHIOI(JION,ISTRA)+PRFPHII(JION,ISTRA)
        TOTI(JION)=
     +     ABS(PIIOI(JION,ISTRA))+ABS(POTIOI(JION,ISTRA))+
     +     ABS(PPIOI(JION,ISTRA))+ABS(WTOTI(JION,ISTRA))+
     +     ABS(PMIOI(JION,ISTRA))+ABS(PAIOI(JION,ISTRA))+
     +     ABS(PRFAII(JION,ISTRA))+ABS(PRFMII(JION,ISTRA))+
     +     ABS(PRFIII(JION,ISTRA))+
     +     ABS(PPHIOI(JION,ISTRA))+ABS(PRFPHII(JION,ISTRA))
        TOTI(JION)=TOTI(JION)+EPS60
        DIF=SIGN (1._DP,DIFI(JION,ISTRA))*
     .      MAX(0._DP,ABS(DIFI(JION,ISTRA))/TOTI(JION)-EPS10)
        DIFRI(JION,ISTRA)=DIF*100.
        DIFI(JION,ISTRA)=DIF*TOTI(JION)
  425 CONTINUE
      CALL EIRENE_MASAGE('ABSOLUTE ERRORS IN PARTICLE BALANCE')
      CALL EIRENE_MASYR1('DIFI =   ',
     .     DIFI,LOGION,ISTRA,0,NION,NION,0,NSTRA,TEXTS(NSPAM+1))
      CALL EIRENE_MASAGE('SUM OVER SPECIES')
      CALL EIRENE_MASR1 ('TOTAL=  ',DIFI(0,ISTRA))
      CALL EIRENE_LEER(1)
      CALL EIRENE_MASAGE('RELATIVE ERRORS IN PARTICLE BALANCE (%)')
      CALL EIRENE_MASYR1('DIFRI =  ',
     .     DIFRI,LOGION,ISTRA,0,NION,NION,0,NSTRA,TEXTS(NSPAM+1))
      CALL EIRENE_MASAGE('SUM OVER SPECIES')
      CALL EIRENE_MASR1 ('TOTAL=  ',DIFRI(0,ISTRA))
      CALL EIRENE_LEER(2)
C
C  PHOTONS PARTICLE BALANCE  430 -- 440
C
  430 CONTINUE
      DIFPH(0,ISTRA)=0.
      TOTPH(0)=0.
      IF (.NOT.TRCBLPH) GOTO 440
      IF (.NOT.LOGPHOT(0,ISTRA)) GOTO 440
      CALL EIRENE_LEER(2)
      CALL EIRENE_HEADNG('PARTICLE FLUX BALANCE (AMP), PHOTONS',36)
      CALL EIRENE_LEER(1)
C   PHOTONS FROM PRIMARY SOURCE
      IF (ANY(WTOTPH(1:NPHOT,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('PHOTONIC INFLUX FROM PRIMARY SOURCE')
        CALL EIRENE_MASYR1('WTOTPH = ',
     .       WTOTPH,LOGPHOT,ISTRA,0,NPHOT,NPHOT,0,NSTRA,TEXTS(  +1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',WTOTPH(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
C
      IF (.NOT.LPPPHT) THEN
        IF (LMSPPPHT) THEN
          CALL EIRENE_MASAGE('PHOTONS FROM RECOMBINING BULK IONS')
          CALL EIRENE_MASAGE
     .     ('PPPHT   SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PPPHTI(1:NPHOT,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('PHOTONS FROM RECOMBINING BULK IONS')
        CALL EIRENE_MASYR1('PPPHTI = ',
     .       PPPHTI,LOGPHOT,ISTRA,0,NPHOT,NPHOT,0,NSTRA,TEXTS(  +1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PPPHTI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
C
      IF (.NOT.LPPHPHT) THEN
        IF (LMSPPHPHT) THEN
          CALL EIRENE_MASAGE
     .     ('PHOTONS BORN BY PHOTON - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('PPHPHT  SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PPHPHTI(1:NPHOT,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .  ('PHOTONS BORN BY PHOTON - PLASMA INTERACTIONS')
        N1D = NPHOT
        IF (NLSPCSCL_PHOT) N1D = NPHOTP*NPHOTP-1
        CALL EIRENE_MASYR1('PPHPHTI= ',
     .       PPHPHTI,LOGPHOT,ISTRA,0,NPHOT,N1D,0,NSTRA,TEXTS( +1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PPHPHTI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
      IF (.NOT.LPAPHT) THEN
        IF (LMSPAPHT) THEN
          CALL EIRENE_MASAGE
     .     ('PHOTONS BORN BY ATOM - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('PAPHT   SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PAPHTI(1:NPHOT,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('PHOTONS BORN BY ATOM - PLASMA INTERACTIONS')
        N1D = NPHOT
        IF (NLSPCSCL_ATM) N1D = NPHOTP*NATMP-1
        CALL EIRENE_MASYR1('PAPHTI = ',
     .       PAPHTI,LOGPHOT,ISTRA,0,NPHOT,N1D,0,NSTRA,TEXTS(  +1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PAPHTI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
      IF (.NOT.LPMPHT) THEN
        IF (LMSPMPHT) THEN
          CALL EIRENE_MASAGE
     .     ('PHOTONS BORN BY MOLECULE - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('PMPHT   SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PMPHTI(1:NPHOT,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .   ('PHOTONS BORN BY MOLECULE - PLASMA INTERACTIONS')
        N1D = NPHOT
        IF (NLSPCSCL_MOL) N1D = NPHOTP*NMOLP-1
        CALL EIRENE_MASYR1('PMPHTI = ',
     .       PMPHTI,LOGPHOT,ISTRA,0,NPHOT,N1D,0,NSTRA,TEXTS(  +1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PMPHTI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
      IF (.NOT.LPIPHT) THEN
        IF (LMSPIPHT) THEN
          CALL EIRENE_MASAGE
     .     ('PHOTONS BORN BY TEST ION - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('PIPHT   SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PIPHTI(1:NPHOT,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .   ('PHOTONS BORN BY TEST ION - PLASMA INTERACTIONS ')
        N1D = NPHOT
        IF (NLSPCSCL_ION) N1D = NPHOTP*NIONP-1
        CALL EIRENE_MASYR1('PIPHTI = ',
     .       PIPHTI,LOGPHOT,ISTRA,0,NPHOT,N1D,0,NSTRA,TEXTS(  +1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PIPHTI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
C   GENERATION LIMIT
      IF (.NOT.LPGENPH) THEN
        IF (LPGENPH) THEN
          CALL EIRENE_MASAGE
     .     ('PHOTONS ABSORBED DUE TO GENERAT. OR FLUID LIMIT')
          CALL EIRENE_MASAGE
     .     ('PGENPH  SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PGENPHI(1:NPHOT,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .  ('PHOTONS ABSORBED DUE TO GENERAT. OR FLUID LIMIT')
        CALL EIRENE_MASYR1('PGENPHI= ',
     .       PGENPHI,LOGPHOT,ISTRA,0,NPHOT,NPHOT,0,NSTRA,TEXTS( +1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PGENPHI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
C   ESCAPING FLUX
      IF (.NOT.LPOTPHT) THEN
        IF (LMSPOTPHT) THEN
          CALL EIRENE_MASAGE('PHOTONIC EFFLUX ONTO THE SURFACES')
          CALL EIRENE_MASAGE
     .     ('POTPHT  SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(POTPHTI(1:NPHOT,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('PHOTONIC EFFLUX ONTO THE SURFACES')
        CALL EIRENE_MASYR1('POTPHTI= ',
     .       POTPHTI,LOGPHOT,ISTRA,0,NPHOT,NPHOT,0,NSTRA,TEXTS( +1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',POTPHTI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
C   REFLECTED FLUX
      IF (.NOT.LPRFAPHT) THEN
        IF (LMSPRFAPHT) THEN
          CALL EIRENE_MASAGE
     .     ('PHOTONIC INFLUX FROM SURFACES, ORIG: ATOMS')
          CALL EIRENE_MASAGE
     .     ('PRFAPHT SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PRFAPHTI(1:NPHOT,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('PHOTONIC INFLUX FROM SURFACES, ORIG: ATOMS')
        N1D = NPHOT
        IF (NLSPCSCL_ATM) N1D = NPHOTP*NATMP-1
        CALL EIRENE_MASYR1('PRFAPHTI=',
     .       PRFAPHTI,LOGPHOT,ISTRA,0,NPHOT,N1D,0,NSTRA,TEXTS( +1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PRFAPHTI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
      IF (.NOT.LPRFMPHT) THEN
        IF (LMSPRFMPHT) THEN
          CALL EIRENE_MASAGE
     .     ('PHOTONIC INFLUX FROM SURFACES, ORIG: MOLECULES')
          CALL EIRENE_MASAGE
     .     ('PRFMPHT SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PRFMPHTI(1:NPHOT,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .   ('PHOTONIC INFLUX FROM SURFACES, ORIG: MOLECULES')
        N1D = NPHOT
        IF (NLSPCSCL_MOL) N1D = NPHOTP*NMOLP-1
        CALL EIRENE_MASYR1('PRFMPHTI=',
     .       PRFMPHTI,LOGPHOT,ISTRA,0,NPHOT,N1D,0,NSTRA,TEXTS( +1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PRFMPHTI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
      IF (.NOT.LPRFIPHT) THEN
        IF (LMSPRFIPHT) THEN
          CALL EIRENE_MASAGE
     .     ('PHOTONIC INFLUX FROM SURFACES, ORIG: TEST IONS')
          CALL EIRENE_MASAGE
     .     ('PRFIPHT SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PRFIPHTI(1:NPHOT,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .   ('PHOTONIC INFLUX FROM SURFACES, ORIG: TEST IONS')
        N1D = NPHOT
        IF (NLSPCSCL_ION) N1D = NPHOTP*NIONP-1
        CALL EIRENE_MASYR1('PRFIPHTI=',
     .       PRFIPHTI,LOGPHOT,ISTRA,0,NPHOT,N1D,0,NSTRA,TEXTS( +1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PRFIPHTI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
      IF (.NOT.LPRFPHPHT) THEN
        IF (LMSPRFPHPHT) THEN
          CALL EIRENE_MASAGE
     .     ('PHOTONIC INFLUX FROM SURFACES, ORIG: PHOTONS')
          CALL EIRENE_MASAGE
     .     ('PRFPHPHT SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PRFPHPHTI(1:NPHOT,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .   ('PHOTONIC INFLUX FROM SURFACES, ORIG: PHOTONS')
        N1D = NPHOT
        IF (NLSPCSCL_PHOT) N1D = NPHOTP*NPHOTP-1
        CALL EIRENE_MASYR1('PRFPHPHTI',
     .       PRFPHPHTI,LOGPHOT,ISTRA,0,NPHOT,N1D,0,NSTRA,TEXTS(+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PRFPHPHTI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
C  SPUTTERED PHOTON FLUXES (I.E. PARTICLES SPUTTERED AS PHOTONS IPHOT=1,NPHOTI)
      SMSPT = 0._DP
      IF (.NOT.LSPTAPHT) THEN
        IF (LMSSPTAPHT) THEN
          CALL EIRENE_MASAGE('PHOTON FLUX SPUTTERED, ORIG: ATOMS')
          CALL EIRENE_MASAGE
     .     ('SPTAPHT  SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(SPTAPHTI(1:NPHOT,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('PHOTON FLUX SPUTTERED, ORIG: ATOMS')
        CALL EIRENE_MASYR1('SPTAPHTI=',
     .       SPTAPHTI,LOGPHOT,ISTRA,0,NPHOT,NPHOT,0,NSTRA,TEXTS( +1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',SPTAPHTI(0,ISTRA))
        CALL EIRENE_LEER(1)
        SMSPT = SMSPT + SPTAPHTI(0,ISTRA)
      ENDIF
      IF (.NOT.LSPTMPHT) THEN
        IF (LMSSPTMPHT) THEN
          CALL EIRENE_MASAGE('PHOTON FLUX SPUTTERED, ORIG: MOLECULES')
          CALL EIRENE_MASAGE
     .     ('SPTMPHT  SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(SPTMPHTI(1:NPHOT,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('PHOTON FLUX SPUTTERED, ORIG: MOLECULES')
        CALL EIRENE_MASYR1('SPTMPHTI=',
     .       SPTMPHTI,LOGPHOT,ISTRA,0,NPHOT,NPHOT,0,NSTRA,TEXTS( +1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',SPTMPHTI(0,ISTRA))
        CALL EIRENE_LEER(1)
        SMSPT = SMSPT + SPTMPHTI(0,ISTRA)
      ENDIF
      IF (.NOT.LSPTIPHT) THEN
        IF (LMSSPTIPHT) THEN
          CALL EIRENE_MASAGE('PHOTON FLUX SPUTTERED, ORIG: TEST IONS')
          CALL EIRENE_MASAGE
     .     ('SPTIPHT  SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(SPTIPHTI(1:NPHOT,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('PHOTON FLUX SPUTTERED, ORIG: TEST IONS')
        CALL EIRENE_MASYR1('SPTIPHTI=',
     .       SPTIPHTI,LOGPHOT,ISTRA,0,NPHOT,NPHOT,0,NSTRA,TEXTS( +1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',SPTIPHTI(0,ISTRA))
        CALL EIRENE_LEER(1)
        SMSPT = SMSPT + SPTIPHTI(0,ISTRA)
      ENDIF
      IF (.NOT.LSPTPHPHT) THEN
        IF (LMSSPTPHPHT) THEN
          CALL EIRENE_MASAGE('PHOTON FLUX SPUTTERED, ORIG: PHOTONS')
          CALL EIRENE_MASAGE
     .     ('SPTPHPHT SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(SPTPHPHTI(1:NPHOT,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('PHOTON FLUX SPUTTERED, ORIG: PHOTONS')
        CALL EIRENE_MASYR1('SPTPHPHTI',
     .       SPTPHPHTI,LOGPHOT,ISTRA,0,NPHOT,NPHOT,0,NSTRA,TEXTS( +1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',SPTPHPHTI(0,ISTRA))
        CALL EIRENE_LEER(1)
        SMSPT = SMSPT + SPTPHPHTI(0,ISTRA)
      ENDIF
      IF (.NOT.LSPTPPHT) THEN
        IF (LMSSPTPPHT) THEN
          CALL EIRENE_MASAGE('PHOTON FLUX SPUTTERED, ORIG: BULK IONS')
          CALL EIRENE_MASAGE
     .     ('SPTPPHT  SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(SPTPPHTI(1:NPHOT,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('PHOTON FLUX SPUTTERED, ORIG: BULK IONS')
        CALL EIRENE_MASYR1('SPTPPHTI=',
     .       SPTPPHTI,LOGPHOT,ISTRA,0,NPHOT,NPHOT,0,NSTRA,TEXTS( +1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',SPTPPHTI(0,ISTRA))
        CALL EIRENE_LEER(1)
        SMSPT = SMSPT + SPTPPHTI(0,ISTRA)
      ENDIF
      IF (ABS(SMSPT) > EPS10) THEN
        CALL EIRENE_MASAGE('TOTAL FLUX SPUTTERED AS PHOTONS')
        CALL EIRENE_MASR1 ('TOTAL=  ',SMSPT)
      END IF
      IF (ABS(SPTPHTTI(ISTRA)) > EPS10) THEN
        CALL EIRENE_MASAGE('TOTAL FLUX SPUTTERED BY PHOTONS')
        CALL EIRENE_MASR1 ('SPTPHTT=',SPTPHTTI(ISTRA))
      END IF
C  CHECK PHOTON PARTICLE BALANCES
      DO 435 JPHOT=0,NPHOTI
        DIFPH(JPHOT,ISTRA)=
     +  POTPHTI(JPHOT,ISTRA)+PAPHTI(JPHOT,ISTRA)+PPPHTI(JPHOT,ISTRA)+
     +       PMPHTI(JPHOT,ISTRA)+PIPHTI(JPHOT,ISTRA)+
     +       PGENPHI(JPHOT,ISTRA)+
     +       WTOTPH(JPHOT,ISTRA)+
     +       PPHPHTI(JPHOT,ISTRA)+
     +       PRFAPHTI(JPHOT,ISTRA)+
     +       PRFMPHTI(JPHOT,ISTRA)+
     +       PRFIPHTI(JPHOT,ISTRA)+
     +       PRFPHPHTI(JPHOT,ISTRA)
        TOTPH(JPHOT)=
     +  ABS(POTPHTI(JPHOT,ISTRA))+ABS(PAPHTI(JPHOT,ISTRA))+
     +       ABS(PPPHTI(JPHOT,ISTRA))+ABS(PMPHTI(JPHOT,ISTRA))+
     +       ABS(PIPHTI(JPHOT,ISTRA))+ABS(WTOTPH(JPHOT,ISTRA))+
     +       ABS(PRFAPHTI(JPHOT,ISTRA))+ABS(PRFMPHTI(JPHOT,ISTRA))+
     +       ABS(PRFIPHTI(JPHOT,ISTRA))+
     +       ABS(PGENPHI(JPHOT,ISTRA))+
     +       ABS(PPHPHTI(JPHOT,ISTRA))+
     +       ABS(PRFPHPHTI(JPHOT,ISTRA))
        TOTPH(JPHOT)=TOTPH(JPHOT)+EPS60
        DIF=SIGN (1._DP,DIFPH(JPHOT,ISTRA))*
     .      MAX(0._DP,ABS(DIFPH(JPHOT,ISTRA))/TOTPH(JPHOT)-EPS10)
        DIFRPH(JPHOT,ISTRA)=DIF*100.
        DIFPH(JPHOT,ISTRA)=DIF*TOTPH(JPHOT)
  435 CONTINUE
      CALL EIRENE_MASAGE('ABSOLUTE ERRORS IN PARTICLE BALANCE')
      CALL EIRENE_MASYR1('DIFPH=   ',
     .     DIFPH,LOGPHOT,ISTRA,0,NPHOT,NPHOT,0,NSTRA,TEXTS(   +1))
      CALL EIRENE_MASAGE('SUM OVER SPECIES')
      CALL EIRENE_MASR1 ('TOTAL=  ',DIFPH(0,ISTRA))
      CALL EIRENE_MASAGE('RELATIVE ERRORS IN PARTICLE BALANCE (%)')
      CALL EIRENE_MASYR1('DIFRPH=  ',
     .     DIFRPH,LOGPHOT,ISTRA,0,NPHOT,NPHOT,0,NSTRA,TEXTS(  +1))
      CALL EIRENE_MASAGE('SUM OVER SPECIES')
      CALL EIRENE_MASR1 ('TOTAL=  ',DIFRPH(0,ISTRA))
      CALL EIRENE_LEER(2)
C
C  TOTAL TEST PARTICLE BALANCE
C
  440 CONTINUE
      CALL EIRENE_MASAGE
     .  ('TRASH: TEST PARTICLES KILLED DUE TO ERRORS')
      CALL EIRENE_MASR1 ('PTRASH= ',PTRASH(ISTRA))
      CALL EIRENE_LEER(3)
      IF (TRCBLPH.OR.TRCBLA.OR.TRCBLM.OR.TRCBLI) THEN
        CALL EIRENE_MASAGE('TOTAL ERROR IN PARTICLE FLUX BALANCE')
        DIFT=DIFA(0,ISTRA)+DIFM(0,ISTRA)+DIFI(0,ISTRA)+DIFPH(0,ISTRA)+
     .       PTRASH(ISTRA)
        TOTT=TOTA(0)+TOTM(0)+TOTI(0)+TOTPH(0)+ABS(PTRASH(ISTRA))+EPS60
        DIFR=DIFT/TOTT*100.
        CALL EIRENE_MASR2 ('DIF: ABS, REL(%)',DIFT,DIFR)
        CALL EIRENE_LEER(2)
      ENDIF
C
C
C   ENERGY FLUX BALANCE, ATOMS 500 -- 510
C
      DIFA(0,ISTRA)=0.
      TOTA(0)=0.
      IF (.NOT.TRCBLA) GOTO 510
      IF (.NOT.LOGATM(0,ISTRA)) GOTO 510
      CALL EIRENE_HEADNG
     .  ('ENERGY FLUX BALANCE (WATT), NEUTRAL ATOMS',41)
      CALL EIRENE_LEER(1)
      CALL EIRENE_MASAGE('ENERGY FLUX FROM PRIMARY SOURCE')
      CALL EIRENE_MASR1 ('ETOTA=  ',ETOTA(ISTRA))
      CALL EIRENE_MASAGE('ENERGY FLUX FROM RECOMBINING BULK IONS')
      CALL EIRENE_MASR1 ('EPATI=  ',EPATI(ISTRA))
      IF (LOGATM(0,ISTRA)) THEN
        IF (LEAAT) THEN
          CALL EIRENE_MASAGE
     .     ('ENERGY FLUX FROM ATOM - PLASMA INTERACTION')
          CALL EIRENE_MASR1 ('EAATI=  ',EAATI(ISTRA))
        ELSE IF (LMSEAAT) THEN
          CALL EIRENE_MASAGE
     .     ('ENERGY FLUX FROM ATOM - PLASMA INTERACTION')
          CALL EIRENE_MASAGE
     .     ('EAAT     SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ENDIF
      IF (LOGMOL(0,ISTRA)) THEN
        IF (LEMAT) THEN
          CALL EIRENE_MASAGE
     .     ('ENERGY FLUX FROM MOLECULE - PLASMA INTERACTIONS')
          CALL EIRENE_MASR1 ('EMATI=  ',EMATI(ISTRA))
        ELSE IF (LMSEMAT) THEN
          CALL EIRENE_MASAGE
     .     ('ENERGY FLUX FROM MOLECULE - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('EMAT     SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ENDIF
      IF (LOGION(0,ISTRA)) THEN
        IF (LEIAT) THEN
          CALL EIRENE_MASAGE
     .     ('ENERGY FLUX FROM TEST ION - PLASMA INTERACTIONS')
          CALL EIRENE_MASR1 ('EIATI=  ',EIATI(ISTRA))
        ELSE IF (LMSEIAT) THEN
          CALL EIRENE_MASAGE
     .     ('ENERGY FLUX FROM TEST ION - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('EIAT     SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ENDIF
      IF (LOGPHOT(0,ISTRA)) THEN
        IF (LEPHAT) THEN
          CALL EIRENE_MASAGE
     .     ('ENERGY FLUX FROM PHOTON - PLASMA INTERACTIONS')
          CALL EIRENE_MASR1 ('EPHATI= ',EPHATI(ISTRA))
        ELSE IF (LMSEPHAT) THEN
          CALL EIRENE_MASAGE
     .     ('ENERGY FLUX FROM PHOTON - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('EPHAT    SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ENDIF
C   GENERATION LIMIT
      IF (.NOT.LEGENA) THEN
        IF (LMSEGENA) THEN
        CALL EIRENE_MASAGE('ENERGY ABSORBED DUE TO GENERATION LIMIT')
        CALL EIRENE_MASAGE
     .   ('EGENA    SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (EGENAI(0,ISTRA).NE.0.D0) THEN
        CALL EIRENE_MASAGE('ENERGY ABSORBED DUE TO GENERATION LIMIT')
        CALL EIRENE_MASR1 ('EGENAI= ',EGENAI(0,ISTRA))
      ENDIF
C   EFFLUX TO SURFACES
      IF (LEOTAT) THEN
        CALL EIRENE_MASAGE('ENERGY FLUX ONTO NON-TRANSPARENT SURFACES')
        CALL EIRENE_MASR1 ('EOTATI= ',EOTATI(0,ISTRA))
      ELSE IF (LMSEOTAT) THEN
        CALL EIRENE_MASAGE('ENERGY FLUX ONTO NON-TRANSPARENT SURFACES')
        CALL EIRENE_MASAGE
     .  ('EOTAT    SWITCHED OFF => MISSING IN BALANCE')
      ENDIF
C   REFLECTED FROM SURFACES
      CALL EIRENE_MASAGE('REFLECTED FROM NON-TRANSPARENT SURFACES')
      CALL EIRENE_MASR1 ('ERFATI= ',ERFAAI(0,ISTRA)+ERFMAI(0,ISTRA)+
     +                       ERFIAI(0,ISTRA)+ERFPHAI(0,ISTRA))
      IF (LMSERFAAT) CALL EIRENE_MASAGE
     .      ('ERFAAT SWITCHED OFF => MISSING IN BALANCE')
      IF (LMSERFMAT) CALL EIRENE_MASAGE
     .      ('ERFMAT SWITCHED OFF => MISSING IN BALANCE')
      IF (LMSERFIAT) CALL EIRENE_MASAGE
     .      ('ERFIAT SWITCHED OFF => MISSING IN BALANCE')
      IF (LMSERFPHAT) CALL EIRENE_MASAGE
     .      ('ERFPHAT SWITCHED OFF => MISSING IN BALANCE')
      CALL EIRENE_MASAGE('ABSOLUTE AND RELATIVE ERROR IN BALANCE')
      DIFA(0,ISTRA)=EOTATI(0,ISTRA)+EPATI(ISTRA)+EAATI(ISTRA)+
     +     ETOTA(ISTRA)+EMATI(ISTRA)+EIATI(ISTRA)+EGENAI(0,ISTRA)+
     +     ERFAAI(0,ISTRA)+ERFMAI(0,ISTRA)+ERFIAI(0,ISTRA)+
     +     EPHATI(ISTRA)+ERFPHAI(0,ISTRA)

      TOTA(0)=ABS(EOTATI(0,ISTRA))+ABS(EPATI(ISTRA))+ABS(EAATI(ISTRA))+
     +     ABS(ETOTA(ISTRA))+ABS(EMATI(ISTRA))+ABS(EIATI(ISTRA))+
     +     ABS(EGENAI(0,ISTRA))+
     +     ABS(ERFAAI(0,ISTRA)+ERFMAI(0,ISTRA)+ERFIAI(0,ISTRA))+
     +     ABS(EPHATI(ISTRA))+ABS(ERFPHAI(0,ISTRA))

      TOTA(0)=TOTA(0)+EPS60
      DIFRA(0,ISTRA)=SIGN(1._DP,DIFA(0,ISTRA))*
     *        MAX(0._DP,ABS(DIFA(0,ISTRA))/TOTA(0)*100._DP-1.E-5_DP)
      DIFA(0,ISTRA)=DIFRA(0,ISTRA)/100.*TOTA(0)
      CALL EIRENE_MASR2
     .  ('DIF: ABS, REL(%)',DIFA(0,ISTRA),DIFRA(0,ISTRA))
      CALL EIRENE_LEER(2)
C
  510 CONTINUE

C   ENERGY FLUX BALANCE, MOLECULES 510 -- 520

      DIFM(0,ISTRA)=0.
      TOTM(0)=0.
      IF (.NOT.TRCBLM) GOTO 520
      IF (.NOT.LOGMOL(0,ISTRA)) GOTO 520
C
      CALL EIRENE_HEADNG
     .  ('ENERGY FLUX BALANCE (WATT), NEUTRAL MOLECULES',45)
      CALL EIRENE_LEER(1)
      CALL EIRENE_MASAGE('FROM PRIMARY SOURCE')
      CALL EIRENE_MASR1 ('ETOTM = ',ETOTM(ISTRA))
      IF (.NOT.LEPML) THEN
        IF (LMSEPML) THEN
          CALL EIRENE_MASAGE('FROM RECOMBINING BULK IONS')
          CALL EIRENE_MASAGE
     .     ('EPML SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSEIF (EPMLI(ISTRA).NE.0.D0) THEN
        CALL EIRENE_MASAGE('FROM RECOMBINING BULK IONS')
        CALL EIRENE_MASR1 ('EPMLI=  ',EPMLI(ISTRA))
      END IF
      IF (.NOT.LEAML) THEN
        IF (LMSEAML) THEN
          CALL EIRENE_MASAGE
     .     ('ENERGY FLUX FROM ATOM - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('EAML     SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (EAMLI(ISTRA).NE.0.D0) THEN
        CALL EIRENE_MASAGE
     .   ('ENERGY FLUX FROM ATOM - PLASMA INTERACTIONS')
        CALL EIRENE_MASR1 ('EAMLI = ',EAMLI(ISTRA))
      ENDIF
      IF (LEMML) THEN
        CALL EIRENE_MASAGE
     .   ('ENERGY FLUX FROM MOLECULE - PLASMA INTERACTIONS')
        CALL EIRENE_MASR1 ('EMMLI = ',EMMLI(ISTRA))
      ELSE IF (LMSEMML) THEN
        CALL EIRENE_MASAGE
     .   ('ENERGY FLUX FROM MOLECULE - PLASMA INTERACTIONS')
        CALL EIRENE_MASAGE
     .   ('EMML SWITCHED OFF => MISSING IN BALANCE')
      END IF
      IF (.NOT.LEIML) THEN
        IF (LMSEIML) THEN
          CALL EIRENE_MASAGE
     .     ('ENERGY FLUX FROM TEST ION - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('EIML     SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (EIMLI(ISTRA).NE.0.D0) THEN
        CALL EIRENE_MASAGE
     .   ('ENERGY FLUX FROM TEST ION - PLASMA INTERACTIONS')
        CALL EIRENE_MASR1 ('EIMLI = ',EIMLI(ISTRA))
      ENDIF
      IF (.NOT.LEPHML) THEN
        IF (LMSEPHML) THEN
          CALL EIRENE_MASAGE
     .     ('ENERGY FLUX FROM PHOTON - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('EPHML    SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (EPHMLI(ISTRA).NE.0.D0) THEN
        CALL EIRENE_MASAGE
     .   ('ENERGY FLUX FROM PHOTON - PLASMA INTERACTIONS')
        CALL EIRENE_MASR1 ('EPHMLI= ',EPHMLI(ISTRA))
      ENDIF
C   GENERATION LIMIT
      IF (.NOT.LEGENM) THEN
        IF (LMSEGENM) THEN
          CALL EIRENE_MASAGE
     .     ('ENERGY ABSORBED DUE TO GENERATION LIMIT')
          CALL EIRENE_MASAGE
     .     ('EGENM    SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (EGENMI(0,ISTRA).NE.0.D0) THEN
        CALL EIRENE_MASAGE
     .   ('ENERGY ABSORBED DUE TO GENERATION LIMIT')
        CALL EIRENE_MASR1 ('EGENMI= ',EGENMI(0,ISTRA))
      ENDIF
C   EFFLUX ONTO SURFACES
      IF (LEOTML) THEN
        CALL EIRENE_MASAGE
     .   ('ENERGY FLUX ONTO NON-TRANSPARENT SURFACES')
        CALL EIRENE_MASR1 ('EOTMLI= ',EOTMLI(0,ISTRA))
      ELSE IF (LMSEOTML) THEN
        CALL EIRENE_MASAGE
     .   ('ENERGY FLUX ONTO NON-TRANSPARENT SURFACES')
        CALL EIRENE_MASAGE
     .   ('EOTML SWITCHED OFF => MISSING IN BALANCE')
      END IF
      CALL EIRENE_MASAGE
     .  ('REFLECTED FROM NON-TRANSPARENT SURFACES')
      CALL EIRENE_MASR1 ('ERFMLI= ',ERFAMI(0,ISTRA)+ERFMMI(0,ISTRA)+
     +                              ERFIMI(0,ISTRA)+ERFPHMI(0,ISTRA))
      IF (LMSERFAML) CALL EIRENE_MASAGE
     .      ('ERFAML SWITCHED OFF => MISSING IN BALANCE')
      IF (LMSERFMML) CALL EIRENE_MASAGE
     .      ('ERFMML SWITCHED OFF => MISSING IN BALANCE')
      IF (LMSERFIML) CALL EIRENE_MASAGE
     .      ('ERFIML SWITCHED OFF => MISSING IN BALANCE')
      IF (LMSERFPHML) CALL EIRENE_MASAGE
     .      ('ERFPHML SWITCHED OFF => MISSING IN BALANCE')
      CALL EIRENE_MASAGE
     .  ('ABSOLUTE AND RELATIVE ERROR IN BALANCE')
      DIFM(0,ISTRA)=
     +     EAMLI(ISTRA)+EOTMLI(0,ISTRA)+EIMLI(ISTRA)+EMMLI(ISTRA)+
     +     ETOTM(ISTRA)+EPMLI(ISTRA)+
     +     ERFAMI(0,ISTRA)+ERFMMI(0,ISTRA)+ERFIMI(0,ISTRA)+
     +     EPHMLI(ISTRA)+ERFPHMI(0,ISTRA)

      TOTM(0)=ABS(EAMLI(ISTRA))+ABS(EOTMLI(0,ISTRA))+ABS(EIMLI(ISTRA))+
     +        ABS(EMMLI(ISTRA))+ABS(ETOTM(ISTRA))+ABS(EPMLI(ISTRA))+
     +        ABS(ERFAMI(0,ISTRA)+ERFMMI(0,ISTRA)+ERFIMI(0,ISTRA))+
     +        ABS(EPHMLI(ISTRA))+ABS(ERFPHMI(0,ISTRA))

      TOTM(0)=TOTM(0)+EPS60
      DIFRM(0,ISTRA)=SIGN(1._DP,DIFM(0,ISTRA))*
     *        MAX(0._DP,ABS(DIFM(0,ISTRA))/TOTM(0)*100._DP-1.E-5_DP)
      DIFM(0,ISTRA)=DIFRM(0,ISTRA)/100.*TOTM(0)
      CALL EIRENE_MASR2
     .  ('DIF: ABS, REL(%)',DIFM(0,ISTRA),DIFRM(0,ISTRA))
      CALL EIRENE_LEER(2)
C
  520 CONTINUE

C   ENERGY FLUX BALANCE, TEST IONS 520 -- 530

      DIFI(0,ISTRA)=0.
      TOTI(0)=0.
      IF (.NOT.TRCBLI) GOTO 530
      IF (.NOT.LOGION(0,ISTRA)) GOTO 530
C
      CALL EIRENE_HEADNG ('ENERGY FLUX BALANCE (WATT), TEST IONS',37)
      CALL EIRENE_LEER(1)
      CALL EIRENE_MASAGE('FROM PRIMARY SOURCE')
      CALL EIRENE_MASR1 ('ETOTI = ',ETOTI(ISTRA))
      IF (.NOT.LEPIO) THEN
        IF (LMSEPIO) THEN
          CALL EIRENE_MASAGE('FROM RECOMBINING BULK IONS')
          CALL EIRENE_MASAGE('EPIO SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSEIF (EPIOI(ISTRA).NE.0.D0) THEN
        CALL EIRENE_MASAGE('FROM RECOMBINING BULK IONS')
        CALL EIRENE_MASR1 ('EPIOI=  ',EPIOI(ISTRA))
      END IF
      IF (.NOT.LEAIO) THEN
        IF (LMSEAIO) THEN
          CALL EIRENE_MASAGE
     .     ('ENERGY GAINED FROM ATOM - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('EAIO     SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (EAIOI(ISTRA).NE.0.D0) THEN
        CALL EIRENE_MASAGE
     .   ('ENERGY GAINED FROM ATOM - PLASMA INTERACTIONS')
        CALL EIRENE_MASR1 ('EAIOI = ',EAIOI(ISTRA))
      ENDIF
      IF (LEMIO) THEN
        CALL EIRENE_MASAGE
     .   ('ENERGY GAINED FROM MOLECULE - PLASMA INTERACTIONS')
        CALL EIRENE_MASR1 ('EMIOI = ',EMIOI(ISTRA))
      ELSE IF (LMSEMIO) THEN
        CALL EIRENE_MASAGE
     .   ('ENERGY GAINED FROM MOLECULE - PLASMA INTERACTIONS')
        CALL EIRENE_MASAGE
     .   ('EMIO SWITCHED OFF => MISSING IN BALANCE')
      END IF
      IF (.NOT.LEIIO) THEN
        IF (LMSEIIO) THEN
          CALL EIRENE_MASAGE
     .     ('ENERGY GAINED FROM TEST ION - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('EIIO     SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (EIIOI(ISTRA).NE.0.D0) THEN
        CALL EIRENE_MASAGE
     .   ('ENERGY GAINED FROM TEST ION - PLASMA INTERACTIONS')
        CALL EIRENE_MASR1 ('EIIOI = ',EIIOI(ISTRA))
      ENDIF
      IF (.NOT.LEPHIO) THEN
        IF (LMSEPHIO) THEN
          CALL EIRENE_MASAGE
     .     ('ENERGY GAINED FROM PHOTON - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('EPHIO    SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (EPHIOI(ISTRA).NE.0.D0) THEN
        CALL EIRENE_MASAGE
     .   ('ENERGY GAINED FROM PHOTON - PLASMA INTERACTIONS')
        CALL EIRENE_MASR1 ('EPHIOI= ',EPHIOI(ISTRA))
      ENDIF
      IF (EELFI(0,ISTRA).NE.0.D0) THEN
        CALL EIRENE_MASAGE ('ENERGY GAINED FROM ELECTRIC FIELDS')
        CALL EIRENE_MASR1 ('EELFI = ',EELFI(0,ISTRA))
      ENDIF
C   GENERATION LIMIT
      IF (.NOT.LEGENI) THEN
        IF (LMSEGENI) THEN
          CALL EIRENE_MASAGE('ENERGY ABSORBED DUE TO GENERATION LIMIT')
          CALL EIRENE_MASAGE
     .     ('EGENI    SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (EGENII(0,ISTRA).NE.0.D0) THEN
        CALL EIRENE_MASAGE
     .   ('ENERGY ABSORBED DUE TO GENERATION LIMIT')
        CALL EIRENE_MASR1 ('EGENII= ',EGENII(0,ISTRA))
      ENDIF
C   EFFLUX ONTO SURFACES
      IF (.NOT.LEOTIO) THEN
        IF (LMSEOTIO) THEN
          CALL EIRENE_MASAGE
     .     ('ENERGY FLUX ONTO NON-TRANSPARENT SURFACES')
          CALL EIRENE_MASAGE
     .     ('EOTIOI   SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (EOTIOI(0,ISTRA).NE.0.D0) THEN
        CALL EIRENE_MASAGE
     .   ('ENERGY FLUX ONTO NON-TRANSPARENT SURFACES')
        CALL EIRENE_MASR1 ('EOTIOI= ',EOTIOI(0,ISTRA))
      ENDIF
C   REFLECTED FROM SURFACES
      CALL EIRENE_MASAGE
     .  ('REFLECTED FROM NON-TRANSPARENT SURFACES')
      CALL EIRENE_MASR1 ('ERFIOI= ',ERFAII(0,ISTRA)+ERFMII(0,ISTRA)+
     +                       ERFIII(0,ISTRA)+ERFPHII(0,ISTRA))
      IF (LMSERFAIO) CALL EIRENE_MASAGE
     .      ('ERFAIO SWITCHED OFF => MISSING IN BALANCE')
      IF (LMSERFMIO) CALL EIRENE_MASAGE
     .      ('ERFMIO SWITCHED OFF => MISSING IN BALANCE')
      IF (LMSERFIIO) CALL EIRENE_MASAGE
     .      ('ERFIIO SWITCHED OFF => MISSING IN BALANCE')
      IF (LMSERFPHIO) CALL EIRENE_MASAGE
     .      ('ERFPHIO SWITCHED OFF => MISSING IN BALANCE')
C
      CALL EIRENE_MASAGE
     .  ('ABSOLUTE AND RELATIVE ERROR IN BALANCE')
      DIFI(0,ISTRA)=
     +     EAIOI(ISTRA)+EOTIOI(0,ISTRA)+EIIOI(ISTRA)+EMIOI(ISTRA)+
     +     ETOTI(ISTRA)+EPIOI(ISTRA)+EELFI(0,ISTRA)+
     +     ERFAII(0,ISTRA)+ERFMII(0,ISTRA)+ERFIII(0,ISTRA)+
     +     EPHIOI(ISTRA)+ERFPHII(0,ISTRA)

      TOTI(0)=ABS(EAIOI(ISTRA))+ABS(EOTIOI(0,ISTRA))+ABS(EIIOI(ISTRA))+
     +        ABS(EMIOI(ISTRA))+ABS(ETOTI(ISTRA))+ABS(EPIOI(ISTRA))+
     +        ABS(ERFAII(0,ISTRA)+ERFMII(0,ISTRA)+ERFIII(0,ISTRA))+
     +        ABS(EPHIOI(ISTRA))+ABS(ERFPHII(0,ISTRA))

      TOTI(0)=TOTI(0)+EPS60
      DIFRI(0,ISTRA)=SIGN(1._DP,DIFI(0,ISTRA))*
     *        MAX(0._DP,ABS(DIFI(0,ISTRA))/TOTI(0)*100._DP-1.E-5_DP)
      DIFI(0,ISTRA)=DIFRI(0,ISTRA)/100.*TOTI(0)
      CALL EIRENE_MASR2
     .  ('DIF: ABS, REL(%)',DIFI(0,ISTRA),DIFRI(0,ISTRA))
      CALL EIRENE_LEER(2)

  530 CONTINUE
C
C   ENERGY FLUX BALANCE, PHOTONS  530 -- 540
C
      DIFPH(0,ISTRA)=0.
      TOTPH(0)=0.
      IF (.NOT.TRCBLPH) GOTO 540
      IF (.NOT.LOGPHOT(0,ISTRA)) GOTO 540
      CALL EIRENE_HEADNG ('ENERGY FLUX BALANCE (WATT), PHOTONS',36)
      CALL EIRENE_LEER(1)
      CALL EIRENE_MASAGE('ENERGY FLUX FROM PRIMARY SOURCE')
      CALL EIRENE_MASR1 ('ETOTPH= ',ETOTPH(ISTRA))
      IF (LEPPHT) THEN
        CALL EIRENE_MASAGE('ENERGY FLUX FROM RECOMBINING BULK IONS')
        CALL EIRENE_MASR1 ('EPPHTI= ',EPPHTI(ISTRA))
      ELSE IF (LMSEPPHT) THEN
        CALL EIRENE_MASAGE('ENERGY FLUX FROM RECOMBINING BULK IONS')
        CALL EIRENE_MASAGE('EPPHT SWITCHED OFF => MISSING IN BALANCE')
      END IF
      IF (.NOT.LEPHPHT) THEN
        IF (LMSEPHPHT) THEN
          CALL EIRENE_MASAGE
     .     ('ENERGY FLUX FROM PHOTON - PLASMA INTERACTION')
          CALL EIRENE_MASAGE
     .     ('EPHPHT   SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (EPHPHTI(ISTRA).NE.0.D0) THEN
        CALL EIRENE_MASAGE
     .   ('ENERGY FLUX FROM PHOTON - PLASMA INTERACTION')
        CALL EIRENE_MASR1 ('EPHPHTI=',EPHPHTI(ISTRA))
      ENDIF
      IF (.NOT.LEAPHT) THEN
        IF (LMSEAPHT) THEN
          CALL EIRENE_MASAGE
     .     ('ENERGY FLUX FROM ATOM - PLASMA INTERACTION')
          CALL EIRENE_MASAGE
     .     ('EAPHT    SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (EAPHTI(ISTRA).NE.0.D0) THEN
        CALL EIRENE_MASAGE
     .   ('ENERGY FLUX FROM ATOM - PLASMA INTERACTION')
        CALL EIRENE_MASR1 ('EAPHTI= ',EAPHTI(ISTRA))
      ENDIF
      IF (.NOT.LEMPHT) THEN
        IF (LMSEMPHT) THEN
          CALL EIRENE_MASAGE
     .     ('ENERGY FLUX FROM MOLECULE - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('EMPHT    SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (EMPHTI(ISTRA).NE.0.D0) THEN
        CALL EIRENE_MASAGE
     .   ('ENERGY FLUX FROM MOLECULE - PLASMA INTERACTIONS')
        CALL EIRENE_MASR1 ('EMPHTI= ',EMPHTI(ISTRA))
      ENDIF
      IF (.NOT.LEIPHT) THEN
        IF (LMSEIPHT) THEN
          CALL EIRENE_MASAGE
     .     ('ENERGY FLUX FROM TEST ION - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('EIPHT    SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (EIPHTI(ISTRA).NE.0.D0) THEN
        CALL EIRENE_MASAGE
     .   ('ENERGY FLUX FROM TEST ION - PLASMA INTERACTIONS')
        CALL EIRENE_MASR1 ('EIPHTI= ',EIPHTI(ISTRA))
      ENDIF
C   GENERATION LIMIT
      IF (.NOT.LEGENPH) THEN
        IF (LMSEGENPH) THEN
          CALL EIRENE_MASAGE
     .     ('ENERGY ABSORBED DUE TO GENERATION LIMIT')
          CALL EIRENE_MASAGE
     .     ('EGENPH   SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (EGENPHI(0,ISTRA).NE.0.D0) THEN
        CALL EIRENE_MASAGE
     .   ('ENERGY ABSORBED DUE TO GENERATION LIMIT')
        CALL EIRENE_MASR1 ('EGENPHI=',EGENPHI(0,ISTRA))
      ENDIF
      IF (LEOTPHT) THEN
        CALL EIRENE_MASAGE
     .   ('ENERGY FLUX ONTO NON-TRANSPARENT SURFACES')
        CALL EIRENE_MASR1 ('EOTPHTI=',EOTPHTI(0,ISTRA))
      ELSE IF (LMSEOTPHT) THEN
        CALL EIRENE_MASAGE
     .   ('ENERGY FLUX ONTO NON-TRANSPARENT SURFACES')
        CALL EIRENE_MASAGE
     .   ('EOTPHT SWITCHED OFF => MISSING IN BALANCE')
      END IF
      CALL EIRENE_MASAGE
     . ('REFLECTED FROM NON-TRANSPARENT SURFACES')
      CALL EIRENE_MASR1 ('ERFPHTI=',ERFAPHTI(0,ISTRA)+ERFMPHTI(0,ISTRA)+
     +                       ERFIPHTI(0,ISTRA)+ERFPHPHTI(0,ISTRA))
      IF (LMSERFAPHT) CALL EIRENE_MASAGE
     .      ('ERFAPHT SWITCHED OFF => MISSING IN BALANCE')
      IF (LMSERFMPHT) CALL EIRENE_MASAGE
     .      ('ERFMPHT SWITCHED OFF => MISSING IN BALANCE')
      IF (LMSERFIPHT) CALL EIRENE_MASAGE
     .      ('ERFIPHT SWITCHED OFF => MISSING IN BALANCE')
      IF (LMSERFPHPHT) CALL EIRENE_MASAGE
     .      ('ERFPHPHT SWITCHED OFF => MISSING IN BALANCE')
      CALL EIRENE_MASAGE('ABSOLUTE AND RELATIVE ERROR IN BALANCE')
      DIFPH(0,ISTRA)=EOTPHTI(0,ISTRA)+EPPHTI(ISTRA)+EAPHTI(ISTRA)+
     +     ETOTPH(ISTRA)+EMPHTI(ISTRA)+EIPHTI(ISTRA)+EGENPHI(0,ISTRA)+
     +     ERFAPHTI(0,ISTRA)+ERFMPHTI(0,ISTRA)+ERFIPHTI(0,ISTRA)+
     +     EPHPHTI(ISTRA)+ERFPHPHTI(0,ISTRA)

      TOTPH(0)=ABS(EOTPHTI(0,ISTRA))+ABS(EPPHTI(ISTRA))+
     +     ABS(EAPHTI(ISTRA))+
     +     ABS(ETOTPH(ISTRA))+ABS(EMPHTI(ISTRA))+ABS(EIPHTI(ISTRA))+
     +     ABS(EGENPHI(0,ISTRA))+
     +     ABS(ERFAPHTI(0,ISTRA)+ERFMPHTI(0,ISTRA)+ERFIPHTI(0,ISTRA))+
     +     ABS(EPHPHTI(ISTRA))+ABS(ERFPHPHTI(0,ISTRA))

      TOTPH(0)=TOTPH(0)+EPS60
      DIFRPH(0,ISTRA)=SIGN(1._DP,DIFPH(0,ISTRA))*
     *        MAX(0._DP,ABS(DIFPH(0,ISTRA))/TOTPH(0)*100._DP-1.E-5_DP)
      DIFPH(0,ISTRA)=DIFRPH(0,ISTRA)/100.*TOTPH(0)
      CALL EIRENE_MASR2
     .  ('DIF: ABS, REL(%)',DIFPH(0,ISTRA),DIFRPH(0,ISTRA))
      CALL EIRENE_LEER(2)
C
C  TOTAL TEST PARTICLE ENERGY FLUX BALANCE
C
  540 CONTINUE
      CALL EIRENE_MASAGE('ETRASH: ENERGY ABSORBED DUE TO ERRORS')
      CALL EIRENE_MASR1 ('ETRASH= ',ETRASH(ISTRA))
      CALL EIRENE_LEER(3)
      IF (TRCBLA.OR.TRCBLM.OR.TRCBLI) THEN
        CALL EIRENE_MASAGE('TOTAL ERROR IN ENERGY FLUX BALANCE')
        DIFT=DIFA(0,ISTRA)+DIFM(0,ISTRA)+DIFI(0,ISTRA)+DIFPH(0,ISTRA)+
     +       ETRASH(ISTRA)

        TOTT=TOTA(0)+TOTM(0)+TOTI(0)+TOTPH(0)+ABS(ETRASH(ISTRA))+EPS60
        DIFR=DIFT/TOTT*100.
        CALL EIRENE_MASR2 ('DIF: ABS, REL(%)',DIFT,DIFR)
        CALL EIRENE_LEER(2)
      ENDIF
C
C  INTEGRATED BULK ION SOURCE TERMS  600 -- 700
C
      IF (.NOT.TRCBLP) GOTO 700
      IF (.NOT.LOGPLS(0,ISTRA)) GOTO 700
      CALL EIRENE_HEADNG ('PARTICLE FLUX BALANCE (AMP), BULK IONS',39)
      CALL EIRENE_LEER(1)
C  PRIMARY SOURCE ORIGINATING FROM BULK PARTICLES
      IF (ANY(WTOTP(1:NPLS,ISTRA).NE.0.D0)) THEN
cdr probably a redundancy here: wtotp and pppli are identical most often.
cdr Exception: pppl contains bulk secondaries (products) from initial bulk,
cdr wtotp is initial bulk reactant only (for source scaling)
        IF (.NOT.LPPPL) THEN
          IF (LMSPPPL) THEN
            CALL EIRENE_MASAGE('BULK PARTICLE FLUX')
            CALL EIRENE_MASAGE(
     .       '(DEFINING THE TEST PARTICLE SOURCE STRENGTH (AMP))')
            CALL EIRENE_MASAGE
     .       ('PPPL     SWITCHED OFF => MISSING IN BALANCE')
          ENDIF
        ELSE IF (ANY(PPPLI(1:NPLS,ISTRA).NE.0.D0)) THEN
          CALL EIRENE_MASAGE('BULK PARTICLE FLUX')
          CALL EIRENE_MASAGE(
     .     '(DEFINING THE TEST PARTICLE SOURCE STRENGTH (AMP))')
          CALL EIRENE_MASYR1('PPPLI =  ',PPPLI,
     .         LOGPLS,ISTRA,0,NPLS,NPLS,0,NSTRA,TEXTS(NSPAMI+1))
          CALL EIRENE_MASAGE('SUM OVER SPECIES')
          CALL EIRENE_MASR1 ('TOTAL=  ',PPPLI(0,ISTRA))
          CALL EIRENE_LEER(1)
        ENDIF
      ENDIF
C  ATOMS PLASMA INTERACTION
      IF (.NOT.LPAPL) THEN
        IF (LMSPAPL) THEN
          CALL EIRENE_MASAGE
     .     ('BULK PARTICLES BORN BY ATOM - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('PAPL     SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PAPLI(1:NPLS,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .   ('BULK PARTICLES BORN BY ATOM - PLASMA INTERACTIONS')
        N1D = NPLS
        IF (NLSPCSCL_ATM) N1D = NPLSP*NATMP-1
        CALL EIRENE_MASYR1('PAPLI  = ',PAPLI,
     .       LOGPLS,ISTRA,0,NPLS,N1D,0,NSTRA,TEXTS(NSPAMI+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PAPLI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
C  MOLECULE PLASMA INTERACTION
      IF (.NOT.LPMPL) THEN
        IF (LMSPMPL) THEN
          CALL EIRENE_MASAGE
     .     ('BULK IONS BORN BY MOLECULE - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('PMPL     SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PMPLI(1:NPLS,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .   ('BULK IONS BORN BY MOLECULE - PLASMA INTERACTIONS')
        N1D = NPLS
        IF (NLSPCSCL_MOL) N1D = NPLSP*NMOLP-1
        CALL EIRENE_MASYR1('PMPLI  = ',PMPLI,
     .       LOGPLS,ISTRA,0,NPLS,N1D,0,NSTRA,TEXTS(NSPAMI+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PMPLI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
C  TEST ION PLASMA INTERACTION
      IF (.NOT.LPIPL) THEN
        IF (LMSPIPL) THEN
          CALL EIRENE_MASAGE
     .     ('BULK IONS BORN BY TEST ION - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('PIPL     SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PIPLI(1:NPLS,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .   ('BULK IONS BORN BY TEST ION - PLASMA INTERACTIONS')
        N1D = NPLS
        IF (NLSPCSCL_ION) N1D = NPLSP*NIONP-1
        CALL EIRENE_MASYR1('PIPLI  = ',PIPLI,
     .       LOGPLS,ISTRA,0,NPLS,N1D,0,NSTRA,TEXTS(NSPAMI+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PIPLI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
C  PHOTON PLASMA INTERACTION
      IF (.NOT.LPPHPL) THEN
        IF (LMSPPHPL) THEN
          CALL EIRENE_MASAGE
     .     ('BULK IONS BORN BY PHOTON - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('PPHPL    SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(PPHPLI(1:NPLS,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .   ('BULK IONS BORN BY PHOTON - PLASMA INTERACTIONS')
        N1D = NPLS
        IF (NLSPCSCL_PHOT) N1D = NPLSP*NPHOTP-1
        CALL EIRENE_MASYR1('PPHPLI = ',PPHPLI,
     .       LOGPLS,ISTRA,0,NPLS,N1D,0,NSTRA,TEXTS(NSPAMI+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',PPHPLI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
C  SPUTTERED BULK ION FLUXES (I.E. PARTICLES SPUTTERED AS BULK IONS IPLS=1,NPLSI)
      SMSPT = 0._DP
      IF (.NOT.LSPTAPL) THEN
        IF (LMSSPTAPL) THEN
          CALL EIRENE_MASAGE('BULK ION FLUX SPUTTERED, ORIG: ATOMS')
          CALL EIRENE_MASAGE
     .     ('SPTAPL   SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(SPTAPLI(1:NPLS,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('BULK ION FLUX SPUTTERED, ORIG: ATOMS')
        CALL EIRENE_MASYR1('SPTAPLI =',SPTAPLI,
     .       LOGPLS,ISTRA,0,NPLS,NPLS,0,NSTRA,TEXTS(NSPAMI+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',SPTAPLI(0,ISTRA))
        CALL EIRENE_LEER(1)
        SMSPT = SMSPT + SPTAPLI(0,ISTRA)
      ENDIF
      IF (.NOT.LSPTMPL) THEN
        IF (LMSSPTMPL) THEN
          CALL EIRENE_MASAGE('BULK ION FLUX SPUTTERED, ORIG: MOLECULES')
          CALL EIRENE_MASAGE
     .     ('SPTMPL   SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(SPTMPLI(1:NPLS,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('BULK ION FLUX SPUTTERED, ORIG: MOLECULES')
        CALL EIRENE_MASYR1('SPTMPLI =',SPTMPLI,
     .       LOGPLS,ISTRA,0,NPLS,NPLS,0,NSTRA,TEXTS(NSPAMI+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',SPTMPLI(0,ISTRA))
        CALL EIRENE_LEER(1)
        SMSPT = SMSPT + SPTMPLI(0,ISTRA)
      ENDIF
      IF (.NOT.LSPTIPL) THEN
        IF (LMSSPTIPL) THEN
          CALL EIRENE_MASAGE('BULK ION FLUX SPUTTERED, ORIG: TEST IONS')
          CALL EIRENE_MASAGE
     .     ('SPTIPL   SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(SPTIPLI(1:NPLS,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('BULK ION FLUX SPUTTERED, ORIG: TEST IONS')
        CALL EIRENE_MASYR1('SPTIPLI =',SPTIPLI,
     .       LOGPLS,ISTRA,0,NPLS,NPLS,0,NSTRA,TEXTS(NSPAMI+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',SPTIPLI(0,ISTRA))
        CALL EIRENE_LEER(1)
        SMSPT = SMSPT + SPTIPLI(0,ISTRA)
      ENDIF
      IF (.NOT.LSPTPHPL) THEN
        IF (LMSSPTPHPL) THEN
          CALL EIRENE_MASAGE('BULK ION FLUX SPUTTERED, ORIG: PHOTONS')
          CALL EIRENE_MASAGE
     .     ('SPTPHPL  SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(SPTPHPLI(1:NPLS,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('BULK ION FLUX SPUTTERED, ORIG: PHOTONS')
        CALL EIRENE_MASYR1('SPTPHPLI=',SPTPHPLI,
     .       LOGPLS,ISTRA,0,NPLS,NPLS,0,NSTRA,TEXTS(NSPAMI+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',SPTPHPLI(0,ISTRA))
        CALL EIRENE_LEER(1)
        SMSPT = SMSPT + SPTPHPLI(0,ISTRA)
      ENDIF
      IF (.NOT.LSPTPPL) THEN
        IF (LMSSPTPPL) THEN
          CALL EIRENE_MASAGE('BULK ION FLUX SPUTTERED, ORIG: BULK IONS')
          CALL EIRENE_MASAGE
     .     ('SPTPPL   SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(SPTPPLI(1:NPLS,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('BULK ION FLUX SPUTTERED, ORIG: BULK IONS')
        CALL EIRENE_MASYR1('SPTPPLI =',SPTPPLI,
     .       LOGPLS,ISTRA,0,NPLS,NPLS,0,NSTRA,TEXTS(NSPAMI+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',SPTPPLI(0,ISTRA))
        CALL EIRENE_LEER(1)
        SMSPT = SMSPT + SPTPPLI(0,ISTRA)
      ENDIF
      IF (ABS(SMSPT) > EPS10) THEN
        CALL EIRENE_MASAGE('TOTAL FLUX SPUTTERED AS BULK IONS')
        CALL EIRENE_MASR1 ('TOTAL=  ',SMSPT)
      END IF
      IF (ABS(SPTPLTTI(ISTRA)) > EPS10) THEN
        CALL EIRENE_MASAGE('TOTAL FLUX SPUTTERED BY BULK IONS')
        CALL EIRENE_MASR1 ('SPTPLTT=',SPTPLTTI(ISTRA))
      END IF
      CALL EIRENE_LEER(2)
      PLOSSP=PPPLI(0,ISTRA)
      PGAINP=PAPLI(0,ISTRA)+PMPLI(0,ISTRA)+PIPLI(0,ISTRA)+
     +       PPHPLI(0,ISTRA)

      CALL EIRENE_MASAGE('TOTAL LOSS  ---  TOTAL GAIN')
      CALL EIRENE_MASR2 ('LOSS--GAIN      ',PLOSSP,PGAINP)
      CALL EIRENE_LEER(2)
C
      CALL EIRENE_HEADNG ('ENERGY FLUX BALANCE (WATT), BULK IONS',37)
      CALL EIRENE_LEER(1)
      IF (ETOTP(ISTRA).NE.0.D0) THEN
      IF (.NOT.LEPPL) THEN
        IF (LMSEPPL) THEN
          CALL EIRENE_MASAGE('BULK ION ENERGY FLUX BEING')
          CALL EIRENE_MASAGE('NEUTRALIZED (DEFINING THE TEST PARTICLES')
          CALL EIRENE_MASAGE('SOURCE STRENGTH (WATT))')
          CALL EIRENE_MASAGE
     .     ('EPPL     SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(EPPLI(1:NPLS,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE('BULK ION ENERGY FLUX BEING')
        CALL EIRENE_MASAGE('NEUTRALIZED (DEFINING THE TEST PARTICLES')
        CALL EIRENE_MASAGE('SOURCE STRENGTH (WATT))')
        CALL EIRENE_MASYR1('EPPLI =  ',EPPLI,
     .       LOGPLS,ISTRA,0,NPLS,NPLS,0,NSTRA,TEXTS(NSPAMI+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',EPPLI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
      ENDIF
      IF (.NOT.LEAPL) THEN
        IF (LMSEAPL) THEN
          CALL EIRENE_MASAGE
     .     ('ENERGY GAIN DUE TO ATOM - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('EAPL     SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(EAPLI(1:NPLS,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .   ('ENERGY GAIN DUE TO ATOM - PLASMA INTERACTIONS')
        CALL EIRENE_MASYR1('EAPLI  = ',EAPLI,
     .       LOGPLS,ISTRA,0,NPLS,NPLS,0,NSTRA,TEXTS(NSPAMI+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',EAPLI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
      IF (.NOT.LRAEL) THEN
        IF (LMSRAEL) THEN
        CALL EIRENE_MASAGE('RADIATION EMITTED BY ATOMS')
        CALL EIRENE_MASAGE
     .   ('RAEL      SWITCHED OFF => MISSING RADIATION')
        ENDIF
      ELSE IF (ANY(RAELI(1:NATM,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .   ('RADIATION DUE TO ELECTRON-ATOM INTERACTIONS')
        CALL EIRENE_MASYR1 ('RAELI  = ',RAELI,
     .       LOGATM,ISTRA,0,NATM,NATM,0,NSTRA,TEXTS(NSPH+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',RAELI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
      IF (.NOT.LEMPL) THEN
        IF (LMSEMPL) THEN
          CALL EIRENE_MASAGE
     .     ('ENERGY GAIN FROM MOLECULE - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('EMPL     SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(EMPLI(1:NPLS,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .   ('ENERGY GAIN FROM MOLECULE - PLASMA INTERACTIONS')
        CALL EIRENE_MASYR1('EMPLI  = ',EMPLI,
     .       LOGPLS,ISTRA,0,NPLS,NPLS,0,NSTRA,TEXTS(NSPAMI+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',EMPLI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
      IF (.NOT.LRMEL) THEN
        IF (LMSRMEL) THEN
        CALL EIRENE_MASAGE('RADIATION EMITTED BY MOLECULES')
        CALL EIRENE_MASAGE
     .   ('RMEL      SWITCHED OFF => MISSING RADIATION    ')
        ENDIF
      ELSE IF (ANY(RMELI(1:NMOL,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .  ('RADIATION DUE TO ELECTRON-MOLECULE INTERACTIONS')
        CALL EIRENE_MASYR1 ('RMELI  = ',RMELI,
     .       LOGMOL,ISTRA,0,NMOL,NMOL,0,NSTRA,TEXTS(NSPA+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',RMELI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
      IF (.NOT.LEIPL) THEN
        IF (LMSEIPL) THEN
          CALL EIRENE_MASAGE
     .     ('ENERGY GAIN FROM TEST ION - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('EIPL     SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(EIPLI(1:NPLS,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .   ('ENERGY GAIN FROM TEST ION - PLASMA INTERACTIONS')
        CALL EIRENE_MASYR1('EIPLI  = ',EIPLI,
     .       LOGPLS,ISTRA,0,NPLS,NPLS,0,NSTRA,TEXTS(NSPAMI+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',EIPLI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
      IF (.NOT.LRIEL) THEN
        IF (LMSRIEL) THEN
        CALL EIRENE_MASAGE('RADIATION EMITTED BY TEST IONS')
        CALL EIRENE_MASAGE
     .   ('RIEL      SWITCHED OFF => MISSING RADIATION')
        ENDIF
      ELSE IF (ANY(RIELI(1:NION,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .   ('RADIATION DUE TO ELECTRON-TEST ION INTERACTIONS')
        CALL EIRENE_MASYR1 ('RIELI  = ',RIELI,
     .       LOGION,ISTRA,0,NION,NION,0,NSTRA,TEXTS(NSPAM+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',RIELI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
      IF (.NOT.LEPHPL) THEN
        IF (LMSEPHPL) THEN
          CALL EIRENE_MASAGE
     .     ('ENERGY GAIN FROM PHOTON - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('EPHPL    SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (ANY(EPHPLI(1:NPLS,ISTRA).NE.0.D0)) THEN
        CALL EIRENE_MASAGE
     .   ('ENERGY GAIN FROM PHOTON - PLASMA INTERACTIONS')
        CALL EIRENE_MASYR1('EPHPLI = ',EPHPLI,
     .       LOGPLS,ISTRA,0,NPLS,NPLS,0,NSTRA,TEXTS(NSPAMI+1))
        CALL EIRENE_MASAGE('SUM OVER SPECIES')
        CALL EIRENE_MASR1 ('TOTAL=  ',EPHPLI(0,ISTRA))
        CALL EIRENE_LEER(1)
      ENDIF
      CALL EIRENE_LEER(2)
      ELOSSP=EPPLI(0,ISTRA)
      EGAINP=EAPLI(0,ISTRA)+EMPLI(0,ISTRA)+EIPLI(0,ISTRA)+
     .       EPHPLI(0,ISTRA)
      CALL EIRENE_MASAGE('TOTAL LOSS  ---   TOTAL GAIN')
      CALL EIRENE_MASR2 ('LOSS--GAIN      ',ELOSSP,EGAINP)
      CALL EIRENE_LEER(2)
C
  700 CONTINUE
C
C  INTEGRATED ELECTRON SOURCE TERMS  700 -- 800
C
      IF (.NOT.TRCBLE) GOTO 800
C
      CALL EIRENE_HEADNG ('PARTICLE FLUX BALANCE (AMP), ELECTRONS',39)
      CALL EIRENE_LEER(1)
cdr  wtote exists, but tally ppel and ppeli not. So use wtote here
      IF (WTOTE(ISTRA).NE.0.D0) THEN
        CALL EIRENE_MASAGE
     .   ('BULK ELECTRON PARTICLE FLUX BEING NEUTRALIZED')
        CALL EIRENE_MASR1 ('PTOTE=  ',WTOTE(ISTRA))
      ENDIF
C  ATOMS PLASMA INTERACTION
      IF (.NOT.LPAEL) THEN
        IF (LMSPAEL) THEN
          CALL EIRENE_MASAGE
     .     ('ELECTRONS BORN BY ATOM - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('PAEL     SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (PAELI(ISTRA).NE.0.D0) THEN
        CALL EIRENE_MASAGE
     .   ('ELECTRONS BORN BY ATOM - PLASMA INTERACTIONS')
        CALL EIRENE_MASR1 ('PAELI=  ',PAELI(ISTRA))
      ENDIF
C  MOLECULE PLASMA INTERACTION
      IF (.NOT.LPMEL) THEN
        IF (LMSPMEL) THEN
          CALL EIRENE_MASAGE
     .     ('ELECTRONS BORN BY MOLECULE - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('PMEL     SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (PMELI(ISTRA).NE.0.D0) THEN
        CALL EIRENE_MASAGE
     .   ('ELECTRONS BORN BY MOLECULE - PLASMA INTERACTIONS')
        CALL EIRENE_MASR1 ('PMELI=  ',PMELI(ISTRA))
      ENDIF
C  TEST ION PLASMA INTERACTION
      IF (.NOT.LPIEL) THEN
        IF (LMSPIEL) THEN
          CALL EIRENE_MASAGE
     .     ('ELECTRONS BORN BY TEST ION - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('PIEL     SWITCHED OFF => MISSING IN BALANCE    ')
        ENDIF
      ELSE IF (PIELI(ISTRA).NE.0.D0) THEN
        CALL EIRENE_MASAGE
     .   ('ELECTRONS BORN BY TEST ION - PLASMA INTERACTIONS')
        CALL EIRENE_MASR1 ('PIELI=  ',PIELI(ISTRA))
      ENDIF
C  PHOTON PLASMA INTERACTION
      IF (.NOT.LPPHEL) THEN
        IF (LMSPPHEL) THEN
          CALL EIRENE_MASAGE
     .     ('ELECTRONS BORN BY PHOTON - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('PPHEL    SWITCHED OFF => MISSING IN BALANCE    ')
        ENDIF
      ELSE IF (PPHELI(ISTRA).NE.0.D0) THEN
        CALL EIRENE_MASAGE
     .   ('ELECTRONS BORN BY PHOTON - PLASMA INTERACTIONS')
        CALL EIRENE_MASR1 ('PPHELI=  ',PPHELI(ISTRA))
      ENDIF
      CALL EIRENE_LEER(2)
      PLOSSE=WTOTE(ISTRA)
      PGAINE=PAELI(ISTRA)+PMELI(ISTRA)+PIELI(ISTRA)+PPHELI(ISTRA)
      CALL EIRENE_MASAGE('TOTAL LOSS  ---  TOTAL GAIN')
      CALL EIRENE_MASR2 ('LOSS--GAIN      ',PLOSSE,PGAINE)
      CALL EIRENE_LEER(2)
C
      CALL EIRENE_HEADNG ('ENERGY FLUX BALANCE (WATT), ELECTRONS',37)
      CALL EIRENE_LEER(1)
C  TO BE WRITTEN: ETOTE FOR RECOMBINATION
C     IF (ETOTE(ISTRA).NE.0.D0) THEN
C       CALL EIRENE_MASAGE('BULK ELECTRON ENERGY FLUX BEING LOST')
C       CALL EIRENE_MASAGE('UPON RECOMBINATION')
C       CALL EIRENE_MASR1 ('ETOTE=  ',ETOTE(ISTRA))
C     ENDIF
      IF (.NOT.LEAEL) THEN
        IF (LMSEAEL) THEN
          CALL EIRENE_MASAGE
     .     ('ENERGY GAIN DUE TO ATOM - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('EAEL     SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (EAELI(ISTRA).NE.0.D0) THEN
        CALL EIRENE_MASAGE
     .   ('ENERGY GAIN DUE TO ATOM - PLASMA INTERACTIONS')
        CALL EIRENE_MASR1 ('EAELI=  ',EAELI(ISTRA))
      ENDIF
      IF (.NOT.LEMEL) THEN
        IF (LMSEMEL) THEN
          CALL EIRENE_MASAGE
     .     ('ENERGY GAIN DUE TO MOLECULE - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('EMEL     SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (EMELI(ISTRA).NE.0.D0) THEN
        CALL EIRENE_MASAGE
     .   ('ENERGY GAIN DUE TO MOLECULE - PLASMA INTERACTIONS')
        CALL EIRENE_MASR1 ('EMELI=  ',EMELI(ISTRA))
      ENDIF
      IF (.NOT.LEIEL) THEN
        IF (LMSEIEL) THEN
          CALL EIRENE_MASAGE
     .     ('ENERGY GAIN DUE TO TEST ION - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('EIEL     SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (EIELI(ISTRA).NE.0.D0) THEN
        CALL EIRENE_MASAGE
     .   ('ENERGY GAIN DUE TO TEST ION - PLASMA INTERACTIONS')
        CALL EIRENE_MASR1 ('EIELI=  ',EIELI(ISTRA))
      ENDIF
      IF (.NOT.LEPHEL) THEN
        IF (LMSEPHEL) THEN
          CALL EIRENE_MASAGE
     .     ('ENERGY GAIN DUE TO PHOTON - PLASMA INTERACTIONS')
          CALL EIRENE_MASAGE
     .     ('EPHEL    SWITCHED OFF => MISSING IN BALANCE')
        ENDIF
      ELSE IF (EPHELI(ISTRA).NE.0.D0) THEN
        CALL EIRENE_MASAGE
     .   ('ENERGY GAIN DUE TO PHOTON - PLASMA INTERACTIONS')
        CALL EIRENE_MASR1 ('EPHELI=  ',EPHELI(ISTRA))
      ENDIF
      ELOSSE=EMELI(ISTRA)+EAELI(ISTRA)+EIELI(ISTRA)+EPHELI(ISTRA)
      ERADE =RAELI(0,ISTRA)+RMELI(0,ISTRA)+RIELI(0,ISTRA)
      EGAINE=0.
      CALL EIRENE_MASAGE('TOTAL LOSS  ---   TOTAL GAIN')
      CALL EIRENE_MASR2 ('LOSS--GAIN      ',ELOSSE,EGAINE)
      CALL EIRENE_MASAGE('TOTAL RADIATION')
      CALL EIRENE_MASR1 ('TOTAL=  ',ERADE)
      CALL EIRENE_LEER(2)
  800 CONTINUE
C
C  TOTAL PUMPED FLUXES  800 -- 900
      WRITE (iunout,*)
     .  'SURFACES, AT WHICH TEST PARTICLES FLUXES ARE REDUCED'
      IF (LSPUMP) THEN
        WRITE (iunout,'(1X,A5,1X,A8,A12)')
     .        'NO.','SPECIES ',' PUMPED FLUX'
        PMPTOT = 0._DP
        DO J=1,NLIMPS
          JJ=J
          IF (J.GT.NLIM) JJ=-(J-NLIM)
          SPA=0.D0
          DO IS=1,NSPTOT
            IF (SPUMP(IS,J).GT.0.) THEN
              WRITE (iunout,'(1X,I5,1X,A8,1PE12.4)')
     .               JJ,TEXTS(IS),SPUMP(IS,J)
              SPA=SPA+SPUMP(IS,J)*NPRT(IS)
              PMPTOT(IS) = PMPTOT(IS) + SPUMP(IS,J)*NPRT(IS)
            ENDIF
          ENDDO
          PMPTOT(0) = PMPTOT(0) + SPA
        ENDDO
        IF (PMPTOT(0).GT.0.D0) CALL EIRENE_LEER(1)
        CALL EIRENE_MASAGE('PUMPED FLUX (ATOMIC) PER SPECIES')
        DO IS=1,NSPTOT
          IF (PMPTOT(IS) > 0.D0) WRITE (iunout,'(1X,A8,1PE12.4)')
     .                           TEXTS(IS),PMPTOT(IS)
        END DO
        CALL EIRENE_LEER(1)
        CALL EIRENE_MASAGE('TOTAL PUMPED FLUX (ATOMIC)')
        CALL EIRENE_MASR1 ('PUMPTOT=',PMPTOT(0))
      ELSE IF (LMSSPUMP) THEN
        CALL EIRENE_MASAGE
     .  ('SPUMP SWITCHED OFF => MISSING IN BALANCE')
      END IF

      IF (SUM(ABS(CEMETERYV)) > 0._DP) THEN
        CALL EIRENE_LEER(2)
        WRITE (iunout,*) ' CEMETERYV != 0'
        WRITE (iunout,*) ' CHECK SUBROUTINE EIRENE_UPDATE FOR BUGS!'
        CALL EIRENE_LEER(2)
      END IF
C
C   DETAILED OUTPUT OF FLUXES ONTO AND FROM SURFACES
      IF (NSURPR.GT.0) THEN
        CALL EIRENE_OUTFLX('FLUXES AT SURFACES              ',ISTRA)
      ENDIF

      IF (SUM(ABS(CEMETERYS)) > 0._DP) THEN
        CALL EIRENE_LEER(2)
        WRITE (iunout,*) ' SURFACE TALLIES: CEMETERYS != 0'
        WRITE (iunout,*) ' CHECK SCORING IN UPDATE_SURFACE FOR BUGS'
        CALL EIRENE_LEER(2)
      END IF
C
      CALL EIRENE_PAGE
C
 1000 CONTINUE

      if (allocated(vector)) deallocate (vector)
      if (allocated(X1D)) deallocate (X1D)
      if (allocated(dummy)) deallocate (dummy)

      RETURN
      END SUBROUTINE EIRENE_OUTEIR
