      MODULE EIRMOD_CUPD
cdr originally for tracing particles across several geometry cells in a
cdr single step. Must be threadprivate

cdr  contains redundant coding: cell_info, type traject,....

      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD

      IMPLICIT NONE

      PRIVATE

      PUBLIC :: EIRENE_ALLOC_CUPD, EIRENE_DEALLOC_CUPD, EIRENE_INIT_CUPD
      PUBLIC :: CELL_INFO, TRAJECT, TRAJECT_ARRAY, EIRENE_CELL_INSERT,
     .          EIRENE_CELL_DELETE, EIRENE_CLEAR_TRAJECTORY
cdr  probably out
      TYPE CELL_INFO
        REAL(DP) :: FLIGHT
        INTEGER :: NO_CELL, NO_SPECT
        TYPE(CELL_INFO), POINTER :: NEXTC, PREVC
      END TYPE CELL_INFO

cdr  probably out
      TYPE TRAJECT
        REAL(DP) :: VX, VY, VZ, WGHT
        REAL(DP) :: P1(3), P2(3)
        INTEGER :: NCOU_CELL, IND_EVENT, NO_SURF, TYP
        TYPE(CELL_INFO), POINTER :: CELLS
      END TYPE TRAJECT

      TYPE TRAJECT_ARRAY
        TYPE(TRAJECT), POINTER :: TRJ
      END TYPE TRAJECT_ARRAY

      TYPE(TRAJECT_ARRAY), PUBLIC, ALLOCATABLE, SAVE :: TRAJ(:)

      REAL(DP), PUBLIC, SAVE ::
     R X00, Y00, Z00, X01, Y01, Z01

      REAL(DP), PUBLIC, ALLOCATABLE, SAVE ::
     R ALPD(:), BLPD(:), CLPD(:)

      INTEGER, PUBLIC, SAVE ::
     I NCOUP, NCOUT,  NCOU,   NNTCLL,
     I IRCELL, IPCELL, ITCELL, ISRFCL

      INTEGER, PUBLIC, ALLOCATABLE, SAVE ::
     I JUPC(:),   KUPC(:),   NUPC(:),
     I NCOUNP(:), NCOUNT(:),
     I LUPC(:),   MUPC(:)

#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP  THREADPRIVATE(X00,Y00,Z00,X01,Y01,Z01,ALPD,BLPD,CLPD,NCOUP,NCOUT,
!$OMP& NCOU,NNTCLL,IRCELL,IPCELL,ITCELL,ISRFCL,JUPC,KUPC,NUPC,NCOUNP,
!$OMP& NCOUNT,LUPC,MUPC)
#endif

      CONTAINS


      SUBROUTINE EIRENE_ALLOC_CUPD

      IF (ALLOCATED(ALPD)) RETURN

      ALLOCATE (ALPD(N2ND))
      ALLOCATE (BLPD(N3RD))
      ALLOCATE (CLPD(N2ND+N3RD))

      ALLOCATE (JUPC(N2ND))
      ALLOCATE (KUPC(N3RD))
      ALLOCATE (NUPC(N2ND+N3RD))
      ALLOCATE (NCOUNP(N2ND+N3RD))
      ALLOCATE (NCOUNT(N2ND+N3RD))
      ALLOCATE (LUPC(N2ND))
      ALLOCATE (MUPC(N2ND))

      WRITE (IUNMEM,'(A,T25,I15)')
     .      ' CUPD ',2*(N2ND+N3RD)*8
      WRITE (IUNMEM,'(A,T25,I15)')
     .      ' CUPD ',(4*(N2ND+N3RD)+2*N2ND)*4

      CALL EIRENE_INIT_CUPD

      RETURN

      END SUBROUTINE EIRENE_ALLOC_CUPD


      SUBROUTINE EIRENE_DEALLOC_CUPD

      IF (.NOT.ALLOCATED(ALPD)) RETURN

      DEALLOCATE (ALPD)
      DEALLOCATE (BLPD)
      DEALLOCATE (CLPD)

      DEALLOCATE (JUPC)
      DEALLOCATE (KUPC)
      DEALLOCATE (NUPC)
      DEALLOCATE (NCOUNP)
      DEALLOCATE (NCOUNT)
      DEALLOCATE (LUPC)
      DEALLOCATE (MUPC)

      RETURN

      END SUBROUTINE EIRENE_DEALLOC_CUPD


      SUBROUTINE EIRENE_INIT_CUPD

      ALPD   = 0._DP
      BLPD   = 0._DP
      CLPD   = 0._DP

      JUPC   = 0
      KUPC   = 0
      NUPC   = 0
      NCOUNP = 0
      NCOUNT = 0
      LUPC   = 0
      MUPC   = 0
      NNTCLL = 0

      X00 = -75.75E20_DP
      Y00 = -75.75E20_DP
      Z00 = -75.75E20_DP
      X01 = -75.75E20_DP
      Y01 = -75.75E20_DP
      Z01 = -75.75E20_DP

      RETURN

      END SUBROUTINE EIRENE_INIT_CUPD


      SUBROUTINE EIRENE_CELL_INSERT (ICHOR,NEW_CELL)

      INTEGER, INTENT(IN) :: ICHOR
      TYPE(CELL_INFO), POINTER :: NEW_CELL

      IF (.NOT.ASSOCIATED(TRAJ(ICHOR)%TRJ%CELLS)) THEN

        NEW_CELL%NEXTC => NEW_CELL
        NEW_CELL%PREVC => NEW_CELL
        TRAJ(ICHOR)%TRJ%CELLS => NEW_CELL

      ELSE

        NEW_CELL%NEXTC => TRAJ(ICHOR)%TRJ%CELLS
        NEW_CELL%PREVC => TRAJ(ICHOR)%TRJ%CELLS%PREVC
        TRAJ(ICHOR)%TRJ%CELLS%PREVC%NEXTC => NEW_CELL
        TRAJ(ICHOR)%TRJ%CELLS%PREVC => NEW_CELL

      END IF

      END SUBROUTINE EIRENE_CELL_INSERT


      SUBROUTINE EIRENE_CELL_DELETE (ICHOR,CUR)

      INTEGER, INTENT(IN) :: ICHOR
      TYPE(CELL_INFO), POINTER :: CUR

      IF (ASSOCIATED(CUR%NEXTC,CUR%PREVC)) THEN

! only one element in cell list
        NULLIFY(TRAJ(ICHOR)%TRJ%CELLS)

      ELSE

        IF (ASSOCIATED(TRAJ(ICHOR)%TRJ%CELLS,CUR)) THEN
! first element in cell list is going to be deleted
! therefore adjust head pointer to list
          TRAJ(ICHOR)%TRJ%CELLS => CUR%NEXTC
        END IF

        CUR%NEXTC%PREVC => CUR%PREVC
        CUR%PREVC%NEXTC => CUR%NEXTC

      END IF

      NULLIFY(CUR%NEXTC)
      NULLIFY(CUR%PREVC)
      DEALLOCATE(CUR)
      NULLIFY(CUR)

      END SUBROUTINE EIRENE_CELL_DELETE


      SUBROUTINE EIRENE_CLEAR_TRAJECTORY (ICHOR)

      INTEGER, INTENT(IN) :: ICHOR
      TYPE(CELL_INFO), POINTER :: CUR, CURDEL

      CUR => TRAJ(ICHOR)%TRJ%CELLS
      NULLIFY(CUR%PREVC%NEXTC)

      NULLIFY(TRAJ(ICHOR)%TRJ%CELLS)

      DO WHILE (ASSOCIATED(CUR))

        CURDEL => CUR
        CUR => CUR%NEXTC

        NULLIFY(CURDEL%NEXTC)
        NULLIFY(CURDEL%PREVC)
        DEALLOCATE(CURDEL)

      END DO

      TRAJ(ICHOR)%TRJ%NCOU_CELL = 0
      TRAJ(ICHOR)%TRJ%NO_SURF = 0
      TRAJ(ICHOR)%TRJ%VX = 0._DP
      TRAJ(ICHOR)%TRJ%VY = 0._DP
      TRAJ(ICHOR)%TRJ%VZ = 0._DP
      TRAJ(ICHOR)%TRJ%WGHT = 0._DP
      TRAJ(ICHOR)%TRJ%P1 = 0._DP
      TRAJ(ICHOR)%TRJ%P2 = 0._DP

      END SUBROUTINE EIRENE_CLEAR_TRAJECTORY

      END MODULE EIRMOD_CUPD
