cdr may 17:   add trcrnf: diagnostics from random number generation,
cdr           correlated sampling etc.
cdr mar 18:   add trchktm (species-resolved cpu consumption),
cdr           read in first line block 11.
cdr           and remove (deactivate) the unused trcdbg... flags inherited from
cdr           V.K. proprietary versions
cdr dec 20:   trcmeld:  turn off all cpu-time consumption printout, to facilitate
cdr                     comparison of large output files.

      MODULE EIRMOD_CTRCEI

      USE EIRMOD_PARMMOD

      IMPLICIT NONE

      PRIVATE

      PUBLIC :: EIRENE_ALLOC_CTRCEI, EIRENE_DEALLOC_CTRCEI,
     P          EIRENE_INIT_CTRCEI, EIRENE_BROADCAST_CTRCEI

      LOGICAL, PUBLIC, TARGET, ALLOCATABLE, SAVE :: LTRCEI(:)

      LOGICAL, PUBLIC, POINTER, SAVE ::
     L TRCPLT, TRCHST, TRCNAL, TRCMOD, TRCSIG,
     L TRCGRD, TRCSUR, TRCREF, TRCFLE, TRCAMD,
     L TRCINT, TRCLST, TRCSOU, TRCREC, TRCTIM,
     L TRCBLA, TRCBLP, TRCBLE, TRCBLM, TRCBLI,
     L TRCBLPH,TRCTAL, TRCOCT, TRCCEN, TRCRNF,
     L TRCHKTIM, TRCSCL, TRCMELD

CVK TRACING FOR DEBUGGING VIA WRITE(0,...
c     INTEGER,PUBLIC,PARAMETER :: LDBGTRC=9
c     LOGICAL, PUBLIC, TARGET, SAVE :: TRCDBG(LDBGTRC)
c     LOGICAL, PUBLIC, POINTER, SAVE ::
c    L                         TRCDBG2,  !DEEPER LEVEL OF DEBUGGING
c    L                         TRCDBGE,  !TRACING OF EIRENE
c    L                         TRCDBGM,  !... MCARLO
c    L                         TRCDBGF,  !... FOLNEUT
c    L                         TRCDBGL,  !... LOCATE
c    L                         TRCDBGS,  !... SURFACE INTERACTION ROUTINES
c    L                         TRCDBGG,  !... GEOMETRY ROUTINES
c    L                         TRCDBGMPI,!... MPI ROUTINES
c    L                         TRCDBGC   !... COUPLING ROUTINES
CVK END

      LOGICAL, PUBLIC, ALLOCATABLE, SAVE :: TRCSRC(:)

      INTEGER, PUBLIC, TARGET, ALLOCATABLE, SAVE :: ITRCEI(:)

      INTEGER, PUBLIC, POINTER, SAVE ::
     I NPRTLV(:), NPRTLS(:), NPRSRF(:),
     I NVOLPR,    NFLAGV(:), NTLVFL(:),
     I NSURPR,    NFLAGS(:), NTLSFL(:),
     I I1TRC,     I2TRC,     NSPCPR

      INTEGER, PUBLIC, ALLOCATABLE, SAVE ::
     I NSPEZV(:,:), NSPEZS(:,:)

      INTEGER, PUBLIC, SAVE :: MCTRC, LCTRC

      CONTAINS


      SUBROUTINE EIRENE_ALLOC_CTRCEI(ICAL)
      IMPLICIT NONE
      INTEGER ICAL

      IF (ICAL.EQ.1) THEN

        IF (ALLOCATED(LTRCEI)) RETURN

        MCTRC=5+3*NVLPR+4*NSRPR
        LCTRC=28

        ALLOCATE (LTRCEI(LCTRC))
        ALLOCATE (ITRCEI(MCTRC))
        ALLOCATE (TRCSRC(0:NSTRA))
        ALLOCATE (NSPEZV(NVLPR,2))
        ALLOCATE (NSPEZS(NSRPR,2))

        WRITE (IUNMEM,'(A,T25,I15)')
     .       ' CTRCEI(1) ',(LCTRC+MCTRC+2*(NVLPR+NSRPR))*4

        TRCPLT => LTRCEI( 1)
        TRCHST => LTRCEI( 2)
        TRCNAL => LTRCEI( 3)
        TRCMOD => LTRCEI( 4)
        TRCSIG => LTRCEI( 5)
        TRCGRD => LTRCEI( 6)
        TRCSUR => LTRCEI( 7)
        TRCREF => LTRCEI( 8)
        TRCFLE => LTRCEI( 9)
        TRCAMD => LTRCEI(10)
        TRCINT => LTRCEI(11)
        TRCLST => LTRCEI(12)
        TRCSOU => LTRCEI(13)
        TRCREC => LTRCEI(14)
        TRCTIM => LTRCEI(15)
        TRCBLA => LTRCEI(16)
        TRCBLP => LTRCEI(17)
        TRCBLE => LTRCEI(18)
        TRCBLM => LTRCEI(19)
        TRCBLI => LTRCEI(20)
        TRCBLPH=> LTRCEI(21)
        TRCTAL => LTRCEI(22)
        TRCOCT => LTRCEI(23)
        TRCCEN => LTRCEI(24)
        TRCRNF => LTRCEI(25)
        TRCHKTIM => LTRCEI(26)
        TRCSCL => LTRCEI(27)
        TRCMELD => LTRCEI(28)

!       NPRTLV => ITRCEI(  1 : 100)
!       NFLAGV => ITRCEI(101 : 200)
!       NTLVFL => ITRCEI(201 : 300)
!       NPRTLS => ITRCEI(301        : 300+  NLIMPS)
!       NPRSRF => ITRCEI(301+  NLIMPS : 300+2*NLIMPS)
!       NFLAGS => ITRCEI(301+2*NLIMPS : 300+3*NLIMPS)
!       NTLSFL => ITRCEI(301+3*NLIMPS : 300+4*NLIMPS)
!       NVOLPR => ITRCEI(301+4*NLIMPS)
!       NSURPR => ITRCEI(302+4*NLIMPS)
!       I1TRC  => ITRCEI(303+4*NLIMPS)
!       I2TRC  => ITRCEI(304+4*NLIMPS)
!       NSPCPR => ITRCEI(305+4*NLIMPS)

        NPRTLV => ITRCEI(1+0*NVLPR : 1*NVLPR)
        NFLAGV => ITRCEI(1+1*NVLPR : 2*NVLPR)
        NTLVFL => ITRCEI(1+2*NVLPR : 3*NVLPR)
        NPRTLS => ITRCEI(1+3*NVLPR : 3*NVLPR + 1*NSRPR)
        NPRSRF => ITRCEI(1+3*NVLPR + 1*NSRPR : 3*NVLPR + 2*NSRPR)
        NFLAGS => ITRCEI(1+3*NVLPR + 2*NSRPR : 3*NVLPR + 3*NSRPR)
        NTLSFL => ITRCEI(1+3*NVLPR + 3*NSRPR : 3*NVLPR + 4*NSRPR)
        NVOLPR => ITRCEI(1+3*NVLPR + 4*NSRPR)
        NSURPR => ITRCEI(2+3*NVLPR + 4*NSRPR)
        I1TRC  => ITRCEI(3+3*NVLPR + 4*NSRPR)
        I2TRC  => ITRCEI(4+3*NVLPR + 4*NSRPR)
        NSPCPR => ITRCEI(5+3*NVLPR + 4*NSRPR)

      ELSE IF (ICAL.EQ.2) THEN

cdr special treatment of array trcsrc. why?

        IF (ALLOCATED(TRCSRC)) RETURN

        ALLOCATE (TRCSRC(0:NSTRA))

        WRITE (IUNMEM,'(A,T25,I15)')
     .       ' CTRCEI(2) ',(NSTRA+1)*4

C  DEEPER DEBUGGING OPTIONS, VK
c       TRCDBG2  => TRCDBG(1)
c       TRCDBGE  => TRCDBG(2)
c       TRCDBGM  => TRCDBG(3)
c       TRCDBGF  => TRCDBG(4)
c       TRCDBGL  => TRCDBG(5)
c       TRCDBGS  => TRCDBG(6)
c       TRCDBGG  => TRCDBG(7)
c       TRCDBGMPI=> TRCDBG(8)
c       TRCDBGC  => TRCDBG(9)

      END IF

      CALL EIRENE_INIT_CTRCEI(ICAL)

      RETURN
      END SUBROUTINE EIRENE_ALLOC_CTRCEI


      SUBROUTINE EIRENE_DEALLOC_CTRCEI

      IF (ALLOCATED(LTRCEI)) THEN
        DEALLOCATE (LTRCEI)
        DEALLOCATE (ITRCEI)
        DEALLOCATE (NSPEZV)
        DEALLOCATE (NSPEZS)
      END IF

      IF (ALLOCATED(TRCSRC)) THEN
        DEALLOCATE (TRCSRC)
      END IF

      RETURN
      END SUBROUTINE EIRENE_DEALLOC_CTRCEI


      SUBROUTINE EIRENE_INIT_CTRCEI(ICAL)
      INTEGER ICAL

      IF (ICAL.EQ.1) THEN
        LTRCEI = .FALSE.
        ITRCEI = 0
        NSPEZV = 0
        NSPEZS = 0
        NFLAGV = 1
      ELSE IF (ICAL.EQ.2) THEN
        TRCSRC = .FALSE.
c       TRCDBG = .FALSE. !VK
      END IF

      RETURN
      END SUBROUTINE EIRENE_INIT_CTRCEI


      SUBROUTINE EIRENE_BROADCAST_CTRCEI(ME)
      USE EIRMOD_MPI
      INTEGER, INTENT(IN) :: ME
      INTEGER :: IER
#if ( defined(USE_MPI) && !defined(GFORTRAN) && !defined(CRAY) )
      EXTERNAL MPI_BCAST
#endif

      IF (ME /= 0) THEN
        CALL EIRENE_ALLOC_CTRCEI(1)
        CALL EIRENE_ALLOC_CTRCEI(2)
      END IF

      CALL MPI_BCAST (LTRCEI,LCTRC,MPI_LOGICAL,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (TRCSRC,NSTRA+1,MPI_LOGICAL,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (ITRCEI,MCTRC,MPI_INTEGER,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (NSPEZV,2*NVLPR,MPI_INTEGER,0,
     .                MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (NSPEZS,2*NSRPR,MPI_INTEGER,0,MPI_COMM_WORLD,ier)

      CALL MPI_BARRIER(MPI_COMM_WORLD,ier)

      RETURN
      END SUBROUTINE EIRENE_BROADCAST_CTRCEI

      END MODULE EIRMOD_CTRCEI
