      MODULE EIRMOD_CSPEZ
cdr  indicate that a certain species has been encountered for a certain stratum,
cdr  to reduce unnecessary printout of zero tallies

      USE EIRMOD_PARMMOD

      IMPLICIT NONE

      PRIVATE

      PUBLIC :: EIRENE_ALLOC_CSPEZ, EIRENE_DEALLOC_CSPEZ,
     P          EIRENE_INIT_CSPEZ

      LOGICAL, TARGET, PUBLIC, ALLOCATABLE, SAVE ::
     L LOGATM(:,:), LOGION(:,:),
     L LOGMOL(:,:), LOGPLS(:,:), LOGPHOT(:,:)

      LOGICAL, POINTER, PUBLIC, SAVE :: LOGXSPZ

#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP  THREADPRIVATE(LOGXSPZ)
#endif

      CONTAINS

      SUBROUTINE EIRENE_ALLOC_CSPEZ

      IF (ALLOCATED(LOGATM)) RETURN

      ALLOCATE (LOGATM(0:NATM,0:NSTRA))
      ALLOCATE (LOGION(0:NION,0:NSTRA))
      ALLOCATE (LOGMOL(0:NMOL,0:NSTRA))
      ALLOCATE (LOGPLS(0:NPLS,0:NSTRA))
      ALLOCATE (LOGPHOT(0:NPHOT,0:NSTRA))

      WRITE (IUNMEM,'(A,T25,I15)')
     .      ' CSPEZ ', (NSTRA+1)*(NPHOT+NATM+NION+NMOL+NPLS+5)*4

      CALL EIRENE_INIT_CSPEZ

      RETURN
      END SUBROUTINE EIRENE_ALLOC_CSPEZ


      SUBROUTINE EIRENE_DEALLOC_CSPEZ

      IF (.NOT.ALLOCATED(LOGATM)) RETURN

      DEALLOCATE (LOGATM)
      DEALLOCATE (LOGION)
      DEALLOCATE (LOGMOL)
      DEALLOCATE (LOGPLS)
      DEALLOCATE (LOGPHOT)

      RETURN
      END SUBROUTINE EIRENE_DEALLOC_CSPEZ


      SUBROUTINE EIRENE_INIT_CSPEZ

      LOGATM  = .FALSE.
      LOGION  = .FALSE.
      LOGMOL  = .FALSE.
      LOGPLS  = .FALSE.
      LOGPHOT = .FALSE.

      RETURN
      END SUBROUTINE EIRENE_INIT_CSPEZ

      END MODULE EIRMOD_CSPEZ
