!    20.06.07: constant NLOGAU = number of logicals introduced
cdr  April 2017:  NEXVS added to logicals (something from Vlad for photons?),
cdr               nlogau=38
cdr  Jan. 2018:   NLEMIS added, nlogau=40

      MODULE EIRMOD_CLOGAU
cdr global control switches, all set in input.f


      IMPLICIT NONE

      PRIVATE

      PUBLIC :: EIRENE_ALLOC_CLOGAU, EIRENE_BROADCAST_CLOGAU

      INTEGER, PUBLIC, PARAMETER :: NLOGAU=46

      LOGICAL, PUBLIC, TARGET, SAVE :: LLOGAU(NLOGAU)

      LOGICAL, PUBLIC, POINTER, SAVE ::
     L NLSCL,  NLDRFT, NLCRR,  NLTEST, NLANA,  NLERG,  NLMOVIE, NLPLAS,
     L NLRAD,  NLSLB,  NLCRC,  NLELL,  NLTRI,  NLPLG,  NLGEN,
     L NLFEM,  NLTET,
     L NLPOL,  NLPLY,  NLPLA,  NLPLP,
     L NLTOR,  NLTRZ,  NLTRA,  NLTRT,
     L NLMLT,  NLADD,
     L NLTRIM, NLONE,  NLDFST, NLRANMAR,
     L NLCASCAD, NLOCTREE, NLSHRT13, NLWRMSH,
     L NEXVS,  NLEMIS, NLTRIMESH,
     L NLSPCSCL, NLSPCSCL_ATM, NLSPCSCL_MOL, NLSPCSCL_ION,
     L NLSPCSCL_PHOT, NLSPCSCL_ON, NLSOLEDGE
C    L NLFREE0, NLFREE1

      CONTAINS


      SUBROUTINE EIRENE_ALLOC_CLOGAU

      NLSCL   => LLOGAU(1)
      NLDRFT  => LLOGAU(2)
      NLCRR   => LLOGAU(3)
      NLTEST  => LLOGAU(4)
      NLANA   => LLOGAU(5)
      NLERG   => LLOGAU(6)
      NLMOVIE => LLOGAU(7)
      NLPLAS  => LLOGAU(8)
C
      NLRAD   => LLOGAU(9)
      NLSLB   => LLOGAU(10)
      NLCRC   => LLOGAU(11)
      NLELL   => LLOGAU(12)
      NLTRI   => LLOGAU(13)
      NLPLG   => LLOGAU(14)
      NLGEN   => LLOGAU(15)
      NLFEM   => LLOGAU(16)
      NLTET   => LLOGAU(17)
      NLPOL   => LLOGAU(18)
      NLPLY   => LLOGAU(19)
      NLPLA   => LLOGAU(20)
      NLPLP   => LLOGAU(21)
      NLTOR   => LLOGAU(22)
      NLTRZ   => LLOGAU(23)
      NLTRA   => LLOGAU(24)
      NLTRT   => LLOGAU(25)
      NLMLT   => LLOGAU(26)
      NLADD   => LLOGAU(27)
C
      NLTRIM   => LLOGAU(28)
C     NLFREE1  => LLOGAU(29) ! NOT IN USE
      NLONE    => LLOGAU(30)
      NLSOLEDGE=> LLOGAU(31) ! was NLFREE0
      NLDFST   => LLOGAU(32)
      NLRANMAR => LLOGAU(33)
      NLCASCAD => LLOGAU(34)
      NLOCTREE => LLOGAU(35)
      NLSHRT13 => LLOGAU(36)
      NLWRMSH  => LLOGAU(37)
      NEXVS    => LLOGAU(38)  ! added April 2017. Not in use,
                              ! but perhaps needed in photon module.
      NLEMIS   => LLOGAU(39)
      NLTRIMESH=> LLOGAU(40)

      NLSPCSCL => LLOGAU(41)
      NLSPCSCL_ATM => LLOGAU(42)
      NLSPCSCL_MOL => LLOGAU(43)
      NLSPCSCL_ION => LLOGAU(44)
      NLSPCSCL_PHOT=> LLOGAU(45)
      NLSPCSCL_ON  => LLOGAU(46)

      LLOGAU = .FALSE.

      RETURN
      END SUBROUTINE EIRENE_ALLOC_CLOGAU


      SUBROUTINE EIRENE_BROADCAST_CLOGAU(ME)
      USE EIRMOD_MPI
      INTEGER, INTENT(IN) :: ME
      INTEGER :: IER
#if ( defined(USE_MPI) && !defined(GFORTRAN) && !defined(CRAY) )
      EXTERNAL :: MPI_BCAST
#endif

      IF (ME /= 0) CALL EIRENE_ALLOC_CLOGAU

      CALL MPI_BCAST (LLOGAU,NLOGAU,MPI_LOGICAL,0,MPI_COMM_WORLD,ier)

      CALL MPI_BARRIER(MPI_COMM_WORLD,ier)

      RETURN
      END SUBROUTINE EIRENE_BROADCAST_CLOGAU

      END MODULE EIRMOD_CLOGAU
