cdr nov. 19: Add XMLIM, XCLIM, LCHSPNWL
cdr          for refined wall chemistry models. Not ready
      MODULE EIRMOD_CLGIN

      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD

      IMPLICIT NONE

      PRIVATE

      PUBLIC :: EIRENE_ALLOC_CLGIN, EIRENE_DEALLOC_CLGIN,
     P          EIRENE_INIT_CLGIN, EIRENE_BROADCAST_CLGIN,
     P          EIRENE_SET_DEF_SURF_DATA, TSURFACE

      REAL(DP), PUBLIC, ALLOCATABLE, SAVE ::
cdr  rlwmn, rlwmx: weight window for surface. Currently unused
     R RLWMN(:),    RLWMX(:),
     R EWALL(:),    EWBIN(:),    TRANSP(:,:,:),
     R FSHEAT(:),
     R ZNML(:),     ZNCL(:),
     R RECYCF(:,:), RECYCT(:,:),
     R RECPRM(:,:),
     R EXPPL(:,:),  EXPEL(:,:),  EXPIL(:,:),
     R RECYCS(:,:),
     R RECYCC(:,:), SPTPRM(:,:), ESPUTS(:,:), ESPUTC(:,:),
     R XMLIM(:),    XCLIM(:)

      INTEGER, PUBLIC, ALLOCATABLE, SAVE ::
     I ILSWCH(:),     ILEQUI(:),     ILTOR(:),
     I ILSIDE(:),     ILIIN(:),      ILREF(:),
     I ILSPT(:),      ILCOL(:),      ILFIT(:),
     I ILCELL(:),     ILBOX(:),      ILPLG(:),
     I ISPUT(:,:),
     I NLIMII(:),     NLIMIE(:),
     I ISWICH(:,:),   ILBLCK(:),     ILACLL(:),
     I JUMLIM(:),
     I INUMP(:,:),    IRPTA(:,:),    IRPTE(:,:),
     I ISRF(:,:),     ISRT(:,:),     ISRS(:,:),
     I ISRC(:,:),
     I INMP1I(:,:,:), INMP2I(:,:,:), INMP3I(:,:,:),
     I IGFIL(:),
     I IGJUM0(:),     IGJUM1(:,:),   IGJUM2(:,:),   IGJUM3(:,:),
     I LCHSPNWL(:,:)

      CHARACTER(70), PUBLIC, ALLOCATABLE, SAVE ::
     C SMOD_NAME(:)
      INTEGER, PUBLIC, SAVE ::
     I NSTSI,
     I NLIMPB

      TYPE TSURFACE
        CHARACTER(70)         :: MODNAME
        INTEGER               :: NOSURF
        TYPE(TSURFACE),POINTER :: NEXT
      END TYPE TSURFACE

      TYPE(TSURFACE), PUBLIC, POINTER, SAVE :: SURFLIST

      CONTAINS


      SUBROUTINE EIRENE_ALLOC_CLGIN

      IF (ALLOCATED(RLWMN)) RETURN

      NLIMPB=NLIMPS/NOPTM1+1

      ALLOCATE (RLWMN(0:NLIMPS))
      ALLOCATE (RLWMX(0:NLIMPS))
      ALLOCATE (EWALL(0:NLIMPS))
      ALLOCATE (EWBIN(0:NLIMPS))
      ALLOCATE (TRANSP(NSPZ,2,0:NLIMPS))
      ALLOCATE (FSHEAT(0:NLIMPS))
      ALLOCATE (ZNML(0:NLIMPS))
      ALLOCATE (ZNCL(0:NLIMPS))
      ALLOCATE (RECYCF(NSPZ,0:NLIMPS))
      ALLOCATE (RECYCT(NSPZ,0:NLIMPS))
      ALLOCATE (RECPRM(NSPZ,0:NLIMPS))
      ALLOCATE (EXPPL(NSPZ,0:NLIMPS))
      ALLOCATE (EXPEL(NSPZ,0:NLIMPS))
      ALLOCATE (EXPIL(NSPZ,0:NLIMPS))
      ALLOCATE (RECYCS(NSPZ,0:NLIMPS))
      ALLOCATE (RECYCC(NSPZ,0:NLIMPS))
      ALLOCATE (SPTPRM(NSPZ,0:NLIMPS))
      ALLOCATE (ESPUTS(NSPZ,0:NLIMPS))
      ALLOCATE (ESPUTC(NSPZ,0:NLIMPS))
      ALLOCATE (XMLIM(0:NLIMPS))
      ALLOCATE (XCLIM(0:NLIMPS))

      ALLOCATE (ILSWCH(0:NLIMPS))
      ALLOCATE (ILEQUI(0:NLIMPS))
      ALLOCATE (ILTOR(0:NLIMPS))
      ALLOCATE (ILSIDE(0:NLIMPS))
      ALLOCATE (ILIIN(0:NLIMPS))
      ALLOCATE (ILREF(0:NLIMPS))
      ALLOCATE (ILSPT(0:NLIMPS))
      ALLOCATE (ILCOL(0:NLIMPS))
      ALLOCATE (ILFIT(0:NLIMPS))
      ALLOCATE (ILCELL(0:NLIMPS))
      ALLOCATE (ILBOX(0:NLIMPS))
      ALLOCATE (ILPLG(0:NLIMPS))
      ALLOCATE (ISPUT(2,0:NLIMPS))

      ALLOCATE (NLIMII(NOPTIM))
      ALLOCATE (NLIMIE(NOPTIM))
      ALLOCATE (ISWICH(6,0:NLIMPS))
      ALLOCATE (ILBLCK(0:NLIMPS))
      ALLOCATE (ILACLL(0:NLIMPS))
      ALLOCATE (JUMLIM(0:NLIMPS))
      ALLOCATE (INUMP(NSTS,3))
      ALLOCATE (IRPTA(NSTS,3))
      ALLOCATE (IRPTE(NSTS,3))
      ALLOCATE (ISRF(NSPZ,0:NLIMPS))
      ALLOCATE (ISRT(NSPZ,0:NLIMPS))
      ALLOCATE (ISRS(NSPZ,0:NLIMPS))
      ALLOCATE (ISRC(NSPZ,0:NLIMPS))
      ALLOCATE (INMP1I(0:N1ST,0:N2ND,0:N3RD))
      ALLOCATE (INMP2I(0:N1ST,0:N2ND,0:N3RD))
      ALLOCATE (INMP3I(0:N1ST,0:N2ND,0:N3RD))
      ALLOCATE (LCHSPNWL(NSPZ,0:NLIMPS))

      ALLOCATE (IGFIL(0:NLIMPS))
      ALLOCATE (IGJUM0(0:NLIMPS))
      ALLOCATE (IGJUM1(0:NLIMPS,NLIMPB))
      ALLOCATE (IGJUM2(0:NLIMPS,NLIMPB))
      ALLOCATE (IGJUM3(0:NOPTIM,NLIMPB))

      ALLOCATE (SMOD_NAME(0:NLIMPS))

      WRITE (IUNMEM,'(A,T25,I15)')
     .       ' CLGIN ',(NLIMPS+1)*(13*NSPZ+9)*8 +
     .                 (2*NOPTIM+(NLIMPS+1)*(14+9+5*NSPZ)+9*NSTS+
     .                  (N1ST+1)*(N2ND+1)*(N3RD+1)*3)*4 +
     .                 ((NLIMPS+1)*(2+2*NLIMPB)+
     .                  NLIMPB*(NOPTIM+1))*4+
     .                  (NLIMPS+1)*70

      CALL EIRENE_INIT_CLGIN

      RETURN
      END SUBROUTINE EIRENE_ALLOC_CLGIN


      SUBROUTINE EIRENE_DEALLOC_CLGIN

      IF (.NOT.ALLOCATED(RLWMN)) RETURN

      DEALLOCATE (RLWMN)
      DEALLOCATE (RLWMX)
      DEALLOCATE (EWALL)
      DEALLOCATE (EWBIN)
      DEALLOCATE (TRANSP)
      DEALLOCATE (FSHEAT)
      DEALLOCATE (ZNML)
      DEALLOCATE (ZNCL)
      DEALLOCATE (RECYCF)
      DEALLOCATE (RECYCT)
      DEALLOCATE (RECPRM)
      DEALLOCATE (EXPPL)
      DEALLOCATE (EXPEL)
      DEALLOCATE (EXPIL)
      DEALLOCATE (RECYCS)
      DEALLOCATE (RECYCC)
      DEALLOCATE (SPTPRM)
      DEALLOCATE (ESPUTS)
      DEALLOCATE (ESPUTC)
      DEALLOCATE (XMLIM)
      DEALLOCATE (XCLIM)

      DEALLOCATE (ILSWCH)
      DEALLOCATE (ILEQUI)
      DEALLOCATE (ILTOR)
      DEALLOCATE (ILSIDE)
      DEALLOCATE (ILIIN)
      DEALLOCATE (ILREF)
      DEALLOCATE (ILSPT)
      DEALLOCATE (ILCOL)
      DEALLOCATE (ILFIT)
      DEALLOCATE (ILCELL)
      DEALLOCATE (ILBOX)
      DEALLOCATE (ILPLG)
      DEALLOCATE (ISPUT)
      DEALLOCATE (LCHSPNWL)

      DEALLOCATE (NLIMII)
      DEALLOCATE (NLIMIE)
      DEALLOCATE (ISWICH)
      DEALLOCATE (ILBLCK)
      DEALLOCATE (ILACLL)
      DEALLOCATE (JUMLIM)
      DEALLOCATE (INUMP)
      DEALLOCATE (IRPTA)
      DEALLOCATE (IRPTE)
      DEALLOCATE (ISRF)
      DEALLOCATE (ISRT)
      DEALLOCATE (ISRS)
      DEALLOCATE (ISRC)
      DEALLOCATE (INMP1I)
      DEALLOCATE (INMP2I)
      DEALLOCATE (INMP3I)

      DEALLOCATE (SMOD_NAME)

      DEALLOCATE (IGFIL)
      DEALLOCATE (IGJUM0)
      DEALLOCATE (IGJUM1)
      DEALLOCATE (IGJUM2)
      DEALLOCATE (IGJUM3)

      RETURN
      END SUBROUTINE EIRENE_DEALLOC_CLGIN


      SUBROUTINE EIRENE_INIT_CLGIN
cdr  rlwmn, rlwmx: weight window, unused.
      RLWMN  = 1.E-5_DP
      RLWMX  = 1.E5_DP
c
      EWALL  = 0.0388_DP
      EWBIN  = 0._DP
      TRANSP = 0._DP
      FSHEAT = 0._DP
      ZNML   = 5626._DP
      ZNCL   = 0._DP
      RECYCF = 1._DP
      RECYCT = 1._DP
      RECPRM = 0._DP
      EXPPL  = 1._DP
      EXPEL  = 0.5_DP
      EXPIL  = 0._DP
      RECYCS = 1._DP
      RECYCC = 1._DP
      SPTPRM = 0._DP
      ESPUTS = 0._DP
      ESPUTC = 0._DP
      XMLIM  = 0._DP
      XCLIM  = 0._DP

      ILSWCH = 0
      ILEQUI = 0
      ILTOR  = 0
      ILSIDE = 0
      ILIIN  = 1
      ILREF  = 2
      ILSPT  = 0
      ILCOL  = 1
      ILFIT  = 0
      ILCELL = 0
      ILBOX  = 0
      ILPLG  = 0
      ISPUT  = 0
      LCHSPNWL=0

      NLIMII = 0
      NLIMIE = 0
      ISWICH = 0
      ILBLCK = 0
      ILACLL = 0
      JUMLIM = 0
      INUMP  = 0
      IRPTA  = 0
      IRPTE  = 0
      ISRF   = 0
      ISRT   = 0
      ISRS   = 0
      ISRC   = 0
      INMP1I = 0
      INMP2I = 0
      INMP3I = 0

      IGFIL  = 0
      IGJUM0 = 0
      IGJUM1 = 0
      IGJUM2 = 0
      IGJUM3 = 0

      SMOD_NAME=''

      RETURN
      END SUBROUTINE EIRENE_INIT_CLGIN


      SUBROUTINE EIRENE_SET_DEF_SURF_DATA

      INTEGER :: NBITS, ISTS, IERROR, J, I
      EXTERNAL :: EIRENE_BITSET, EIRENE_MASPRM, EIRENE_EXIT_OWN
C
C  SET DEFAULT 'ADDITIONAL SURFACE' DATA
C
      NBITS=BIT_SIZE(I)
      IF (NOPTM1 > NBITS) THEN
        CALL EIRENE_MASPRM('NOPTM1',6,NOPTM1,'NBITS',5,NBITS,IERROR)
        CALL EIRENE_EXIT_OWN(1)
      END IF
      IF (NLIMPB >= NLIMPS) THEN
        DO J=1,NLIMPS
          IGJUM2(J,J) = 1
        END DO
      ELSE
        DO J=1,NLIMPS
          CALL EIRENE_BITSET (IGJUM2,0,NLIMPS,J,J,1,NBITS)
        END DO
      END IF
C
C  SET DEFAULT 'STANDARD SURFACE' DATA
C
      DO ISTS=1,NSTS
        IRPTA(ISTS,1)=1
        IRPTE(ISTS,1)=MAX(2,N1ST)
        INUMP(ISTS,1)=0
C  DEFAULT POLOIDAL INDICES FOR "NON-DEFAULT STANDARD SURFACES"
        IRPTA(ISTS,2)=1
        IRPTE(ISTS,2)=MAX(2,N2ND)
        INUMP(ISTS,2)=0
C  DEFAULT TOROIDAL INDICES FOR "NON-DEFAULT STANDARD SURFACES"
        IRPTA(ISTS,3)=1
        IRPTE(ISTS,3)=MAX(2,N3RD)
        INUMP(ISTS,3)=0
      END DO

      RETURN
      END SUBROUTINE EIRENE_SET_DEF_SURF_DATA


      SUBROUTINE EIRENE_BROADCAST_CLGIN(ME)
      USE EIRMOD_MPI
      INTEGER, INTENT(IN) :: ME
      INTEGER :: IER
#if ( defined(USE_MPI) && !defined(GFORTRAN) && !defined(CRAY) )
      EXTERNAL :: MPI_BCAST
#endif

      IF (ME /= 0) CALL EIRENE_ALLOC_CLGIN

      CALL MPI_BCAST (RLWMN,NLIMPS+1,MPI_REAL8,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (RLWMX,NLIMPS+1,MPI_REAL8,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (EWALL,NLIMPS+1,MPI_REAL8,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (EWBIN,NLIMPS+1,MPI_REAL8,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (TRANSP,2*NSPZ*(NLIMPS+1),
     .                MPI_REAL8,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (FSHEAT,NLIMPS+1,MPI_REAL8,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (ZNML,NLIMPS+1,MPI_REAL8,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (ZNCL,NLIMPS+1,MPI_REAL8,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (RECYCF,NSPZ*(NLIMPS+1),
     .                MPI_REAL8,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (RECYCT,NSPZ*(NLIMPS+1),
     .                MPI_REAL8,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (RECPRM,NSPZ*(NLIMPS+1),
     .                MPI_REAL8,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (EXPPL,NSPZ*(NLIMPS+1),
     .                MPI_REAL8,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (EXPEL,NSPZ*(NLIMPS+1),
     .                MPI_REAL8,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (EXPIL,NSPZ*(NLIMPS+1),
     .                MPI_REAL8,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (RECYCS,NSPZ*(NLIMPS+1),
     .                MPI_REAL8,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (RECYCC,NSPZ*(NLIMPS+1),
     .                MPI_REAL8,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (SPTPRM,NSPZ*(NLIMPS+1),
     .                MPI_REAL8,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (ESPUTS,NSPZ*(NLIMPS+1),
     .                MPI_REAL8,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (ESPUTC,NSPZ*(NLIMPS+1),
     .                MPI_REAL8,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (ILSWCH,NLIMPS+1,MPI_INTEGER,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (ILEQUI,NLIMPS+1,MPI_INTEGER,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (ILTOR ,NLIMPS+1,MPI_INTEGER,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (ILSIDE,NLIMPS+1,MPI_INTEGER,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (ILIIN ,NLIMPS+1,MPI_INTEGER,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (ILREF ,NLIMPS+1,MPI_INTEGER,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (ILSPT ,NLIMPS+1,MPI_INTEGER,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (ILCOL ,NLIMPS+1,MPI_INTEGER,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (ILFIT ,NLIMPS+1,MPI_INTEGER,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (ILCELL,NLIMPS+1,MPI_INTEGER,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (ILBOX ,NLIMPS+1,MPI_INTEGER,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (ILPLG ,NLIMPS+1,MPI_INTEGER,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (ISPUT ,2*(NLIMPS+1),MPI_INTEGER,0,
     .                MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (NLIMII,NOPTIM,MPI_INTEGER,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (NLIMIE,NOPTIM,MPI_INTEGER,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (ISWICH,6*(NLIMPS+1),
     .                MPI_INTEGER,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (ILBLCK,NLIMPS+1,MPI_INTEGER,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (ILACLL,NLIMPS+1,MPI_INTEGER,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (JUMLIM,NLIMPS+1,MPI_INTEGER,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (NSTSI,1,MPI_INTEGER,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (INUMP,3*NSTS,MPI_INTEGER,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (IRPTA,3*NSTS,MPI_INTEGER,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (IRPTE,3*NSTS,MPI_INTEGER,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (ISRF,NSPZ*(NLIMPS+1),
     .                MPI_INTEGER,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (ISRT,NSPZ*(NLIMPS+1),
     .                MPI_INTEGER,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (ISRS,NSPZ*(NLIMPS+1),
     .                MPI_INTEGER,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (ISRC,NSPZ*(NLIMPS+1),
     .                MPI_INTEGER,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (INMP1I,(N1ST+1)*(N2ND+1)*(N3RD+1),
     .                MPI_INTEGER,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (INMP2I,(N1ST+1)*(N2ND+1)*(N3RD+1),
     .                MPI_INTEGER,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (INMP3I,(N1ST+1)*(N2ND+1)*(N3RD+1),
     .                MPI_INTEGER,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (IGFIL,NLIMPS+1,MPI_INTEGER,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (IGJUM0,NLIMPS+1,MPI_INTEGER,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (IGJUM1,(NLIMPS+1)*NLIMPB,
     .                MPI_INTEGER,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (IGJUM2,(NLIMPS+1)*NLIMPB,
     .                MPI_INTEGER,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (IGJUM3,(NOPTIM+1)*NLIMPB,
     .                MPI_INTEGER,0,MPI_COMM_WORLD,ier)
CVK Remaining AK VARIABLES FOR CHEMICAL SPUTTERING
      CALL MPI_BCAST (XMLIM,NLIMPS+1,MPI_REAL8,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (XCLIM,NLIMPS+1,MPI_REAL8,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (LCHSPNWL,NSPZ*(1+NLIMPS),
     .                MPI_INTEGER,0,MPI_COMM_WORLD,ier)
CVK END

      CALL MPI_BARRIER(MPI_COMM_WORLD,ier)

      RETURN
      END SUBROUTINE EIRENE_BROADCAST_CLGIN

      END MODULE EIRMOD_CLGIN
