      MODULE EIRMOD_CGRPTL
cdr  grid parameters only needed for graphical output with proprietary
cdr  eirene graphics routines.
cdr  Can probably go out in case of using routines "plot_dummy"
cdr  instead of routines from "plotting"

      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD

      IMPLICIT NONE

      PRIVATE

      PUBLIC :: EIRENE_ALLOC_CGRPTL, EIRENE_DEALLOC_CGRPTL,
     P          EIRENE_INIT_CGRPTL

      REAL(DP), PUBLIC, ALLOCATABLE, SAVE ::
     R        XXP2D(:), XXP3D(:),YYP3D(:),
     R        XXP2D_USR(:,:)

      REAL(DP), PUBLIC, ALLOCATABLE, SAVE ::
     R        XCONTOUR(:,:), YCONTOUR(:,:)

      INTEGER, PUBLIC, SAVE ::
     I         IXTL2, IXTL3, IYTL3

      INTEGER, PUBLIC, SAVE ::
     I         NCONTOUR

      INTEGER, PUBLIC, ALLOCATABLE, SAVE ::
     I         NCONPOINT(:)

      CONTAINS


      SUBROUTINE EIRENE_ALLOC_CGRPTL

      IF (ALLOCATED(XXP2D)) RETURN

      ALLOCATE (XXP2D(NRADS))
      ALLOCATE (XXP3D(NRADS))
      ALLOCATE (YYP3D(NRADS))
      ALLOCATE (XXP2D_USR(NRADS,NPTAL))

      WRITE (IUNMEM,'(A,T25,I15)')
     .      ' CGRPTL ',(NPTAL+3)*NRADS*8

      CALL EIRENE_INIT_CGRPTL

      RETURN
      END SUBROUTINE EIRENE_ALLOC_CGRPTL


      SUBROUTINE EIRENE_DEALLOC_CGRPTL

      IF (.NOT.ALLOCATED(XXP2D)) RETURN

      DEALLOCATE (XXP2D)
      DEALLOCATE (XXP3D)
      DEALLOCATE (YYP3D)
      DEALLOCATE (XXP2D_USR)

      RETURN
      END SUBROUTINE EIRENE_DEALLOC_CGRPTL


      SUBROUTINE EIRENE_INIT_CGRPTL

      XXP2D     = 0._DP
      XXP3D     = 0._DP
      YYP3D     = 0._DP
      XXP2D_USR = 0._DP

      RETURN
      END SUBROUTINE EIRENE_INIT_CGRPTL

      END MODULE EIRMOD_CGRPTL
