      MODULE EIRMOD_CGRID

cdr  Standard grid surfaces, input block 3a
cdr  Also some derived grid parameters to speed up MC calculation
cdr  Also some zone-centered grid parameters RHOZNE, PHZONE, ZZONE, etc.

      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD

      IMPLICIT NONE

      PRIVATE

      PUBLIC :: EIRENE_ALLOC_CGRID, EIRENE_DEALLOC_CGRID,
     P          EIRENE_INIT_CGRID, EIRENE_BROADCAST_CGRID

      INTEGER, PUBLIC, SAVE :: NCGRD, MCGRD

      REAL(DP), PUBLIC, TARGET, ALLOCATABLE, SAVE :: RCGRID(:)

      REAL(DP), PUBLIC, POINTER, SAVE ::
C  NCGRD, REAL
     R RSURF(:),  EP1(:),    ELL(:),    TRI(:),    ELLQ(:),
     R RHOSRF(:), RHOZNE(:), RQ(:),
     R PSURF(:),  SINPH(:),  COSPH(:),  PHZONE(:),
     R ZSURF(:),  ZZONE(:),
     R ALPHA,  TANAL,  COSAL,  SINAL,  RMTOR,  ZHALF,  ZFULL,
     R RIA,    RGA,    RAA,    RRA,    XDF,
     R YIA,    YGA,    YAA,    YYA,    DTHET,  YDF,
     R ZIA,    ZGA,    ZAA,    ZZA,    ROA,    DPHI,   ZDF

      INTEGER, PUBLIC, TARGET, ALLOCATABLE, SAVE :: ICGRID(:)

      INTEGER, PUBLIC, POINTER, SAVE ::
C  MCGRD, INTEGER
     I LEVGEO,
     I NR1ST,  NR1STM,
     I NP2ND,  NP2NDM, NPPLA,  NPPER,
     I NT3RD,  NT3RDM, NTTRA,  NTTRAM, NTPER,
     I NRSEP,  NPSEP,  NTSEP,  NBMLT,  NBMLTP, NRADD,
     I NSURF,  NSURFM, NBLCKS, NSTRD,  NSBOX,
     I NR1P2,  NP2T3,
     I NR1TAL, NP2TAL, NT3TAL, NSBOX_TAL,NRADD_TAL,NSURF_TAL,
     I NPLP_CGRID  !dr: apparently added for B2.5 interface.
                   !    Set eq. NPLP there


      CONTAINS

      SUBROUTINE EIRENE_ALLOC_CGRID

      INTEGER :: IND

      IF (ALLOCATED(RCGRID)) RETURN

      NCGRD=8*N1ST+4*N2ND+2*(N3RD+NTOR)+25
      MCGRD=32

      ALLOCATE (RCGRID(NCGRD))
      ALLOCATE (ICGRID(MCGRD))

      WRITE (IUNMEM,'(A,T25,I15)')
     .      ' CGRID ',NCGRD*8 + MCGRD*4

      RSURF  => RCGRID(1+0*N1ST : 1*N1ST)
      EP1    => RCGRID(1+1*N1ST : 2*N1ST)
      ELL    => RCGRID(1+2*N1ST : 3*N1ST)
      TRI    => RCGRID(1+3*N1ST : 4*N1ST)
      ELLQ   => RCGRID(1+4*N1ST : 5*N1ST)
      RHOSRF => RCGRID(1+5*N1ST : 6*N1ST)
      RHOZNE => RCGRID(1+6*N1ST : 7*N1ST)
      RQ     => RCGRID(1+7*N1ST : 8*N1ST)
      PSURF  => RCGRID(1+8*N1ST+0*N2ND : 8*N1ST+1*N2ND)
      SINPH  => RCGRID(1+8*N1ST+1*N2ND : 8*N1ST+2*N2ND)
      COSPH  => RCGRID(1+8*N1ST+2*N2ND : 8*N1ST+3*N2ND)
      PHZONE => RCGRID(1+8*N1ST+3*N2ND : 8*N1ST+4*N2ND)
      IND = 8*N1ST+4*N2ND
      ZSURF  => RCGRID(1+IND+0*(N3RD+NTOR) : IND+1*(N3RD+NTOR))
      ZZONE  => RCGRID(1+IND+1*(N3RD+NTOR) : IND+2*(N3RD+NTOR))
      IND = 8*N1ST+4*N2ND+2*(N3RD+NTOR)
      ALPHA  => RCGRID( 1+IND)
      TANAL  => RCGRID( 2+IND)
      COSAL  => RCGRID( 3+IND)
      SINAL  => RCGRID( 4+IND)
      RMTOR  => RCGRID( 5+IND)
      ZHALF  => RCGRID( 6+IND)
      ZFULL  => RCGRID( 7+IND)
      RIA    => RCGRID( 8+IND)
      RGA    => RCGRID( 9+IND)
      RAA    => RCGRID(10+IND)
      RRA    => RCGRID(11+IND)
      XDF    => RCGRID(12+IND)
      YIA    => RCGRID(13+IND)
      YGA    => RCGRID(14+IND)
      YAA    => RCGRID(15+IND)
      YYA    => RCGRID(16+IND)
      DTHET  => RCGRID(17+IND)
      YDF    => RCGRID(18+IND)
      ZIA    => RCGRID(19+IND)
      ZGA    => RCGRID(20+IND)
      ZAA    => RCGRID(21+IND)
      ZZA    => RCGRID(22+IND)
      ROA    => RCGRID(23+IND)
      DPHI   => RCGRID(24+IND)
      ZDF    => RCGRID(25+IND)

      LEVGEO => ICGRID( 1)
      NR1ST  => ICGRID( 2)
      NR1STM => ICGRID( 3)
      NP2ND  => ICGRID( 4)
      NP2NDM => ICGRID( 5)
      NPPLA  => ICGRID( 6)
      NPPER  => ICGRID( 7)
      NT3RD  => ICGRID( 8)
      NT3RDM => ICGRID( 9)
      NTTRA  => ICGRID(10)
      NTTRAM => ICGRID(11)
      NTPER  => ICGRID(12)
      NRSEP  => ICGRID(13)
      NPSEP  => ICGRID(14)
      NTSEP  => ICGRID(15)
      NBMLT  => ICGRID(16)
      NBMLTP => ICGRID(17)
      NRADD  => ICGRID(18)
      NSURF  => ICGRID(19)
      NSURFM => ICGRID(20)
      NBLCKS => ICGRID(21)
      NSTRD  => ICGRID(22)
      NSBOX  => ICGRID(23)
      NR1P2  => ICGRID(24)
      NP2T3  => ICGRID(25)
      NR1TAL => ICGRID(26)
      NP2TAL => ICGRID(27)
      NT3TAL => ICGRID(28)
      NSBOX_TAL=> ICGRID(29)
      NRADD_TAL=> ICGRID(30)
      NSURF_TAL=> ICGRID(31)
      NPLP_CGRID=> ICGRID(32)

      CALL EIRENE_INIT_CGRID

      RETURN
      END SUBROUTINE EIRENE_ALLOC_CGRID


      SUBROUTINE EIRENE_DEALLOC_CGRID

      IF (.NOT.ALLOCATED(RCGRID)) RETURN

      DEALLOCATE (RCGRID)
      DEALLOCATE (ICGRID)

      RETURN
      END SUBROUTINE EIRENE_DEALLOC_CGRID


      SUBROUTINE EIRENE_INIT_CGRID

      RCGRID = 0._DP
      ICGRID = 0
      NPLP_CGRID = 1

      RETURN
      END SUBROUTINE EIRENE_INIT_CGRID


      SUBROUTINE EIRENE_BROADCAST_CGRID(ME)
      USE EIRMOD_MPI
      INTEGER, INTENT(IN) :: ME
      INTEGER :: IER
#if ( defined(USE_MPI) && !defined(GFORTRAN) && !defined(CRAY) )
      EXTERNAL :: MPI_BCAST
#endif

      IF (ME /= 0) CALL EIRENE_ALLOC_CGRID

      CALL MPI_BCAST (RCGRID,NCGRD,MPI_REAL8,0,MPI_COMM_WORLD,ier)
      CALL MPI_BCAST (ICGRID,MCGRD,MPI_INTEGER,0,MPI_COMM_WORLD,ier)

      CALL MPI_BARRIER(MPI_COMM_WORLD,ier)

      RETURN
      END SUBROUTINE EIRENE_BROADCAST_CGRID

      END MODULE EIRMOD_CGRID
