C   6.12.05   AU_TO_CM2 added here (and removed from fpatha, veloel)
C   1.01.06   hplnk_bar = hplnk/2Pi added here (and set in setcon.f)
C  22.12.06   Periodic Table of Elements (PTE) introduced.
C  16.01.06   Functions SET_PTE_ELEMENT and FIND_PTE_ELEMENT
C             identify a chemical element in the PTE
C             and returns the element number, resp.
!  20.06.07   constant NCONA = number of constants in module introduced
C             and made private (Aug.20)

      MODULE EIRMOD_CCONA
      USE EIRMOD_PRECISION

      IMPLICIT NONE

      PRIVATE

      PUBLIC :: EIRENE_ALLOC_CCONA,
     P          PTE_TYPE,
     P          EIRENE_SET_PTE_ELEMENT, EIRENE_FIND_PTE_ELEMENT,
     P          EIRENE_BROADCAST_CCONA

cd  Periodic Table Element (PTE):
      TYPE PTE_TYPE
        CHARACTER(13) :: NAME
        CHARACTER(2) :: ABBR
        REAL(DP) :: EL_MASS, EL_CHARGE
      END TYPE

      INTEGER,  PRIVATE, PARAMETER :: NCONA=50
      REAL(DP), PUBLIC, TARGET, SAVE :: RCONA(NCONA)

      REAL(DP), PUBLIC, POINTER, SAVE ::
     R EPS60,   EPS30,   EPS12,    EPS10,    EPS6,      EPS5,
     R PMASSA,  PMASSE,  AMUA,
     R PIA,     PI2A,    PIHA,     PIQU,     PISQ,     PIAI,      SQ2,
     R SQ2I,    DEGRAD,  RADDEG,
     R CVELI2,  CVELAA,  CVEL2A,   ELCHA,    EFACT,     EFCT23,   EVKEL,
     R EIONH,   EIONH2,  EIONHE,
     R EV_TO_J, J_TO_EV, J_TO_ERG, ERG_TO_J, EV_TO_ERG, ERG_TO_EV,
     R HPLANCK, CLIGHT, MUB, HPLNK, HPCL, EV2HZ,
     R AU_TO_CM2, HPLNK_BAR,
     R EPSILON0,AMUAKG,FAKVTH,FAKLAM,COULOMBLOG,MY0,FAKTAUT !JS

cdr elements of periodic table 1:111, plus two heavier hydrogen isotopes
      TYPE (PTE_TYPE), PUBLIC, SAVE :: PTE(113)

      CONTAINS

      SUBROUTINE EIRENE_ALLOC_CCONA

      EPS60     => RCONA(1)
      EPS30     => RCONA(2)
      EPS12     => RCONA(3)
      EPS10     => RCONA(4)
      EPS6      => RCONA(5)
      EPS5      => RCONA(6)
      PMASSA    => RCONA(7)
      PMASSE    => RCONA(8)
      AMUA      => RCONA(9)
      PIA       => RCONA(10)
      PI2A      => RCONA(11)
      PIHA      => RCONA(12)
      PISQ      => RCONA(13)
      PIAI      => RCONA(14)
      SQ2       => RCONA(15)
      SQ2I      => RCONA(16)
      DEGRAD    => RCONA(17)
      RADDEG    => RCONA(18)
      CVELI2    => RCONA(19)
      CVELAA    => RCONA(20)
      CVEL2A    => RCONA(21)
      ELCHA     => RCONA(22)
      EFACT     => RCONA(23)
      EFCT23    => RCONA(24)
      EVKEL     => RCONA(25)
      EIONH     => RCONA(26)
      EIONH2    => RCONA(27)
      EIONHE    => RCONA(28)
      EV_TO_J   => RCONA(29)
      J_TO_EV   => RCONA(30)
      J_TO_ERG  => RCONA(31)
      ERG_TO_J  => RCONA(32)
      EV_TO_ERG => RCONA(33)
      ERG_TO_EV => RCONA(34)
      HPLANCK   => RCONA(35)
      CLIGHT    => RCONA(36)
      MUB       => RCONA(37)
      PIQU      => RCONA(38)
      HPLNK     => RCONA(39)
      HPCL      => RCONA(40)
      EV2HZ     => RCONA(41)
      AU_TO_CM2 => RCONA(42)
      HPLNK_BAR => RCONA(43)
      EPSILON0  => RCONA(44) !JS
      AMUAKG    => RCONA(45) !JS
      FAKVTH    => RCONA(46) !JS
      FAKLAM    => RCONA(47) !JS
      COULOMBLOG=> RCONA(48) !JS
      MY0       => RCONA(49) !JS
      FAKTAUT   => RCONA(50) !JS

      RETURN
      END SUBROUTINE EIRENE_ALLOC_CCONA


      SUBROUTINE EIRENE_SET_PTE_ELEMENT (IEL,NAME,AB,EM,CH)

cdr  Called from SETCON.f
cdr  Set elements of periodic table, 1:111, identify them by
cdr  name (NAME), short name in periodic table (ABBR),
cdr  nuclear mass (EL_MASS), nuclear charge (EL_CHARGE)
cdr  112:113: heavier isotopes of hydrogen D and T.
c
cdr  Data type PTE_TYPE is unused so far (Jan. 2020)

      INTEGER, INTENT(IN) :: IEL
      CHARACTER(*), INTENT(IN) :: NAME, AB
      REAL(DP), INTENT(IN) :: EM, CH

      PTE(IEL)%NAME = NAME
      PTE(IEL)%ABBR = AB
      PTE(IEL)%EL_MASS = EM
      PTE(IEL)%EL_CHARGE = CH

      RETURN
      END SUBROUTINE EIRENE_SET_PTE_ELEMENT



      FUNCTION EIRENE_FIND_PTE_ELEMENT(NAME) RESULT(IELEM)
cdr unused (Jan. 2020)

      CHARACTER(2),INTENT(IN) :: NAME
      INTEGER :: IELEM, I

      IELEM = 0

      do i = 1,113
         if (pte(i)%abbr == name) then
           ielem = i
           return
         end if
      end do

      return
      END FUNCTION EIRENE_FIND_PTE_ELEMENT

      SUBROUTINE EIRENE_BROADCAST_CCONA(ME)
      USE EIRMOD_MPI
      INTEGER, INTENT(IN) :: ME
      INTEGER :: IER
#if ( defined(USE_MPI) && !defined(GFORTRAN) && !defined(CRAY) )
      EXTERNAL :: MPI_BCAST
#endif

      IF (ME /= 0) CALL EIRENE_ALLOC_CCONA

      CALL MPI_BCAST (RCONA,NCONA,MPI_REAL8,0,MPI_COMM_WORLD,ier)

      CALL MPI_BARRIER(MPI_COMM_WORLD,ier)

      RETURN
      END SUBROUTINE EIRENE_BROADCAST_CCONA

      END MODULE EIRMOD_CCONA
