

C   NAME                -   RS
C-----------------------------------------------------------------------
C
C   PURPOSE             -   CALCULATION OF EIGENVALUES AND OPTIONALLY
C                           EIGENVECTORS OF A REAL SYMMETRIC MATRIX
C
C   COMPILER            -   VS FORTRAN
C
C   PRECISION           -   IBM DOUBLE
C
C   USAGE               -   CALL RS(NM,N,A,W,MATZ,Z,FV1,FV2,IERR)
C
C   ARGUMENTS    NM     -   MUST BE SET TO THE ROW DIMENSION OF THE
C                           TWO-DIMENSIONAL ARRAY PARAMETERS AS DECLARED
C                           IN THE CALLING PROGRAM DIMENSION STATEMENT.
C                                                                (INPUT)
C
C                N      -   ORDER OF THE MATRIX  A.              (INPUT)
C
C                A      -   MATRIX OF DIMENSION N BY N,
C                           CONTAINS THE REAL SYMMETRIC MATRIX   (INPUT)
C
C                W      -   VECTOR OF LENGTH N,
C                           CONTAINS THE EIGENVALUES IN ASCENDING ORDER
C                                                               (OUTPUT)
C
C                MATZ   -   INTEGER VARIABLE SET EQUAL TO ZERO IF
C                           ONLY EIGENVALUES ARE DESIRED,  OTHERWISE
C                           SET TO ANY NONZERO INTEGER FOR BOTH
C                           EIGENVALUES AND EIGENVECTORS.        (INPUT)
C
C                Z      -   MATRIX OF DIMENSION N BY N,
C                           CONTAINS THE EIGENVECTORS IF MATZ IS
C                           NOT ZERO.                           (OUTPUT)
C
C                FV1    -   VECTOR OF LENGTH N. WORK AREA.
C
C                FV2    -   VECTOR OF LENGTH N. WORK AREA.
C
C                IERR   -   INTEGER OUTPUT VARIABLE SET EQUAL TO
C                           AN ERROR COMPLETION CODE DESCRIBED IN
C                           SECTION 2.3 OF THE REFERENCE. THE
C                           NORMAL COMPLETION CODE IS ZERO.     (OUTPUT)
C
C   REQD. ROUTINES      -   TRED1, TQLRAT AND
C                           TRED2, TQL2 ARE PROVIDED.
C
C   REFERENCES          -   B.T. SMITH ET.AL.
C                           MATRIX EIGENSYSTEM ROUTINES - EISPACK GUIDE
C                           SECOND EDITION 1976
C                           LECTURE NOTES IN COMPUTER SCIENCES 6
C
C   REMARKS             -   THIS SUBROUTINE CALLS THE RECOMMENDED
C                           SEQUENCE OF SUBROUTINES FROM THE EIGENSYSTEM
C                           SUBROUTINE PACKAGE (EISPACK) TO FIND THE
C                           EIGENVALUES AND EIGENVECTORS (IF DESIRED)
C                           OF A REAL SYMMETRIC MATRIX.
C
C                           THE CORRESPONDING CRAY-VERSION IS A MEMBER
C                           OF THE $SCILIB.
C
C   ALGORITHM           -   THE MATRIX A IS REDUCED TO A SYMMETRIC
C                           TRIDIAGONAL MATRIX BY ORTHOGONAL TRANSFOR-
C                           MATIONS. THE EIGENVALUE PROBLEM FOR THE RE-
C                           DUCED MATRIX IS SOLVED BY THE QL ALGORITHM.
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C     ------------------------------------------------------------------
C
      SUBROUTINE EIRENE_RS(NM,N,A,W,MATZ,Z,FV1,FV2,IERR)
CCCCC
CCCCC     AENDERUNG:    REAL ---> REAL(DP)
CCCCC
      USE EIRMOD_PRECISION
      IMPLICIT NONE
C
      INTEGER :: N,NM,IERR,MATZ
      REAL(DP) :: A(NM,N),W(N),Z(NM,N),FV1(N),FV2(N)
      EXTERNAL :: EIRENE_TQLRAT, EIRENE_TQL2, EIRENE_TRED1, EIRENE_TRED2
C
C     THIS SUBROUTINE CALLS THE RECOMMENDED SEQUENCE OF
C     SUBROUTINES FROM THE EIGENSYSTEM SUBROUTINE PACKAGE (EISPACK)
C     TO FIND THE EIGENVALUES AND EIGENVECTORS (IF DESIRED)
C     OF A REAL SYMMETRIC MATRIX.
C
C     ON INPUT-
C
C        NM  MUST BE SET TO THE ROW DIMENSION OF THE TWO-DIMENSIONAL
C        ARRAY PARAMETERS AS DECLARED IN THE CALLING PROGRAM
C        DIMENSION STATEMENT,
C
C        N  IS THE ORDER OF THE MATRIX  A,
C
C        A  CONTAINS THE REAL SYMMETRIC MATRIX,
C
C        MATZ  IS AN INTEGER VARIABLE SET EQUAL TO ZERO IF
C        ONLY EIGENVALUES ARE DESIRED,  OTHERWISE IT IS SET TO
C        ANY NONZERO INTEGER FOR BOTH EIGENVALUES AND EIGENVECTORS.
C
C     ON OUTPUT-
C
C        W  CONTAINS THE EIGENVALUES IN ASCENDING ORDER,
C
C        Z  CONTAINS THE EIGENVECTORS IF MATZ IS NOT ZERO,
C
C        IERR  IS AN INTEGER OUTPUT VARIABLE SET EQUAL TO AN
C        ERROR COMPLETION CODE DESCRIBED IN SECTION 2B OF THE
C        DOCUMENTATION.  THE NORMAL COMPLETION CODE IS ZERO,
C
C        FV1  AND  FV2  ARE TEMPORARY STORAGE ARRAYS.
C
C     QUESTIONS AND COMMENTS SHOULD BE DIRECTED TO B. S. GARBOW,
C     APPLIED MATHEMATICS DIVISION, ARGONNE NATIONAL LABORATORY
C     MODIFIED FOR CFT BY MIKE ESS, CRI, JULY 1980
C
C     ------------------------------------------------------------------
C
C                                  FIRST EXECUTABLE STATEMENT
      IF (N .LE. NM) GO TO 10
      IERR = 10 * N
      GO TO 50
C
   10 IF (MATZ .NE. 0) GO TO 20
C     ********** FIND EIGENVALUES ONLY **********
      CALL  EIRENE_TRED1(NM,N,A,W,FV1,FV2)
      CALL  EIRENE_TQLRAT(N,W,FV2,IERR)
      GO TO 50
C     ********** FIND BOTH EIGENVALUES AND EIGENVECTORS **********
   20 CALL  EIRENE_TRED2(NM,N,A,W,FV1,Z)
      CALL  EIRENE_TQL2(NM,N,W,FV1,Z,IERR)
   50 RETURN
C     ********** LAST CARD OF RS **********
      END SUBROUTINE EIRENE_RS
