cdr  dec. 15:  added species index ipls for energy source tallies for bulk ions
cdr            eapl,empl,eipl,ephpl,eppl
cdr  nov. 19:  serial overhead speedup
C
      SUBROUTINE EIRENE_SUMOSTRA (ISTRA)
C
C  SUM UP TALLIES FOR SUM OVER STRATA
C
      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD
      USE EIRMOD_CAI, ONLY: XMCT
      USE EIRMOD_COMUSR
      USE EIRMOD_COUTAU
      USE EIRMOD_CLOGAU

      IMPLICIT NONE

      INTEGER, INTENT(IN) :: ISTRA
      INTEGER :: IMOL, IATM, IION, IPHOT, IPLS
      INTEGER :: IADV, ICLV, ISNV, ICPV, IBGV
      REAL(DP), POINTER, SAVE ::
     R  PAATIS(:,:),  PMATIS(:,:),  PIATIS(:,:),  PPHATIS(:,:),
     R  PRFAAIS(:,:), PRFMAIS(:,:), PRFIAIS(:,:), PRFPHAIS(:,:)
      REAL(DP), POINTER, SAVE ::
     R  PAMLIS(:,:),  PMMLIS(:,:),  PIMLIS(:,:),  PPHMLIS(:,:),
     R  PRFAMIS(:,:), PRFMMIS(:,:), PRFIMIS(:,:), PRFPHMIS(:,:)
      REAL(DP), POINTER, SAVE ::
     R  PAIOIS(:,:),  PMIOIS(:,:),  PIIOIS(:,:),  PPHIOIS(:,:),
     R  PRFAIIS(:,:), PRFMIIS(:,:), PRFIIIS(:,:), PRFPHIIS(:,:)
      REAL(DP), POINTER, SAVE ::
     R  PAPHTIS(:,:),  PMPHTIS(:,:),  PIPHTIS(:,:),  PPHPHTIS(:,:),
     R  PRFAPHTIS(:,:),PRFMPHTIS(:,:), PRFIPHTIS(:,:), PRFPHPHTIS(:,:)
      REAL(DP), POINTER, SAVE ::
     R  PAPLIS(:,:),  PMPLIS(:,:),  PIPLIS(:,:),  PPHPLIS(:,:)

#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP  THREADPRIVATE( PAATIS, PMATIS, PIATIS, PPHATIS,
!$OMP& PRFAAIS, PRFMAIS, PRFIAIS, PRFPHAIS,
!$OMP& PAMLIS,  PMMLIS,  PIMLIS,  PPHMLIS,
!$OMP& PRFAMIS, PRFMMIS, PRFIMIS, PRFPHMIS,
!$OMP& PAIOIS,  PMIOIS,  PIIOIS,  PPHIOIS,
!$OMP& PRFAIIS, PRFMIIS, PRFIIIS, PRFPHIIS,
!$OMP& PAPHTIS, PMPHTIS, PIPHTIS, PPHPHTIS,
!$OMP& PRFAPHTIS, PRFMPHTIS, PRFIPHTIS, PRFPHPHTIS,
!$OMP& PAPLIS,  PMPLIS,  PIPLIS,  PPHPLIS )
#endif

C
C  UPDATE TALLIES FOR "SUM OVER STRATA", CONTRIBUTION FROM ISTRA
C
      IF (NLSPCSCL_ATM) THEN
        PAMLIS(0:NMOL,0:NATM) => PAMLI(:,0)
        PAMLI2(0:NMOL,0:NATM) => PAMLI(:,ISTRA)
        PRFAMIS(0:NMOL,0:NATM) => PRFAMI(:,0)
        PRFAMI2(0:NMOL,0:NATM) => PRFAMI(:,ISTRA)
      END IF
      IF (NLSPCSCL_MOL) THEN
        PMMLIS(0:NMOL,0:NMOL) => PMMLI(:,0)
        PMMLI2(0:NMOL,0:NMOL) => PMMLI(:,ISTRA)
        PRFMMIS(0:NMOL,0:NMOL) => PRFMMI(:,0)
        PRFMMI2(0:NMOL,0:NMOL) => PRFMMI(:,ISTRA)
      END IF
      IF (NLSPCSCL_ION) THEN
        PIMLIS(0:NMOL,0:NION) => PIMLI(:,0)
        PIMLI2(0:NMOL,0:NION) => PIMLI(:,ISTRA)
        PRFIMIS(0:NMOL,0:NION) => PRFIMI(:,0)
        PRFIMI2(0:NMOL,0:NION) => PRFIMI(:,ISTRA)
      END IF
      IF (NLSPCSCL_PHOT) THEN
        PPHMLIS(0:NMOL,0:NPHOT) => PPHMLI(:,0)
        PPHMLI2(0:NMOL,0:NPHOT) => PPHMLI(:,ISTRA)
        PRFPHMIS(0:NMOL,0:NPHOT) => PRFPHMI(:,0)
        PRFPHMI2(0:NMOL,0:NPHOT) => PRFPHMI(:,ISTRA)
      END IF
      DO 1101 IMOL=0,NMOLI
        PPMLI (IMOL,0)=PPMLI (IMOL,0)+PPMLI (IMOL,ISTRA)
        WTOTM (IMOL,0)=WTOTM (IMOL,0)+WTOTM (IMOL,ISTRA)
        PDENMI(IMOL,0)=PDENMI(IMOL,0)+PDENMI(IMOL,ISTRA)
        EDENMI(IMOL,0)=EDENMI(IMOL,0)+EDENMI(IMOL,ISTRA)
        IF (NLSPCSCL_ATM) THEN
          PAMLIS(IMOL,0:NATMI) = PAMLIS(IMOL,0:NATMI) +
     .                           PAMLI2(IMOL,0:NATMI)
        ELSE
          PAMLI (IMOL,0)=PAMLI (IMOL,0)+PAMLI (IMOL,ISTRA)
        END IF
        IF (NLSPCSCL_MOL) THEN
          PMMLIS(IMOL,0:NMOLI) = PMMLIS(IMOL,0:NMOLI) +
     .                           PMMLI2(IMOL,0:NMOLI)
        ELSE
          PMMLI (IMOL,0)=PMMLI (IMOL,0)+PMMLI (IMOL,ISTRA)
        END IF
        IF (NLSPCSCL_ION) THEN
          PIMLIS(IMOL,0:NIONI) = PIMLIS(IMOL,0:NIONI) +
     .                           PIMLI2(IMOL,0:NIONI)
        ELSE
          PIMLI (IMOL,0)=PIMLI (IMOL,0)+PIMLI (IMOL,ISTRA)
        END IF
        IF (NLSPCSCL_PHOT) THEN
          PPHMLIS(IMOL,0:NPHOTI) = PPHMLIS(IMOL,0:NPHOTI) +
     .                             PPHMLI2(IMOL,0:NPHOTI)
        ELSE
          PPHMLI(IMOL,0)=PPHMLI(IMOL,0)+PPHMLI(IMOL,ISTRA)
        END IF
        POTMLI(IMOL,0)=POTMLI(IMOL,0)+POTMLI(IMOL,ISTRA)
        IF (NLSPCSCL_ATM) THEN
          PRFAMIS(IMOL,0:NATMI) = PRFAMIS(IMOL,0:NATMI) +
     .                            PRFAMI2(IMOL,0:NATMI)
        ELSE
          PRFAMI(IMOL,0)=PRFAMI(IMOL,0)+PRFAMI(IMOL,ISTRA)
        END IF
        IF (NLSPCSCL_MOL) THEN
          PRFMMIS(IMOL,0:NMOLI) = PRFMMIS(IMOL,0:NMOLI) +
     .                            PRFMMI2(IMOL,0:NMOLI)
        ELSE
          PRFMMI(IMOL,0)=PRFMMI(IMOL,0)+PRFMMI(IMOL,ISTRA)
        END IF
        IF (NLSPCSCL_ION) THEN
          PRFIMIS(IMOL,0:NIONI) = PRFIMIS(IMOL,0:NIONI) +
     .                            PRFIMI2(IMOL,0:NIONI)
        ELSE
          PRFIMI(IMOL,0)=PRFIMI(IMOL,0)+PRFIMI(IMOL,ISTRA)
        END IF
        IF (NLSPCSCL_PHOT) THEN
          PRFPHMIS(IMOL,0:NPHOTI) = PRFPHMIS(IMOL,0:NPHOTI) +
     .                              PRFPHMI2(IMOL,0:NPHOTI)
        ELSE
          PRFPHMI(IMOL,0)=PRFPHMI(IMOL,0)+PRFPHMI(IMOL,ISTRA)
        END IF
        PRFPMI(IMOL,0)=PRFPMI(IMOL,0)+PRFPMI(IMOL,ISTRA)
        EOTMLI(IMOL,0)=EOTMLI(IMOL,0)+EOTMLI(IMOL,ISTRA)
        ERFAMI(IMOL,0)=ERFAMI(IMOL,0)+ERFAMI(IMOL,ISTRA)
        ERFMMI(IMOL,0)=ERFMMI(IMOL,0)+ERFMMI(IMOL,ISTRA)
        ERFIMI(IMOL,0)=ERFIMI(IMOL,0)+ERFIMI(IMOL,ISTRA)
        ERFPHMI(IMOL,0)=ERFPHMI(IMOL,0)+ERFPHMI(IMOL,ISTRA)
        ERFPMI(IMOL,0)=ERFPMI(IMOL,0)+ERFPMI(IMOL,ISTRA)
        SPTAMLI(IMOL,0)=SPTAMLI(IMOL,0)+SPTAMLI(IMOL,ISTRA)
        SPTMMLI(IMOL,0)=SPTMMLI(IMOL,0)+SPTMMLI(IMOL,ISTRA)
        SPTIMLI(IMOL,0)=SPTIMLI(IMOL,0)+SPTIMLI(IMOL,ISTRA)
        SPTPHMLI(IMOL,0)=SPTPHMLI(IMOL,0)+SPTPHMLI(IMOL,ISTRA)
        SPTPMLI(IMOL,0)=SPTPMLI(IMOL,0)+SPTPMLI(IMOL,ISTRA)
        PGENMI(IMOL,0)=PGENMI(IMOL,0)+PGENMI(IMOL,ISTRA)
        EGENMI(IMOL,0)=EGENMI(IMOL,0)+EGENMI(IMOL,ISTRA)
        VGENMI(IMOL,0)=VGENMI(IMOL,0)+VGENMI(IMOL,ISTRA)
        VXDENMI(IMOL,0)=VXDENMI(IMOL,0)+VXDENMI(IMOL,ISTRA)
        VYDENMI(IMOL,0)=VYDENMI(IMOL,0)+VYDENMI(IMOL,ISTRA)
        VZDENMI(IMOL,0)=VZDENMI(IMOL,0)+VZDENMI(IMOL,ISTRA)
        RMELI(IMOL,0)=RMELI(IMOL,0)+RMELI(IMOL,ISTRA)
 1101 CONTINUE

      IF (NLSPCSCL_ATM) THEN
        PAATIS(0:NATM,0:NATM) => PAATI(:,0)
        PAATI2(0:NATM,0:NATM) => PAATI(:,ISTRA)
        PRFAAIS(0:NATM,0:NATM) => PRFAAI(:,0)
        PRFAAI2(0:NATM,0:NATM) => PRFAAI(:,ISTRA)
      END IF
      IF (NLSPCSCL_MOL) THEN
        PMATIS(0:NATM,0:NMOL) => PMATI(:,0)
        PMATI2(0:NATM,0:NMOL) => PMATI(:,ISTRA)
        PRFMAIS(0:NATM,0:NMOL) => PRFMAI(:,0)
        PRFMAI2(0:NATM,0:NMOL) => PRFMAI(:,ISTRA)
      END IF
      IF (NLSPCSCL_ION) THEN
        PIATIS(0:NATM,0:NION) => PIATI(:,0)
        PIATI2(0:NATM,0:NION) => PIATI(:,ISTRA)
        PRFIAIS(0:NATM,0:NION) => PRFIAI(:,0)
        PRFIAI2(0:NATM,0:NION) => PRFIAI(:,ISTRA)
      END IF
      IF (NLSPCSCL_PHOT) THEN
        PPHATIS(0:NATM,0:NPHOT) => PPHATI(:,0)
        PPHATI2(0:NATM,0:NPHOT) => PPHATI(:,ISTRA)
        PRFPHAIS(0:NATM,0:NPHOT) => PRFPHAI(:,0)
        PRFPHAI2(0:NATM,0:NPHOT) => PRFPHAI(:,ISTRA)
      END IF
      DO 1102 IATM=0,NATMI
        PPATI (IATM,0)=PPATI (IATM,0)+PPATI (IATM,ISTRA)
        WTOTA (IATM,0)=WTOTA (IATM,0)+WTOTA (IATM,ISTRA)
        PDENAI(IATM,0)=PDENAI(IATM,0)+PDENAI(IATM,ISTRA)
        EDENAI(IATM,0)=EDENAI(IATM,0)+EDENAI(IATM,ISTRA)
        IF (NLSPCSCL_ATM) THEN
          PAATIS(IATM,0:NATMI) = PAATIS(IATM,0:NATMI) +
     .                           PAATI2(IATM,0:NATMI)
        ELSE
          PAATI (IATM,0)=PAATI (IATM,0)+PAATI (IATM,ISTRA)
        END IF
        IF (NLSPCSCL_MOL) THEN
          PMATIS(IATM,0:NMOLI) = PMATIS(IATM,0:NMOLI) +
     .                           PMATI2(IATM,0:NMOLI)
        ELSE
          PMATI (IATM,0)=PMATI (IATM,0)+PMATI (IATM,ISTRA)
        END IF
        IF (NLSPCSCL_ION) THEN
          PIATIS(IATM,0:NIONI) = PIATIS(IATM,0:NIONI) +
     .                           PIATI2(IATM,0:NIONI)
        ELSE
          PIATI (IATM,0)=PIATI (IATM,0)+PIATI (IATM,ISTRA)
        END IF
        IF (NLSPCSCL_PHOT) THEN
          PPHATIS(IATM,0:NPHOTI) = PPHATIS(IATM,0:NPHOTI) +
     .                             PPHATI2(IATM,0:NPHOTI)
        ELSE
          PPHATI(IATM,0)=PPHATI(IATM,0)+PPHATI(IATM,ISTRA)
        END IF
        POTATI(IATM,0)=POTATI(IATM,0)+POTATI(IATM,ISTRA)
        IF (NLSPCSCL_ATM) THEN
          PRFAAIS(IATM,0:NATMI) = PRFAAIS(IATM,0:NATMI) +
     .                            PRFAAI2(IATM,0:NATMI)
        ELSE
          PRFAAI(IATM,0)=PRFAAI(IATM,0)+PRFAAI(IATM,ISTRA)
        END IF
        IF (NLSPCSCL_MOL) THEN
          PRFMAIS(IATM,0:NMOLI) = PRFMAIS(IATM,0:NMOLI) +
     .                            PRFMAI2(IATM,0:NMOLI)
        ELSE
          PRFMAI(IATM,0)=PRFMAI(IATM,0)+PRFMAI(IATM,ISTRA)
        END IF
        IF (NLSPCSCL_ION) THEN
          PRFIAIS(IATM,0:NIONI) = PRFIAIS(IATM,0:NIONI) +
     .                            PRFIAI2(IATM,0:NIONI)
        ELSE
          PRFIAI(IATM,0)=PRFIAI(IATM,0)+PRFIAI(IATM,ISTRA)
        END IF
        IF (NLSPCSCL_PHOT) THEN
          PRFPHAIS(IATM,0:NPHOTI) = PRFPHAIS(IATM,0:NPHOTI) +
     .                              PRFPHAI2(IATM,0:NPHOTI)
        ELSE
          PRFPHAI(IATM,0)=PRFPHAI(IATM,0)+PRFPHAI(IATM,ISTRA)
        END IF
        PRFPAI(IATM,0)=PRFPAI(IATM,0)+PRFPAI(IATM,ISTRA)
        EOTATI(IATM,0)=EOTATI(IATM,0)+EOTATI(IATM,ISTRA)
        ERFAAI(IATM,0)=ERFAAI(IATM,0)+ERFAAI(IATM,ISTRA)
        ERFMAI(IATM,0)=ERFMAI(IATM,0)+ERFMAI(IATM,ISTRA)
        ERFIAI(IATM,0)=ERFIAI(IATM,0)+ERFIAI(IATM,ISTRA)
        ERFPHAI(IATM,0)=ERFPHAI(IATM,0)+ERFPHAI(IATM,ISTRA)
        ERFPAI(IATM,0)=ERFPAI(IATM,0)+ERFPAI(IATM,ISTRA)
        SPTAATI(IATM,0)=SPTAATI(IATM,0)+SPTAATI(IATM,ISTRA)
        SPTMATI(IATM,0)=SPTMATI(IATM,0)+SPTMATI(IATM,ISTRA)
        SPTIATI(IATM,0)=SPTIATI(IATM,0)+SPTIATI(IATM,ISTRA)
        SPTPHATI(IATM,0)=SPTPHATI(IATM,0)+SPTPHATI(IATM,ISTRA)
        SPTPATI(IATM,0)=SPTPATI(IATM,0)+SPTPATI(IATM,ISTRA)
        PGENAI(IATM,0)=PGENAI(IATM,0)+PGENAI(IATM,ISTRA)
        EGENAI(IATM,0)=EGENAI(IATM,0)+EGENAI(IATM,ISTRA)
        VGENAI(IATM,0)=VGENAI(IATM,0)+VGENAI(IATM,ISTRA)
        VXDENAI(IATM,0)=VXDENAI(IATM,0)+VXDENAI(IATM,ISTRA)
        VYDENAI(IATM,0)=VYDENAI(IATM,0)+VYDENAI(IATM,ISTRA)
        VZDENAI(IATM,0)=VZDENAI(IATM,0)+VZDENAI(IATM,ISTRA)
        RAELI(IATM,0)=RAELI(IATM,0)+RAELI(IATM,ISTRA)
 1102 CONTINUE

      IF (NLSPCSCL_ATM) THEN
        PAIOIS(0:NION,0:NATM) => PAIOI(:,0)
        PAIOI2(0:NION,0:NATM) => PAIOI(:,ISTRA)
        PRFAIIS(0:NION,0:NATM) => PRFAII(:,0)
        PRFAII2(0:NION,0:NATM) => PRFAII(:,ISTRA)
      END IF
      IF (NLSPCSCL_MOL) THEN
        PMIOIS(0:NION,0:NMOL) => PMIOI(:,0)
        PMIOI2(0:NION,0:NMOL) => PMIOI(:,ISTRA)
        PRFMIIS(0:NION,0:NMOL) => PRFMII(:,0)
        PRFMII2(0:NION,0:NMOL) => PRFMII(:,ISTRA)
      END IF
      IF (NLSPCSCL_ION) THEN
        PIIOIS(0:NION,0:NION) => PIIOI(:,0)
        PIIOI2(0:NION,0:NION) => PIIOI(:,ISTRA)
        PRFIIIS(0:NION,0:NION) => PRFIII(:,0)
        PRFIII2(0:NION,0:NION) => PRFIII(:,ISTRA)
      END IF
      IF (NLSPCSCL_PHOT) THEN
        PPHIOIS(0:NION,0:NPHOT) => PPHIOI(:,0)
        PPHIOI2(0:NION,0:NPHOT) => PPHIOI(:,ISTRA)
        PRFPHIIS(0:NION,0:NPHOT) => PRFPHII(:,0)
        PRFPHII2(0:NION,0:NPHOT) => PRFPHII(:,ISTRA)
      END IF
      DO 1103 IION=0,NIONI
        PPIOI (IION,0)=PPIOI (IION,0)+PPIOI (IION,ISTRA)
        EELFI (IION,0)=EELFI (IION,0)+EELFI (IION,ISTRA)
        WTOTI (IION,0)=WTOTI (IION,0)+WTOTI (IION,ISTRA)
        PDENII(IION,0)=PDENII(IION,0)+PDENII(IION,ISTRA)
        EDENII(IION,0)=EDENII(IION,0)+EDENII(IION,ISTRA)
        IF (NLSPCSCL_ATM) THEN
          PAIOIS(IION,0:NATMI) = PAIOIS(IION,0:NATMI) +
     .                           PAIOI2(IION,0:NATMI)
        ELSE
          PAIOI (IION,0)=PAIOI (IION,0)+PAIOI (IION,ISTRA)
        END IF
        IF (NLSPCSCL_MOL) THEN
          PMIOIS(IION,0:NMOLI) = PMIOIS(IION,0:NMOLI) +
     .                           PMIOI2(IION,0:NMOLI)
        ELSE
          PMIOI (IION,0)=PMIOI (IION,0)+PMIOI (IION,ISTRA)
        END IF
        IF (NLSPCSCL_ION) THEN
          PIIOIS(IION,0:NIONI) = PIIOIS(IION,0:NIONI) +
     .                           PIIOI2(IION,0:NIONI)
        ELSE
          PIIOI (IION,0)=PIIOI (IION,0)+PIIOI (IION,ISTRA)
        END IF
        IF (NLSPCSCL_PHOT) THEN
          PPHIOIS(IION,0:NPHOTI) = PPHIOIS(IION,0:NPHOTI) +
     .                             PPHIOI2(IION,0:NPHOTI)
        ELSE
          PPHIOI(IION,0)=PPHIOI(IION,0)+PPHIOI(IION,ISTRA)
        END IF
        POTIOI(IION,0)=POTIOI(IION,0)+POTIOI(IION,ISTRA)
        IF (NLSPCSCL_ATM) THEN
          PRFAIIS(IION,0:NATMI) = PRFAIIS(IION,0:NATMI) +
     .                            PRFAII2(IION,0:NATMI)
        ELSE
          PRFAII(IION,0)=PRFAII(IION,0)+PRFAII(IION,ISTRA)
        END IF
        IF (NLSPCSCL_MOL) THEN
          PRFMIIS(IION,0:NMOLI) = PRFMIIS(IION,0:NMOLI) +
     .                            PRFMII2(IION,0:NMOLI)
        ELSE
          PRFMII(IION,0)=PRFMII(IION,0)+PRFMII(IION,ISTRA)
        END IF
        IF (NLSPCSCL_ION) THEN
          PRFIIIS(IION,0:NIONI) = PRFIIIS(IION,0:NIONI) +
     .                            PRFIII2(IION,0:NIONI)
        ELSE
          PRFIII(IION,0)=PRFIII(IION,0)+PRFIII(IION,ISTRA)
        END IF
        IF (NLSPCSCL_PHOT) THEN
          PRFPHIIS(IION,0:NPHOTI) = PRFPHIIS(IION,0:NPHOTI) +
     .                              PRFPHII2(IION,0:NPHOTI)
        ELSE
          PRFPHII(IION,0)=PRFPHII(IION,0)+PRFPHII(IION,ISTRA)
        END IF
        PRFPII(IION,0)=PRFPII(IION,0)+PRFPII(IION,ISTRA)
        EOTIOI(IION,0)=EOTIOI(IION,0)+EOTIOI(IION,ISTRA)
        ERFAII(IION,0)=ERFAII(IION,0)+ERFAII(IION,ISTRA)
        ERFMII(IION,0)=ERFMII(IION,0)+ERFMII(IION,ISTRA)
        ERFIII(IION,0)=ERFIII(IION,0)+ERFIII(IION,ISTRA)
        ERFPHII(IION,0)=ERFPHII(IION,0)+ERFPHII(IION,ISTRA)
        ERFPII(IION,0)=ERFPII(IION,0)+ERFPII(IION,ISTRA)
        SPTAIOI(IION,0)=SPTAIOI(IION,0)+SPTAIOI(IION,ISTRA)
        SPTMIOI(IION,0)=SPTMIOI(IION,0)+SPTMIOI(IION,ISTRA)
        SPTIIOI(IION,0)=SPTIIOI(IION,0)+SPTIIOI(IION,ISTRA)
        SPTPHIOI(IION,0)=SPTPHIOI(IION,0)+SPTPHIOI(IION,ISTRA)
        SPTPIOI(IION,0)=SPTPIOI(IION,0)+SPTPIOI(IION,ISTRA)
        PGENII(IION,0)=PGENII(IION,0)+PGENII(IION,ISTRA)
        EGENII(IION,0)=EGENII(IION,0)+EGENII(IION,ISTRA)
        VGENII(IION,0)=VGENII(IION,0)+VGENII(IION,ISTRA)
        VXDENII(IION,0)=VXDENII(IION,0)+VXDENII(IION,ISTRA)
        VYDENII(IION,0)=VYDENII(IION,0)+VYDENII(IION,ISTRA)
        VZDENII(IION,0)=VZDENII(IION,0)+VZDENII(IION,ISTRA)
        RIELI(IION,0)=RIELI(IION,0)+RIELI(IION,ISTRA)
 1103 CONTINUE

      IF (NLSPCSCL_ATM) THEN
        PAPHTIS(0:NPHOT,0:NATM) => PAPHTI(:,0)
        PAPHTI2(0:NPHOT,0:NATM) => PAPHTI(:,ISTRA)
        PRFAPHTIS(0:NPHOT,0:NATM) => PRFAPHTI(:,0)
        PRFAPHTI2(0:NPHOT,0:NATM) => PRFAPHTI(:,ISTRA)
      END IF
      IF (NLSPCSCL_MOL) THEN
        PMPHTIS(0:NPHOT,0:NMOL) => PMPHTI(:,0)
        PMPHTI2(0:NPHOT,0:NMOL) => PMPHTI(:,ISTRA)
        PRFMPHTIS(0:NPHOT,0:NMOL) => PRFMPHTI(:,0)
        PRFMPHTI2(0:NPHOT,0:NMOL) => PRFMPHTI(:,ISTRA)
      END IF
      IF (NLSPCSCL_ION) THEN
        PIPHTIS(0:NPHOT,0:NION) => PIPHTI(:,0)
        PIPHTI2(0:NPHOT,0:NION) => PIPHTI(:,ISTRA)
        PRFIPHTIS(0:NPHOT,0:NION) => PRFIPHTI(:,0)
        PRFIPHTI2(0:NPHOT,0:NION) => PRFIPHTI(:,ISTRA)
      END IF
      IF (NLSPCSCL_PHOT) THEN
        PPHPHTIS(0:NPHOT,0:NPHOT) => PPHPHTI(:,0)
        PPHPHTI2(0:NPHOT,0:NPHOT) => PPHPHTI(:,ISTRA)
        PRFPHPHTIS(0:NPHOT,0:NPHOT) => PRFPHPHTI(:,0)
        PRFPHPHTI2(0:NPHOT,0:NPHOT) => PRFPHPHTI(:,ISTRA)
      END IF
      DO IPHOT=0,NPHOTI
        PPPHTI  (IPHOT,0)=PPPHTI  (IPHOT,0)+PPPHTI  (IPHOT,ISTRA)
        WTOTPH  (IPHOT,0)=WTOTPH  (IPHOT,0)+WTOTPH  (IPHOT,ISTRA)
        PDENPHI (IPHOT,0)=PDENPHI (IPHOT,0)+PDENPHI (IPHOT,ISTRA)
        EDENPHI (IPHOT,0)=EDENPHI (IPHOT,0)+EDENPHI (IPHOT,ISTRA)
        IF (NLSPCSCL_ATM) THEN
          PAPHTIS(IPHOT,0:NATMI) = PAPHTIS(IPHOT,0:NATMI) +
     .                             PAPHTI2(IPHOT,0:NATMI)
        ELSE
          PAPHTI (IPHOT,0)=PAPHTI (IPHOT,0)+PAPHTI (IPHOT,ISTRA)
        END IF
        IF (NLSPCSCL_MOL) THEN
          PMPHTIS(IPHOT,0:NMOLI) = PMPHTIS(IPHOT,0:NMOLI) +
     .                             PMPHTI2(IPHOT,0:NMOLI)
        ELSE
          PMPHTI  (IPHOT,0)=PMPHTI  (IPHOT,0)+PMPHTI  (IPHOT,ISTRA)
        END IF
        IF (NLSPCSCL_ION) THEN
          PIPHTIS(IPHOT,0:NIONI) = PIPHTIS(IPHOT,0:NIONI) +
     .                             PIPHTI2(IPHOT,0:NIONI)
        ELSE
          PIPHTI  (IPHOT,0)=PIPHTI  (IPHOT,0)+PIPHTI  (IPHOT,ISTRA)
        END IF
        IF (NLSPCSCL_PHOT) THEN
          PPHPHTIS(IPHOT,0:NPHOTI) = PPHPHTIS(IPHOT,0:NPHOTI) +
     .                               PPHPHTI2(IPHOT,0:NPHOTI)
        ELSE
          PPHPHTI (IPHOT,0)=PPHPHTI (IPHOT,0)+PPHPHTI (IPHOT,ISTRA)
        END IF
        POTPHTI (IPHOT,0)=POTPHTI (IPHOT,0)+POTPHTI (IPHOT,ISTRA)
        IF (NLSPCSCL_ATM) THEN
          PRFAPHTIS(IPHOT,0:NATMI) = PRFAPHTIS(IPHOT,0:NATMI) +
     .                               PRFAPHTI2(IPHOT,0:NATMI)
        ELSE
          PRFAPHTI(IPHOT,0)=PRFAPHTI(IPHOT,0)+PRFAPHTI(IPHOT,ISTRA)
        END IF
        IF (NLSPCSCL_MOL) THEN
          PRFMPHTIS(IPHOT,0:NMOLI) = PRFMPHTIS(IPHOT,0:NMOLI) +
     .                               PRFMPHTI2(IPHOT,0:NMOLI)
        ELSE
          PRFMPHTI(IPHOT,0)=PRFMPHTI(IPHOT,0)+PRFMPHTI(IPHOT,ISTRA)
        END IF
        IF (NLSPCSCL_ION) THEN
          PRFIPHTIS(IPHOT,0:NIONI) = PRFIPHTIS(IPHOT,0:NIONI) +
     .                               PRFIPHTI2(IPHOT,0:NIONI)
        ELSE
          PRFIPHTI(IPHOT,0)=PRFIPHTI(IPHOT,0)+PRFIPHTI(IPHOT,ISTRA)
        END IF
        IF (NLSPCSCL_PHOT) THEN
          PRFPHPHTIS(IPHOT,0:NPHOTI) = PRFPHPHTIS(IPHOT,0:NPHOTI) +
     .                                 PRFPHPHTI2(IPHOT,0:NPHOTI)
        ELSE
          PRFPHPHTI(IPHOT,0)=PRFPHPHTI(IPHOT,0)+PRFPHPHTI(IPHOT,ISTRA)
        END IF
        PRFPPHTI(IPHOT,0)=PRFPPHTI(IPHOT,0)+PRFPPHTI(IPHOT,ISTRA)
        EOTPHTI (IPHOT,0)=EOTPHTI (IPHOT,0)+EOTPHTI (IPHOT,ISTRA)
        ERFAPHTI(IPHOT,0)=ERFAPHTI(IPHOT,0)+ERFAPHTI(IPHOT,ISTRA)
        ERFMPHTI(IPHOT,0)=ERFMPHTI(IPHOT,0)+ERFMPHTI(IPHOT,ISTRA)
        ERFIPHTI(IPHOT,0)=ERFIPHTI(IPHOT,0)+ERFIPHTI(IPHOT,ISTRA)
        ERFPHPHTI(IPHOT,0)=ERFPHPHTI(IPHOT,0)+ERFPHPHTI(IPHOT,ISTRA)
        ERFPPHTI(IPHOT,0)=ERFPPHTI(IPHOT,0)+ERFPPHTI(IPHOT,ISTRA)
        SPTAPHTI(IPHOT,0)=SPTAPHTI(IPHOT,0)+SPTAPHTI(IPHOT,ISTRA)
        SPTMPHTI(IPHOT,0)=SPTMPHTI(IPHOT,0)+SPTMPHTI(IPHOT,ISTRA)
        SPTIPHTI(IPHOT,0)=SPTIPHTI(IPHOT,0)+SPTIPHTI(IPHOT,ISTRA)
        SPTPHPHTI(IPHOT,0)=SPTPHPHTI(IPHOT,0)+SPTPHPHTI(IPHOT,ISTRA)
        SPTPPHTI(IPHOT,0)=SPTPPHTI(IPHOT,0)+SPTPPHTI(IPHOT,ISTRA)
        PGENPHI (IPHOT,0)=PGENPHI (IPHOT,0)+PGENPHI (IPHOT,ISTRA)
        EGENPHI (IPHOT,0)=EGENPHI (IPHOT,0)+EGENPHI (IPHOT,ISTRA)
        VGENPHI (IPHOT,0)=VGENPHI (IPHOT,0)+VGENPHI (IPHOT,ISTRA)
        VXDENPHI (IPHOT,0)=VXDENPHI (IPHOT,0)+VXDENPHI (IPHOT,ISTRA)
        VYDENPHI (IPHOT,0)=VYDENPHI (IPHOT,0)+VYDENPHI (IPHOT,ISTRA)
        VZDENPHI (IPHOT,0)=VZDENPHI (IPHOT,0)+VZDENPHI (IPHOT,ISTRA)
      END DO

      IF (NLSPCSCL_ATM) THEN
        PAPLIS(0:NPLS,0:NATM) => PAPLI(:,0)
        PAPLI2(0:NPLS,0:NATM) => PAPLI(:,ISTRA)
      END IF
      IF (NLSPCSCL_MOL) THEN
        PMPLIS(0:NPLS,0:NMOL) => PMPLI(:,0)
        PMPLI2(0:NPLS,0:NMOL) => PMPLI(:,ISTRA)
      END IF
      IF (NLSPCSCL_ION) THEN
        PIPLIS(0:NPLS,0:NION) => PIPLI(:,0)
        PIPLI2(0:NPLS,0:NION) => PIPLI(:,ISTRA)
      END IF
      IF (NLSPCSCL_PHOT) THEN
        PPHPLIS(0:NPLS,0:NPHOT) => PPHPLI(:,0)
        PPHPLI2(0:NPLS,0:NPHOT) => PPHPLI(:,ISTRA)
      END IF
      DO 1104 IPLS=0,NPLSI
        WTOTP (IPLS,0)=WTOTP (IPLS,0)+WTOTP (IPLS,ISTRA)

        PPPLI (IPLS,0)=PPPLI (IPLS,0)+PPPLI (IPLS,ISTRA)
        IF (NLSPCSCL_ATM) THEN
          PAPLIS(IPLS,0:NATMI) = PAPLIS(IPLS,0:NATMI) +
     .                           PAPLI2(IPLS,0:NATMI)
        ELSE
          PAPLI (IPLS,0)=PAPLI (IPLS,0)+PAPLI (IPLS,ISTRA)
        END IF
        IF (NLSPCSCL_MOL) THEN
          PMPLIS(IPLS,0:NMOLI) = PMPLIS(IPLS,0:NMOLI) +
     .                           PMPLI2(IPLS,0:NMOLI)
        ELSE
          PMPLI (IPLS,0)=PMPLI (IPLS,0)+PMPLI (IPLS,ISTRA)
        END IF
        IF (NLSPCSCL_ION) THEN
          PIPLIS(IPLS,0:NIONI) = PIPLIS(IPLS,0:NIONI) +
     .                           PIPLI2(IPLS,0:NIONI)
        ELSE
          PIPLI (IPLS,0)=PIPLI (IPLS,0)+PIPLI (IPLS,ISTRA)
        END IF
        IF (NLSPCSCL_PHOT) THEN
          PPHPLIS(IPLS,0:NPHOTI) = PPHPLIS(IPLS,0:NPHOTI) +
     .                             PPHPLI2(IPLS,0:NPHOTI)
        ELSE
          PPHPLI(IPLS,0)=PPHPLI(IPLS,0)+PPHPLI(IPLS,ISTRA)
        END IF

        EAPLI (IPLS,0)=EAPLI (IPLS,0)+EAPLI (IPLS,ISTRA)
        EMPLI (IPLS,0)=EMPLI (IPLS,0)+EMPLI (IPLS,ISTRA)
        EIPLI (IPLS,0)=EIPLI (IPLS,0)+EIPLI (IPLS,ISTRA)
        EPHPLI(IPLS,0)=EPHPLI(IPLS,0)+EPHPLI(IPLS,ISTRA)
        EPPLI (IPLS,0)=EPPLI (IPLS,0)+EPPLI (IPLS,ISTRA)

        POTPLI(IPLS,0)=POTPLI(IPLS,0)+POTPLI(IPLS,ISTRA)
        EOTPLI(IPLS,0)=EOTPLI(IPLS,0)+EOTPLI(IPLS,ISTRA)

        SPTAPLI(IPLS,0)=SPTAPLI(IPLS,0)+SPTAPLI(IPLS,ISTRA)
        SPTMPLI(IPLS,0)=SPTMPLI(IPLS,0)+SPTMPLI(IPLS,ISTRA)
        SPTIPLI(IPLS,0)=SPTIPLI(IPLS,0)+SPTIPLI(IPLS,ISTRA)
        SPTPHPLI(IPLS,0)=SPTPHPLI(IPLS,0)+SPTPHPLI(IPLS,ISTRA)
        SPTPPLI(IPLS,0)=SPTPPLI(IPLS,0)+SPTPPLI(IPLS,ISTRA)
        MAPLI (IPLS,0)=MAPLI (IPLS,0)+MAPLI (IPLS,ISTRA)
        MMPLI (IPLS,0)=MMPLI (IPLS,0)+MMPLI (IPLS,ISTRA)
        MIPLI (IPLS,0)=MIPLI (IPLS,0)+MIPLI (IPLS,ISTRA)
        MPHPLI(IPLS,0)=MPHPLI(IPLS,0)+MPHPLI(IPLS,ISTRA)
 1104 CONTINUE
      WTOTE(0)=WTOTE(0)+WTOTE(ISTRA)
      DO 1105 IADV=0,NADVI
        ADDVI(IADV,0)=ADDVI(IADV,0)+ADDVI(IADV,ISTRA)
 1105 CONTINUE
      DO 1106 ICLV=0,NCLVI
        COLVI(ICLV,0)=COLVI(ICLV,0)+COLVI(ICLV,ISTRA)
 1106 CONTINUE
      DO 1107 ISNV=0,NSNVI
        SNAPVI(ISNV,0)=SNAPVI(ISNV,0)+SNAPVI(ISNV,ISTRA)
 1107 CONTINUE
      DO 1108 ICPV=0,NCPVI
        COPVI(ICPV,0)=COPVI(ICPV,0)+COPVI(ICPV,ISTRA)
 1108 CONTINUE
      DO 1109 IBGV=0,NBGVI
        BGKVI(IBGV,0)=BGKVI(IBGV,0)+BGKVI(IBGV,ISTRA)
 1109 CONTINUE
      PAELI (0)=PAELI (0)+PAELI (ISTRA)
      PMELI (0)=PMELI (0)+PMELI (ISTRA)
      PIELI (0)=PIELI (0)+PIELI (ISTRA)
      PPHELI(0)=PPHELI(0)+PPHELI(ISTRA)
C
      EAELI (0)=EAELI (0)+EAELI (ISTRA)
      EAATI (0)=EAATI (0)+EAATI (ISTRA)
      EAMLI (0)=EAMLI (0)+EAMLI (ISTRA)
      EAIOI (0)=EAIOI (0)+EAIOI (ISTRA)
      EAPHTI(0)=EAPHTI(0)+EAPHTI(ISTRA)
C
      EMELI (0)=EMELI (0)+EMELI (ISTRA)
      EMATI (0)=EMATI (0)+EMATI (ISTRA)
      EMMLI (0)=EMMLI (0)+EMMLI (ISTRA)
      EMIOI (0)=EMIOI (0)+EMIOI (ISTRA)
      EMPHTI(0)=EMPHTI(0)+EMPHTI(ISTRA)
C
      EIELI (0)=EIELI (0)+EIELI (ISTRA)
      EIATI (0)=EIATI (0)+EIATI (ISTRA)
      EIMLI (0)=EIMLI (0)+EIMLI (ISTRA)
      EIIOI (0)=EIIOI (0)+EIIOI (ISTRA)
      EIPHTI(0)=EIPHTI(0)+EIPHTI(ISTRA)
C
      EPHELI (0)=EPHELI (0)+EPHELI (ISTRA)
      EPHATI (0)=EPHATI (0)+EPHATI (ISTRA)
      EPHMLI (0)=EPHMLI (0)+EPHMLI (ISTRA)
      EPHIOI (0)=EPHIOI (0)+EPHIOI (ISTRA)
      EPHPHTI(0)=EPHPHTI(0)+EPHPHTI(ISTRA)
C
      EPATI (0)=EPATI (0)+EPATI (ISTRA)
      EPMLI (0)=EPMLI (0)+EPMLI (ISTRA)
      EPIOI (0)=EPIOI (0)+EPIOI (ISTRA)
      EPPHTI(0)=EPPHTI(0)+EPPHTI(ISTRA)
C
C
      FLUXT(0)=FLUXT(0)+FLUXT(ISTRA)
      XMCP(0)=XMCP(0)+XMCP(ISTRA)
      XMCT(0)=XMCT(0)+XMCT(ISTRA)
      PTRASH(0)=PTRASH(0)+PTRASH(ISTRA)
      ETRASH(0)=ETRASH(0)+ETRASH(ISTRA)
      ETOTA(0)=ETOTA(0)+ETOTA(ISTRA)
      ETOTM(0)=ETOTM(0)+ETOTM(ISTRA)
      ETOTI(0)=ETOTI(0)+ETOTI(ISTRA)
      ETOTP(0)=ETOTP(0)+ETOTP(ISTRA)
      ETOTPH(0)=ETOTPH(0)+ETOTPH(ISTRA)

      SPTTTI(0) = SPTTTI(0) + SPTTTI(ISTRA)
      SPTATTI(0) = SPTATTI(0) + SPTATTI(ISTRA)
      SPTMTTI(0) = SPTMTTI(0) + SPTMTTI(ISTRA)
      SPTITTI(0) = SPTITTI(0) + SPTITTI(ISTRA)
      SPTPHTTI(0) = SPTPHTTI(0) + SPTPHTTI(ISTRA)
      SPTPLTTI(0) = SPTPLTTI(0) + SPTPLTTI(ISTRA)
C
      RETURN
      END SUBROUTINE EIRENE_SUMOSTRA
