cdr   enforce a rescaling of all output tallies (for a given stratum ISTR)
cdr   such that a specified particular response takes a given value SCALV,
cdr   rather than employing the default scaling with source strength FLUX.
cdr   The particular reference response is coded in
c       ISCLS                            (SPECIES NUMBER)
c       ISCLT                            (TALLY NUMBER)
c       ISCL1, ISCL2,ISCL3,ISCLB,ISCLA   (CELL NUMBER)

      SUBROUTINE EIRENE_SET_SCAL_CONST (ISTR, WTT, ZWW, ZW, ZVOLNT,
     .                            ZVOLWT, ZVOLIN, ZVOLIW, SCLTAL, N1DIM)
C
C  SET SOME SCALING CONSTANTS
C
      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD
      USE EIRMOD_COMSOU
      USE EIRMOD_COMPRT, ONLY : IUNOUT
      USE EIRMOD_CGRID
      USE EIRMOD_COUTAU
      USE EIRMOD_CESTIM
      USE EIRMOD_CCONA
      USE EIRMOD_CGEOM

      IMPLICIT NONE

      INTEGER, INTENT(IN) :: ISTR, N1DIM
      REAL(DP), INTENT(IN) :: WTT
      REAL(DP), INTENT(OUT) :: ZWW, ZW, ZVOLNT, ZVOLWT
! ONLY SCLTAL(1,..) IS USED SO FAR.
! THIS RULES OUT RESCALING BASED ON ADDITIONAL TALLIES NTALA (=57),
!                                                      NTALC (=58),
!                                                      NTALT (=59),
!                                                      NTALM (=60),
!                                                      NTALB (=61),
!                                                      NTALR (=62)

! BECAUSE IN THESE CASES SCLTAL MAY BE DEPENDENT ON FIRST (SPECIES) INDEX
!
      REAL(DP), INTENT(IN) :: SCLTAL(N1DIM,*)
      REAL(DP), INTENT(OUT) :: ZVOLIN(*), ZVOLIW(*)

      INTEGER :: IS, IT, IC, I1, I2, I3, IA, IB, NBLCKA, IADD
      REAL(DP) :: VALUE, VAL, FLX
      EXTERNAL :: EIRENE_LEER, EIRENE_MASR1

C  FACTOR FOR FLUXES (AMP) (INPUT FLUX "FLUXT" IS IN AMP)
      FLXFAC(ISTR)=0.

      IF (SCALV(ISTR).NE.0.D0) THEN
C  NON-DEFAULT SCALING OPTION
        IS=ISCLS(ISTR)
        IT=ISCLT(ISTR)
        IC=ISCL1(ISTR)
        IF (IVLSF(ISTR).EQ.1) THEN
C  SCALE TO ENFORCE CERTAIN VALUE OF VOLUME TALLY
          IF (ISCL2(ISTR).GT.0.AND.ISCL3(ISTR).GT.0) THEN
            I1=ISCL1(ISTR)
            I2=ISCL2(ISTR)
            I3=ISCL3(ISTR)
            IB=ISCLB(ISTR)
            IA=ISCLA(ISTR)
            NBLCKA=NSTRD*(IB-1)+IA
            IC=I1+((I2-1)+(I3-1)*NP2T3)*NR1P2+NBLCKA
          ENDIF

cdr  Currently tallies .ge. ntala=57 cannot be used for rescaling.
cdr  This is too restrictive.  Tallies 63 -- 100 should be fine.
cdr  Only tallies between 57 and 62 (algebr. tallies) should be excluded.
cdr  Even those may be possible choices, when SCLTAL is used with proper
cdr  1st index below, rather than only SCLTAL(1,..).

          IF (IT.LE.0.OR.IT.GE.NTALA) GOTO 207
c
          IF (IS.LT.0.OR.IS.GT.NFSTVI(IT)) GOTO 207
          IF (IC.LT.0.OR.IC.GT.NSBOX_TAL) GOTO 207
          IADD=NADDV(IT)
          IF (SCLTAL(1,IT).EQ.1) THEN
            VALUE=ESTIMV(IADD+IS,IC)/VOLTAL(IC)/ELCHA
          ELSEIF (SCLTAL(1,IT).EQ.2) THEN
            VALUE=ESTIMV(IADD+IS,IC)/ELCHA
          ELSEIF (SCLTAL(1,IT).EQ.3) THEN
            VALUE=ESTIMV(IADD+IS,IC)/VOLTAL(IC)
          ELSEIF (SCLTAL(1,IT).EQ.4) THEN
            VALUE=ESTIMV(IADD+IS,IC)
          ENDIF
          IF (ABS(VALUE).LE.EPS60) GOTO 207
          VAL=SCALV(ISTR)
          FLXFAC(ISTR)=VAL/VALUE
          FLX=FLXFAC(ISTR)*WTT
          FLUXT(ISTR)=FLX
        ELSEIF (IVLSF(ISTR).EQ.2) THEN
C  SCALE TO ENFORCE CERTAIN VALUE OF SURFACE TALLY
cdr: to be written
          GOTO 207
        ELSE
          GOTO 207
        ENDIF
        GOTO 205

c  error, inconsistent input
  207   WRITE (iunout,*)
     .    'INCONSISTENT INPUT FOR SCALING OF STRATUM ISTR '
        WRITE (iunout,*) 'ISTR ',ISTR,IS,IT,IC
        WRITE (iunout,*) 'USE DEFAULT SCALING (FLUX(ISTR)) '
        FLUXT(ISTR)=FLUX(ISTR)
        IF (WTT.NE.0.D0) FLXFAC(ISTR)=FLUXT(ISTR)/WTT
  205   CONTINUE
      ELSE

C  DEFAULT SCALING OPTION: USE FLUX(ISTR)
        FLUXT(ISTR)=FLUX(ISTR)
        IF (WTT.NE.0.D0) FLXFAC(ISTR)=FLUXT(ISTR)/WTT
      ENDIF
C
C  TOTAL TEST PARTICLE FLUX (AMP)
      WRITE (iunout,*) 'TOTAL SOURCE STRENGTH FOR TEST PARTICLE SPECIES'
      CALL EIRENE_MASR1 ('FLUXT=  ',FLUXT(ISTR))
      CALL EIRENE_LEER(2)
C
C  ZONE-INDEPENDENT SCALING FACTORS
      ZWW=FLXFAC(ISTR)
      ZW=FLXFAC(ISTR)/ELCHA
C  ZONE-DEPENDENT SCALING FACTORS
      DO 206 IC=1,NSBOX_TAL
        ZVOLIN(IC)=0.
        ZVOLIW(IC)=0.
        IF (VOLTAL(IC).NE.0.D0) THEN
          ZVOLIN(IC)=ZW /VOLTAL(IC)
          ZVOLIW(IC)=ZWW/VOLTAL(IC)
        ENDIF
  206 CONTINUE
      ZVOLNT=ZW /VOLTOT
      ZVOLWT=ZWW/VOLTOT

      RETURN
      END SUBROUTINE EIRENE_SET_SCAL_CONST
