cdr  dec. 15:  added species index ipls for energy source arrays for bulk ions
cdr            eapls, empls, eipls, eppls

cdr            not concluded yet: e.g. eplpls,  photon tallies
cdr            nomenclature: eppl_cops --> eppls  ???

      MODULE EIRMOD_BRASPOI
cdr  purpose ....?

      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD

      IMPLICIT NONE

      PRIVATE
      PUBLIC :: EIRENE_ALLOC_BRASPOI, EIRENE_DEALLOC_BRASPOI,
     .          EIRENE_NEW_SIMARR, EIRENE_NEW_MULARR,
     .          EIRENE_FREE_SIMARR, EIRENE_FREE_MULARR
      PUBLIC :: CELLSIM, CELLMUL, SIMARR, MULARR,
     .          EAELS, EMELS, EIELS, EPELS,
     .          EAPLS, EMPLS, EIPLS,
     .          PAPLS, PMPLS, PIPLS,
     .          PDENAS, PDENMS, PDENIS,
     .          EDENAS, COPVS,
     .          MAPLS, MMPLS, MIPLS, MPHPLS,
     .          PPPL_COPS, CPPVS, EPPL_COPS

      TYPE :: CELLSIM
        REAL(DP) :: VALUES
        INTEGER :: ICS
        TYPE(CELLSIM), POINTER :: NXTSIM
      END TYPE CELLSIM

      TYPE :: CELLMUL
        REAL(DP) :: VALUEM
        INTEGER :: IART,ICM
        TYPE(CELLMUL), POINTER :: NXTMUL
      END TYPE CELLMUL

      TYPE :: SIMARR
        TYPE(CELLSIM),POINTER :: PSIM
      END TYPE SIMARR

      TYPE :: MULARR
        TYPE(CELLMUL),POINTER :: PMUL
      END TYPE MULARR

      TYPE(SIMARR), ALLOCATABLE, SAVE :: EAELS(:), EMELS(:), EIELS(:),
     .                                   EPELS(:)
      TYPE(MULARR), ALLOCATABLE, SAVE :: PAPLS(:), PMPLS(:), PIPLS(:),
     .                                   EAPLS(:), EMPLS(:), EIPLS(:),
     .                                   EPPL_COPS(:),
     .                                   PDENAS(:),PDENMS(:),PDENIS(:),
     .                                   EDENAS(:),COPVS(:),
     .                                   PPPL_COPS(:), CPPVS(:),
     .                                   MAPLS(:), MMPLS(:), MIPLS(:),
     .                                   MPHPLS(:)

      TYPE(CELLSIM),POINTER, SAVE :: COLLECT_SIMARR
      TYPE(CELLMUL),POINTER, SAVE :: COLLECT_MULARR

      CONTAINS


      SUBROUTINE EIRENE_ALLOC_BRASPOI

      INTEGER :: ISTRAI

      IF (ALLOCATED(EAELS)) RETURN

      ALLOCATE (EAELS(NSTRA))
      ALLOCATE (EMELS(NSTRA))
      ALLOCATE (EIELS(NSTRA))
      ALLOCATE (EAPLS(NSTRA))
      ALLOCATE (EMPLS(NSTRA))
      ALLOCATE (EIPLS(NSTRA))
      ALLOCATE (EPPL_COPS(NSTRA))
      ALLOCATE (EPELS(NSTRA))
      ALLOCATE (PAPLS(NSTRA))
      ALLOCATE (PMPLS(NSTRA))
      ALLOCATE (PIPLS(NSTRA))
      ALLOCATE (PDENAS(NSTRA))
      ALLOCATE (PDENMS(NSTRA))
      ALLOCATE (PDENIS(NSTRA))
      ALLOCATE (EDENAS(NSTRA))
      ALLOCATE (COPVS(NSTRA))
      ALLOCATE (PPPL_COPS(NSTRA))
      ALLOCATE (CPPVS(NSTRA))
      ALLOCATE (MAPLS(NSTRA))
      ALLOCATE (MMPLS(NSTRA))
      ALLOCATE (MIPLS(NSTRA))
      ALLOCATE (MPHPLS(NSTRA))


      DO ISTRAI=1,NSTRA

      NULLIFY(PAPLS(ISTRAI)%PMUL)
      NULLIFY(PMPLS(ISTRAI)%PMUL)
      NULLIFY(PIPLS(ISTRAI)%PMUL)

      NULLIFY(EAPLS(ISTRAI)%PMUL)
      NULLIFY(EMPLS(ISTRAI)%PMUL)
      NULLIFY(EIPLS(ISTRAI)%PMUL)

      NULLIFY(EAELS(ISTRAI)%PSIM)
      NULLIFY(EMELS(ISTRAI)%PSIM)
      NULLIFY(EIELS(ISTRAI)%PSIM)
      NULLIFY(EPELS(ISTRAI)%PSIM)

      NULLIFY(PDENAS(ISTRAI)%PMUL)
      NULLIFY(PDENMS(ISTRAI)%PMUL)
      NULLIFY(PDENIS(ISTRAI)%PMUL)
      NULLIFY(EDENAS(ISTRAI)%PMUL)

      NULLIFY(COPVS(ISTRAI)%PMUL)
      NULLIFY(PPPL_COPS(ISTRAI)%PMUL)
      NULLIFY(EPPL_COPS(ISTRAI)%PMUL)
      NULLIFY(CPPVS(ISTRAI)%PMUL)

      NULLIFY(MAPLS(ISTRAI)%PMUL)
      NULLIFY(MMPLS(ISTRAI)%PMUL)
      NULLIFY(MIPLS(ISTRAI)%PMUL)
      NULLIFY(MPHPLS(ISTRAI)%PMUL)

      END DO

      NULLIFY(COLLECT_SIMARR)
      NULLIFY(COLLECT_MULARR)

      WRITE (IUNMEM,'(A,T25,I15)')
     .      ' BRASPOI ',18*NSTRA*8

      RETURN
      END SUBROUTINE EIRENE_ALLOC_BRASPOI


      SUBROUTINE EIRENE_DEALLOC_BRASPOI

      IF (.NOT.ALLOCATED(EAELS)) RETURN

      DEALLOCATE (EAELS)
      DEALLOCATE (EMELS)
      DEALLOCATE (EIELS)
      DEALLOCATE (EAPLS)
      DEALLOCATE (EMPLS)
      DEALLOCATE (EIPLS)
      DEALLOCATE (EPPL_COPS)
      DEALLOCATE (EPELS)
      DEALLOCATE (PAPLS)
      DEALLOCATE (PMPLS)
      DEALLOCATE (PIPLS)
      DEALLOCATE (PDENAS)
      DEALLOCATE (PDENMS)
      DEALLOCATE (PDENIS)
      DEALLOCATE (EDENAS)
      DEALLOCATE (COPVS)
      DEALLOCATE (PPPL_COPS)
      DEALLOCATE (CPPVS)
      DEALLOCATE (MAPLS)
      DEALLOCATE (MMPLS)
      DEALLOCATE (MIPLS)
      DEALLOCATE (MPHPLS)

      RETURN
      END SUBROUTINE EIRENE_DEALLOC_BRASPOI


      FUNCTION EIRENE_NEW_SIMARR() RESULT(NODE)

      TYPE(CELLSIM), POINTER :: NODE

      IF (ASSOCIATED(COLLECT_SIMARR)) THEN
        NODE => COLLECT_SIMARR
        COLLECT_SIMARR => COLLECT_SIMARR%NXTSIM
      ELSE
        ALLOCATE (NODE)
        NULLIFY (NODE%NXTSIM)
      END IF

      RETURN
      END FUNCTION EIRENE_NEW_SIMARR


      FUNCTION EIRENE_NEW_MULARR() RESULT(NODE)

      TYPE(CELLMUL), POINTER :: NODE

      IF (ASSOCIATED(COLLECT_MULARR)) THEN
        NODE => COLLECT_MULARR
        COLLECT_MULARR => COLLECT_MULARR%NXTMUL
      ELSE
        ALLOCATE (NODE)
        NULLIFY (NODE%NXTMUL)
      END IF

      RETURN
      END FUNCTION EIRENE_NEW_MULARR


      SUBROUTINE EIRENE_FREE_SIMARR(ISTRAI)

      INTEGER, INTENT(IN) :: ISTRAI
      TYPE(CELLSIM), POINTER :: P

C  FREE EAELS
      P => EAELS(ISTRAI)%PSIM
      IF (ASSOCIATED(P)) THEN
        DO WHILE (ASSOCIATED(P%NXTSIM))
          P => P%NXTSIM
        END DO
        P%NXTSIM => COLLECT_SIMARR
        COLLECT_SIMARR => EAELS(ISTRAI)%PSIM
        NULLIFY(EAELS(ISTRAI)%PSIM)
      END IF

C  FREE EMELS
      P => EMELS(ISTRAI)%PSIM
      IF (ASSOCIATED(P)) THEN
        DO WHILE (ASSOCIATED(P%NXTSIM))
          P => P%NXTSIM
        END DO
        P%NXTSIM => COLLECT_SIMARR
        COLLECT_SIMARR => EMELS(ISTRAI)%PSIM
        NULLIFY(EMELS(ISTRAI)%PSIM)
      END IF

C  FREE EIELS
      P => EIELS(ISTRAI)%PSIM
      IF (ASSOCIATED(P)) THEN
        DO WHILE (ASSOCIATED(P%NXTSIM))
          P => P%NXTSIM
        END DO
        P%NXTSIM => COLLECT_SIMARR
        COLLECT_SIMARR => EIELS(ISTRAI)%PSIM
        NULLIFY(EIELS(ISTRAI)%PSIM)
      END IF

C  FREE EPELS
      P => EPELS(ISTRAI)%PSIM
      IF (ASSOCIATED(P)) THEN
        DO WHILE (ASSOCIATED(P%NXTSIM))
          P => P%NXTSIM
        END DO
        P%NXTSIM => COLLECT_SIMARR
        COLLECT_SIMARR => EPELS(ISTRAI)%PSIM
        NULLIFY(EPELS(ISTRAI)%PSIM)
      END IF

      RETURN
      END SUBROUTINE EIRENE_FREE_SIMARR



      SUBROUTINE EIRENE_FREE_MULARR(ISTRAI)

      INTEGER, INTENT(IN) :: ISTRAI
      TYPE(CELLMUL), POINTER :: P

C  FREE PAELS
      P => PAPLS(ISTRAI)%PMUL
      IF (ASSOCIATED(P)) THEN
        DO WHILE (ASSOCIATED(P%NXTMUL))
          P => P%NXTMUL
        END DO
        P%NXTMUL => COLLECT_MULARR
        COLLECT_MULARR => PAPLS(ISTRAI)%PMUL
        NULLIFY(PAPLS(ISTRAI)%PMUL)
      END IF

C  FREE PMPLS
      P => PMPLS(ISTRAI)%PMUL
      IF (ASSOCIATED(P)) THEN
        DO WHILE (ASSOCIATED(P%NXTMUL))
          P => P%NXTMUL
        END DO
        P%NXTMUL => COLLECT_MULARR
        COLLECT_MULARR => PMPLS(ISTRAI)%PMUL
        NULLIFY(PMPLS(ISTRAI)%PMUL)
      END IF

C  FREE PIPLS
      P => PIPLS(ISTRAI)%PMUL
      IF (ASSOCIATED(P)) THEN
        DO WHILE (ASSOCIATED(P%NXTMUL))
          P => P%NXTMUL
        END DO
        P%NXTMUL => COLLECT_MULARR
        COLLECT_MULARR => PIPLS(ISTRAI)%PMUL
        NULLIFY(PIPLS(ISTRAI)%PMUL)
      END IF

C  FREE EAPLS
      P => EAPLS(ISTRAI)%PMUL
      IF (ASSOCIATED(P)) THEN
        DO WHILE (ASSOCIATED(P%NXTMUL))
          P => P%NXTMUL
        END DO
        P%NXTMUL => COLLECT_MULARR
        COLLECT_MULARR => EAPLS(ISTRAI)%PMUL
        NULLIFY(EAPLS(ISTRAI)%PMUL)
      END IF

C  FREE EMPLS
      P => EMPLS(ISTRAI)%PMUL
      IF (ASSOCIATED(P)) THEN
        DO WHILE (ASSOCIATED(P%NXTMUL))
          P => P%NXTMUL
        END DO
        P%NXTMUL => COLLECT_MULARR
        COLLECT_MULARR => EMPLS(ISTRAI)%PMUL
        NULLIFY(EMPLS(ISTRAI)%PMUL)
      END IF

C  FREE EIPLS
      P => EIPLS(ISTRAI)%PMUL
      IF (ASSOCIATED(P)) THEN
        DO WHILE (ASSOCIATED(P%NXTMUL))
          P => P%NXTMUL
        END DO
        P%NXTMUL => COLLECT_MULARR
        COLLECT_MULARR => EIPLS(ISTRAI)%PMUL
        NULLIFY(EIPLS(ISTRAI)%PMUL)
      END IF

C  FREE EPPL_COPS
      P => EPPL_COPS(ISTRAI)%PMUL
      IF (ASSOCIATED(P)) THEN
        DO WHILE (ASSOCIATED(P%NXTMUL))
          P => P%NXTMUL
        END DO
        P%NXTMUL => COLLECT_MULARR
        COLLECT_MULARR => EPPL_COPS(ISTRAI)%PMUL
        NULLIFY(EPPL_COPS(ISTRAI)%PMUL)
      END IF

C  FREE PDENAS
      P => PDENAS(ISTRAI)%PMUL
      IF (ASSOCIATED(P)) THEN
        DO WHILE (ASSOCIATED(P%NXTMUL))
          P => P%NXTMUL
        END DO
        P%NXTMUL => COLLECT_MULARR
        COLLECT_MULARR => PDENAS(ISTRAI)%PMUL
        NULLIFY(PDENAS(ISTRAI)%PMUL)
      END IF

C  FREE PDENMS
      P => PDENMS(ISTRAI)%PMUL
      IF (ASSOCIATED(P)) THEN
        DO WHILE (ASSOCIATED(P%NXTMUL))
          P => P%NXTMUL
        END DO
        P%NXTMUL => COLLECT_MULARR
        COLLECT_MULARR => PDENMS(ISTRAI)%PMUL
        NULLIFY(PDENMS(ISTRAI)%PMUL)
      END IF

C  FREE PDENIS
      P => PDENIS(ISTRAI)%PMUL
      IF (ASSOCIATED(P)) THEN
        DO WHILE (ASSOCIATED(P%NXTMUL))
          P => P%NXTMUL
        END DO
        P%NXTMUL => COLLECT_MULARR
        COLLECT_MULARR => PDENIS(ISTRAI)%PMUL
        NULLIFY(PDENIS(ISTRAI)%PMUL)
      END IF

C  FREE EDENAS
      P => EDENAS(ISTRAI)%PMUL
      IF (ASSOCIATED(P)) THEN
        DO WHILE (ASSOCIATED(P%NXTMUL))
          P => P%NXTMUL
        END DO
        P%NXTMUL => COLLECT_MULARR
        COLLECT_MULARR => EDENAS(ISTRAI)%PMUL
        NULLIFY(EDENAS(ISTRAI)%PMUL)
      END IF

C  FREE COPVS
      P => COPVS(ISTRAI)%PMUL
      IF (ASSOCIATED(P)) THEN
        DO WHILE (ASSOCIATED(P%NXTMUL))
          P => P%NXTMUL
        END DO
        P%NXTMUL => COLLECT_MULARR
        COLLECT_MULARR => COPVS(ISTRAI)%PMUL
        NULLIFY(COPVS(ISTRAI)%PMUL)
      END IF

C  FREE PPPL_COPS
      P => PPPL_COPS(ISTRAI)%PMUL
      IF (ASSOCIATED(P)) THEN
        DO WHILE (ASSOCIATED(P%NXTMUL))
          P => P%NXTMUL
        END DO
        P%NXTMUL => COLLECT_MULARR
        COLLECT_MULARR => PPPL_COPS(ISTRAI)%PMUL
        NULLIFY(PPPL_COPS(ISTRAI)%PMUL)
      END IF

C  FREE CPPVS
      P => CPPVS(ISTRAI)%PMUL
      IF (ASSOCIATED(P)) THEN
        DO WHILE (ASSOCIATED(P%NXTMUL))
          P => P%NXTMUL
        END DO
        P%NXTMUL => COLLECT_MULARR
        COLLECT_MULARR => CPPVS(ISTRAI)%PMUL
        NULLIFY(CPPVS(ISTRAI)%PMUL)
      END IF

C  FREE MAPLS
      P => MAPLS(ISTRAI)%PMUL
      IF (ASSOCIATED(P)) THEN
        DO WHILE (ASSOCIATED(P%NXTMUL))
          P => P%NXTMUL
        END DO
        P%NXTMUL => COLLECT_MULARR
        COLLECT_MULARR => MAPLS(ISTRAI)%PMUL
        NULLIFY(MAPLS(ISTRAI)%PMUL)
      END IF

C  FREE MAPLS
      P => MMPLS(ISTRAI)%PMUL
      IF (ASSOCIATED(P)) THEN
        DO WHILE (ASSOCIATED(P%NXTMUL))
          P => P%NXTMUL
        END DO
        P%NXTMUL => COLLECT_MULARR
        COLLECT_MULARR => MMPLS(ISTRAI)%PMUL
        NULLIFY(MMPLS(ISTRAI)%PMUL)
      END IF

C  FREE MIPLS
      P => MIPLS(ISTRAI)%PMUL
      IF (ASSOCIATED(P)) THEN
        DO WHILE (ASSOCIATED(P%NXTMUL))
          P => P%NXTMUL
        END DO
        P%NXTMUL => COLLECT_MULARR
        COLLECT_MULARR => MIPLS(ISTRAI)%PMUL
        NULLIFY(MIPLS(ISTRAI)%PMUL)
      END IF

C  FREE MPHPLS
      P => MPHPLS(ISTRAI)%PMUL
      IF (ASSOCIATED(P)) THEN
        DO WHILE (ASSOCIATED(P%NXTMUL))
          P => P%NXTMUL
        END DO
        P%NXTMUL => COLLECT_MULARR
        COLLECT_MULARR => MPHPLS(ISTRAI)%PMUL
        NULLIFY(MPHPLS(ISTRAI)%PMUL)
      END IF

      RETURN
      END SUBROUTINE EIRENE_FREE_MULARR

      END MODULE EIRMOD_BRASPOI
