C
C
      SUBROUTINE EIRENE_ZSHADD (ZSH,ILINI,ILEND)
C
C  SHIFT COORDINATE SYSTEM FOR ADDITIONAL SURFACES IN Z DIRECTION
C  OLD ORIGIN: ZO=O.    (X,Y,Z)  SYSTEM
C  NEW ORIGIN: ZN=-ZSH   (X,Y,Z') SYSTEM
C
C    Z'=Z+ZSH
C
      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD
      USE EIRMOD_CADGEO

      IMPLICIT NONE
C
      REAL(DP), INTENT(IN) :: ZSH
      INTEGER, INTENT(IN) :: ILINI, ILEND
      REAL(DP) :: ZQ
      INTEGER :: I, J

      ZQ=ZSH*ZSH
C
      DO 100 I=ILINI,ILEND
C
C
C   CHANGE COEFFICIENTS FOR ALGEBRAIC EQUATION
          A0LM(I)=A0LM(I)-A3LM(I)*ZSH+A6LM(I)*ZQ
          A3LM(I)=A3LM(I)-2.*A6LM(I)*ZSH
          A1LM(I)=A1LM(I)-A8LM(I)*ZSH
          A2LM(I)=A2LM(I)-A9LM(I)*ZSH
          IF (RLB(I).LT.0.) THEN
C   CHANGE COEFFICIENTS IN LINEAR INEQUALITIES BOUNDING THE SURFACE
            DO 10 J=1,ILIN(I)
              ALIMS(J,I)=ALIMS(J,I)-ZLIMS(J,I)*ZSH
   10       CONTINUE
C   CHANGE COEFFICIENTS IN NONLINEAR INEQUALITIES BOUNDING THE SURFACE
            DO 20 J=1,ISCN(I)
              ALIMS0(J,I)=ALIMS0(J,I)-ZLIMS1(J,I)*ZSH+ZLIMS2(J,I)*ZQ
              ZLIMS1(J,I)=ZLIMS1(J,I)-2.*ZLIMS2(J,I)*ZSH
              XLIMS1(J,I)=XLIMS1(J,I)-YLIMS3(J,I)*ZSH
              YLIMS1(J,I)=YLIMS1(J,I)-ZLIMS3(J,I)*ZSH
   20       CONTINUE
          ELSEIF (RLB(I).GT.0.AND.RLB(I).LT.2) THEN
C  BOUNDED BY QUADER
            ZLIMS1(1,I)=ZLIMS1(1,I)+ZSH
            ZLIMS2(1,I)=ZLIMS2(1,I)+ZSH
C
          ELSE
C
C   POINT OPTIONS
            P1(3,I)=P1(3,I)+ZSH
            P2(3,I)=P2(3,I)+ZSH
            IF (RLB(I).GE.3.) P3(3,I)=P3(3,I)+ZSH
            IF (RLB(I).GE.4.) P4(3,I)=P4(3,I)+ZSH
            IF (RLB(I).GE.5.) P5(3,I)=P5(3,I)+ZSH
            IF (RLB(I).GE.6.) P6(3,I)=P6(3,I)+ZSH
          ENDIF
C
  100 CONTINUE
C
      RETURN
      END SUBROUTINE EIRENE_ZSHADD
