C
C
      SUBROUTINE EIRENE_XSHADD (XSH,ILINI,ILEND)
C
C  SHIFT COORDINATE SYSTEM FOR ADDITIONAL SURFACES IN X DIRECTION
C  OLD ORIGIN: X0=0.    (X,Y,Z)  SYSTEM
C  NEW ORIGIN: XN=-XSH   (X',Y,Z) SYSTEM
C
C     X'=X+XSH
C
      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD
      USE EIRMOD_CADGEO

      IMPLICIT NONE

      REAL(DP), INTENT(IN) :: XSH
      INTEGER, INTENT(IN) :: ILINI, ILEND
      REAL(DP) :: XQ
      INTEGER :: I, J
C
      XQ=XSH*XSH
C
      DO 100 I=ILINI,ILEND
C
C
C   CHANGE COEFFICIENTS FOR ALGEBRAIC EQUATION
          A0LM(I)=A0LM(I)-A1LM(I)*XSH+A4LM(I)*XQ
          A1LM(I)=A1LM(I)-2.*A4LM(I)*XSH
          A2LM(I)=A2LM(I)-A7LM(I)*XSH
          A3LM(I)=A3LM(I)-A8LM(I)*XSH
          IF (RLB(I).LT.0.) THEN
C   CHANGE COEFFICIENTS IN LINEAR INEQUALITIES BOUNDING THE SURFACE
            DO 10 J=1,ILIN(I)
              ALIMS(J,I)=ALIMS(J,I)-XLIMS(J,I)*XSH
   10       CONTINUE
C   CHANGE COEFFICIENTS IN NONLINEAR INEQUALITIES BOUNDING THE SURFACE
            DO 20 J=1,ISCN(I)
              ALIMS0(J,I)=ALIMS0(J,I)-XLIMS1(J,I)*XSH+XLIMS2(J,I)*XQ
              XLIMS1(J,I)=XLIMS1(J,I)-2.*XLIMS2(J,I)*XSH
              YLIMS1(J,I)=YLIMS1(J,I)-XLIMS3(J,I)*XSH
              ZLIMS1(J,I)=ZLIMS1(J,I)-YLIMS3(J,I)*XSH
   20       CONTINUE
          ELSEIF (RLB(I).GT.0.AND.RLB(I).LT.2) THEN
C  BOUNDED BY QUADER
            XLIMS1(1,I)=XLIMS1(1,I)+XSH
            XLIMS2(1,I)=XLIMS2(1,I)+XSH
C
C
          ELSE
C   POINT OPTIONS
            P1(1,I)=P1(1,I)+XSH
            P2(1,I)=P2(1,I)+XSH
            IF (RLB(I).GE.3.) P3(1,I)=P3(1,I)+XSH
            IF (RLB(I).GE.4.) P4(1,I)=P4(1,I)+XSH
            IF (RLB(I).GE.5.) P5(1,I)=P5(1,I)+XSH
            IF (RLB(I).GE.6.) P6(1,I)=P6(1,I)+XSH
          ENDIF
C
  100 CONTINUE
C
      RETURN
      END SUBROUTINE EIRENE_XSHADD
