cdr
!     oct 17: NLTRA correction, from june 09: apparently not properly functional, e.g. for chord (diagno) points
cdr  sept 17: sync with timep
!  18.06.09  correction added for NLTRA
!            if particle accidently on toroidal surface
C
      SUBROUTINE EIRENE_TIMET (ZRAD)
C
C   CALCULATE TIME SEGMENTS FOR 2D-OR 3D PROFILES,
C     X-RADIALLY AND Z-TOROIDALLY RESOLVED
C
C   BLOCK 1 : NLTRZ  slab in z-coordinate
C   BLOCK 2B: NLTRA  polygonal in x-z
C   BLOCK 2A: NLTRT  circular in x-z. To be written
C
C   INPUT:
C
C     X01,Z01,PHI: STARTING POINT FOR THIS TRACK
C     ZRAD  = DISTANCE (CM) TO THE NEXT RADIAL SURFACE OF 1D STANDARD MESH
C             OR TO NEXT ADDITIONAL SURFACE, TRAVELED IN RADIAL CELL NRCELL
C     NRCELL = RADIAL CELL NUMBER, IN WHICH THIS TRACK OF LENGTH ZRAD
C                                  IS PERFORMED
C              = 0, IF TRACK OUTSIDE RADIAL MESH
C                   IF MRSURF .NE. 0 THEN
C                   REENTRY FOUND AT RADIAL SURFACE MRSURF.
C                   OTHERWISE: REENTRY AT NON-DEFAULT
C                   POLOIDAL SURFACES IS SEARCHED FOR IN THIS CALL
C     NPCELL =
C     IPCELL =
C     NTCELL = TOROIDAL CELL INDEX OF POINT X01,Z01,PHI
C              AT WHICH THIS TRACK OF LENGTH ZRAD STARTS

C  WARNING: IF NLSRFZ, NTCELL MAY BE WRONG
C     ITCELL =
C
C       NCOUT,BLPD,NCOUNT
C
C   OUTPUT:
C
C  IF NLTRZ AND NLTOR
C     NINCZ    : DIRECTION IN Z-GRID
C     Z01      :
C     NTCELL   :
C     MTSURF   :
C  ELSEIF NLTRA
C    EITHER
C     ISRFCL<3 : NO ROTATION , NNTCLL=0 , NO PARAMETERS CHANGED
C    OR
C     ISRFCL=3 : ROTATION CLOCKWISE,
C                STOP AND RESTART LATER AT MTSURF = NNTCLL
C     ISRFCL=3 : ROTATION COUNTER-CLOCKWISE
C                STOP AND RESTART LATER AT MTSURF = NNTCLL+1
C
C     PHI      :
C     X01      :
C     Z01      :
C     ZRAD     : REDUCED TO DISTANCE TO NEXT TOROIDAL SURFACE
C     NNTCLL   : NEXT POSSIBLE CELL NUMBER IN TOROIDAL MESH
C                IF PARTICLE TRAVELS REDUCED DISTANCE ZRAD
C     MTSURF   : NEXT TOROIDAL SURFACE, IF ANY
C     NINCZ    : DIRECTION IN Z-GRID
C     NINCX    : RESET TO ZERO
C     MRSURF   : RESET TO ZERO
C  ELSEIF NLTRT
C    TO BE WRITTEN
C
C  FOR THE TIME BEING: IF NLPOL, REDUCE PATH TO ONE TOROIDAL CELL
C
C
      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD
      USE EIRMOD_CCONA
      USE EIRMOD_CLOGAU
      USE EIRMOD_CUPD
      USE EIRMOD_CGRID
      USE EIRMOD_COMPRT
      USE EIRMOD_COMSOU
      USE EIRMOD_CLGIN

      IMPLICIT NONE

      REAL(DP), INTENT(INOUT) :: ZRAD
      REAL(DP) :: TTT, PHI0, X001, TO, AA, SUM, TU, XTO, EPSTST, XTU,
     .          F, ZRADS, BB, ZRD, DUM, Z001, X0TEST, Z0TEST, DZ,
     .          Y0TEST, z01_cell
      INTEGER :: ITT, ITEST, J2, NERR, IN, J, ICOU, MTTEST,
     .           NZSAVE, INCZ, J1, IRSAVE, IRET
      INTEGER, SAVE :: MTSAVE=-1
#ifdef TRACE
      EXTERNAL :: EIRENE_LEER, EIRENE_MASR3
#endif

      ZRADS=ZRAD
C
#ifdef TRACE
      IF (NLTRC) THEN
        CALL EIRENE_LEER(1)
        IF (NRCELL.GT.0) THEN
          WRITE (iunout,*) 'TIMET FROM INSIDE, NPANU ', NPANU
          WRITE (iunout,*) 'ZRAD,NRCELL,NTCELL,MTSURF '
          WRITE (iunout,*)  ZRAD,NRCELL,NTCELL,MTSURF
          CALL EIRENE_MASR3('INITIAL: X01,Z01,PHI    ',
     .                                X01,Z01,PHI/DEGRAD)
        ELSE
          WRITE (iunout,*) 'TIMET FROM OUTSIDE, NPANU ', NPANU
          WRITE (iunout,*) 'MRSURF,MTSURF,ZRAD '
          WRITE (iunout,*)  MRSURF,MTSURF,ZRAD
        ENDIF
      ENDIF
#endif
C
C
C  BLOCK 1 STARTS HERE....
C
      IF (NLTRZ) THEN

        CALL EIRENE_TIMET_CYLINDER_GEOMETRY(ZRAD, IRET)
        IF (IRET == 1) GOTO 9990

C
C  BLOCK 1 (NLTRZ)  done ::::::::::::::::::::::::::::::::::::::
C

C
C ::::::::::::::::::::::::::::::::::::::::::::::::::::::
C
      ELSEIF (NLTRA) THEN
C
C  BLOCK 2B: DISCRETE TOROIDAL APPROXIMATION,
C            also: default toroidal periodicity model.
C            ONLY ONE STEP AT A TIME
C
        CALL EIRENE_TIMET_TOR_APPROX(ZRAD, IRET)
        IF (IRET == 2) GOTO 9998
        IF (IRET == 3) RETURN

C  BLOCK 2B DONE.... NLTRA
C                 polygonal in x-z, (rather than x-y, as in timep.f).
C::::::::::::::::::::::::::::::::::::::::::::::::::::::::
      END IF

C
C  BLOCK 2A STARTS HERE....  NLTRT,
c                  circular in x-z, ( rather than x-y, as in timep.f).
C                  TO BE WRITTEN


C  FROM HERE ON: CODE COMMON TO ALL OPTIONS.
C   ::::::::::::::::::::::::::::::::::::::::::::::::::::::::
C
#ifdef TRACE
      IF (NLTRC) WRITE (iunout,*) 'NCOUT= ',NCOUT
#endif
      DO 5100 J=1,NCOUT
        CLPD(J)=BLPD(J)
        NUPC(J)=(KUPC(J)-1)*NP2T3
        NCOUNT(J)=KUPC(J)
        IF (CLPD(J).LE.0..OR.KUPC(J).LE.0.OR.
     .      (KUPC(J).GE.NT3RD.AND.NLTOR)) THEN
          WRITE (iunout,*) 'ERROR DETECTED IN TIMET '
          WRITE (iunout,*) 'NPANU,J,BLPD,KUPC ',
     .                      NPANU,J,BLPD(J),KUPC(J)
        ENDIF
#ifdef TRACE
        IF (NLTRC) THEN
          WRITE (iunout,'(1X,A,1X,I6,1PE12.4,3X,2I6)')
     .     'TIMET: J,BLPD(J),NUPC(J),NCOUNT(J) ',
     .             J,BLPD(J),NUPC(J),NCOUNT(J)
        ENDIF
#endif
 5100 CONTINUE
#ifdef TRACE
      IF (NLTRC) THEN
        WRITE (iunout,*) 'MTSURF,NLSRFZ,NINCZ,IRCELL,IPCELL '
        WRITE (iunout,*)  MTSURF,NLSRFZ,NINCZ,IRCELL,IPCELL
        IF (NLTOR)
     .    WRITE (iunout,*) 'INMP3I ',INMP3I(IRCELL,IPCELL,MTSURF)
      ENDIF
#endif
C
      NCOU=NCOUT
C
      SUM=0.
      DO 5110 ICOU=1,NCOU
        SUM=SUM+CLPD(ICOU)

C       WRITE (iunout,*) 'ICOU,NCOUNT,CLPD ',
C    .                    ICOU,NCOUNT(ICOU),CLPD(ICOU)
 5110 CONTINUE
      IF (MTSURF.EQ.0.AND.ABS(SUM-ZRADS).GT.EPS10) THEN
        WRITE (iunout,*) 'ERROR IN TIMET: NPANU,SUM,ZRADS ',
     .                               NPANU,SUM,ZRADS
        WRITE (iunout,*) 'TRY TO KILL PARTICLE ASAP '
        SUM=-1.0D0
      ENDIF
C
      ZRAD=SUM
      RETURN
C
 9990 CONTINUE
      WRITE (iunout,*) 'ERROR IN TIMET, Z SURFACE INDEX OUT OF RANGE  '
      WRITE (iunout,*) 'NPANU,Z0,Z01,ZRAD,VELZ,NTCELL '
      WRITE (iunout,*)  NPANU,Z0,Z01,ZRAD,VELZ,NTCELL
      WEIGHT=0.
      ZRAD=-1.
      RETURN
 9998 CONTINUE
      WRITE (iunout,*) 'ERROR DETECTED IN TIMET. RETURN ZRAD=1.D30'
      WRITE (iunout,*) 'NPANU,AA,BB ',NPANU,AA,BB
      RETURN

      CONTAINS

!---------------------------------------------------------------

      SUBROUTINE EIRENE_TIMET_CYLINDER_GEOMETRY(ZRAD, IRET)

      IMPLICIT NONE
      REAL(DP), INTENT(INOUT) :: ZRAD
      INTEGER, INTENT(OUT) :: IRET
      INTEGER :: EIRENE_LEARCA
      INTEGER :: ISTS
      EXTERNAL :: EIRENE_LEARCA, EIRENE_EXIT_OWN
#ifdef TRACE
      EXTERNAL :: EIRENE_MASR3
#endif
C
C  CYLINDRICAL OR CARTESIAN COORDINATE SYSTEM.
C  Z COORDINATE IS A STRAIGHT LINE.

C  IDENTICAL, UP TO NAMES, TO POLOIDAL GRID PART, TIMEP.F,
C                          THERE THE LEVGEO=1 BLOCK
C
      IRET = 0

      IF (NRCELL.EQ.0) THEN
C
C  PARTICLE OUTSIDE STANDARD MESH
C  CHECK AT NON-DEFAULT TOROIDAL SURFACES
C
        NCOUT=0
        ZRD=ZRAD
        BB=VELZ+EPS60
        NZSAVE=1
        IF (VELZ.LT.0.D0) NZSAVE=-1
        DO 120 ISTS=1,NSTSI
          MTTEST=INUMP(ISTS,3)
          IF (MTTEST.NE.0) THEN
C  TEST TOROIDAL SURFACE NO. MTTEST FOR REENTRY
C  TIME FROM Z01 TO ZSURF
            DZ=ZSURF(MTTEST)-Z01
            F=DZ/BB
#ifdef TRACE
            IF (NLTRC) WRITE (iunout,*) 'MTTEST,F,DZ ',MTTEST,F,DZ
#endif
            IF (F.LE.ZRD.AND.F.GT.0.D0) THEN
              X0TEST=X0+VELX*F
              Y0TEST=Y0+VELY*F
C  IS THIS RE-ENTRY INSIDE THE STANDARD GRID REGION?
              select case (levgeo)
              case (1)
                  IF (X0TEST.GE.RSURF(1).AND.
     .                X0TEST.LE.RSURF(NR1ST)) THEN
                  IRSAVE=EIRENE_LEARCA(X0TEST,RSURF,1,NR1ST,1,
     .                   'TIMET 1    ')
                  NCOUT=1
                  JUPC(NCOUT)=1
                  MTSAVE=MTTEST
                  ZRD=F
                ENDIF
              case default
                WRITE (iunout,*) 'ERROR FROM TIMET: '
                WRITE (iunout,*)
     .            'RE-ENTRY THROUGH TOROIDAL SURFACE NOT '
                WRITE (iunout,*) 'READY FOR LEVGEO > 1 '
                CALL EIRENE_EXIT_OWN(1)
              end select
            ENDIF
          ENDIF
  120   CONTINUE  ! end of loop over tor. non-def std surfaces

        IF (NCOUT.GT.0.AND.MTSAVE.NE.MTSURF) THEN
C  REENTRY FOUND, REDUCE ZRAD TO F
C  NCOUT=1 AT THIS POINT
          NCOUT=1
          MTSURF=MTSAVE
          NINCZ=NZSAVE
          IRCELL=IRSAVE
          ZRAD=ZRD
          ISRFCL=0
          BLPD(NCOUT)=ZRAD
          MRSURF=0
          MPSURF=0
          MASURF=0
          NINCX=0
          NINCY=0
#ifdef TRACE
          IF (NLTRC) THEN
            WRITE (iunout,*) 'REENTRY FOUND, MTSURF,ZRAD = ',
     .                                       MTSURF,ZRAD
            WRITE (iunout,*) 'IRCELL ',IRCELL
          ENDIF
#endif
          Z01=Z01+VELZ*ZRD
          NTCELL=KUPC(NCOUT)
          ITCELL=NTCELL
          RETURN
        ELSE
C  NO REENTRY FOUND
          NCOUT=1
          KUPC(1)=1
          BLPD(1)=ZRAD
          IF (MRSURF.GT.0) THEN
C  CHECK VALID RANGE ON MRSURF
            Z0TEST=Z00+VELZ*ZRAD
#ifdef TRACE
            IF (NLTRC)
     .        WRITE (iunout,*) 'CHECK VALID RANGE: Z0TEST ',Z0TEST
#endif
              IF (Z0TEST.GE.ZSURF(1).AND.Z0TEST.LE.ZSURF(NT3RD)) THEN
                ITCELL=EIRENE_LEARCA(Z0TEST,ZSURF,1,NT3RD,1,
     .               'TIMET 2     ')
            ELSE
              MRSURF=0

              NINCX=0

            ENDIF
          ENDIF  ! MRSURF.GT.0
          MTSURF=0
          NINCZ=0

#ifdef TRACE
          IF (NLTRC) THEN
            WRITE (iunout,*) 'NO REENTRY INTO TOROIDAL GRID FOUND '
          ENDIF
#endif
          Z01=Z01+ZRD*VELZ
          RETURN
        ENDIF
C
      ENDIF  !  part "reentry from outside grid" done

C
C  NOW: PARTICLE INSIDE STANDARD MESH, RADIAL CELL NRCELL
c  still: nltrz
C
      Z001=Z01+VELZ*ZRAD
#ifdef TRACE
        IF (NLTRC) CALL EIRENE_MASR3('Z001, Z01, ZRAD         ',
     .                                Z001, Z00, ZRAD)
#endif
C
      DUM=0.
      NCOUT=1
C
C  J1: CELL INDEX FOR CURRENT SUB_STEP
C  J2: NEXT SURFACE INDEX
      J1=NTCELL
      IF (VELZ.LT.0.) THEN
        INCZ=0
        NINCZ=-1
        IF (NLSRFZ) J1=MTSURF-1
      ELSE
        INCZ=1
        NINCZ=1
        IF (NLSRFZ) J1=MTSURF
      ENDIF
      J2=J1+INCZ
C
      NLSRFZ=.FALSE.
C
  110 CONTINUE
      IF (J2.LE.0.OR.J2.GT.NT3RD) THEN
        IRET = 1
        RETURN
      END IF


C OLD SURFACE = NEW SURFACE ?
C POSSIBLE CONFLICT IF TRACK STARTED EXACTLY ON SURFACE
C TRY NEXT SURFACE
        IF (MTSURF.EQ.J2) THEN
          J1=J1+NINCZ
          J2=J1+INCZ
          GOTO 110
        ENDIF

C  TIME FROM Z01 TO ZSURF
      DZ=(ZSURF(J2)-Z01)
!pb reduce zrad if the trajectory comes too close
!pb to the next z-standard surface
!pb without hitting it
      IF (ABS(ABS(DZ/ZRAD)-1._DP) <= EPS10) THEN
        ZRAD=(1._DP-EPS6)*ZRAD
        ZRADS=ZRAD
      END IF
      BB=VELZ+EPS60
      F=DZ/BB
#ifdef TRACE
      IF (NLTRC) WRITE (iunout,*) 'J2,F,DZ ',J2,F,DZ
#endif
      IF (F.LE.ZRAD) THEN
        KUPC(NCOUT)=J1
        BLPD(NCOUT)=F-DUM
        DUM=F
C  STOP HISTORY AT NON-DEFAULT STANDARD SURFACE J2
!pb        ITEST=INMP3I(0,0,J2)
        ITEST=INMP3I(IRCELL,IPCELL,J2)
        IN=ITEST+NLIM
!pb        IF (ITEST.NE.0.AND.ILIIN(IN).NE.0) THEN
        IF ((ITEST.NE.0.AND.ILIIN(IN).NE.0).or.(ityp==3)) THEN
          ZRAD=F
          ISRFCL=0
          NTCELL=J1
          MTSURF=J2
          MRSURF=0
          MASURF=0
          NINCX=0
          IPOLGN=0
          ITCELL=NTCELL
          Z01=ZSURF(J2)
#ifdef TRACE
          IF (NLTRC) WRITE (iunout,*)
     .              'STOP AT MTSURF ',MTSURF
#endif
          RETURN
        ENDIF
C  NEXT CELL
        J1=J1+NINCZ
        J2=J1+INCZ
        NCOUT=NCOUT+1
        GOTO 110
      ENDIF
C
C  LAST CELL
C

#ifdef TRACE
      IF (NLTRC) WRITE (iunout,*) 'LAST CELL ',ZRAD,DUM
#endif

      NTCELL=J1
      MTSURF=0
      NINCZ=0
      KUPC(NCOUT)=J1
      BLPD(NCOUT)=ZRAD-DUM
      ITCELL=NTCELL
      Z01=Z001
C
      RETURN
C
C  BLOCK 1 (NLTRZ)  done ::::::::::::::::::::::::::::::::::::::
C

      END SUBROUTINE EIRENE_TIMET_CYLINDER_GEOMETRY

!---------------------------------------------------------------

      SUBROUTINE EIRENE_TIMET_TOR_APPROX(ZRAD,IRET)

      IMPLICIT NONE
      REAL(DP), INTENT(INOUT) :: ZRAD
      INTEGER, INTENT(OUT) :: IRET
      INTEGER :: ISTS
C
C  BLOCK 2B: DISCRETE TOROIDAL APPROXIMATION,
C            also: default toroidal periodicity model.
C            ONLY ONE STEP AT A TIME
C
      IRET=0
      NERR=0
      NCOUT=1
      KUPC(1)=NTCELL
C
C     IF (NLSRFZ) THEN ....
C  PARTICLE ON TOROIDAL SURFACE MTSURF
      NLSRFZ=.FALSE.
C
 1010 CONTINUE
C  PHI0 IS THE PHI AT THE CENTER OF THE CURRENT TOROIDAL CELL
      PHI0=PHI-ATAN2(Z01,X01)
C
      TTT=Z01/(X01*TANAL)
      IF (ABS(TTT).GT.1.+EPS10) THEN
        WRITE (iunout,*) 'NPANU ',NPANU
        WRITE (iunout,*) 'X01,Z01 OUT OF RANGE IN TIMET'
        WRITE (iunout,*) X01,Z01,TTT
        WRITE (iunout,*) 'TRY TO KILL PARTICLE ASAP '
        ZRAD=-1._DP
        IRET=3
        RETURN
      ENDIF
C
      Z001=Z01+ZRAD*VELZ
      X001=X01+ZRAD*VELX
      IF (ZRAD.LT.1.D30.AND.X01*X001.GT.EPS10) THEN

        ITT=INT(REAL(Z001/(X001*TANAL),DP))
#ifdef TRACE
        IF (NLTRC) WRITE (iunout,'(1X,A,1X,4(1PE12.4,3X),I6)')
     .              'TIMET 1 ',X01,Z01,X001,Z001,ITT
#endif
      ELSE
        IF (1._DP-ABS(VELY) > EPS10) THEN
          TO=(Z01-X01*TANAL)/(TANAL*VELX-VELZ)
          XTO=X01+TO*VELX
          TU=(Z01+X01*TANAL)/(-TANAL*VELX-VELZ)
          XTU=X01+TU*VELX
#ifdef TRACE
          IF (NLTRC) WRITE (iunout,*) 'TU,TO ',TU,TO,XTU,XTO
#endif
          EPSTST=EPS10*TANAL
          IF (XTO.GT.0..AND.TO.GT.EPSTST) THEN
            ITT=1
          ELSEIF (XTU.GT.0..AND.TU.GT.EPSTST) THEN
            ITT=-1
          ELSE
            ITT=0
            Z001=Z01
            X001=X01
          ENDIF
        ELSE
          ITT=0
          Z001=Z01
          X001=X01
        ENDIF
#ifdef TRACE
        IF (NLTRC) WRITE (iunout,*) 'TIMET 2 ',X01,Z01,ITT
#endif
      ENDIF
C
      IF (ITT.LT.0) GOTO 1100
      IF (ITT.GT.0) GOTO 1300
C
C  NO INTERSECTION WITH TOROIDAL SURFACE, particle stays within tor. cell.
C
C 1200 CONTINUE
      MTSURF=0
      NNTCLL=IPERID
      Z01=Z001
      X01=X001
C  IN CASE ZRAD=1.D30, IS NEXT STATEMENT IS NONSENSE, BUT CORRECTED
C                      FOR IN SUBR. STDCOL, WHICH MUST BE CALLED NEXT
C                      FOR A POLOIDAL SURFACE (OTHERWISE: ERROR EXIT)
      PHI=PHI0+ATAN2(Z01,X01)
      BLPD(1)=ZRAD
#ifdef TRACE
      IF (NLTRC) CALL EIRENE_MASR3('FINAL 1: X01,Z01,PHI    ',
     .                                       X01,Z01,PHI/DEGRAD)
#endif
      RETURN
C
C  PARTICLE LEAVES CELL IN POSITIVE DIRECTION, REDUCE ZRAD
C
 1300 CONTINUE
C
C  TIME TO REACH CELL SURFACE: F
C
      AA=Z01-X01*TANAL
      BB=(TANAL*VELX-VELZ)+EPS60
      F=AA/BB
      IF (F.LE.0.) THEN
C  PARTICLE ACCIDENTALLY ON A TOROIDAL SURFACE?
        IF (ABS(AA).LE.EPS10.AND.NERR.LE.1) THEN
#ifdef TRACE
          IF (NLTRC) WRITE (iunout,*) 'TRY AGAIN IN TIMET'
#endif
!pb          Z01=Z01-VELZ*EPS10
!pb          X01=X01-VELX*EPS10
          z01_cell = x01*tanal
          Z01=Z01-z01_cell*EPS10
          NERR=NERR+1
          GOTO 1010
        ENDIF
        ZRAD=1.D30
        IRET=2
        RETURN
      ENDIF

C  a valid flight time F has been found
      X01=X01+F*VELX
      Z01=TANAL*X01
      PHI=PHI0+ZHALF
      ZRAD=F
C
      ISRFCL=3
      BLPD(1)=ZRAD
C
      NINCX=0
      NINCZ=1
      IPOLGN=0
      MRSURF=0
      MASURF=0
      NNTCLL=NTCELL+1
      IF (.NOT.NLTOR) NNTCLL=IPERID+1
      MTSURF=NNTCLL
C  ENFORCED PERIODICITY, UNLESS NON-DEFAULT STANDARD SURFACE
      ISTS=0
      IF (NLTOR) ISTS=INMP3I(IRCELL,IPCELL,MTSURF)
      IF (ISTS.EQ.0) THEN
        IF (NNTCLL.GE.NTTRA) NNTCLL=1
        MTSURF=NNTCLL
      ELSE
C  NO AUTOMATIC PERIODICITY IN SUBR. TORCOL. CALL STDCOL FOR NON-DEF. SURF.
        ISRFCL=0
      ENDIF
C
#ifdef TRACE
      IF (NLTRC) THEN
        WRITE (iunout,*) 'FINAL 2: X01,Z01,PHI ',X01,Z01,PHI/DEGRAD
        WRITE (iunout,*) 'ZRAD,ISTS,ISRFCL,IPERID ',
     .                    ZRAD,ISTS,ISRFCL,IPERID
      ENDIF
#endif
      RETURN
C
C  PARTICLE LEAVES CELL IN NEGATIVE DIRECTION, REDUCE ZRAD
C
 1100 CONTINUE
C
C  TIME TO REACH CELL SURFACE
C
      AA=Z01+X01*TANAL
      BB=-TANAL*VELX-VELZ+EPS60
      F=AA/BB

C  try to identify particles exactly on toroidal surfaces. unfinished
!      if (abs(aa*bb) <= eps30) then
!        f = 0._dp
!      else
!        F=AA/BB
!      end if
c
      IF (F.LE.0.) THEN
C  PARTICLE ACCIDENTALLY ON A TOROIDAL SURFACE?
        IF (ABS(AA).LE.EPS10.AND.NERR.LE.1) THEN
#ifdef TRACE
          IF (NLTRC) WRITE (iunout,*) 'TRY AGAIN IN TIMET'
#endif
!pb          Z01=Z01-VELZ*EPS10
!pb          X01=X01-VELX*EPS10
          z01_cell = x01*tanal
          Z01=Z01+z01_cell*EPS10
          NERR=NERR+1
          GOTO 1010
        ENDIF
        ZRAD=1.D30
        IRET=2
        RETURN
      ENDIF

C  a valid flight time F has been found
      X01=X01+F*VELX
      Z01=-TANAL*X01
      PHI=PHI0-ZHALF
      ZRAD=F
C
      ISRFCL=3
      BLPD(1)=ZRAD
C
      NINCX=0
      NINCZ=-1
      IPOLGN=0
      MRSURF=0
      MASURF=0
      NNTCLL=NTCELL-1
      IF (.NOT.NLTOR) NNTCLL=IPERID-1
      MTSURF=NNTCLL+1
C  ENFORCED PERIODICITY, UNLESS NON-DEFAULT STANDARD SURFACE
      ISTS=0
      IF (NLTOR) ISTS=INMP3I(IRCELL,IPCELL,MTSURF)
      IF (ISTS.EQ.0) THEN
        IF (NNTCLL.LE.0) NNTCLL=NTTRAM
        MTSURF=NNTCLL+1
      ELSE
C  NO AUTOMATIC PERIODICITY IN SUBR. TORCOL. CALL STDCOL FOR NON-DEF. SURF.
        ISRFCL=0
      ENDIF
C
#ifdef TRACE
      IF (NLTRC) THEN
        WRITE (iunout,*) 'FINAL 3: X01,Z01,PHI ',X01,Z01,PHI/DEGRAD
        WRITE (iunout,*) 'ZRAD,ISTS,ISRFCL,IPERID ',
     .                    ZRAD,ISTS,ISRFCL,IPERID
      ENDIF
#endif

      RETURN
C

C  BLOCK 2B DONE.... NLTRA
C                 polygonal in x-z, (rather than x-y, as in timep.f).
C::::::::::::::::::::::::::::::::::::::::::::::::::::::::

      END SUBROUTINE EIRENE_TIMET_TOR_APPROX

      END SUBROUTINE EIRENE_TIMET
