cdr  oct 16:  levgeo=1, error exit due to round-off errors removed,
cdr                     now: "save landing of lost particle".
cdr           prevents random error exits in very long (parallel) runs.
C
cdr   at some point in time: included LDAMCEL
cdr   (indicator for "damaged cells" in 2D (x-y) plane)
cdr   LDAMCEL is set in initialization phase

cdr  sept 17: sync with timet
cym 04/2020 turned into a module because of SAVE attribute

      module eirmod_timep
      use eirmod_precision
      implicit none
      private

      public :: eirene_timep
C
      REAL(DP) :: ZRADS
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP THREADPRIVATE(ZRADS)
#endif

!      REAL(DP) :: HELP, GS, GC, F, XNEN, DUM, SUM, BB, DY, X0TEST,
!     .          Y0TEST, V1, V2, T1, ZRADS, ZRD, WIN1, X000, Z0T,
!     .          TWIN1, XT, Y000, TSS, X0T, Y0T,
!     .          DYZR
!      INTEGER :: IANP, I, IENP, JHELP, ISW, JJC, J1,
!     .           NRCLLP, LHELP, J2, INCY, JN, ICOU, NYSAVE, NHELP,
!     .           I1, MPTEST, IR, IRSAVE, NCOUPE, ISTS,
!     .           IADD, ICOUT, NCPEN, IPOLGS, NCPAN, J,
cym     .           EIRENE_LEARCA, EIRENE_LEARC2,
!     .           NJC, ITEST, JSH, NN ,IN, itc

cdr logicals for intersection with poloidal surfaces
!      LOGICAL :: LHITP0
!      LOGICAL :: lnincz

#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!!$OMP THREADPRIVATE(HELP, GS, GC, F, XNEN, DUM, SUM, BB, DY, X0TEST,
!!$OMP&  Y0TEST, V1, V2, T1, ZRADS, ZRD, WIN1, X000, Z0T,
!!$OMP&  TWIN1, XT, Y000, TSS, X0T, Y0T,
!!$OMP&  DYZR,
!!$OMP&  IANP, I, IENP, JHELP, ISW, JJC, J1,
!!$OMP&  NRCLLP, LHELP, J2, INCY, JN, ICOU, NYSAVE, NHELP,
!!$OMP&  I1, MPTEST, IR, IRSAVE, NCOUPE, ISTS,
!!$OMP&  IADD, ICOUT, NCPEN, IPOLGS, NCPAN, J,
!!$OMP&  NJC, ITEST, JSH, NN ,IN, itc,
!!$OMP&  LHITP0, lnincz)
#endif

cym is this really useful ?
!      SAVE

      contains

      SUBROUTINE EIRENE_TIMEP (ZRAD)
C
C   CALCULATE TIME SEGMENTS FOR 2D-OR 3D PROFILES,
C     X-RADIALLY AND Y-POLOIDALLY RESOLVED
C
C   BLOCK 1 : LEVGEO.EQ.1
C   BLOCK 3 : LEVGEO.EQ.3
C   BLOCK 2a: LEVGEO.EQ.2 and NLCRC
C   BLOCK 2b: LEVGEO.EQ.2 and .NOT.NLCRC  (use poloidal polygons)

C
C   INPUT:
C
C       X00,Y00,Z00: STARTING POINT FOR THIS TRACK
C     ZRAD  = DISTANCE (CM)
C                TO NEXT RADIAL SURFACE OF 1D STANDARD MESH
C             OR TO NEXT ADDITIONAL SURFACE, TRAVELED IN RADIAL CELL NRCELL
C             OR TO NEXT TOROIDAL SURFACE, TRAVELED IN RADIAL CELL NRCELL
C       NRCELL = RADIAL CELL NUMBER, IN WHICH THIS TRACK OF LENGTH ZRAD
C                                    IS PERFORMED
C              = 0, IF TRACK OUTSIDE RADIAL MESH
C                   IF MRSURF .NE. 0 THEN
C                   REENTRY FOUND AT RADIAL SURFACE MRSURF.
C                   OTHERWISE: REENTRY AT NON-DEFAULT
C                   POLOIDAL SURFACES IS SEARCHED FOR IN THIS CALL
C       NTCELL =
C       ITCELL =
C       NPCELL = POLOIDAL CELL INDEX OF POINT X00,Y00,Z00
C                AT WHICH THIS TRACK OF LENGTH ZRAD STARTS

C  WARNING: IF NLSRFY, NPCELL MAY BE WRONG
C       IPCELL =
C
C       NCOUT,BLPD,NCOUNT
C
C   OUTPUT:
C
C       X00,Y00,Z00: END POINT FOR THIS TRACK
C       NCOU   = TOTAL NUMBER OF CELLS, WHICH THE CURRENT TRACK OF
C                LENGTH ZRAD HAS CROSSED
C       CLPD(I)= LENGTH OF THE PART NO. I (I=1,NCOU)
C       JUPC(I)= CELL NUMBER IN P-GRID FOR TRACK I
C       LUPC(I)= SURFACE NUMBER IN P-GRID AN THE END OF TRACK I
C       MUPC(I)= ORIENTATION OF TRACK I
C       NPCELL = LAST POLOIDAL CELL INDEX OF X00,Y00,Z00 POINT,
C                ON WHICH THIS TRACK OF LENGTH ZRAD ENDS
C       IPCELL = NUMBER OF FINAL POLOIDAL CELL NPCELL
C                IF TRACK ORIGINATED INSIDE STANDARD MESH
C              = NUMBER OF POLOIDAL CELL, AT WHICH REENTRY WAS FOUND
C                ON RADIAL OR TOROIDAL SURFACE
C                IF TRACK ORIGINATED OUTSIDE  STANDARD MESH
C       IRCELL = NUMBER OF RADIAL CELL, AT WHICH REENTRY AT POLOIDAL
C                SURFACE MPSURF WAS FOUND. OTHERWISE: UNMODIFIED.
C
C              = 0  IF TRACK COMPLETELY OUTSIDE STANDARD MESH
C
      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD
      USE EIRMOD_CCONA
      USE EIRMOD_CLOGAU
      USE EIRMOD_CUPD
      USE EIRMOD_CPOLYG
      USE EIRMOD_CGRID
      USE EIRMOD_CGEOM
      USE EIRMOD_COMPRT
      USE EIRMOD_COMSOU
      USE EIRMOD_CLGIN

      IMPLICIT NONE

      REAL(DP), INTENT(INOUT) :: ZRAD
      REAL(DP) :: SUM
      INTEGER :: J, JN, NCPAN, NCPEN, IPOLGS, ICOUT, ICOU, IADD

cym stays here because not correct in module declaration
cym therefore: save not there, same in timer.F
cym check this is correct
cdr logicals for intersection with poloidal surfaces
      INTEGER :: NCOUNS(N2ND+N3RD)
      EXTERNAL :: EIRENE_EXIT_OWN

#ifdef TRACE
      INTEGER :: JJ
      EXTERNAL :: EIRENE_LEER
#endif

cym cccccccccccccccccccccccccccccccccccccccccccccccccccccc
cym local variables moved to module declaration section
cym cccccccccccccccccccccccccccccccccccccccccccccccccccccc

cym removed - check - if indeed useless could have been supressed without
cym turning this to a module
cym      SAVE
C
#ifdef TRACE
      IF (NLTRC) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP CRITICAL
#endif
        CALL EIRENE_LEER(1)
        IF (NRCELL.GT.0) THEN
          WRITE (iunout,*) 'TIMEP FROM INSIDE, NPANU ', NPANU
          WRITE (iunout,*) 'ZRAD,NRCELL,NPCELL,MPSURF,NTCELL,MTSURF '
          WRITE (iunout,'(1PE12.4,3X,5I6)')
     .                      ZRAD,NRCELL,NPCELL,MPSURF,NTCELL,MTSURF
        ELSE
          WRITE (iunout,*) 'TIMEP FROM OUTSIDE, NPANU ', NPANU
          WRITE (iunout,*) 'MRSURF,MPSURF,MTSURF,ZRAD '
          WRITE (iunout,*)  MRSURF,MPSURF,MTSURF,ZRAD
        ENDIF
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP END CRITICAL
#endif
      ENDIF
#endif
C
      ICOUT=1
      IADD=0
      ZRADS=ZRAD
      IPOLGS=IPOLGN
      ncpan=0
      ncpen=0
C
      IF (NLTOR) THEN
C  zrad,ntcell, ... may have been modified in TIMET.F
C       NCOUT=NCOUT
        ZRAD=BLPD(1)
        NTCELL=NCOUNT(1)
        IF (NCOUT.GT.1) IPOLGN=0
#ifdef TRACE
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP CRITICAL
#endif
        IF (NLTRC)
     .    WRITE (iunout,*) 'because NLTOR/NLTRA: ZRAD,NTCELL ',
     .                                           ZRAD,NTCELL
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP END CRITICAL
#endif
#endif
      ELSE
        NCOUT=1
C       ZRAD=ZRAD
C       NTCELL=1
      ENDIF
C
10000 CONTINUE
C
CDR NOV.99: ADDED BECAUSE OF FOLION OPTION,
C           WITH DEFAULT B FIELD (IN Z DIRECTION)
C
      IF (ABS(VELZ).EQ.1.D0) THEN
        NCOUP=1
        ALPD(NCOUP)=ZRAD
        JUPC(NCOUP)=NPCELL
C       X00=X00+ZRAD*VELX
C       Y00=Y00+ZRAD*VELY
        IPCELL=NPCELL
        MPSURF=0
        GOTO 5000
      ENDIF
C

      SELECT CASE (LEVGEO)

      CASE(1)
C
C****SLAB MODEL IN Y DIRECTION
C
        CALL EIRENE_TIMEP_SLAB(ZRAD)

      CASE(2)
        IF (NLCRC) THEN
C
C****CIRCULAR MESH   (CONCENTRIC)
C
          CALL EIRENE_TIMEP_CIRCULAR_MESH(ZRAD)
        ELSE
C
C****NONCIRCULAR (E.G. ELLIPTICAL) MESH  (NOT NECESSARILY CONCENTRIC NOR CONFOCAL)
C
          CALL EIRENE_TIMEP_NONCIRCULAR_MESH(ZRAD)
        ENDIF                   ! (LEVGEO=2,  block 2A and 2B)

      CASE(3)
C
C  POLYGON MESH
C
        CALL EIRENE_TIMEP_CURVILINEAR_MESH(ZRAD, ICOUT, NCPAN, NCPEN)

      CASE DEFAULT

        WRITE (IUNOUT,*) 'UNIDENTIFIED GEOMETRY OPTION FOUND IN TIMEP'
        WRITE (IUNOUT,*) 'LEVGEO = ',LEVGEO
        WRITE (IUNOUT,*) 'CALCULATION ABANDONED'
        CALL EIRENE_EXIT_OWN(1)

      END SELECT

C  FROM HERE ON: CODE COMMON TO ALL OPTIONS.
C   ::::::::::::::::::::::::::::::::::::::::::::::::::::::::
C
 5000 CONTINUE
#ifdef TRACE
      IF (NLTRC) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP CRITICAL
#endif
        WRITE (iunout,*) 'NCOUP= ',NCOUP
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP END CRITICAL
#endif
      ENDIF
#endif
      DO 5100 J=1,NCOUP
        CLPD(IADD+J)=ALPD(J)
        NUPC(IADD+J)=(JUPC(J)-1)+(NTCELL-1)*NP2T3
        NCOUNP(IADD+J)=JUPC(J)
        NCOUNS(IADD+J)=NTCELL
        IF (ALPD(J).LE.0..OR.JUPC(J).LE.0.OR.
     .      JUPC(J).GE.NP2ND) THEN
          WRITE (iunout,*) 'ERROR DETECTED IN TIMEP '
          WRITE (iunout,*) 'NPANU,J,IADD+J,ALPD,JUPC ',
     .                      NPANU,J,IADD+J,ALPD(J),JUPC(J)
        ENDIF
#ifdef TRACE
        IF (NLTRC) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP CRITICAL
#endif
          JJ=J+IADD
          WRITE (iunout,'(1X,A,3X,I6,3X,1PE12.4,3X,I6,3X,I6)')
     .                     'TIMEP: JJ,CLPD(JJ),NUPC(JJ),NCOUNP(JJ) ',
     .                             JJ,CLPD(JJ),NUPC(JJ),NCOUNP(JJ)
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP END CRITICAL
#endif
        ENDIF
#endif
 5100 CONTINUE
C
      IF (ICOUT.LT.NCOUT.AND.MPSURF.EQ.0) THEN
        ICOUT=ICOUT+1
        IPOLGN=0
        IF (ICOUT.EQ.NCOUT) IPOLGN=IPOLGS
        ZRAD=BLPD(ICOUT)
        if (ncpan.gt.0) then
          jn=0
          do j=ncpan,ncpen
            jn=jn+1
            alpd(jn)=alpd(j)
            jupc(jn)=jupc(j)
            lupc(jn)=lupc(j)
            mupc(jn)=mupc(j)
          end do
        endif
        NTCELL=NCOUNT(ICOUT)
        IADD=IADD+NCOUP
        ncoup=jn
#ifdef TRACE
        IF (NLTRC) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP CRITICAL
#endif
          WRITE (iunout,*) 'NEXT TOR. CELL: ZRAD,NTCELL,IADD ',
     .                                      ZRAD,NTCELL,IADD
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP END CRITICAL
#endif
        ENDIF
#endif
        GOTO 10000
      ENDIF
C
      NCOU=IADD+NCOUP
C
      SUM=0.
      DO 5110 ICOU=1,NCOU
        SUM=SUM+CLPD(ICOU)
        NCOUNT(ICOU)=NCOUNS(ICOU)
C       WRITE (iunout,*) 'ICOU,NCOUNT,CLPD ',
C    .                    ICOU,NCOUNT(ICOU),CLPD(ICOU)
 5110 CONTINUE
      IF (MPSURF.EQ.0.AND.ABS(SUM-ZRADS).GT.EPS10) THEN
        WRITE (iunout,*) 'ERROR IN TIMEP: NPANU,SUM,ZRADS ',
     .                               NPANU,SUM,ZRADS
        RETURN  ! changed to avoid job crash in long runs
!       CALL EIRENE_EXIT_OWN(1)
      ENDIF
C
      ZRAD=SUM
      RETURN

      END SUBROUTINE EIRENE_TIMEP

!------------------------------------------------------------------------

      SUBROUTINE EIRENE_TIMEP_CURVILINEAR_MESH(ZRAD, ICOUT,
     .                                         NCPAN, NCPEN)
      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD
      USE EIRMOD_CUPD
      USE EIRMOD_CCONA
      USE EIRMOD_COMPRT
      USE EIRMOD_CGRID
      USE EIRMOD_CGEOM
      USE EIRMOD_CLGIN
      USE EIRMOD_CPOLYG
      USE EIRMOD_LEARC1, ONLY: EIRENE_LEARC1

      IMPLICIT NONE
      REAL(DP), INTENT(INOUT) :: ZRAD
      INTEGER, INTENT(IN) :: ICOUT
      INTEGER, INTENT(INOUT) :: NCPAN, NCPEN
      REAL(DP) :: ZRD, X0T, Y0T, Z0T, V1, V2, TSS, T1
      INTEGER :: J, JSH, ISTS, NN, NCOUPE, MPTEST, IR, IN,
     .           IRSAVE, I1, ITEST, ITC
      INTEGER :: EIRENE_LEARC2
      EXTERNAL :: EIRENE_LEARC2
      LOGICAL  :: LNINCZ, LHITP0
C
      IF (NRCELL.GT.0) GOTO 10
C
C  PARTICLE OUTSIDE STANDARD MESH
C  CHECK AT NON-DEFAULT POLOIDAL SURFACES
C  (RADIAL SURFACES ARE ALREADY DONE IN TIMER.F)
C
      NCOUP=0
      ZRD=ZRAD
      DO 3 ISTS=1,NSTSI
        MPTEST=INUMP(ISTS,2)
        IF (MPTEST.NE.0) THEN
C  TEST POLOIDAL SURFACE NO. MPTEST FOR REENTRY
          DO 2 IR=1,NR1STM
            I1=IR+1
            V1=(YPOL(IR,MPTEST)-Y00)*VELX-(XPOL(IR,MPTEST)-X00)*VELY
            V2=(YPOL(I1,MPTEST)-Y00)*VELX-(XPOL(I1,MPTEST)-X00)*VELY

! allow only intersections with non-default poloidal standard surfaces
! no intersections with "default parts" of the grid are calculated
            LHITP0=(V1*V2.LE.0.) .AND. (INMP2I(IR,MPTEST,0) /= 0)

            IF (.NOT.LHITP0) CYCLE
            T1=((XPOL(IR,MPTEST)-X00)*VVTY(IR,MPTEST)-
     .          (YPOL(IR,MPTEST)-Y00)*VVTX(IR,MPTEST))
     .         /(VELX*VVTY(IR,MPTEST)-VELY*VVTX(IR,MPTEST)+EPS60)
#ifdef TRACE
            IF (NLTRC) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP CRITICAL
#endif
              WRITE (iunout,*) 'IR,MPTEST,T1 ',IR,MPTEST,T1
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP END CRITICAL
#endif
            ENDIF
#endif
            IF (T1.LT.0..OR.T1.GE.ZRD) CYCLE
#ifdef TRACE
            IF (NLTRC) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP CRITICAL
#endif
              WRITE (iunout,*) 'VALID INTERSECTION AT T1= ',T1
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP END CRITICAL
#endif
            ENDIF
#endif
            NCOUP=1
            LUPC(NCOUP)=MPTEST
            IRSAVE=IR
            MUPC(NCOUP)=NINT(SIGN(1._DP,VELX*PPLNX(IR,MPTEST)+
     .                                  VELY*PPLNY(IR,MPTEST)))
            JUPC(NCOUP)=1
            ZRD=T1
    2     CONTINUE

        ENDIF
    3 CONTINUE
      IF (NCOUP.GT.0.AND.LUPC(MAX(1,NCOUP)).NE.MPSURF) THEN
C  REENTRY FOUND, REDUCE ZRAD TO T1
C  NCOUP=1 AT THIS POINT
        NCOUPE=1
        MPSURF=LUPC(NCOUPE)
        IPOLGN=LUPC(NCOUPE)
        NINCY=MUPC(NCOUPE)
        IRCELL=IRSAVE
        ZRAD=ZRD
        ISRFCL=0
        ALPD(NCOUPE)=ZRAD
        MRSURF=0
        MTSURF=0
        MASURF=0
        NINCX=0
        NINCZ=0
#ifdef TRACE
        IF (NLTRC) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP CRITICAL
#endif
          WRITE (iunout,*) 'REENTRY FOUND, MPSURF,ZRAD = ',MPSURF,ZRAD
          WRITE (iunout,*) 'IRCELL ',IRCELL
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP END CRITICAL
#endif
        ENDIF
#endif
        GOTO 31
      ELSE
C  NO REENTRY FOUND
        NCOUP=1
        JUPC(1)=1
        ALPD(1)=ZRAD
        IPCELL=IPOLGN
        MPSURF=0
#ifdef TRACE
        IF (NLTRC) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP CRITICAL
#endif
          WRITE (iunout,*) 'NO REENTRY INTO POLOIDAL GRID FOUND '
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP END CRITICAL
#endif
        ENDIF
#endif
        X00=X00+ZRAD*VELX
        Y00=Y00+ZRAD*VELY
        RETURN
      ENDIF
C
   10 CONTINUE
C
C  PARTICLE INSIDE STANDARD MESH, RADIAL CELL NO. NRCELL
C
      IF (NCOUP.EQ.0) THEN
        WRITE (iunout,*) 'ERROR IN TIMEP: NCOUP=0'
        RETURN
      ENDIF
#ifdef TRACE
      IF (NLTRC) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP CRITICAL
#endif
        WRITE (iunout,*) ' TIMEP IN NEIGHBOR PART '
        WRITE (iunout,*) ' ALPD ',(ALPD(J),J=1,NCOUP)
        WRITE (iunout,*) ' JUPC ',(JUPC(J),J=1,NCOUP)
        WRITE (iunout,*) ' LUPC ',(LUPC(J),J=1,NCOUP)
        WRITE (iunout,*) ' MUPC ',(MUPC(J),J=1,NCOUP)
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP END CRITICAL
#endif
      ENDIF
#endif
      NLSRFY=.FALSE.
      IF ((icout == 1) .and.
     .   (SQRT((X0-X00)**2+(Y0-Y00)**2).GT.EPS10)) THEN
        DO J=1,NCOUP
          ALPD(J)=ALPD(J)-ZT
        ENDDO
      ENDIF
C
C  ACCOUNT FOR OTHER SURFACES INSIDE POLOIDAL MESH
C
      lnincz=.false.
      if (ityp==3) lnincz=(zrad < alpd(1))
      IF (ALPD(NCOUP).GT.ZRAD) THEN
        DO J=1,NCOUP
          IF (ALPD(J).GT.ZRAD) THEN
            ncpan=j+1
            ncpen=ncoup+1
            do jsh=ncoup,j+1,-1
              alpd(jsh+1)=alpd(jsh)-zrad
              jupc(jsh+1)=jupc(jsh)
              lupc(jsh+1)=lupc(jsh)
              mupc(jsh+1)=mupc(jsh)
            end do
            alpd(ncpan)=alpd(j)-zrad
            jupc(ncpan)=jupc(j)
            lupc(ncpan)=lupc(j)
            mupc(ncpan)=mupc(j)
            ALPD(J)=ZRAD
            IPOLGN=JUPC(J)
            NCOUP=J
            LUPC(NCOUP)=0
            MUPC(NCOUP)=0
            GOTO 4711
          ENDIF
        ENDDO
 4711   CONTINUE
      ENDIF
C
C   ADJUST ALPD AND ACCOUNT FOR "NON-DEFAULT" POLOIDAL SURFACES
C
      TSS=0.
      DO J=1,NCOUP
        ALPD(J)=ALPD(J)-TSS
        TSS=TSS+ALPD(J)
C
        ITEST=INMP2I(NRCELL,LUPC(J),0)
        IN=ITEST+NLIM
        if (LUPC(J) > 0) then
          itc = NRCELL+((LUPC(J)-1)+(NTCELL-1)*NP2T3)*NR1P2+NBLCKA
        else
          itc = ncell
        end if
!pb                            IF (ITEST.NE.0.AND.ILIIN(IN).NE.0) THEN
        IF (.not.ldamcel(itc).and.(ITEST.NE.0.AND.ILIIN(IN).NE.0))THEN
C
C  TRACK ENDS ON ONE OF THE NON-DEFAULT POLOIDAL SURFACES
C
#ifdef TRACE
          IF (NLTRC) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP CRITICAL
#endif
            WRITE (iunout,*) ' TRACK TERMINATED'
            WRITE (iunout,*) ' ITEST,ILIIN ',ITEST,ILIIN(IN)
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP END CRITICAL
#endif
          ENDIF
#endif
          NCOUPE=J
          MPSURF=LUPC(NCOUPE)
          IPOLGN=LUPC(NCOUPE)
          NINCY=MUPC(NCOUPE)
          ZRAD=TSS
          ISRFCL=0
          MASURF=0
          nincx=0
          nincz=0
          mrsurf=0
          mtsurf=0
          NCOUP=NCOUPE
          GOTO 311

        ELSEIF (ldamcel(itc).or.(ityp==3)) THEN
C
C  STOP TRACK ANYHOW
C
#ifdef TRACE
          IF (NLTRC) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP CRITICAL
#endif
            WRITE (iunout,*) ' TRACK TERMINATED'
            WRITE (iunout,*) ' ITYP,ILIIN ',ITYP,ILIIN(IN)
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP END CRITICAL
#endif
          ENDIF
#endif
          if (ldamcel(itc)) lgpart=.false.
          NCOUPE=J
          MPSURF=LUPC(NCOUPE)
          IF (LUPC(NCOUPE) /= 0) IPOLGN=LUPC(NCOUPE)
          NINCY=MUPC(NCOUPE)
          ZRAD=TSS
          if (1.-zrad/(zrads+eps60) > eps10) then
            ISRFCL=0
            MASURF=0
          end if
!pb
          if (lnincz) then      ! toroidal surface
            nincx=0
            nincy=0
            mrsurf=0
            mpsurf=0
          elseif ((ityp==3).and.(nincx.ne.0)) then ! radial surface
            nincy=0
            nincz=0
            mpsurf=0
            mtsurf=0
          else                  ! poloidal surface
            nincx=0
            nincz=0
            mrsurf=0
            mtsurf=0
          end if
!pb
          NCOUP=NCOUPE
          GOTO 311
        ENDIF
C
      ENDDO
C
C  LAST CELL, TRACK DOES NOT END ON A POLOIDAL SURFACE
C
C  INDEX IPOLGN OF LAST CELL NOT KNOWN ?
      IF (IPOLGN.EQ.0) THEN
        X0T=X00+VELX*ZRAD
        Y0T=Y00+VELY*ZRAD
        NN=EIRENE_LEARC1(X0T,Y0T,Z0T,IPOLGN,
     .            NRCELL,NRCELL,.FALSE.,.FALSE.,
     .            NPANU,'TIMEP       ')
      ENDIF
C
      MPSURF=0
      NINCY=0
C
  311 CONTINUE
#ifdef TRACE
      IF (NLTRC) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP CRITICAL
#endif
        WRITE (iunout,*) ' ALPD ',(ALPD(J),J=1,NCOUP)
        WRITE (iunout,*) ' JUPC ',(JUPC(J),J=1,NCOUP)
        WRITE (iunout,*) ' LUPC ',(LUPC(J),J=1,NCOUP)
        WRITE (iunout,*) ' MUPC ',(MUPC(J),J=1,NCOUP)
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP END CRITICAL
#endif
      ENDIF
#endif
C
      X00=X00+ZRAD*VELX
      Y00=Y00+ZRAD*VELY
      NPCELL=JUPC(NCOUP)
      IPCELL=NPCELL
      RETURN
C
C
C  LAST CELL, TRACK DOES NOT END ON A POLOIDAL SURFACE
C
C  INDEX OF LAST CELL NOT KNOWN (E.G. DUE TO ADD. SURFACE) ?
CDR  ERROR: FALLS NLSRFY, GGFLS NPCELL FALSCH
      IF (IPOLGN.EQ.0) THEN
CDR       IF (NCOUP.EQ.0) THEN
CDR         IPOLGN=NPCELL
CDR       ELSE
        X0T=X00+VELX*ZRAD
        Y0T=Y00+VELY*ZRAD
        IPOLGN=EIRENE_LEARC2(X0T,Y0T,NRCELL,NPANU,'TIMEP       ')
CDR       ENDIF
      ENDIF
C
      NCOUPE=NCOUP+1
      JUPC(NCOUPE)=IPOLGN
      LUPC(NCOUPE)=0
      MUPC(NCOUPE)=0
      ALPD(NCOUPE)=ZRAD-TSS
      MPSURF=0
      NINCY=0
C
   31 CONTINUE
      NCOUP=NCOUPE
#ifdef TRACE
      IF (NLTRC) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP CRITICAL
#endif
        WRITE (iunout,*) ' ALPD ',(ALPD(J),J=1,NCOUP)
        WRITE (iunout,*) ' JUPC ',(JUPC(J),J=1,NCOUP)
        WRITE (iunout,*) ' LUPC ',(LUPC(J),J=1,NCOUP)
        WRITE (iunout,*) ' MUPC ',(MUPC(J),J=1,NCOUP)
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP END CRITICAL
#endif
      ENDIF
#endif
C
      X00=X00+ZRAD*VELX
      Y00=Y00+ZRAD*VELY
      NPCELL=JUPC(NCOUP)
      IPCELL=NPCELL
      RETURN

      END SUBROUTINE EIRENE_TIMEP_CURVILINEAR_MESH

!----------------------------------------------------------------------

      SUBROUTINE EIRENE_TIMEP_CIRCULAR_MESH(ZRAD)
      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD
      USE EIRMOD_CUPD
      USE EIRMOD_CCONA
      USE EIRMOD_CGRID
      USE EIRMOD_COMPRT

      IMPLICIT NONE
      REAL(DP), INTENT(INOUT) :: ZRAD
      REAL(DP) :: X000, Y000, XT, XNEN, WIN1, TWIN1, GC, GS, F
      INTEGER :: J1, JJC, NJC

C
C  BLOCK 2A: POLOIDAL SURFACES ARE PLANE SURFACES, AT CONST. ANGLE THETA
C
C  DISTANCE TO NEXT X- OR RADIAL SURFACE KNOWN?
C
C       IF (TS.GE.1.D30) GOTO 1000
C
C  YES! ZRAD IS THE DISTANCE TRAVELLED IN X- OR RADIAL CELL NO. NRCELL
C
      NCOUP=1

      IF (NRCELL.LE.0.OR.NRCELL.GT.NR1STM) THEN
C  PARTICLE OUTSIDE STANDARD MESH, BUT THETA GRID EXTENDS TO INFINITY

        X00=X00+VELX*ZRAD
        Y00=Y00+VELY*ZRAD
        WIN1=MOD(ATAN2(Y00,X00)+PI2A-PSURF(1),PI2A)+PSURF(1)
        NPCELL=INT(WIN1/YDF*DBLE(NP2NDM)+1.)
        RETURN
      ENDIF
C
C  PARTICLE INSIDE STANDARD MESH, RADIAL CELL NO. NRCELL
C
C  THE OLD POLOIDAL CELL INDEX IS: NPCELL
C  FIND THE NEW CELL INDEX : NJC
C
      X000=X00+VELX*ZRAD
      Y000=Y00+VELY*ZRAD
      WIN1=MOD(ATAN2(Y000,X000)+PI2A-PSURF(1),PI2A)+PSURF(1)
      NJC=INT(WIN1/YDF*DBLE(NP2NDM)+1.)
C
      TWIN1=0.
      NCOUP=0
      IF (NJC.EQ.NPCELL) GOTO 150
C
C   FIND ORIENTATION IN THETA-GRID
C
      XT=-Y00*VELX+X00*VELY
      NINCY=1
      IF (XT.LT.0.) NINCY=-1
C
C   CONTRIBUTION TO EACH THETA-CELL
C   NPCELL : STARTINDEX
C   JJC    : SURFACEINDEX
C   J1     : CELLINDEX
C   NJC    : ENDINDEX
      J1=NPCELL
  100 JJC=J1
      IF (NINCY.EQ.1) JJC=JJC+1
C   TIMESTEP FROM X00,Y00 TO THETA-SURFACE, THETA=WIN
      GS=SINPH(JJC)
      GC=COSPH(JJC)
      XNEN=VELX*GS-VELY*GC
      F=(Y00*GC-X00*GS)/(XNEN+EPS60)
      NCOUP=NCOUP+1
      JUPC(NCOUP)=J1
      LUPC(NCOUP)=JJC
      ALPD(NCOUP)=F-TWIN1
      TWIN1=F
C
      J1=J1+NINCY
      IF (J1.EQ.0) J1=NP2NDM
      IF (J1.EQ.NP2ND) J1=1
!pb          IF (J1.NE.NJC) GOTO 100
      IF ((ityp.ne.3).and.(J1.NE.NJC)) GOTO 100
C
C   LAST THETA-CELL
C
  150 NCOUP=NCOUP+1
      JUPC(NCOUP)=NJC
      ALPD(NCOUP)=ZRAD-TWIN1
      X00=X000
      Y00=Y000
      NPCELL=NJC
      MPSURF=0
      NINCY=0
      RETURN

      END SUBROUTINE EIRENE_TIMEP_CIRCULAR_MESH

!----------------------------------------------------------------------

      SUBROUTINE EIRENE_TIMEP_NONCIRCULAR_MESH(ZRAD)
      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD
      USE EIRMOD_CUPD
      USE EIRMOD_CCONA
      USE EIRMOD_COMPRT
      USE EIRMOD_CGRID
      USE EIRMOD_CGEOM
      USE EIRMOD_CLGIN
      USE EIRMOD_CPOLYG

      IMPLICIT NONE
      REAL(DP), INTENT(INOUT) :: ZRAD
      REAL(DP) :: X0T, Y0T, V1, V2, TSS, T1, HELP
      INTEGER :: I, J, NCOUPE, NHELP, NRCLLP, JHELP, ITEST, IN, ISW,
     .           IANP, IENP, LHELP
      INTEGER :: EIRENE_ILLZ
      INTEGER :: EIRENE_LEARC2
cdr logicals for intersection with poloidal surfaces
      LOGICAL :: LHITP(N2NDPLGS)
      EXTERNAL :: EIRENE_EXIT_OWN, EIRENE_ILLZ, EIRENE_LEARC2
C
C  BLOCK 2B. LEVGEO=2 BUT NOT NLCRC, POLOIDAL SURFACES ARE NOT PLANE SURFACES

      IF (NRCELL.LE.0.OR.NRCELL.GT.NR1STM) THEN
C  PARTICLE OUTSIDE STANDARD MESH
        WRITE (iunout,*)
     .    'REENTRANCE FROM VACUUM REGION UNFINISHED IN TIMEP'
        CALL EIRENE_EXIT_OWN(1)
      ENDIF


C  PARTICLE INSIDE STANDARD MESH, NRCELL
C
      NCOUP=0
      NRCLLP=NRCELL+1
C
C   SEARCH FOR ALL POSSIBLE INTERSECTIONS WITHIN THE RADIAL CELL NRCELL
C

      LHITP=.FALSE.
C
      DO 112 J=1,NP2ND
        V1=(YPOL(NRCELL,J)-Y00)*VELX-(XPOL(NRCELL,J)-X00)*VELY
        V2=(YPOL(NRCLLP,J)-Y00)*VELX-(XPOL(NRCLLP,J)-X00)*VELY
        LHITP(J)=V1*V2.LE.0.
#ifdef TRACE
        IF (NLTRC) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP CRITICAL
#endif
          IF (LHITP(J)) WRITE (iunout,*) 'LHITP=TRUE FOR ',J
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP END CRITICAL
#endif
        ENDIF
#endif
  112 CONTINUE

C  PARTICLE EXACTLY ON A (PLANE) POLOIDAL SURFACE
      IF (NLSRFY) THEN
        LHITP(MPSURF)=.FALSE.
        NLSRFY=.FALSE.
C  HARD-WIRED PERIODICITY
C  PSURF(1)=PSURF(NP2ND)
        IF (MPSURF.EQ.1) LHITP(NP2ND)=.FALSE.
        IF (MPSURF.EQ.NP2ND) LHITP(1)=.FALSE.
      ENDIF
C
      IANP=EIRENE_ILLZ(NP2ND,LHITP,1)+1
      IENP=NP2ND-EIRENE_ILLZ(NP2ND,LHITP,-1)
C
C   COMPUTE THE FLIGHT TIMES TO THE INTERSECTION POINTS
C
      DO 114 I=IANP,IENP
        IF (LHITP(I)) THEN
          T1=((XPOL(NRCELL,I)-X00)*VVTY(NRCELL,I)-
     .        (YPOL(NRCELL,I)-Y00)*VVTX(NRCELL,I))
     .       /(VELX*VVTY(NRCELL,I)-VELY*VVTX(NRCELL,I)+EPS60)
#ifdef TRACE
          IF (NLTRC) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP CRITICAL
#endif
            WRITE (iunout,*) 'I,T1 ',I,T1
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP END CRITICAL
#endif
          ENDIF
#endif
          IF (T1.LT.0..OR.T1.GE.ZRAD) GOTO 114
#ifdef TRACE
          IF (NLTRC) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP CRITICAL
#endif
            WRITE (iunout,*) 'VALID INTERSECTION AT T1= ',T1
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP END CRITICAL
#endif
          ENDIF
#endif
          NCOUP=NCOUP+1
          LUPC(NCOUP)=I
          MUPC(NCOUP)=NINT(SIGN(1._DP,VELX*PPLNX(NRCELL,I)+
     .                                VELY*PPLNY(NRCELL,I)))
          IF (MUPC(NCOUP).EQ.-1) THEN
            JUPC(NCOUP)=I
            ALPD(NCOUP)=T1
            IF (I.EQ.NP2ND) NCOUP=NCOUP-1
          ELSEIF (MUPC(NCOUP).EQ.1) THEN
            JUPC(NCOUP)=I-1
            ALPD(NCOUP)=T1
            IF (I.EQ.1) NCOUP=NCOUP-1
          ENDIF
        ENDIF
  114 CONTINUE
C
C   REARRANGE THE FLIGHT TIMES IN ASCENDING ORDER
C
  115 ISW=0
      DO 120 J=1,NCOUP-1
        IF (ALPD(J).GT.ALPD(J+1)) THEN
          ISW=ISW+1
          HELP=ALPD(J)
          ALPD(J)=ALPD(J+1)
          ALPD(J+1)=HELP
          JHELP=JUPC(J)
          JUPC(J)=JUPC(J+1)
          JUPC(J+1)=JHELP
          LHELP=LUPC(J)
          LUPC(J)=LUPC(J+1)
          LUPC(J+1)=LHELP
          NHELP=MUPC(J)
          MUPC(J)=MUPC(J+1)
          MUPC(J+1)=NHELP
        ENDIF
  120 CONTINUE
      IF (ISW.GT.0.AND.NCOUP.GT.2) GOTO 115
#ifdef TRACE
      IF (NLTRC.AND.NCOUP.GT.0) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP CRITICAL
#endif
        WRITE (iunout,*) ' NACH SORTIEREN '
        WRITE (iunout,*) ' ALPD ',(ALPD(J),J=1,NCOUP)
        WRITE (iunout,*) ' JUPC ',(JUPC(J),J=1,NCOUP)
        WRITE (iunout,*) ' LUPC ',(LUPC(J),J=1,NCOUP)
        WRITE (iunout,*) ' MUPC ',(MUPC(J),J=1,NCOUP)
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP END CRITICAL
#endif
      ENDIF
#endif
C
      DO 125 J=1,NCOUP-1
        IF (ABS(ALPD(J+1)-ALPD(J)).LE.EPS30) THEN
          IF (JUPC(J).LE.0.OR.JUPC(J).GE.NP2ND) THEN
#ifdef TRACE
            IF (NLTRC) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP CRITICAL
#endif
              WRITE (iunout,*) ' VERTAUSCHE ALPD(',J,') UND (',J+1,')'
              WRITE (iunout,*) ' ALPD = ',ALPD(J),ALPD(J+1)
              WRITE (iunout,*) ' JUPC = ',JUPC(J),JUPC(J+1)
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP END CRITICAL
#endif
            ENDIF
#endif
            HELP=ALPD(J)
            ALPD(J)=ALPD(J+1)
            ALPD(J+1)=HELP
            JHELP=JUPC(J)
            JUPC(J)=JUPC(J+1)
            JUPC(J+1)=JHELP
            LHELP=LUPC(J)
            LUPC(J)=LUPC(J+1)
            LUPC(J+1)=LHELP
            NHELP=MUPC(J)
            MUPC(J)=MUPC(J+1)
            MUPC(J+1)=NHELP
          ENDIF
        ENDIF
  125 CONTINUE
C
C   ADJUST ALPD AND ACCOUNT FOR "NON-DEFAULT" POLOIDAL SURFACES
C
      TSS=0.
      DO 130 J=1,NCOUP
        ALPD(J)=ALPD(J)-TSS
        TSS=TSS+ALPD(J)
C
        ITEST=INMP2I(NRCELL,LUPC(J),0)
        IN=ITEST+NLIM
!pb          IF (ITEST.NE.0.AND.ILIIN(IN).NE.0) THEN
        IF ((ityp==3).or.(ITEST.NE.0.AND.ILIIN(IN).NE.0)) THEN
C
C  TRACK ENDS ON ONE OF THE NON-DEFAULT POLOIDAL SURFACES
C
#ifdef TRACE
          IF (NLTRC) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP CRITICAL
#endif
            WRITE (iunout,*) ' TRACK TERMINATED'
            WRITE (iunout,*) ' ITEST,ILIIN ',ITEST,ILIIN(IN)
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP END CRITICAL
#endif
          ENDIF
#endif
          NCOUPE=J
          MPSURF=LUPC(NCOUPE)
          IPOLGN=LUPC(NCOUPE)
          NINCY=MUPC(NCOUPE)
          ZRAD=TSS
          ISRFCL=0
          NINCX=0
          NINCZ=0
          MRSURF=0
          MTSURF=0
          MASURF=0
          GOTO 131
        ENDIF
C
  130 CONTINUE
C
C  LAST CELL, TRACK DOES NOT END ON A POLOIDAL SURFACE
C
C  INDEX OF LAST CELL NOT KNOWN (E.G. DUE TO ADD. SURFACE) ?
CDR  ERROR: FALLS NLSRFY, GGFLS NPCELL FALSCH
      IF (IPOLGN.EQ.0) THEN
CDR       IF (NCOUP.EQ.0) THEN
CDR         IPOLGN=NPCELL
CDR       ELSE
        X0T=X00+VELX*ZRAD
        Y0T=Y00+VELY*ZRAD
        IPOLGN=EIRENE_LEARC2(X0T,Y0T,NRCELL,NPANU,'TIMEP       ')
CDR     ENDIF
      ENDIF
C
      NCOUPE=NCOUP+1
      JUPC(NCOUPE)=IPOLGN
      LUPC(NCOUPE)=0
      MUPC(NCOUPE)=0
      ALPD(NCOUPE)=ZRAD-TSS
      MPSURF=0
      NINCY=0
C
  131 CONTINUE
      NCOUP=NCOUPE
#ifdef TRACE
      IF (NLTRC) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP CRITICAL
#endif
        WRITE (iunout,*) ' ALPD ',(ALPD(J),J=1,NCOUP)
        WRITE (iunout,*) ' JUPC ',(JUPC(J),J=1,NCOUP)
        WRITE (iunout,*) ' LUPC ',(LUPC(J),J=1,NCOUP)
        WRITE (iunout,*) ' MUPC ',(MUPC(J),J=1,NCOUP)
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP END CRITICAL
#endif
      ENDIF
#endif
C
      X00=X00+ZRAD*VELX
      Y00=Y00+ZRAD*VELY
      NPCELL=JUPC(NCOUP)
      IPCELL=NPCELL
      RETURN
C
      END SUBROUTINE EIRENE_TIMEP_NONCIRCULAR_MESH

!----------------------------------------------------------------------

      SUBROUTINE EIRENE_TIMEP_SLAB(ZRAD)
      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD
      USE EIRMOD_CUPD
      USE EIRMOD_CCONA
      USE EIRMOD_COMPRT
      USE EIRMOD_CGRID
      USE EIRMOD_CLGIN

      IMPLICIT NONE
      REAL(DP), INTENT(INOUT) :: ZRAD
      REAL(DP) :: ZRD, Y0T, X0TEST, Y0TEST, Y000, F, DY,
     .            DYZR, DUM, BB
      INTEGER :: ISTS, ITEST, J1, J2, MPTEST, NYSAVE, IRSAVE, IN, INCY
      INTEGER :: EIRENE_LEARCA
      EXTERNAL :: EIRENE_LEARCA
C
C  IDENTICAL, UP TO NAMES, TO TOROIDAL GRID PART, NLTRZ BLOCK
C
      IF (NRCELL.GT.0) GOTO 2900
C
C  PARTICLE OUTSIDE STANDARD MESH
C  CHECK AT NON-DEFAULT POLOIDAL SURFACES
C
      NCOUP=0
      ZRD=ZRAD
      BB=VELY+EPS60
      NYSAVE=1
      IF (VELY.LT.0.D0) NYSAVE=-1
      DO 2903 ISTS=1,NSTSI
        MPTEST=INUMP(ISTS,2)
        IF (MPTEST.NE.0) THEN
C  TEST POLOIDAL SURFACE NO. MPTEST FOR REENTRY
C  TIME FROM Y00 TO PSURF
          DY=PSURF(MPTEST)-Y00
          F=DY/BB
#ifdef TRACE
          IF (NLTRC) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP CRITICAL
#endif
            WRITE (iunout,*) 'MPTEST,F,DY ',MPTEST,F,DY
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP END CRITICAL
#endif
          ENDIF
#endif
          IF (F.LE.ZRD.AND.F.GT.0.D0) THEN
            X0TEST=X00+VELX*F
            IF (X0TEST.GE.RSURF(1).AND.X0TEST.LE.RSURF(NR1ST)) THEN
              IRSAVE=EIRENE_LEARCA(X0TEST,RSURF,1,NR1ST,1,
     .               'TIMEP 1    ')
              NCOUP=1
              JUPC(NCOUP)=1
              LUPC(NCOUP)=MPTEST
              MUPC(NCOUP)=NYSAVE
              ZRD=F
            ENDIF
          ENDIF
        ENDIF
 2903 CONTINUE
      IF (NCOUP.GT.0.AND.LUPC(MAX(1,NCOUP)).NE.MPSURF) THEN
C  REENTRY FOUND, REDUCE ZRAD TO F
C  NCOUP=1 AT THIS POINT
        NCOUP=1
        MPSURF=LUPC(NCOUP)
        NINCY=MUPC(NCOUP)
        IRCELL=IRSAVE
        ZRAD=ZRD
        ISRFCL=0
        ALPD(NCOUP)=ZRAD
        MRSURF=0
        MTSURF=0
        MASURF=0
        NINCX=0
        NINCZ=0
#ifdef TRACE
        IF (NLTRC) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP CRITICAL
#endif
          WRITE (iunout,*) 'REENTRY FOUND, MPSURF,ZRAD = ',MPSURF,ZRAD
          WRITE (iunout,*) 'IRCELL ',IRCELL
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP END CRITICAL
#endif
        ENDIF
#endif
        Y00=Y00+VELY*ZRD
        NPCELL=JUPC(NCOUP)
        IPCELL=NPCELL
        RETURN
      ELSE
C  NO REENTRY FOUND
        NCOUP=1
        JUPC(1)=1
        ALPD(1)=ZRAD
        IF (MRSURF.GT.0) THEN
C  CHECK VALID RANGE ON MRSURF
          Y0TEST=Y00+VELY*ZRAD
#ifdef TRACE
          IF (NLTRC) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP CRITICAL
#endif
            WRITE (iunout,*) 'CHECK VALID RANGE: Y0TEST ',Y0TEST
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP END CRITICAL
#endif
          ENDIF
#endif
          IF (Y0TEST.GE.PSURF(1).AND.Y0TEST.LE.PSURF(NP2ND)) THEN
            IPCELL=EIRENE_LEARCA(Y0TEST,PSURF,1,NP2ND,1,
     .             'TIMEP 2     ')
          ELSE
            MRSURF=0
            MTSURF=0
            NINCX=0
            NINCZ=0
          ENDIF
        ENDIF
        MPSURF=0
        NINCY=0
#ifdef TRACE
        IF (NLTRC) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP CRITICAL
#endif
          WRITE (iunout,*) 'NO REENTRY FOUND '
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP END CRITICAL
#endif
        ENDIF
#endif
        Y00=Y00+ZRD*VELY
        RETURN
      ENDIF
C
C  PARTICLE IN STANDARD MESH, RADIAL CELL NRCELL
C
 2900 CONTINUE
      Y000=Y00+VELY*ZRAD
#ifdef TRACE
      IF (NLTRC) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP CRITICAL
#endif
        WRITE (iunout,*) 'Y000,Y00,ZRAD ',Y000,Y00,ZRAD
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP END CRITICAL
#endif
      ENDIF
#endif
C
      DUM=0.
      NCOUP=1
C
C  J1: CELL INDEX
C  J2: SURFACE INDEX
      J1=NPCELL
      IF (VELY.LT.0.) THEN
        INCY=0
        NINCY=-1
        IF (NLSRFY) J1=MPSURF-1
      ELSE
        INCY=1
        NINCY=1
        IF (NLSRFY) J1=MPSURF
      ENDIF
      J2=J1+INCY
C
      NLSRFY=.FALSE.
C
 3000 CONTINUE
      IF (J2.LE.0.OR.J2.GT.NP2ND) THEN
        WRITE (iunout,*) 'ERROR IN TIMEP ',J2,J1,VELY
        RETURN  ! changed to avoid job crash in long runs
!       CALL EIRENE_EXIT_OWN(1)
      ENDIF
C  TIME FROM Y00 TO PSURF
      IF (MPSURF.EQ.J2) THEN
        J1=J1+NINCY
        J2=J1+INCY
        GOTO 3000
      ENDIF
      DY=(PSURF(J2)-Y00)
!pb reduce zrad if the trajectory comes too close to the next standard surface
!pb without hitting it
      DYZR = ABS(ABS(DY/ZRAD)-1._DP)
!pb     IF (DYZR <= EPS10) THEN
      IF ((DYZR > 0._DP) .AND. (DYZR <= EPS10)) THEN
        ZRAD=(1._DP-EPS6)*ZRAD
        ZRADS=ZRAD
      END IF
      BB=VELY+EPS60
      F=DY/BB
#ifdef TRACE
      IF (NLTRC) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP CRITICAL
#endif
        WRITE (iunout,*) 'J2,F,DY ',J2,F,DY
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP END CRITICAL
#endif
      ENDIF
#endif
      IF (F.LE.ZRAD) THEN
        JUPC(NCOUP)=J1
        LUPC(NCOUP)=J2
        ALPD(NCOUP)=F-DUM
        DUM=F
C  STOP HISTORY AT NON-DEFAULT STANDARD SURFACE J2
        ITEST=INMP2I(0,J2,0)
        IN=ITEST+NLIM
!pb          IF (ITEST.NE.0.AND.ILIIN(IN).NE.0) THEN
        IF ((ityp==3).or.(ITEST.NE.0.AND.ILIIN(IN).NE.0)) THEN
          ZRAD=F
          ISRFCL=0
          NPCELL=J1
          MPSURF=J2
          MRSURF=0
          NINCX=0
          NINCZ=0
          MTSURF=0
          MASURF=0
          IPCELL=NPCELL
          Y00=PSURF(J2)
          RETURN
        ENDIF
C  NEXT CELL
        J1=J1+NINCY
        J2=J1+INCY
        NCOUP=NCOUP+1
        GOTO 3000
      ENDIF
C
C  LAST CELL
C
#ifdef TRACE
      IF (NLTRC) THEN
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP CRITICAL
#endif
        WRITE (iunout,*) 'LAST CELL ',ZRAD,DUM
#if ( defined(USE_OPENMP) || defined(USE_EXT_OPENMP) )
!$OMP END CRITICAL
#endif
      ENDIF
#endif
      IF (MPSURF.EQ.0) THEN
        NPCELL=J1
      ELSE
        Y0T=Y00+VELY*ZRAD
        NPCELL=EIRENE_LEARCA(Y0T,PSURF,1,NP2ND,1,'TIMEP 3     ')
      ENDIF
      MPSURF=0
      JUPC(NCOUP)=J1
      ALPD(NCOUP)=ZRAD-DUM
      IPCELL=NPCELL
      Y00=Y000
      RETURN

      END SUBROUTINE EIRENE_TIMEP_SLAB

      end module eirmod_timep
